/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.FacetResult;
import fr.gouv.vitam.metadata.core.database.collections.ElasticsearchAccessMetadata;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.database.collections.MetadataDocument;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbMetadataResponseFilter;
import fr.gouv.vitam.metadata.core.database.collections.ObjectGroup;
import fr.gouv.vitam.metadata.core.database.collections.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class Result<T> {
    private static final String INVALID_NUMBER_OF_RESULT_AND_LIST_OF_RESULTS = "Invalid number of Result and List of results";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ElasticsearchAccessMetadata.class);
    public static final String RESULT_FIELD = "results";
    public static final String IDLIST = "idList";
    protected List<String> currentIds = new ArrayList<String>();
    protected List<Float> scores = new ArrayList<Float>();
    protected long nbResult = 0L;
    protected long total = 0L;
    protected final BuilderToken.FILTERARGS type;
    protected List<T> finalResult;
    protected List<FacetResult> facetResult;
    protected String scrollId;

    public Result(BuilderToken.FILTERARGS type) {
        this.type = type;
    }

    public Result(BuilderToken.FILTERARGS type, Collection<String> collection) {
        this.type = type;
        this.currentIds.addAll(collection);
        this.currentIds.remove("");
        this.nbResult = this.currentIds.size();
        for (int i = 0; i < collection.size(); ++i) {
            this.scores.add(Float.valueOf(1.0f));
        }
        this.total = this.nbResult;
    }

    public Result<T> clear() {
        this.currentIds.clear();
        this.scores.clear();
        this.nbResult = 0L;
        this.total = 0L;
        this.finalResult = null;
        return this;
    }

    public Result<T> putFrom(Result<T> from) {
        for (int i = 0; i < from.currentIds.size(); ++i) {
            if (this.currentIds.contains(from.currentIds.get(i))) continue;
            this.currentIds.add(from.currentIds.get(i));
            this.scores.add(from.scores.get(i));
        }
        this.nbResult = this.currentIds.size();
        this.total += from.total;
        return this;
    }

    public boolean isError() {
        return false;
    }

    public List<String> getCurrentIds() {
        return this.currentIds;
    }

    public List<Float> getCurrentScores() {
        return this.scores;
    }

    public BuilderToken.FILTERARGS getType() {
        return this.type;
    }

    public Result<T> addId(String id, float score) {
        if (id != null && !this.currentIds.contains(id)) {
            this.currentIds.add(id);
            this.scores.add(Float.valueOf(score));
            this.nbResult = this.currentIds.size();
        }
        return this;
    }

    public Result<T> setScrollId(String scrollId) {
        this.scrollId = scrollId;
        return this;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public final long getNbResult() {
        return this.nbResult;
    }

    public final Result<T> setUpdatedResult(long nb) {
        this.nbResult = nb;
        this.total = nb;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public Result<T> setTotal(long total) {
        this.total = total;
        return this;
    }

    public List<T> getFinal() {
        if (this.finalResult == null) {
            this.finalResult = new ArrayList<T>();
        }
        return this.finalResult;
    }

    public List<FacetResult> getFacet() {
        if (this.facetResult == null) {
            this.facetResult = new ArrayList<FacetResult>();
        }
        return this.facetResult;
    }

    public List<T> getListFiltered() throws InvalidParseOperationException {
        LOGGER.debug(this.toString());
        if (this.finalResult == null || this.finalResult.isEmpty()) {
            if (this.nbResult != 0L) {
                throw new InvalidParseOperationException(INVALID_NUMBER_OF_RESULT_AND_LIST_OF_RESULTS);
            }
            return Collections.emptyList();
        }
        int size = this.finalResult.size();
        if ((long)size != this.nbResult) {
            throw new InvalidParseOperationException(INVALID_NUMBER_OF_RESULT_AND_LIST_OF_RESULTS);
        }
        if (this.finalResult.get(0) instanceof MetadataDocument) {
            ArrayList<T> list = new ArrayList<T>(size);
            for (T metadataDocument : this.finalResult) {
                MongoDbMetadataResponseFilter.filterFinalResponse((MetadataDocument)((Object)metadataDocument));
                list.add(metadataDocument);
            }
            return list;
        }
        return this.finalResult;
    }

    public Result<T> addFinal(T document) {
        if (this.finalResult == null) {
            this.finalResult = new ArrayList<T>();
        }
        this.finalResult.add(document);
        this.nbResult = this.finalResult.size();
        return this;
    }

    private boolean isScoreIncluded(Bson projection) {
        if (projection == null) {
            return true;
        }
        BsonDocument document = (BsonDocument)projection;
        if (document.isEmpty()) {
            return true;
        }
        BsonValue value = document.get((Object)"_score");
        return value == null || ((BsonInt32)value).getValue() > 0;
    }

    public void setFinal(Bson projection) {
        ArrayList<T> list = new ArrayList<T>(this.currentIds.size());
        if (this.type == BuilderToken.FILTERARGS.UNITS) {
            for (int i = 0; i < this.currentIds.size(); ++i) {
                String id = this.currentIds.get(i);
                Unit unit = (Unit)((Object)MetadataCollections.UNIT.getCollection().find((Bson)new Document("_id", (Object)id)).projection(projection).first());
                if (unit == null) continue;
                if (VitamConfiguration.isExportScore() && MetadataCollections.UNIT.useScore() && this.isScoreIncluded(projection)) {
                    Float score = Float.valueOf(1.0f);
                    try {
                        score = this.scores.get(i);
                        if (score.isNaN()) {
                            score = Float.valueOf(1.0f);
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                    }
                    unit.append("_score", score);
                }
                list.add((T)((Object)unit));
            }
        } else if (this.type == BuilderToken.FILTERARGS.OBJECTGROUPS) {
            for (int i = 0; i < this.currentIds.size(); ++i) {
                String id = this.currentIds.get(i);
                ObjectGroup og = (ObjectGroup)((Object)MetadataCollections.OBJECTGROUP.getCollection().find((Bson)new Document("_id", (Object)id)).projection(projection).first());
                if (og != null && VitamConfiguration.isExportScore() && MetadataCollections.OBJECTGROUP.useScore() && this.isScoreIncluded(projection)) {
                    Float score = Float.valueOf(1.0f);
                    try {
                        score = this.scores.get(i);
                        if (score.isNaN()) {
                            score = Float.valueOf(1.0f);
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                    }
                    og.append("_score", score);
                }
                list.add((T)((Object)og));
            }
        }
        this.finalResult = list;
        this.nbResult = this.finalResult.size();
    }

    public void addFacetResult(FacetResult facetResult) {
        this.getFacet().add(facetResult);
    }

    public String toString() {
        if (this.finalResult == null) {
            return this.getClass().getSimpleName() + ": {" + IDLIST + ':' + this.currentIds + ',' + "nb" + ':' + this.nbResult + ", total: " + this.total + ',' + "type" + ':' + this.type + '}';
        }
        return this.getClass().getSimpleName() + ": {" + IDLIST + ':' + this.currentIds + ',' + "nb" + ':' + this.nbResult + ", total: " + this.total + ',' + "type" + ':' + this.type + ',' + this.finalResult + '}';
    }

    public boolean hasFinalResult() {
        return this.finalResult != null;
    }
}

