/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.google.common.collect.Lists;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbAccessMetadataImpl;
import fr.gouv.vitam.metadata.core.reconstruction.model.PurgedPersistentIdentifier;
import fr.gouv.vitam.metadata.core.reconstruction.repository.PersistentIdentifierRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PersistentIdentifierRepositoryImpl
implements PersistentIdentifierRepository {
    public static final String PURGED_PERSISTENT_IDENTIFIER_COLLECTION = "PurgedPersistentIdentifier";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PersistentIdentifierRepositoryImpl.class);
    private static final String LAST_PERSISTENT_DATE = "lastPersistentDate";
    private static final String ALL_PARAMS_REQUIRED = "All params are required";
    private final MongoCollection<Document> purgedPersistentIdentifierCollection;

    public PersistentIdentifierRepositoryImpl(MongoDbAccessMetadataImpl mongoDbAccess) {
        this.purgedPersistentIdentifierCollection = mongoDbAccess.getMongoDatabase().getCollection(PURGED_PERSISTENT_IDENTIFIER_COLLECTION);
    }

    public PersistentIdentifierRepositoryImpl(MongoDbAccessMetadataImpl mongoDbAccess, String prefix) {
        this.purgedPersistentIdentifierCollection = mongoDbAccess.getMongoDatabase().getCollection(prefix + PURGED_PERSISTENT_IDENTIFIER_COLLECTION);
    }

    @Override
    public List<PurgedPersistentIdentifier> findByPersistentIdentifierAndTenant(String persistentIdentifier, Integer tenant, @Nullable String type) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{persistentIdentifier, tenant});
        ArrayList filters = Lists.newArrayList((Object[])new Bson[]{Filters.eq((String)"persistentIdentifier.PersistentIdentifierContent", (Object)persistentIdentifier), Filters.eq((String)"_tenant", (Object)tenant)});
        if (type != null) {
            filters.add(Filters.eq((String)"type", (Object)type));
        }
        Bson query = Filters.and((Iterable)filters);
        try {
            ArrayList<PurgedPersistentIdentifier> result = new ArrayList<PurgedPersistentIdentifier>();
            FindIterable documents = this.purgedPersistentIdentifierCollection.find(query);
            for (Document doc : documents) {
                result.add(PurgedPersistentIdentifier.fromDocument(doc));
            }
            return result;
        }
        catch (MongoException | InvalidParseOperationException e) {
            throw new DatabaseException(String.format("Error while findByPersistentIdentifierAndTenant > persistentIdentifier : %s and tenant: %s", persistentIdentifier, tenant), e);
        }
    }

    @Override
    public void insert(List<Document> purgedPersistentIdentifiers) throws MetaDataExecutionException {
        BulkWriteOptions options = new BulkWriteOptions().ordered(false);
        try {
            List insertModels = purgedPersistentIdentifiers.stream().map(document -> {
                document.append("_v", (Object)0);
                document.append("_tenant", (Object)ParameterHelper.getTenantParameter());
                document.append(LAST_PERSISTENT_DATE, (Object)LocalDateUtil.nowFormatted());
                return new InsertOneModel(document);
            }).collect(Collectors.toList());
            this.purgedPersistentIdentifierCollection.bulkWrite(insertModels, options);
        }
        catch (MongoBulkWriteException e) {
            boolean hasBlockerErrors = false;
            for (BulkWriteError bulkWriteError : e.getWriteErrors()) {
                if (bulkWriteError.getCategory() == ErrorCategory.DUPLICATE_KEY) {
                    LOGGER.info("Document already exists " + purgedPersistentIdentifiers.get(bulkWriteError.getIndex()) + ". Ignoring quietly (idempotency)");
                    continue;
                }
                hasBlockerErrors = true;
                LOGGER.error("An error occurred during metadata insert " + bulkWriteError);
            }
            if (hasBlockerErrors) {
                throw new MetaDataExecutionException((Throwable)e);
            }
        }
        catch (MongoException | IllegalArgumentException e) {
            throw new MetaDataExecutionException(e);
        }
    }
}

