/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.mongodb.client.model.Updates;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.core.database.collections.Unit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bson.conversions.Bson;

public class ObjectGroupGraphUpdates {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ObjectGroupGraphUpdates.class);
    private final Set<String> parentUnitsToAdd = new HashSet<String>();
    private final Set<String> allParentUnitsToAdd = new HashSet<String>();
    private final Set<String> operationsToAdd = new HashSet<String>();
    private final Set<String> originatingAgenciesToAdd = new HashSet<String>();

    public void buildParentGraph(Unit unit) {
        this.parentUnitsToAdd.add(unit.getId());
        this.allParentUnitsToAdd.add(unit.getId());
        this.allParentUnitsToAdd.addAll(unit.getCollectionOrEmpty("_us"));
        this.originatingAgenciesToAdd.addAll(unit.getCollectionOrEmpty("_sps"));
        this.operationsToAdd.add(VitamThreadUtils.getVitamSession().getRequestId());
    }

    public Bson toBsonUpdate() {
        Bson updates = Updates.combine((Bson[])new Bson[]{Updates.addEachToSet((String)"_up", new ArrayList<String>(this.parentUnitsToAdd)), Updates.addEachToSet((String)"_us", new ArrayList<String>(this.allParentUnitsToAdd)), Updates.addEachToSet((String)"_sps", new ArrayList<String>(this.originatingAgenciesToAdd)), Updates.addEachToSet((String)"_ops", new ArrayList<String>(this.operationsToAdd)), Updates.set((String)"_glpd", (Object)LocalDateUtil.nowFormatted()), Updates.inc((String)"_v", (Number)1), Updates.inc((String)"_av", (Number)1)});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DEBUG: OG {}", (Object)this.toString());
        }
        return updates;
    }

    public String toString() {
        return "ObjectGroupGraphUpdates{parentUnitsToAdd=" + this.parentUnitsToAdd + ", allParentUnitsToAdd=" + this.allParentUnitsToAdd + ", operationsToAdd=" + this.operationsToAdd + ", originatingAgenciesToAdd=" + this.originatingAgenciesToAdd + "}";
    }
}

