/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import org.apache.commons.lang3.StringUtils;

public class MongoDbVarNameAdapter
extends VarNameAdapter {
    public boolean metadataAdapter() {
        return true;
    }

    public String getVariableName(String name) throws InvalidParseOperationException {
        String[] fields = StringUtils.split((String)name, (char)'.');
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            if (sb.length() != 0) {
                sb.append(".");
            }
            sb.append(this.resolveField(field));
        }
        String resolvedName = sb.toString();
        if (resolvedName.equals(name)) {
            return null;
        }
        return resolvedName;
    }

    private String resolveField(String field) throws InvalidParseOperationException {
        if (field.isEmpty()) {
            throw new InvalidParseOperationException("Empty field name");
        }
        char firstChar = field.charAt(0);
        if (firstChar != '#') {
            return field;
        }
        try {
            ParserTokens.PROJECTIONARGS proj = ParserTokens.PROJECTIONARGS.parse((String)field.substring(1));
            switch (proj) {
                case ID: {
                    return "_id";
                }
                case QUALIFIERS: {
                    return "_qualifiers";
                }
                case NBUNITS: {
                    return "_nbc";
                }
                case NBOBJECTS: {
                    return "_nbc";
                }
                case NBC: {
                    return "_nbc";
                }
                case SIZE: {
                    return "_qualifiers.versions.Size";
                }
                case TYPE: {
                    return "_profil";
                }
                case TENANT: {
                    return "_tenant";
                }
                case OBJECT: {
                    return "_og";
                }
                case UNITUPS: {
                    return "_up";
                }
                case MIN: {
                    return "_min";
                }
                case MAX: {
                    return "_max";
                }
                case ALLUNITUPS: {
                    return "_us";
                }
                case UNITTYPE: {
                    return "_unitType";
                }
                case MANAGEMENT: {
                    return "_mgt";
                }
                case OPERATIONS: {
                    return "_ops";
                }
                case OPI: {
                    return "_opi";
                }
                case ORIGINATING_AGENCY: {
                    return "_sp";
                }
                case ORIGINATING_AGENCIES: {
                    return "_sps";
                }
                case VERSION: {
                    return "_v";
                }
                case ATOMIC_VERSION: {
                    return "_av";
                }
                case STORAGE: {
                    return "_storage";
                }
                case SCORE: {
                    return "_score";
                }
                case UDS: {
                    return "_uds";
                }
                case GRAPH: {
                    return "_graph";
                }
                case ELIMINATION: {
                    return "_elimination";
                }
                case COMPUTEDINHERITEDRULES: {
                    return "_computedInheritedRules";
                }
                case VALIDCOMPUTEDINHERITEDRULES: {
                    return "_validComputedInheritedRules";
                }
                case OPTS: {
                    return "_opts";
                }
                case GRAPH_LAST_PERSISTED_DATE: {
                    return "_glpd";
                }
                case HISTORY: {
                    return "_history";
                }
                case SEDAVERSION: {
                    return "_sedaVersion";
                }
                case IMPLEMENTATIONVERSION: {
                    return "_implementationVersion";
                }
                case APPROXIMATE_CREATION_DATE: {
                    return "_acd";
                }
                case APPROXIMATE_UPDATE_DATE: {
                    return "_aud";
                }
                case BATCHID: {
                    return "_batchId";
                }
                case MANAGEMENTCONTRACTID: {
                    return "_managementContractId";
                }
                case UPLOADPATH: {
                    return "_uploadPath";
                }
                case FORMAT: {
                    return "_qualifiers.versions.FormatIdentification.FormatId";
                }
                case USAGE: 
                case LAST_PERSISTED_DATE: {
                    throw new InvalidParseOperationException("Invalid field '" + field + "'");
                }
            }
            throw new IllegalStateException("Unexpected value: " + proj);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParseOperationException("Invalid field name '" + field + "'", (Throwable)e);
        }
    }
}

