/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.metadata.core.database.collections.MetadataDocument;
import fr.gouv.vitam.metadata.core.database.collections.Unit;
import java.util.List;
import org.bson.Document;

public class MongoDbMetadataResponseFilter {
    private static final String VERSION = "versions";

    private MongoDbMetadataResponseFilter() {
    }

    private static void remove(Document document, String fieldName) {
        document.remove((Object)fieldName);
    }

    private static void replace(Document document, String originalFieldName, String targetFieldName) {
        Object value = document.remove((Object)originalFieldName);
        if (value != null) {
            document.append(targetFieldName, value);
        }
    }

    static void filterFinalResponse(MetadataDocument<?> document) {
        boolean isUnit = document instanceof Unit;
        block40: for (ParserTokens.PROJECTIONARGS projection : ParserTokens.PROJECTIONARGS.values()) {
            switch (projection) {
                case ID: {
                    MongoDbMetadataResponseFilter.replace(document, "_id", VitamFieldsHelper.id());
                    continue block40;
                }
                case NBUNITS: {
                    if (!isUnit) continue block40;
                    MongoDbMetadataResponseFilter.replace(document, "_nbc", VitamFieldsHelper.nbunits());
                    continue block40;
                }
                case NBOBJECTS: {
                    if (isUnit) continue block40;
                    MongoDbMetadataResponseFilter.replace(document, "_nbc", VitamFieldsHelper.nbobjects());
                    continue block40;
                }
                case STORAGE: {
                    MongoDbMetadataResponseFilter.filterStorage(document);
                    continue block40;
                }
                case OBJECT: {
                    MongoDbMetadataResponseFilter.replace(document, "_og", VitamFieldsHelper.object());
                    continue block40;
                }
                case OPERATIONS: {
                    MongoDbMetadataResponseFilter.replace(document, "_ops", VitamFieldsHelper.operations());
                    continue block40;
                }
                case OPI: {
                    MongoDbMetadataResponseFilter.replace(document, "_opi", VitamFieldsHelper.initialOperation());
                    continue block40;
                }
                case QUALIFIERS: {
                    MongoDbMetadataResponseFilter.filterQualifiers(document);
                    continue block40;
                }
                case TYPE: {
                    MongoDbMetadataResponseFilter.replace(document, "_profil", VitamFieldsHelper.type());
                    continue block40;
                }
                case TENANT: {
                    MongoDbMetadataResponseFilter.replace(document, "_tenant", VitamFieldsHelper.tenant());
                    continue block40;
                }
                case UNITUPS: {
                    MongoDbMetadataResponseFilter.replace(document, "_up", VitamFieldsHelper.unitups());
                    continue block40;
                }
                case VERSION: {
                    MongoDbMetadataResponseFilter.replace(document, "_v", VitamFieldsHelper.version());
                    continue block40;
                }
                case ATOMIC_VERSION: {
                    MongoDbMetadataResponseFilter.remove(document, "_av");
                    continue block40;
                }
                case MIN: {
                    MongoDbMetadataResponseFilter.replace(document, "_min", VitamFieldsHelper.min());
                    continue block40;
                }
                case MAX: {
                    MongoDbMetadataResponseFilter.replace(document, "_max", VitamFieldsHelper.max());
                    continue block40;
                }
                case ALLUNITUPS: {
                    MongoDbMetadataResponseFilter.replace(document, "_us", VitamFieldsHelper.allunitups());
                    continue block40;
                }
                case MANAGEMENT: {
                    MongoDbMetadataResponseFilter.replace(document, "_mgt", VitamFieldsHelper.management());
                    continue block40;
                }
                case UNITTYPE: {
                    MongoDbMetadataResponseFilter.replace(document, "_unitType", VitamFieldsHelper.unitType());
                    continue block40;
                }
                case UDS: {
                    MongoDbMetadataResponseFilter.remove(document, "_uds");
                    continue block40;
                }
                case ORIGINATING_AGENCY: {
                    MongoDbMetadataResponseFilter.replace(document, "_sp", VitamFieldsHelper.originatingAgency());
                    continue block40;
                }
                case ORIGINATING_AGENCIES: {
                    MongoDbMetadataResponseFilter.replace(document, "_sps", VitamFieldsHelper.originatingAgencies());
                    continue block40;
                }
                case SIZE: {
                    MongoDbMetadataResponseFilter.replace(document, "_qualifiers.versions.Size", VitamFieldsHelper.size());
                    continue block40;
                }
                case FORMAT: {
                    MongoDbMetadataResponseFilter.replace(document, "_qualifiers.versions.FormatIdentification.FormatId", VitamFieldsHelper.format());
                    continue block40;
                }
                case SCORE: {
                    MongoDbMetadataResponseFilter.replace(document, "_score", ParserTokens.PROJECTIONARGS.SCORE.exactToken());
                    continue block40;
                }
                case GRAPH: {
                    MongoDbMetadataResponseFilter.remove(document, "_graph");
                    continue block40;
                }
                case GRAPH_LAST_PERSISTED_DATE: {
                    MongoDbMetadataResponseFilter.remove(document, "_glpd");
                    continue block40;
                }
                case HISTORY: {
                    MongoDbMetadataResponseFilter.replace(document, "_history", VitamFieldsHelper.history());
                    continue block40;
                }
                case ELIMINATION: {
                    MongoDbMetadataResponseFilter.replace(document, "_elimination", ParserTokens.PROJECTIONARGS.ELIMINATION.exactToken());
                    continue block40;
                }
                case COMPUTEDINHERITEDRULES: {
                    MongoDbMetadataResponseFilter.replace(document, "_computedInheritedRules", ParserTokens.PROJECTIONARGS.COMPUTEDINHERITEDRULES.exactToken());
                    continue block40;
                }
                case VALIDCOMPUTEDINHERITEDRULES: {
                    MongoDbMetadataResponseFilter.replace(document, "_validComputedInheritedRules", ParserTokens.PROJECTIONARGS.VALIDCOMPUTEDINHERITEDRULES.exactToken());
                    continue block40;
                }
                case OPTS: {
                    MongoDbMetadataResponseFilter.replace(document, "_opts", ParserTokens.PROJECTIONARGS.OPTS.exactToken());
                    continue block40;
                }
                case SEDAVERSION: {
                    MongoDbMetadataResponseFilter.replace(document, "_sedaVersion", VitamFieldsHelper.sedaVersion());
                    continue block40;
                }
                case IMPLEMENTATIONVERSION: {
                    MongoDbMetadataResponseFilter.replace(document, "_implementationVersion", VitamFieldsHelper.implementationVersion());
                    continue block40;
                }
                case APPROXIMATE_CREATION_DATE: {
                    MongoDbMetadataResponseFilter.replace(document, "_acd", VitamFieldsHelper.approximateCreationDate());
                    continue block40;
                }
                case APPROXIMATE_UPDATE_DATE: {
                    MongoDbMetadataResponseFilter.replace(document, "_aud", VitamFieldsHelper.approximateUpdateDate());
                    continue block40;
                }
                case BATCHID: {
                    MongoDbMetadataResponseFilter.replace(document, "_batchId", VitamFieldsHelper.batchId());
                    continue block40;
                }
                case UPLOADPATH: {
                    MongoDbMetadataResponseFilter.replace(document, "_uploadPath", VitamFieldsHelper.uploadPath());
                    continue block40;
                }
                case MANAGEMENTCONTRACTID: {
                    MongoDbMetadataResponseFilter.replace(document, "_managementContractId", VitamFieldsHelper.managementContractId());
                    continue block40;
                }
            }
        }
    }

    private static void filterStorage(MetadataDocument<?> document) {
        if (document.get("_storage") != null) {
            Object storage = document.get("_storage");
            MongoDbMetadataResponseFilter.replace((Document)storage, "_nbc", VitamFieldsHelper.nbc());
            MongoDbMetadataResponseFilter.replace(document, "_storage", VitamFieldsHelper.storage());
        }
    }

    private static void filterQualifiers(MetadataDocument<?> document) {
        if (document.get("_qualifiers") != null) {
            MongoDbMetadataResponseFilter.replace(document, "_qualifiers", VitamFieldsHelper.qualifiers());
            for (Object qualifier : (List)document.get(VitamFieldsHelper.qualifiers())) {
                MongoDbMetadataResponseFilter.replace((Document)qualifier, "_nbc", VitamFieldsHelper.nbc());
                List versions = (List)((Document)qualifier).remove((Object)VERSION);
                if (versions == null) continue;
                for (Object version : versions) {
                    Object storage;
                    MongoDbMetadataResponseFilter.replace((Document)version, "_id", VitamFieldsHelper.id());
                    MongoDbMetadataResponseFilter.replace((Document)version, "_opi", VitamFieldsHelper.initialOperation());
                    MongoDbMetadataResponseFilter.replace((Document)qualifier, "_nbc", VitamFieldsHelper.nbc());
                    if (null != ((Document)version).get((Object)"_managementContractId")) {
                        MongoDbMetadataResponseFilter.replace((Document)version, "_managementContractId", VitamFieldsHelper.managementContractId());
                    }
                    if ((storage = ((Document)version).get((Object)"_storage")) == null) continue;
                    MongoDbMetadataResponseFilter.replace((Document)storage, "_nbc", VitamFieldsHelper.nbc());
                    MongoDbMetadataResponseFilter.replace((Document)version, "_storage", VitamFieldsHelper.storage());
                }
                ((Document)qualifier).put(VERSION, (Object)versions);
            }
        }
    }
}

