/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.mongodb.BasicDBObject;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateOneModel;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;

public class MongoDbMetadataRepository<T extends VitamDocument<T>> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MongoDbMetadataRepository.class);
    private final Supplier<MongoCollection<T>> mongoCollectionSupplier;

    public MongoDbMetadataRepository(Supplier<MongoCollection<T>> mongoCollectionSupplier) {
        this.mongoCollectionSupplier = mongoCollectionSupplier;
    }

    public List<T> selectByIds(Iterable<? extends String> ids, BasicDBObject projection) {
        Bson condition = Filters.in((String)"_id", ids);
        FindIterable result = this.mongoCollectionSupplier.get().find(condition).projection((Bson)projection);
        ArrayList<VitamDocument> vitamDocuments = new ArrayList<VitamDocument>();
        try (MongoCursor cursor = result.iterator();){
            while (cursor.hasNext()) {
                VitamDocument vitamDocument = (VitamDocument)cursor.next();
                vitamDocuments.add(vitamDocument);
            }
        }
        return vitamDocuments;
    }

    public void insert(List<T> metadataDocuments) throws MetaDataExecutionException {
        BulkWriteOptions options = new BulkWriteOptions().ordered(false);
        try {
            List collect = metadataDocuments.stream().map(metadataDocument -> {
                metadataDocument.append("_v", (Object)0);
                metadataDocument.append("_av", (Object)0);
                metadataDocument.append("_tenant", (Object)ParameterHelper.getTenantParameter());
                return new InsertOneModel(metadataDocument);
            }).collect(Collectors.toList());
            this.mongoCollectionSupplier.get().bulkWrite(collect, options);
        }
        catch (MongoBulkWriteException e) {
            boolean hasBlockerErrors = false;
            for (BulkWriteError bulkWriteError : e.getWriteErrors()) {
                if (bulkWriteError.getCategory() == ErrorCategory.DUPLICATE_KEY) {
                    LOGGER.info("Document already exists " + ((VitamDocument)metadataDocuments.get(bulkWriteError.getIndex())).getId() + ". Ignoring quietly (idempotency)");
                    continue;
                }
                hasBlockerErrors = true;
                LOGGER.error("An error occurred during metadata insert " + bulkWriteError);
            }
            if (hasBlockerErrors) {
                throw new MetaDataExecutionException((Throwable)e);
            }
        }
        catch (MongoException | IllegalArgumentException e) {
            throw new MetaDataExecutionException(e);
        }
    }

    public void delete(List<T> metadataDocuments) throws MetaDataExecutionException {
        BulkWriteOptions options = new BulkWriteOptions().ordered(false);
        try {
            List toDeleteModels = metadataDocuments.stream().map(DeleteOneModel::new).collect(Collectors.toList());
            this.mongoCollectionSupplier.get().bulkWrite(toDeleteModels, options);
        }
        catch (MongoException | IllegalArgumentException e) {
            throw new MetaDataExecutionException(e);
        }
    }

    public void update(Map<String, Bson> updates) throws MetaDataExecutionException {
        BulkWriteOptions options = new BulkWriteOptions().ordered(false);
        try {
            List collect = updates.entrySet().stream().map(item -> new UpdateOneModel(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)((String)item.getKey())), Filters.eq((String)"_tenant", (Object)ParameterHelper.getTenantParameter())}), (Bson)item.getValue())).collect(Collectors.toList());
            this.mongoCollectionSupplier.get().bulkWrite(collect, options);
        }
        catch (MongoException | IllegalArgumentException e) {
            throw new MetaDataExecutionException(e);
        }
    }
}

