/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.result.DeleteResult;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.core.database.collections.ElasticsearchAccessMetadata;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbAccessMetadataImpl
extends MongoDbAccess {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MongoDbAccess.class);
    private final ElasticsearchAccessMetadata esClient;

    public MongoDbAccessMetadataImpl(MongoClient mongoClient, String dbname, boolean recreate, ElasticsearchAccessMetadata esClient, MetadataCollections unitCollection, MetadataCollections objectCollection) {
        super(mongoClient, dbname);
        this.esClient = esClient;
        unitCollection.initialize(this.getMongoDatabase(), recreate);
        objectCollection.initialize(this.getMongoDatabase(), recreate);
        unitCollection.initialize(this.esClient);
        objectCollection.initialize(this.esClient);
        esClient.createIndexesAndAliases(objectCollection, unitCollection);
    }

    public String getInfo() {
        StringBuilder builder = new StringBuilder();
        MongoIterable collectionNames = this.getMongoDatabase().listCollectionNames();
        for (String s : collectionNames) {
            builder.append(s);
            builder.append('\n');
        }
        for (MetadataCollections coll : MetadataCollections.values()) {
            if (coll == null || coll.getCollection() == null) continue;
            ListIndexesIterable list = coll.getCollection().listIndexes();
            for (Document dbObject : list) {
                builder.append(coll.getName()).append(' ').append(dbObject).append('\n');
            }
        }
        return builder.toString();
    }

    public static long getUnitSize() {
        return MetadataCollections.UNIT.getCollection().countDocuments();
    }

    public static long getObjectGroupSize() {
        return MetadataCollections.OBJECTGROUP.getCollection().countDocuments();
    }

    public ElasticsearchAccessMetadata getEsClient() {
        return this.esClient;
    }

    @VisibleForTesting
    public void deleteUnitByTenant(Integer ... tenantIds) throws MetaDataExecutionException {
        long count = MetadataCollections.UNIT.getCollection().countDocuments();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(MetadataCollections.UNIT.getName() + " count before: " + count);
        }
        for (Integer tenantId : tenantIds) {
            if (count <= 0L) continue;
            DeleteResult result = MetadataCollections.UNIT.getCollection().deleteMany((Bson)new Document().append("_tenant", (Object)tenantId));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(MetadataCollections.UNIT.getName() + " result.result.getDeletedCount(): " + result.getDeletedCount());
            }
            this.esClient.purgeIndexForTesting(MetadataCollections.UNIT, tenantId);
        }
    }

    @VisibleForTesting
    public void deleteObjectGroupByTenant(Integer ... tenantIds) throws MetaDataExecutionException {
        long count = MetadataCollections.OBJECTGROUP.getCollection().countDocuments();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(MetadataCollections.OBJECTGROUP.getName() + " count before: " + count);
        }
        for (Integer tenantId : tenantIds) {
            if (count <= 0L) continue;
            DeleteResult result = MetadataCollections.OBJECTGROUP.getCollection().deleteMany((Bson)new Document().append("_tenant", (Object)tenantId));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(MetadataCollections.OBJECTGROUP.getName() + " result.result.getDeletedCount(): " + result.getDeletedCount());
            }
            this.esClient.purgeIndexForTesting(MetadataCollections.OBJECTGROUP, tenantId);
        }
    }
}

