/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.database.collections.ObjectGroup;
import fr.gouv.vitam.metadata.core.database.collections.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MetadataRepositoryService {
    private VitamRepositoryProvider vitamRepositoryProvider;

    public MetadataRepositoryService(VitamRepositoryProvider vitamRepositoryProvider) {
        this.vitamRepositoryProvider = vitamRepositoryProvider;
    }

    public JsonNode getDocumentById(MetadataCollections collection, String id, Integer tenant) throws DatabaseException, MetaDataNotFoundException, InvalidParseOperationException {
        Optional document = this.vitamRepositoryProvider.getVitamMongoRepository(collection.getVitamCollection()).getByID(id, tenant);
        if (document.isPresent()) {
            switch (collection) {
                case UNIT: {
                    return JsonHandler.toJsonNode((Object)((Object)new Unit((Document)document.get())));
                }
                case OBJECTGROUP: {
                    return JsonHandler.toJsonNode((Object)((Object)new ObjectGroup((Document)document.get())));
                }
            }
            throw new IllegalArgumentException("Metadata collection invalid");
        }
        throw new MetaDataNotFoundException(String.format("Could not find document of type %s by id %s for tenant %d", collection.getName(), id, tenant));
    }

    public List<JsonNode> getDocumentsByIds(MetadataCollections collection, Collection<String> ids, Integer tenant) throws InvalidParseOperationException {
        MongoCursor documents = this.vitamRepositoryProvider.getVitamMongoRepository(collection.getVitamCollection()).findDocuments(Filters.and((Bson[])new Bson[]{Filters.in((String)"_id", ids), Filters.eq((String)"_tenant", (Object)tenant)}), VitamConfiguration.getBatchSize()).iterator();
        ArrayList<JsonNode> entries = new ArrayList<JsonNode>();
        block4: while (documents.hasNext()) {
            Document document = (Document)documents.next();
            switch (collection) {
                case UNIT: {
                    entries.add(JsonHandler.toJsonNode((Object)((Object)new Unit(document))));
                    continue block4;
                }
                case OBJECTGROUP: {
                    entries.add(JsonHandler.toJsonNode((Object)((Object)new ObjectGroup(document))));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Metadata collection invalid");
        }
        return entries;
    }
}

