/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.client.MongoCollection;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.bson.Document;

public abstract class MetadataDocument<E>
extends VitamDocument<E> {
    private static final long serialVersionUID = 7912599149562030658L;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataDocument.class);
    public static final String ATOMIC_VERSION = "_av";
    public static final String QUALIFIERS = "_qualifiers";
    public static final String NBCHILD = "_nbc";
    public static final String MANAGEMENT_CONTRACT_ID = "_managementContractId";
    public static final String TYPE = "_profil";
    public static final String UP = "_up";
    public static final String OG = "_og";
    public static final String OPS = "_ops";
    public static final String OPI = "_opi";
    public static final String ORIGINATING_AGENCY = "_sp";
    public static final String ORIGINATING_AGENCIES = "_sps";
    public static final String UNITUPS = "_us";
    public static final String GRAPH_LAST_PERSISTED_DATE = "_glpd";
    public static final String APPROXIMATE_CREATION_DATE = "_acd";
    public static final String APPROXIMATE_UPDATE_DATE = "_aud";
    public static final String BATCH_ID = "_batchId";
    public static final String UPLOAD_PATH = "_uploadPath";
    static final String[] ES_PROJECTION = new String[]{"_id", "_nbc", "_tenant", "_score"};

    public MetadataDocument() {
    }

    public MetadataDocument(JsonNode content) {
        super(Document.parse((String)JsonHandler.unprettyPrint((Object)content)));
    }

    public MetadataDocument(Document content) {
        super(content);
    }

    public MetadataDocument(String content) {
        super(Document.parse((String)content));
    }

    public MetadataDocument<E> checkId() {
        return this;
    }

    public final String getId() {
        return this.getString("_id");
    }

    protected abstract MongoCollection<E> getCollection();

    protected abstract MetadataCollections getMetadataCollections();

    public String toStringDirect() {
        return super.toString();
    }

    public String toStringDebug() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.get("_id");
    }

    public <T> Collection<T> getCollectionOrEmpty(String name) {
        Collection collection = (Collection)this.get(name, Collection.class);
        if (collection == null) {
            return Collections.EMPTY_LIST;
        }
        return collection;
    }

    public <V> Map<String, V> getMapOrEmpty(String name) {
        Map map = (Map)this.get(name, Map.class);
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return map;
    }

    public String getSp() {
        return (String)this.get(ORIGINATING_AGENCY, String.class);
    }

    public Collection<String> getUp() {
        return this.getCollectionOrEmpty(UP);
    }

    public Integer getAtomicVersion() {
        return this.getInteger(ATOMIC_VERSION);
    }

    public void setApproximateCreationDate(LocalDateTime creationDate) {
        this.put(APPROXIMATE_CREATION_DATE, LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)creationDate));
    }

    public void setApproximateUpdateDate(LocalDateTime lastUpdate) {
        this.put(APPROXIMATE_UPDATE_DATE, LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)lastUpdate));
    }
}

