/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mongodb.client.MongoDatabase;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.metadata.core.config.DefaultCollectionConfiguration;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.config.GroupedTenantConfiguration;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.config.MetadataIndexationConfiguration;
import fr.gouv.vitam.metadata.core.database.collections.ElasticsearchAccessMetadata;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.mapping.MappingLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

@VisibleForTesting
public final class MetadataCollectionsTestUtils {
    private MetadataCollectionsTestUtils() {
    }

    @VisibleForTesting
    public static ElasticsearchMetadataIndexManager createTestIndexManager(List<Integer> dedicatedTenants, Map<String, List<Integer>> tenantGroups, MappingLoader mappingLoader) {
        List<Integer> allTenants = Streams.concat((Stream[])new Stream[]{dedicatedTenants.stream(), tenantGroups.values().stream().flatMap(Collection::stream)}).collect(Collectors.toList());
        List<GroupedTenantConfiguration> tenantGroupConfiguration = tenantGroups.entrySet().stream().map(entry -> new GroupedTenantConfiguration().setName((String)entry.getKey()).setTenants(((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining(",")))).collect(Collectors.toList());
        MetaDataConfiguration metadataConfiguration = new MetaDataConfiguration().setIndexationConfiguration(new MetadataIndexationConfiguration().setDefaultCollectionConfiguration(new DefaultCollectionConfiguration().setUnit(new CollectionConfiguration(Integer.valueOf(1), Integer.valueOf(0))).setObjectgroup(new CollectionConfiguration(Integer.valueOf(1), Integer.valueOf(0)))).setGroupedTenantConfiguration(tenantGroupConfiguration));
        return new ElasticsearchMetadataIndexManager(metadataConfiguration, allTenants, mappingLoader);
    }

    @VisibleForTesting
    public static void beforeTestClass(MongoDatabase db, String prefix, ElasticsearchAccessMetadata esClient) {
        MetadataCollectionsTestUtils.beforeTestClass(db, prefix, esClient, Lists.newArrayList((Object[])MetadataCollections.values()));
    }

    @VisibleForTesting
    public static void beforeTestClass(MongoDatabase db, String prefix, ElasticsearchAccessMetadata esClient, Collection<MetadataCollections> metadataCollections) {
        ParametersChecker.checkParameter((String)"metadataCollections is required", (Object[])new Object[]{metadataCollections});
        for (MetadataCollections collection : metadataCollections) {
            collection.getVitamCollection().setName(prefix + collection.getVitamCollection().getClasz().getSimpleName());
            collection.initialize(db, true);
            if (collection.getEsClient() == null) {
                collection.initialize(esClient);
            }
            if (esClient == null) continue;
            esClient.createIndexesAndAliases(collection);
        }
    }

    @VisibleForTesting
    public static void afterTestClass(ElasticsearchMetadataIndexManager indexManager, boolean deleteEsIndexes) {
        MetadataCollectionsTestUtils.afterTestClass(indexManager, Lists.newArrayList((Object[])MetadataCollections.values()), deleteEsIndexes);
    }

    @VisibleForTesting
    public static void afterTestClass(ElasticsearchMetadataIndexManager indexManager, Collection<MetadataCollections> metadataCollections, boolean deleteEsIndexes) {
        if (null == metadataCollections) {
            return;
        }
        try {
            for (MetadataCollections collection : metadataCollections) {
                if (null != collection.getVitamCollection().getCollection()) {
                    collection.getVitamCollection().getCollection().deleteMany((Bson)new Document());
                }
                if (null == collection.getEsClient() || collection != MetadataCollections.UNIT && collection != MetadataCollections.OBJECTGROUP) continue;
                for (Integer tenant : indexManager.getDedicatedTenants()) {
                    if (deleteEsIndexes) {
                        collection.getEsClient().deleteIndexByAliasForTesting(indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenant));
                        continue;
                    }
                    collection.getEsClient().purgeIndexForTesting(indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenant));
                }
                for (String tenantGroupName : indexManager.getTenantGroups()) {
                    Integer tenant = indexManager.getTenantGroupTenants(tenantGroupName).iterator().next();
                    if (deleteEsIndexes) {
                        collection.getEsClient().deleteIndexByAliasForTesting(indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenant));
                        continue;
                    }
                    collection.getEsClient().purgeIndexForTesting(indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenant));
                }
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public static void afterTest(ElasticsearchMetadataIndexManager indexManager) {
        MetadataCollectionsTestUtils.afterTestClass(indexManager, false);
    }

    @VisibleForTesting
    public static void afterTest(ElasticsearchMetadataIndexManager indexManager, Collection<MetadataCollections> metadataCollections) {
        MetadataCollectionsTestUtils.afterTestClass(indexManager, metadataCollections, false);
    }
}

