/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import fr.gouv.vitam.common.database.collections.VitamCollection;
import fr.gouv.vitam.common.database.collections.VitamCollectionHelper;
import fr.gouv.vitam.common.database.collections.VitamDescriptionLoader;
import fr.gouv.vitam.common.database.collections.VitamDescriptionResolver;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.model.ElasticsearchCollections;
import fr.gouv.vitam.metadata.core.database.collections.ElasticsearchAccessMetadata;
import fr.gouv.vitam.metadata.core.database.collections.MetadataDocument;
import fr.gouv.vitam.metadata.core.database.collections.ObjectGroup;
import fr.gouv.vitam.metadata.core.database.collections.Unit;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public enum MetadataCollections {
    UNIT(Unit.class),
    OBJECTGROUP(ObjectGroup.class);

    private final VitamDescriptionResolver vitamDescriptionResolver;
    private final VitamCollection<? extends MetadataDocument<?>> vitamCollection;
    private String prefix = "";

    private MetadataCollections(Class<? extends MetadataDocument<?>> clasz) {
        VitamDescriptionLoader vitamDescriptionLoader = new VitamDescriptionLoader(clasz.getSimpleName());
        this.vitamDescriptionResolver = vitamDescriptionLoader.getVitamDescriptionResolver();
        this.vitamCollection = VitamCollectionHelper.getCollection(clasz, (boolean)true, (boolean)clasz.equals(Unit.class), (String)"", (VitamDescriptionResolver)this.vitamDescriptionResolver);
    }

    public static List<Class<?>> getClasses() {
        ArrayList classes = new ArrayList();
        for (MetadataCollections collection : MetadataCollections.values()) {
            classes.add(collection.getClasz());
        }
        return classes;
    }

    void initialize(MongoDatabase db, boolean recreate) {
        this.vitamCollection.initialize(db, recreate);
    }

    void initialize(ElasticsearchAccessMetadata esClient) {
        this.vitamCollection.initialize((ElasticsearchAccess)esClient);
    }

    public String getName() {
        return this.prefix + this.vitamCollection.getName();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public <T extends Document> MongoCollection<T> getCollection() {
        return this.vitamCollection.getCollection();
    }

    public <T extends MetadataDocument<T>> VitamCollection<T> getVitamCollection() {
        return this.vitamCollection;
    }

    public Class<? extends MetadataDocument<?>> getClasz() {
        return this.vitamCollection.getClasz();
    }

    public ElasticsearchAccessMetadata getEsClient() {
        return (ElasticsearchAccessMetadata)this.vitamCollection.getEsClient();
    }

    public boolean useScore() {
        return this.vitamCollection.isUseScore();
    }

    public static MetadataCollections getFromValue(String collection) {
        for (MetadataCollections coll : MetadataCollections.values()) {
            if (!coll.name().equalsIgnoreCase(collection)) continue;
            return coll;
        }
        throw new IllegalArgumentException(collection + " is not in enum MetadataCollections.");
    }

    public VitamDescriptionResolver getVitamDescriptionResolver() {
        return this.vitamDescriptionResolver;
    }

    public ElasticsearchCollections getElasticsearchCollection() {
        switch (this) {
            case UNIT: {
                return ElasticsearchCollections.UNIT;
            }
            case OBJECTGROUP: {
                return ElasticsearchCollections.OBJECTGROUP;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }
}

