/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchFacetResultHelper;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexSettings;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.database.collections.MetadataDocument;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbMetadataHelper;
import fr.gouv.vitam.metadata.core.database.collections.Result;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class ElasticsearchAccessMetadata
extends ElasticsearchAccess {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ElasticsearchAccessMetadata.class);
    private final ElasticsearchMetadataIndexManager indexManager;

    public ElasticsearchAccessMetadata(String clusterName, List<ElasticsearchNode> nodes, ElasticsearchMetadataIndexManager indexManager) throws VitamException {
        super(clusterName, nodes);
        this.indexManager = indexManager;
    }

    public void createIndexesAndAliases(MetadataCollections ... collections) {
        try {
            this.createIndexesAndAliasesForDedicatedTenants(collections);
            this.createIndexesAndAliasesForTenantGroups(collections);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new RuntimeException("Could not create indexes and aliases", e);
        }
    }

    private void createIndexesAndAliasesForDedicatedTenants(MetadataCollections ... collections) throws MetaDataExecutionException {
        Collection<Integer> dedicatedTenants = this.indexManager.getDedicatedTenants();
        for (int tenantId : dedicatedTenants) {
            for (MetadataCollections collection : collections) {
                this.createIndexAndAliasIfAliasNotExists(collection, tenantId);
            }
        }
    }

    private void createIndexesAndAliasesForTenantGroups(MetadataCollections ... collections) throws MetaDataExecutionException {
        Collection<String> tenantGroups = this.indexManager.getTenantGroups();
        for (String tenantGroup : tenantGroups) {
            List<Integer> tenantGroupTenants = this.indexManager.getTenantGroupTenants(tenantGroup);
            if (tenantGroupTenants.isEmpty()) continue;
            int tenantId = (Integer)tenantGroupTenants.iterator().next();
            for (MetadataCollections collection : collections) {
                this.createIndexAndAliasIfAliasNotExists(collection, tenantId);
            }
        }
    }

    public final void createIndexAndAliasIfAliasNotExists(MetadataCollections collection, Integer tenantId) throws MetaDataExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            ElasticsearchIndexSettings indexSettings = this.indexManager.getElasticsearchIndexSettings(collection, tenantId);
            super.createIndexAndAliasIfAliasNotExists(indexAlias, indexSettings);
        }
        catch (Exception e) {
            throw new MetaDataExecutionException("Error while set Mapping", (Throwable)e);
        }
    }

    protected final Result<MetadataDocument<?>> search(MetadataCollections collection, Integer tenantId, QueryBuilder query, List<SortBuilder<?>> sorts, int offset, Integer limit, List<AggregationBuilder> facets, String scrollId, Integer scrollTimeout, boolean trackTotalHits) throws MetaDataExecutionException, BadRequestException {
        SearchHits hits;
        Result resultRequest;
        SearchResponse response;
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            BoolQueryBuilder finalQuery = new BoolQueryBuilder().must(query).must((QueryBuilder)QueryBuilders.termQuery((String)"_tenant", (Object)tenantId));
            response = super.search(indexAlias, (QueryBuilder)finalQuery, null, MetadataDocument.ES_PROJECTION, sorts, offset, limit, facets, scrollId, scrollTimeout, trackTotalHits);
        }
        catch (DatabaseException e) {
            throw new MetaDataExecutionException((Throwable)e);
        }
        switch (response.status()) {
            default: 
        }
        if (response.status() != RestStatus.OK) {
            throw new MetaDataExecutionException("Error collection : " + collection.getName() + ", tenant: " + tenantId + ", query: " + query);
        }
        boolean isUnit = collection == MetadataCollections.UNIT;
        Result result = resultRequest = isUnit ? MongoDbMetadataHelper.createOneResult(BuilderToken.FILTERARGS.UNITS) : MongoDbMetadataHelper.createOneResult(BuilderToken.FILTERARGS.OBJECTGROUPS);
        if (scrollId != null && !scrollId.isEmpty()) {
            resultRequest.setScrollId(response.getScrollId());
            hits = response.getHits();
            if (hits.getHits().length == 0) {
                try {
                    super.clearScroll(response.getScrollId());
                }
                catch (DatabaseException e) {
                    LOGGER.warn((Throwable)e);
                }
            }
        }
        if ((hits = response.getHits()).getHits().length > 10000) {
            LOGGER.warn("Warning, more than 10000 hits: " + hits.getTotalHits());
        }
        if (hits.getTotalHits().value == 0L) {
            LOGGER.debug("No result found collection : " + collection.getName() + ", tenant: " + tenantId + ", query: " + query);
            return isUnit ? MongoDbMetadataHelper.createOneResult(BuilderToken.FILTERARGS.UNITS) : MongoDbMetadataHelper.createOneResult(BuilderToken.FILTERARGS.OBJECTGROUPS);
        }
        for (SearchHit hit : hits) {
            String id = hit.getId();
            resultRequest.addId(id, hit.getScore());
        }
        LOGGER.debug("FinalEsResult: {} : {}", resultRequest.getCurrentIds(), (Object)resultRequest.getNbResult());
        resultRequest.setTotal(hits.getTotalHits().value);
        Aggregations aggregations = response.getAggregations();
        if (aggregations != null) {
            for (Aggregation aggregation : aggregations) {
                resultRequest.addFacetResult(ElasticsearchFacetResultHelper.transformFromEsAggregation((Aggregation)aggregation));
            }
        }
        return resultRequest;
    }

    public Aggregations basicAggregationSearch(MetadataCollections collection, Integer tenantId, List<AggregationBuilder> aggregations, QueryBuilder query) throws MetaDataExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            BoolQueryBuilder finalQuery = new BoolQueryBuilder().must(query).must((QueryBuilder)QueryBuilders.termQuery((String)"_tenant", (Object)tenantId));
            return super.search(indexAlias, (QueryBuilder)finalQuery, null, null, (List)Lists.newArrayList((Object[])new SortBuilder[]{SortBuilders.fieldSort((String)"_doc").order(SortOrder.ASC)}), 0, Integer.valueOf(0), aggregations, null, null, false).getAggregations();
        }
        catch (BadRequestException | DatabaseException e) {
            throw new MetaDataExecutionException(e);
        }
    }

    public void insertFullDocument(MetadataCollections collection, Integer tenantId, String id, MetadataDocument<?> doc) throws MetaDataExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            super.indexEntry(indexAlias, id, doc);
        }
        catch (DatabaseException e) {
            throw new MetaDataExecutionException((Throwable)e);
        }
    }

    public void insertFullDocumentsWithRefreshSettings(MetadataCollections collection, Integer tenantId, Collection<? extends MetadataDocument<?>> documents, boolean withRefreshIndex) throws MetaDataExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            super.indexEntries(indexAlias, documents, withRefreshIndex);
        }
        catch (DatabaseException e) {
            throw new MetaDataExecutionException((Throwable)e);
        }
    }

    public void insertFullDocuments(MetadataCollections collection, Integer tenantId, Collection<? extends MetadataDocument<?>> documents) throws MetaDataExecutionException {
        this.insertFullDocumentsWithRefreshSettings(collection, tenantId, documents, true);
    }

    public void updateFullDocument(MetadataCollections collection, Integer tenantId, String id, MetadataDocument<?> metadataDocument) throws MetaDataExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            super.updateEntry(indexAlias, id, metadataDocument);
        }
        catch (DatabaseException e) {
            throw new MetaDataExecutionException((Throwable)e);
        }
    }

    public void deleteBulkOGEntriesIndexes(List<String> ids, Integer tenantId) throws MetaDataExecutionException {
        this.bulkDelete(ids, tenantId, MetadataCollections.OBJECTGROUP);
    }

    public void deleteBulkUnitsEntriesIndexes(List<String> ids, Integer tenantId) throws MetaDataExecutionException {
        this.bulkDelete(ids, tenantId, MetadataCollections.UNIT);
    }

    private void bulkDelete(List<String> ids, Integer tenantId, MetadataCollections collection) throws MetaDataExecutionException {
        if (ids.isEmpty()) {
            LOGGER.error("ES delete in error since no results to delete");
            throw new MetaDataExecutionException("No result to delete");
        }
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            super.delete(indexAlias, ids);
        }
        catch (DatabaseException e) {
            LOGGER.error((Throwable)e);
            throw new MetaDataExecutionException((Throwable)e);
        }
    }

    public void refreshIndex(MetadataCollections collection, int tenantId) throws MetaDataExecutionException {
        try {
            super.refreshIndex(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(Integer.valueOf(tenantId)));
        }
        catch (DatabaseException e) {
            throw new MetaDataExecutionException((Throwable)e);
        }
    }

    public void indexEntry(MetadataCollections collection, Integer tenantId, String id, VitamDocument<?> vitamDocument) throws MetaDataExecutionException {
        try {
            super.indexEntry(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId), id, vitamDocument);
        }
        catch (DatabaseException e) {
            throw new MetaDataExecutionException((Throwable)e);
        }
    }

    @VisibleForTesting
    public void purgeIndexForTesting(MetadataCollections collection, Integer tenantId) throws MetaDataExecutionException {
        try {
            super.purgeIndexForTesting(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId), tenantId);
        }
        catch (DatabaseException e) {
            throw new MetaDataExecutionException((Throwable)e);
        }
    }

    @VisibleForTesting
    public void deleteIndexByAliasForTesting(MetadataCollections collection, int tenantId) throws MetaDataExecutionException {
        try {
            super.purgeIndexForTesting(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(Integer.valueOf(tenantId)));
        }
        catch (DatabaseException e) {
            throw new MetaDataExecutionException((Throwable)e);
        }
    }

    public void delete(MetadataCollections collection, List<String> ids, Integer tenantId) throws MetaDataExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            super.delete(indexAlias, ids);
        }
        catch (DatabaseException e) {
            throw new MetaDataExecutionException((Throwable)e);
        }
    }
}

