/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoException;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.DeleteMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.collections.DynamicParserTokens;
import fr.gouv.vitam.common.database.parser.query.PathQuery;
import fr.gouv.vitam.common.database.parser.query.helper.QueryDepthHelper;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.multiple.InsertParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.database.server.MongoDbInMemory;
import fr.gouv.vitam.common.database.server.RuleUpdateException;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.database.translators.RequestToAbstract;
import fr.gouv.vitam.common.database.translators.elasticsearch.QueryToElasticsearch;
import fr.gouv.vitam.common.database.translators.mongodb.DeleteToMongodb;
import fr.gouv.vitam.common.database.translators.mongodb.InsertToMongodb;
import fr.gouv.vitam.common.database.translators.mongodb.MongoDbHelper;
import fr.gouv.vitam.common.database.translators.mongodb.QueryToMongodb;
import fr.gouv.vitam.common.database.translators.mongodb.RequestToMongodb;
import fr.gouv.vitam.common.database.translators.mongodb.SelectToMongodb;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.metrics.VitamCommonMetrics;
import fr.gouv.vitam.common.model.DurationData;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.database.collections.MetadataDocument;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbMetadataHelper;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbMetadataRepository;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbVarNameAdapter;
import fr.gouv.vitam.metadata.core.database.collections.ObjectGroup;
import fr.gouv.vitam.metadata.core.database.collections.ObjectGroupGraphUpdates;
import fr.gouv.vitam.metadata.core.database.collections.Result;
import fr.gouv.vitam.metadata.core.database.collections.ResultError;
import fr.gouv.vitam.metadata.core.database.collections.Unit;
import fr.gouv.vitam.metadata.core.database.collections.UnitGraphModel;
import fr.gouv.vitam.metadata.core.graph.GraphLoader;
import fr.gouv.vitam.metadata.core.model.RequestById;
import fr.gouv.vitam.metadata.core.model.UpdatedDocument;
import fr.gouv.vitam.metadata.core.trigger.FieldHistoryManager;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationErrorCode;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationException;
import fr.gouv.vitam.metadata.core.validation.OntologyValidator;
import fr.gouv.vitam.metadata.core.validation.UnitValidator;
import io.prometheus.client.Counter;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.conversions.Bson;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.sort.SortBuilder;

public class DbRequest {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DbRequest.class);
    private static final JsonPointer JSON_POINTER_TO_OPS = JsonPointer.compile((String)"/$push/_ops/0");
    private static final BasicDBObject ID_PROJECTION = new BasicDBObject("_id", (Object)1);
    private static final String HISTORY_TRIGGER_NAME = "history-triggers.json";
    private static final String QUERY2 = "query: ";
    private static final String WHERE_PREVIOUS_RESULT_WAS = "where_previous_result_was: ";
    private static final String FROM2 = "from: ";
    private static final String NO_RESULT_AT_RANK2 = "no_result_at_rank: ";
    private static final String NO_RESULT_TRUE = "no_result: true";
    private static final String WHERE_PREVIOUS_IS = " \n\twhere previous is ";
    private static final String FROM = " from ";
    private static final String NO_RESULT_AT_RANK = "No result at rank: ";
    private static final String DEPTH_ARRAY = "deptharray";
    private static final String CONSISTENCY_ERROR_THE_DOCUMENT_GUID_S_IN_ES_IS_NOT_IN_MONGO_DB_ANYMORE_TENANT_S_REQUEST_ID_S = "[Consistency Error] : The document guid=%s in ES is not in MongoDB anymore, tenant : %s, requestId : %s";
    private static final long DEFAULT_WAITING_TIME_RETRY_MS = 10000L;
    private static final int DEFAULT_RETRIES_COUNT = 3;
    private final MongoDbMetadataRepository<Unit> mongoDbUnitRepository;
    private final MongoDbMetadataRepository<ObjectGroup> mongoDbObjectGroupRepository;
    private final FieldHistoryManager fieldHistoryManager;

    @VisibleForTesting
    DbRequest(MongoDbMetadataRepository<Unit> mongoDbUnitRepository, MongoDbMetadataRepository<ObjectGroup> mongoDbObjectGroupRepository, FieldHistoryManager fieldHistoryManager) {
        this.mongoDbUnitRepository = mongoDbUnitRepository;
        this.mongoDbObjectGroupRepository = mongoDbObjectGroupRepository;
        this.fieldHistoryManager = fieldHistoryManager;
    }

    public DbRequest() {
        this(new MongoDbMetadataRepository<Unit>(MetadataCollections.UNIT::getCollection), new MongoDbMetadataRepository<ObjectGroup>(MetadataCollections.OBJECTGROUP::getCollection), new FieldHistoryManager(HISTORY_TRIGGER_NAME));
    }

    public UpdatedDocument execRuleRequest(String documentId, RuleActions ruleActions, Map<String, DurationData> bindRuleToDuration, OntologyValidator ontologyValidator, UnitValidator unitValidator, List<OntologyModel> ontologyModels) throws InvalidParseOperationException, MetaDataExecutionException, InvalidCreateOperationException, MetaDataNotFoundException, MetadataValidationException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        for (int tries = 0; tries < 3; ++tries) {
            ObjectNode updatedJsonDocument;
            MetadataCollections metadataCollections = MetadataCollections.UNIT;
            MongoCollection collection = metadataCollections.getCollection();
            MetadataDocument document = (MetadataDocument)((Object)collection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)documentId), Filters.eq((String)"_tenant", (Object)VitamThreadUtils.getVitamSession().getTenantId())})).first());
            if (document == null) {
                throw new MetaDataNotFoundException("Document not found by id " + documentId);
            }
            JsonNode jsonDocument = JsonHandler.toJsonNode((Object)((Object)document));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("DEBUG update {} to update to {}", (Object)jsonDocument, (Object)JsonHandler.prettyPrint((Object)ruleActions));
            }
            DynamicParserTokens parserTokens = new DynamicParserTokens(metadataCollections.getVitamDescriptionResolver(), ontologyModels);
            MongoDbInMemory mongoInMemory = new MongoDbInMemory(jsonDocument, parserTokens);
            UpdateMultiQuery updateQuery = new UpdateMultiQuery();
            updateQuery.addActions(new Action[]{UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{VitamThreadUtils.getVitamSession().getRequestId()})});
            UpdateParserMultiple updateRequest = new UpdateParserMultiple((VarNameAdapter)new MongoDbVarNameAdapter());
            updateRequest.parse((JsonNode)updateQuery.getFinalUpdateById());
            mongoInMemory.getUpdateJson((AbstractParser)updateRequest);
            try {
                updatedJsonDocument = (ObjectNode)mongoInMemory.getUpdateJsonForRule(ruleActions, bindRuleToDuration);
            }
            catch (RuleUpdateException e) {
                throw new MetadataValidationException(this.toMetadataValidationErrorCode(e), e.getMessage(), e);
            }
            this.fieldHistoryManager.trigger(jsonDocument, (JsonNode)updatedJsonDocument);
            Integer documentVersion = document.getVersion();
            int newDocumentVersion = documentVersion + 1;
            Integer atomicVersion = document.getAtomicVersion();
            int newAtomicVersion = atomicVersion == null ? newDocumentVersion : atomicVersion + 1;
            updatedJsonDocument.put("_v", newDocumentVersion);
            updatedJsonDocument.put("_av", newAtomicVersion);
            Unit updatedDocument = new Unit((JsonNode)updatedJsonDocument);
            ObjectNode transformedUpdatedDocument = ontologyValidator.verifyAndReplaceFields((JsonNode)updatedJsonDocument);
            unitValidator.validateUnit(transformedUpdatedDocument);
            Bson condition = atomicVersion == null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)documentId), Filters.eq((String)"_tenant", (Object)VitamThreadUtils.getVitamSession().getTenantId()), Filters.exists((String)"_av", (boolean)false)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)documentId), Filters.eq((String)"_tenant", (Object)VitamThreadUtils.getVitamSession().getTenantId()), Filters.eq((String)"_av", (Object)atomicVersion)});
            updatedDocument.setApproximateUpdateDate(LocalDateUtil.now());
            LOGGER.debug("DEBUG update {}", (Object)transformedUpdatedDocument);
            UpdateResult result = collection.replaceOne(condition, (Object)updatedDocument);
            if (result.getModifiedCount() != 1L) continue;
            this.indexFieldsUpdated(updatedDocument, tenantId);
            return new UpdatedDocument(documentId, jsonDocument, JsonHandler.toJsonNode((Object)((Object)updatedDocument)), true);
        }
        throw new MetaDataExecutionException("Can not modify document " + documentId);
    }

    private MetadataValidationErrorCode toMetadataValidationErrorCode(RuleUpdateException e) {
        switch (e.getRuleUpdateErrorCode()) {
            case HOLD_END_DATE_BEFORE_START_DATE: {
                return MetadataValidationErrorCode.RULE_UPDATE_HOLD_END_DATE_BEFORE_START_DATE;
            }
            case HOLD_END_DATE_ONLY_ALLOWED_FOR_HOLD_RULE_WITH_UNDEFINED_DURATION: {
                return MetadataValidationErrorCode.RULE_UPDATE_UNEXPECTED_HOLD_END_DATE;
            }
        }
        throw new IllegalStateException("Unexpected value: " + e.getRuleUpdateErrorCode());
    }

    public Result<MetadataDocument<?>> execRequest(RequestParserMultiple requestParser, List<OntologyModel> ontologies) throws MetaDataExecutionException, InvalidParseOperationException, BadRequestException, VitamDBException {
        Result<MetadataDocument<?>> newResult;
        MetadataCollections metadataCollections;
        ResultError roots;
        RequestMultiple request = requestParser.getRequest();
        RequestToMongodb requestToMongodb = RequestToMongodb.getRequestToMongoDb((AbstractParser)requestParser);
        int maxQuery = request.getNbQueries();
        boolean checkConsistency = false;
        if (requestParser.model() == BuilderToken.FILTERARGS.UNITS) {
            roots = this.checkUnitStartupRoots(requestParser);
            metadataCollections = MetadataCollections.UNIT;
        } else {
            metadataCollections = MetadataCollections.OBJECTGROUP;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("OBJECTGROUPS DbRequest: %s", requestParser.toString()));
            }
            roots = this.checkObjectGroupStartupRoots(requestParser);
        }
        DynamicParserTokens parserTokens = new DynamicParserTokens(metadataCollections.getVitamDescriptionResolver(), ontologies);
        Result result = roots;
        int rank = 0;
        if (result.getCurrentIds().isEmpty() && maxQuery > 0) {
            newResult = this.executeQuery(requestParser, (RequestToAbstract)requestToMongodb, rank, result, parserTokens);
            if (newResult == null || newResult.getCurrentIds().isEmpty() || newResult.isError()) {
                LOGGER.debug(NO_RESULT_AT_RANK + rank + FROM + requestParser + WHERE_PREVIOUS_IS + result);
                result = new ResultError(requestParser.model()).addError(newResult != null ? newResult.getCurrentIds().toString() : NO_RESULT_TRUE).addError(NO_RESULT_AT_RANK2 + rank).addError(FROM2 + requestParser).addError(WHERE_PREVIOUS_RESULT_WAS + result).setTotal(newResult != null ? newResult.total : 0L);
                return result;
            }
            result = newResult;
            checkConsistency = true;
            LOGGER.debug("Query: {}\n\tResult: {}", (Object)requestParser, result);
            ++rank;
        }
        while (!result.getCurrentIds().isEmpty() && rank < maxQuery) {
            newResult = this.executeQuery(requestParser, (RequestToAbstract)requestToMongodb, rank, result, parserTokens);
            if (newResult == null) {
                LOGGER.debug(NO_RESULT_AT_RANK + rank + FROM + requestParser + WHERE_PREVIOUS_IS + result);
                result = new ResultError(result.type).addError(result.getCurrentIds().toString()).addError(NO_RESULT_AT_RANK2 + rank).addError(FROM2 + requestParser).addError(WHERE_PREVIOUS_RESULT_WAS + result);
                return result;
            }
            if (newResult.getCurrentIds().isEmpty() || newResult.isError()) {
                LOGGER.debug(NO_RESULT_AT_RANK + rank + FROM + requestParser + WHERE_PREVIOUS_IS + result);
                result = new ResultError(newResult.type).addError(newResult.getCurrentIds().toString()).addError(NO_RESULT_AT_RANK2 + rank).addError(FROM2 + requestParser).addError(WHERE_PREVIOUS_RESULT_WAS + result);
                return result;
            }
            result = newResult;
            LOGGER.debug("Query: {}\n\tResult: {}", (Object)requestParser, result);
            ++rank;
        }
        if (result.getCurrentIds().isEmpty()) {
            LOGGER.debug(NO_RESULT_AT_RANK + rank + FROM + requestParser + WHERE_PREVIOUS_IS + result);
            result = new ResultError(result.type).addError(result.getCurrentIds().toString()).addError(NO_RESULT_AT_RANK2 + rank).addError(FROM2 + requestParser).addError(WHERE_PREVIOUS_RESULT_WAS + result);
            return result;
        }
        if (request instanceof DeleteMultiQuery) {
            newResult = this.lastDeleteFilterProjection((DeleteToMongodb)requestToMongodb, result);
            if (newResult != null) {
                result = newResult;
            }
        } else {
            newResult = this.lastSelectFilterProjection((SelectToMongodb)requestToMongodb, result, checkConsistency);
            if (newResult != null) {
                result = newResult;
            }
        }
        LOGGER.debug("Results: {}", result);
        return result;
    }

    public List<UpdatedDocument> execUpdateRequest(List<RequestById> bulkRequests, MetadataCollections metadataCollection, OntologyValidator ontologyValidator, UnitValidator unitValidator, List<OntologyModel> ontologyModels, boolean forceUpdate, boolean refreshElasticIndexPostBulkIndexing) throws MetaDataExecutionException, InvalidParseOperationException, MetaDataNotFoundException {
        ArrayList<RequestById> bulkRequestsFiltered;
        ArrayList<RequestById> duplicateElementsList;
        if (CollectionUtils.isEmpty(bulkRequests)) {
            return Collections.emptyList();
        }
        AtomicInteger index = new AtomicInteger(0);
        bulkRequests.forEach(requestById -> requestById.setIndex(index.getAndIncrement()));
        ArrayList<Object> sortedResults = new ArrayList<Object>(Collections.nCopies(bulkRequests.size(), null));
        ArrayList<RequestById> remainElementsList = new ArrayList<RequestById>(bulkRequests);
        do {
            duplicateElementsList = new ArrayList<RequestById>();
            HashMap<String, Integer> queriesIndexByDocumentId = new HashMap<String, Integer>();
            HashSet<String> seenIdentifiers = new HashSet<String>();
            bulkRequestsFiltered = new ArrayList<RequestById>();
            for (RequestById requestById2 : remainElementsList) {
                if (seenIdentifiers.add(requestById2.getDocumentId())) {
                    bulkRequestsFiltered.add(requestById2);
                    queriesIndexByDocumentId.put(requestById2.getDocumentId(), requestById2.getIndex());
                    continue;
                }
                duplicateElementsList.add(requestById2);
            }
            LOGGER.debug("handling a list of elements containings : " + String.join((CharSequence)",", bulkRequestsFiltered.stream().map(elt -> elt.getDocumentId()).collect(Collectors.toList())));
            List<UpdatedDocument> partialResults = this.updateDocumentWithRetries(bulkRequestsFiltered, metadataCollection, ontologyValidator, unitValidator, ontologyModels, forceUpdate, refreshElasticIndexPostBulkIndexing);
            for (UpdatedDocument resultElt : partialResults) {
                if (!queriesIndexByDocumentId.containsKey(resultElt.getDocumentId())) continue;
                sortedResults.set((Integer)queriesIndexByDocumentId.get(resultElt.getDocumentId()), resultElt);
            }
        } while (CollectionUtils.isNotEmpty(remainElementsList = duplicateElementsList));
        LOGGER.info("handling " + String.join((CharSequence)",", bulkRequestsFiltered.stream().map(elt -> elt.getDocumentId()).collect(Collectors.toList())));
        return sortedResults;
    }

    private Result<MetadataDocument<?>> checkUnitStartupRoots(RequestParserMultiple request) {
        Set roots = request.getRequest().getRoots();
        if (roots.isEmpty()) {
            return MongoDbMetadataHelper.createOneResult(BuilderToken.FILTERARGS.UNITS);
        }
        return MongoDbMetadataHelper.createOneResult(BuilderToken.FILTERARGS.UNITS, roots);
    }

    private Result<MetadataDocument<?>> checkObjectGroupStartupRoots(RequestParserMultiple request) {
        Set roots = request.getRequest().getRoots();
        return MongoDbMetadataHelper.createOneResult(BuilderToken.FILTERARGS.OBJECTGROUPS, roots);
    }

    private Set<String> checkUnitAgainstRoots(Set<String> current, Result<MetadataDocument<?>> defaultStartSet) {
        if (defaultStartSet == null || defaultStartSet.getCurrentIds().isEmpty()) {
            return current;
        }
        FindIterable<?> iterable = MongoDbMetadataHelper.select(MetadataCollections.UNIT, MongoDbMetadataHelper.queryForAncestorsOrSame(current, defaultStartSet.getCurrentIds()), (Bson)MongoDbMetadataHelper.ID_PROJECTION);
        HashSet<String> newRoots = new HashSet<String>();
        try (MongoCursor cursor = iterable.iterator();){
            while (cursor.hasNext()) {
                Unit unit = (Unit)((Object)cursor.next());
                newRoots.add(unit.getId());
            }
        }
        return newRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result<MetadataDocument<?>> executeQuery(RequestParserMultiple requestParser, RequestToAbstract requestToMongodb, int rank, Result<MetadataDocument<?>> previous, DynamicParserTokens parserTokens) throws MetaDataExecutionException, InvalidParseOperationException, BadRequestException {
        Result<MetadataDocument<?>> result;
        Query realQuery = requestToMongodb.getNthQuery(rank);
        boolean isLastQuery = requestToMongodb.getNbQueries() == rank + 1;
        List sorts = null;
        List facets = null;
        int limit = -1;
        int offset = -1;
        String scrollId = requestParser.getFinalScrollId();
        Integer scrollTimeout = requestParser.getFinalScrollTimeout();
        Integer tenantId = ParameterHelper.getTenantParameter();
        BuilderToken.FILTERARGS collectionType = requestToMongodb.model();
        if (requestToMongodb instanceof SelectToMongodb && isLastQuery) {
            sorts = QueryToElasticsearch.getSorts((AbstractParser)requestParser, (boolean)(collectionType.equals((Object)BuilderToken.FILTERARGS.UNITS) ? MetadataCollections.UNIT.useScore() : MetadataCollections.OBJECTGROUP.useScore()), (DynamicParserTokens)parserTokens);
            if (BuilderToken.FILTERARGS.UNITS.equals((Object)collectionType) || BuilderToken.FILTERARGS.OBJECTGROUPS.equals((Object)collectionType)) {
                facets = QueryToElasticsearch.getFacets((AbstractParser)requestParser, (DynamicParserTokens)parserTokens);
            }
            limit = requestToMongodb.getFinalLimit();
            offset = requestToMongodb.getFinalOffset();
        }
        LOGGER.debug("Rank: " + rank + "\n\tPrevious: " + previous + "\n\tRequest: " + realQuery.getCurrentQuery());
        BuilderToken.QUERY type = realQuery.getQUERY();
        if (type == BuilderToken.QUERY.PATH) {
            if (previous.getCurrentIds().isEmpty()) {
                previous.clear();
                return MongoDbMetadataHelper.createOneResult(collectionType, ((PathQuery)realQuery).getPaths());
            }
            if (collectionType.equals((Object)BuilderToken.FILTERARGS.UNITS)) {
                Set<String> newRoots = this.checkUnitAgainstRoots(((PathQuery)realQuery).getPaths(), previous);
                previous.clear();
                if (newRoots.isEmpty()) {
                    return MongoDbMetadataHelper.createOneResult(collectionType);
                }
                return MongoDbMetadataHelper.createOneResult(collectionType, newRoots);
            }
            return previous;
        }
        int exactDepth = QueryDepthHelper.HELPER.getExactDepth(realQuery);
        if (exactDepth < 0) {
            exactDepth = 100;
        }
        boolean trackTotalHits = false;
        if (isLastQuery) {
            trackTotalHits = requestParser.trackTotalHits();
        }
        int relativeDepth = QueryDepthHelper.HELPER.getRelativeDepth(realQuery);
        try {
            if (collectionType == BuilderToken.FILTERARGS.UNITS) {
                if (exactDepth > 0) {
                    LOGGER.debug("Unit Exact Depth request (descending)");
                    result = this.exactDepthUnitQuery(realQuery, previous, exactDepth, tenantId, sorts, offset, limit, facets, scrollId, scrollTimeout, parserTokens, trackTotalHits);
                } else if (relativeDepth != 0) {
                    LOGGER.debug("Unit Relative Depth request (ascending or descending)");
                    result = this.relativeDepthUnitQuery(realQuery, previous, relativeDepth, tenantId, sorts, offset, limit, facets, scrollId, scrollTimeout, parserTokens, trackTotalHits);
                } else {
                    LOGGER.debug("Unit Current sub level request");
                    result = this.sameDepthUnitQuery(realQuery, previous, tenantId, sorts, offset, limit, facets, scrollId, scrollTimeout, parserTokens, trackTotalHits);
                }
            } else {
                LOGGER.debug("ObjectGroup No depth at all");
                result = this.objectGroupQuery(realQuery, previous, tenantId, sorts, offset, limit, scrollId, scrollTimeout, facets, parserTokens, trackTotalHits);
            }
        }
        finally {
            previous.clear();
        }
        return result;
    }

    protected Result<MetadataDocument<?>> exactDepthUnitQuery(Query realQuery, Result<MetadataDocument<?>> previous, int exactDepth, Integer tenantId, List<SortBuilder<?>> sorts, int offset, int limit, List<AggregationBuilder> facets, String scrollId, Integer scrollTimeout, DynamicParserTokens parserTokens, boolean trackTotalHits) throws InvalidParseOperationException, MetaDataExecutionException, BadRequestException {
        BoolQueryBuilder roots = new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.rangeQuery((String)"_max").lte((Object)exactDepth).gte((Object)0)).must((QueryBuilder)QueryBuilders.rangeQuery((String)"_min").lte((Object)exactDepth).gte((Object)0));
        if (!previous.getCurrentIds().isEmpty()) {
            roots.must(QueryToElasticsearch.getRoots((String)"_up", previous.getCurrentIds()));
        }
        MetadataCollections metadataCollections = MetadataCollections.UNIT;
        BoolQueryBuilder query = new BoolQueryBuilder().must(QueryToElasticsearch.getCommand((Query)realQuery, (VarNameAdapter)new MongoDbVarNameAdapter(), (DynamicParserTokens)parserTokens)).filter((QueryBuilder)QueryBuilders.termQuery((String)("_us." + exactDepth), previous.getCurrentIds()));
        LOGGER.debug("Req1LevelMD: {}", (Object)query);
        Result<MetadataDocument<?>> result = metadataCollections.getEsClient().search(metadataCollections, tenantId, (QueryBuilder)query, sorts, offset, limit, facets, scrollId, scrollTimeout, trackTotalHits);
        LOGGER.warn("UnitExact: {}", result);
        return result;
    }

    protected Result<MetadataDocument<?>> relativeDepthUnitQuery(Query realQuery, Result<MetadataDocument<?>> previous, int relativeDepth, Integer tenantId, List<SortBuilder<?>> sorts, int offset, int limit, List<AggregationBuilder> facets, String scrollId, Integer scrollTimeout, DynamicParserTokens parserTokens, boolean trackTotalHits) throws InvalidParseOperationException, MetaDataExecutionException, BadRequestException {
        BoolQueryBuilder query = new BoolQueryBuilder().must(QueryToElasticsearch.getCommand((Query)realQuery, (VarNameAdapter)new MongoDbVarNameAdapter(), (DynamicParserTokens)parserTokens));
        if (previous.getCurrentIds().isEmpty()) {
            if (relativeDepth < 1) {
                query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"_max").lte((Object)1).gte((Object)0));
            } else {
                query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"_max").lte((Object)(relativeDepth + 1)).gte((Object)0));
            }
        } else if (relativeDepth == 1) {
            QueryBuilder roots = QueryToElasticsearch.getRoots((String)"_up", previous.getCurrentIds());
            query.filter(roots);
        } else if (relativeDepth > 1) {
            QueryToElasticsearch.addRoots((BoolQueryBuilder)query, (String)"_uds", previous.getCurrentIds(), (int)relativeDepth);
        } else {
            Set<String> fathers = this.aggregateUnitDepths(previous.getCurrentIds(), relativeDepth);
            QueryBuilder roots = QueryToElasticsearch.getRoots((String)"_id", fathers);
            query.filter(roots);
        }
        LOGGER.debug("Req1LevelMD: {}", (Object)query);
        Result<MetadataDocument<?>> result = MetadataCollections.UNIT.getEsClient().search(MetadataCollections.UNIT, tenantId, (QueryBuilder)query, sorts, offset, limit, facets, scrollId, scrollTimeout, trackTotalHits);
        LOGGER.debug("UnitRelative: {}", result);
        return result;
    }

    protected Set<String> aggregateUnitDepths(Collection<String> ids, int relativeDepth) {
        Bson match = Aggregates.match((Bson)Filters.in((String)"_id", ids));
        Bson group = Aggregates.group((Object)new BasicDBObject("_id", (Object)"all"), (BsonField[])new BsonField[]{Accumulators.addToSet((String)DEPTH_ARRAY, (Object)"$_uds")});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Depth: {} {}", (Object)MongoDbHelper.bsonToString((Bson)match, (boolean)false), (Object)MongoDbHelper.bsonToString((Bson)group, (boolean)false));
        }
        List<Bson> pipeline = Arrays.asList(match, group);
        AggregateIterable aggregateIterable = MetadataCollections.UNIT.getCollection().aggregate(pipeline);
        Unit aggregate = (Unit)((Object)aggregateIterable.first());
        HashSet<String> set = new HashSet<String>();
        if (aggregate != null) {
            List array = (List)aggregate.get(DEPTH_ARRAY);
            relativeDepth = Math.abs(relativeDepth);
            for (Map map : array) {
                for (String key : map.keySet()) {
                    int depth = Integer.parseInt(key);
                    if (depth > relativeDepth) continue;
                    set.addAll((Collection)map.get(key));
                }
                map.clear();
            }
            array.clear();
        }
        return set;
    }

    protected Result<MetadataDocument<?>> sameDepthUnitQuery(Query realQuery, Result<MetadataDocument<?>> previous, Integer tenantId, List<SortBuilder<?>> sorts, int offset, int limit, List<AggregationBuilder> facets, String scrollId, Integer scrollTimeout, DynamicParserTokens parserTokens, boolean trackTotalHits) throws InvalidParseOperationException, MetaDataExecutionException, BadRequestException {
        QueryBuilder finalQuery;
        QueryBuilder query = QueryToElasticsearch.getCommand((Query)realQuery, (VarNameAdapter)new MongoDbVarNameAdapter(), (DynamicParserTokens)parserTokens);
        LOGGER.debug("DEBUG prev {} RealQuery {}", previous.getCurrentIds(), (Object)realQuery);
        if (previous.getCurrentIds().isEmpty()) {
            finalQuery = query;
        } else {
            QueryBuilder roots = QueryToElasticsearch.getRoots((String)"_id", previous.getCurrentIds());
            finalQuery = QueryBuilders.boolQuery().must(query).must(roots);
        }
        LOGGER.debug("query: {}", (Object)finalQuery);
        return MetadataCollections.UNIT.getEsClient().search(MetadataCollections.UNIT, tenantId, finalQuery, sorts, offset, limit, facets, scrollId, scrollTimeout, trackTotalHits);
    }

    protected Result<MetadataDocument<?>> objectGroupQuery(Query realQuery, Result<MetadataDocument<?>> previous, Integer tenantId, List<SortBuilder<?>> sorts, int offset, int limit, String scrollId, Integer scrollTimeout, List<AggregationBuilder> facets, DynamicParserTokens parserTokens, boolean trackTotalHits) throws InvalidParseOperationException, MetaDataExecutionException, BadRequestException {
        QueryBuilder finalQuery;
        QueryBuilder query = QueryToElasticsearch.getCommand((Query)realQuery, (VarNameAdapter)new MongoDbVarNameAdapter(), (DynamicParserTokens)parserTokens);
        if (previous.getCurrentIds().isEmpty()) {
            finalQuery = query;
        } else {
            QueryBuilder roots = BuilderToken.FILTERARGS.UNITS.equals((Object)previous.getType()) ? QueryToElasticsearch.getRoots((String)"_up", previous.getCurrentIds()) : QueryToElasticsearch.getRoots((String)"_id", previous.getCurrentIds());
            finalQuery = QueryBuilders.boolQuery().must(query).must(roots);
        }
        LOGGER.debug("query: {}", (Object)finalQuery);
        return MetadataCollections.OBJECTGROUP.getEsClient().search(MetadataCollections.OBJECTGROUP, tenantId, finalQuery, sorts, offset, limit, facets, scrollId, scrollTimeout, trackTotalHits);
    }

    protected Result<MetadataDocument<?>> lastSelectFilterProjection(SelectToMongodb requestToMongodb, Result<MetadataDocument<?>> last, boolean checkConsistency) throws InvalidParseOperationException, VitamDBException {
        Bson roots = QueryToMongodb.getRoots((String)"_id", last.getCurrentIds());
        Bson projection = requestToMongodb.getFinalProjection();
        boolean isIdIncluded = requestToMongodb.idWasInProjection();
        BuilderToken.FILTERARGS model = requestToMongodb.model();
        ArrayList<String> desynchronizedResults = new ArrayList<String>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("To Select: " + MongoDbHelper.bsonToString((Bson)roots, (boolean)false) + " " + (projection != null ? MongoDbHelper.bsonToString((Bson)projection, (boolean)false) : ""));
        }
        if (model == BuilderToken.FILTERARGS.UNITS) {
            HashMap<String, Unit> units = new HashMap<String, Unit>();
            FindIterable iterable = MetadataCollections.UNIT.getCollection().find(roots).projection(projection);
            try (MongoCursor cursor = iterable.iterator();){
                while (cursor.hasNext()) {
                    Unit unit = (Unit)((Object)cursor.next());
                    units.put(unit.getId(), unit);
                }
            }
            for (int i = 0; i < last.getCurrentIds().size(); ++i) {
                String id = last.getCurrentIds().get(i);
                Unit unit = (Unit)((Object)units.get(id));
                if (unit != null) {
                    if (VitamConfiguration.isExportScore() && MetadataCollections.UNIT.useScore() && requestToMongodb.isScoreIncluded()) {
                        Float score = Float.valueOf(1.0f);
                        try {
                            score = last.scores.get(i);
                            if (score.isNaN()) {
                                score = Float.valueOf(1.0f);
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                        }
                        unit.append("_score", score);
                    }
                    if (!isIdIncluded) {
                        unit.remove("_id");
                    }
                    last.addFinal(unit);
                    continue;
                }
                if (!checkConsistency) continue;
                desynchronizedResults.add(id);
                ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "DbRequest"})).inc();
                LOGGER.error(String.format(CONSISTENCY_ERROR_THE_DOCUMENT_GUID_S_IN_ES_IS_NOT_IN_MONGO_DB_ANYMORE_TENANT_S_REQUEST_ID_S, id, ParameterHelper.getTenantParameter(), VitamThreadUtils.getVitamSession().getRequestId()));
            }
            if (!desynchronizedResults.isEmpty()) {
                ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "DbRequest"})).inc();
                throw new VitamDBException("[Consistency ERROR] : An internal data consistency error has been detected !");
            }
            return last;
        }
        HashMap<String, ObjectGroup> obMap = new HashMap<String, ObjectGroup>();
        FindIterable<?> iterable = MongoDbMetadataHelper.select(MetadataCollections.OBJECTGROUP, roots, projection, null, -1, -1);
        try (MongoCursor cursor = iterable.iterator();){
            while (cursor.hasNext()) {
                ObjectGroup og = (ObjectGroup)((Object)cursor.next());
                obMap.put(og.getId(), og);
            }
        }
        for (int i = 0; i < last.getCurrentIds().size(); ++i) {
            String id = last.getCurrentIds().get(i);
            ObjectGroup og = (ObjectGroup)((Object)obMap.get(id));
            if (og != null) {
                if (VitamConfiguration.isExportScore() && MetadataCollections.OBJECTGROUP.useScore() && requestToMongodb.isScoreIncluded()) {
                    Float score = Float.valueOf(1.0f);
                    try {
                        score = last.scores.get(i);
                        if (score.isNaN()) {
                            score = Float.valueOf(1.0f);
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                    }
                    og.append("_score", score);
                }
                if (!isIdIncluded) {
                    og.remove("_id");
                }
                last.addFinal(og);
                continue;
            }
            if (!checkConsistency) continue;
            desynchronizedResults.add(id);
            ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "DbRequest"})).inc();
            LOGGER.error(String.format(CONSISTENCY_ERROR_THE_DOCUMENT_GUID_S_IN_ES_IS_NOT_IN_MONGO_DB_ANYMORE_TENANT_S_REQUEST_ID_S, id, ParameterHelper.getTenantParameter(), VitamThreadUtils.getVitamSession().getRequestId()));
        }
        if (!desynchronizedResults.isEmpty()) {
            ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "DbRequest"})).inc();
            throw new VitamDBException("[Consistency ERROR] : An internal data consistency error has been detected !");
        }
        return last;
    }

    private List<UpdatedDocument> updateDocumentWithRetries(List<RequestById> bulkRequests, MetadataCollections metadataCollection, OntologyValidator ontologyValidator, UnitValidator unitValidator, List<OntologyModel> ontologyModels, boolean forceUpdate, boolean refreshElasticIndexPostBulkIndexing) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException {
        boolean retryMore;
        Integer tenantId = ParameterHelper.getTenantParameter();
        if (CollectionUtils.isEmpty(bulkRequests)) {
            return Collections.emptyList();
        }
        DynamicParserTokens parserTokens = new DynamicParserTokens(metadataCollection.getVitamDescriptionResolver(), ontologyModels);
        HashMap<String, UpdatedDocument> updateDocumentResults = new HashMap<String, UpdatedDocument>();
        HashSet seen = new HashSet();
        Set duplicates = bulkRequests.stream().map(RequestById::getDocumentId).filter(val -> !seen.add(val)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(duplicates)) {
            throw new InvalidParseOperationException("Duplicate document Id found: " + String.join((CharSequence)",", duplicates));
        }
        Set<RequestById> remainRequests = new HashSet<RequestById>(bulkRequests);
        int tries = 0;
        HashMap<String, UpdatedDocument> failedUpdateDocuments = new HashMap<String, UpdatedDocument>();
        do {
            boolean hasFailedUpdates;
            Set<String> documentIds = remainRequests.stream().map(RequestById::getDocumentId).collect(Collectors.toSet());
            List<MetadataDocument> dbDocuments = this.loadDocumentsFromDb(documentIds, metadataCollection);
            Map<String, MetadataDocument> dbDocumentsById = dbDocuments.stream().collect(Collectors.toMap(MetadataDocument::getId, Function.identity()));
            Set<String> alreadyUpdatedDocumentIdsByCurrentProcess = this.retrieveDocumentIdsAlreadyUpdatedByCurrentProcess(remainRequests, dbDocumentsById, updateDocumentResults);
            Set<RequestById> requestsByIdToApplyOnMongoDb = remainRequests.stream().filter(requestById -> !alreadyUpdatedDocumentIdsByCurrentProcess.contains(requestById.getDocumentId())).collect(Collectors.toSet());
            Map<String, ObjectNode> transformedDocumentsToUpdateInMongo = this.transformDocumentsToUpdate(requestsByIdToApplyOnMongoDb, dbDocumentsById, parserTokens, ontologyValidator, metadataCollection, unitValidator, failedUpdateDocuments);
            Map<String, UpdatedDocument> documentsResultToIgnore = this.retrieveIgnoredDocumentForUpdate(metadataCollection, forceUpdate, remainRequests, dbDocumentsById, transformedDocumentsToUpdateInMongo, updateDocumentResults);
            documentsResultToIgnore.keySet().forEach(transformedDocumentsToUpdateInMongo::remove);
            List<WriteModel<MetadataDocument<?>>> bulkOperations = this.prepareDbBulkOperations(transformedDocumentsToUpdateInMongo, dbDocumentsById);
            Set<String> successUpdatedDocumentsIds = this.handleBulkingUpdateDocumentsInMongo(metadataCollection, bulkOperations, requestsByIdToApplyOnMongoDb, failedUpdateDocuments, tenantId);
            updateDocumentResults.putAll(this.handleIndexingDocumentsInElasticSearch(metadataCollection, refreshElasticIndexPostBulkIndexing, successUpdatedDocumentsIds, alreadyUpdatedDocumentIdsByCurrentProcess, transformedDocumentsToUpdateInMongo, dbDocumentsById, documentsResultToIgnore));
            updateDocumentResults.putAll(documentsResultToIgnore);
            boolean bl = hasFailedUpdates = successUpdatedDocumentsIds.size() != bulkOperations.size();
            if (hasFailedUpdates) {
                remainRequests = this.retrieveFailedDocuments(remainRequests, successUpdatedDocumentsIds);
                LOGGER.debug("Failed updated found with documents size : " + remainRequests.size());
                this.waitSomeTimeBeforeRetryFailed();
                if (++tries >= 3 && CollectionUtils.isEmpty(remainRequests)) {
                    LOGGER.error("After 3 retries, failed to documents with ids [" + String.join((CharSequence)", ", remainRequests.stream().map(RequestById::getDocumentId).collect(Collectors.toList())) + "]");
                    throw new IllegalStateException("After 3 retries, failed to documents with ids [" + String.join((CharSequence)", ", remainRequests.stream().map(RequestById::getDocumentId).collect(Collectors.toList())) + "]");
                }
                retryMore = tries < 3 && !remainRequests.isEmpty();
                continue;
            }
            retryMore = false;
        } while (retryMore);
        updateDocumentResults.putAll(failedUpdateDocuments);
        return updateDocumentResults.values().stream().collect(Collectors.toList());
    }

    private void waitSomeTimeBeforeRetryFailed() {
        try {
            long waitingMs = 10000L * (long)(new SecureRandom().nextInt(10) + 1);
            LOGGER.info("Waiting before retry for " + waitingMs);
            Thread.sleep(waitingMs);
        }
        catch (InterruptedException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
        }
    }

    private Set<String> handleBulkingUpdateDocumentsInMongo(MetadataCollections metadataCollection, List<WriteModel<MetadataDocument<?>>> bulkOperations, Set<RequestById> requestsByIdToApplyOnMongoDb, Map<String, UpdatedDocument> failedUpdateDocuments, Integer tenantId) {
        Set<String> successUpdatedDocumentsIds = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(bulkOperations)) {
            BulkWriteResult bulkWriteMongoResult = metadataCollection.getCollection().bulkWrite(bulkOperations, new BulkWriteOptions().ordered(false));
            Set<String> documentIdsRequestedToUpdate = requestsByIdToApplyOnMongoDb.stream().map(RequestById::getDocumentId).filter(documentId -> !failedUpdateDocuments.containsKey(documentId)).collect(Collectors.toSet());
            successUpdatedDocumentsIds = this.extractSuccessUpdatedDocumentIds(bulkWriteMongoResult, metadataCollection, bulkOperations.size(), documentIdsRequestedToUpdate, tenantId);
        }
        return successUpdatedDocumentsIds;
    }

    private Map<String, UpdatedDocument> handleIndexingDocumentsInElasticSearch(MetadataCollections metadataCollection, boolean refreshElasticIndexPostBulkIndexing, Set<String> successUpdatedDocumentsIds, Set<String> alreadyUpdatedDocumentIdsByCurrentProcess, Map<String, ObjectNode> transformedDocumentsToUpdateInMongo, Map<String, MetadataDocument> dbDocumentsById, Map<String, UpdatedDocument> documentsResultToIgnore) throws InvalidParseOperationException, MetaDataExecutionException {
        HashSet<String> documentIdsToIndexInEs = new HashSet<String>(successUpdatedDocumentsIds);
        documentIdsToIndexInEs.addAll(alreadyUpdatedDocumentIdsByCurrentProcess);
        HashMap<String, ObjectNode> documentsToIndexInES = new HashMap<String, ObjectNode>(transformedDocumentsToUpdateInMongo);
        for (String documentId : alreadyUpdatedDocumentIdsByCurrentProcess) {
            documentsToIndexInES.put(documentId, (ObjectNode)JsonHandler.toJsonNode((Object)((Object)dbDocumentsById.get(documentId))));
        }
        this.indexSuccessDocumentsInES(metadataCollection, documentIdsToIndexInEs, dbDocumentsById, documentsToIndexInES, refreshElasticIndexPostBulkIndexing);
        return this.prepareSuccessResponseResults(documentIdsToIndexInEs, documentsResultToIgnore, dbDocumentsById, transformedDocumentsToUpdateInMongo);
    }

    private Map<String, UpdatedDocument> prepareSuccessResponseResults(Set<String> documentIdsToIndexInEs, Map<String, UpdatedDocument> documentsResultToIgnore, Map<String, MetadataDocument> dbDocumentsById, Map<String, ObjectNode> transformedDocumentsToUpdateInMongo) throws InvalidParseOperationException {
        HashMap<String, UpdatedDocument> successUpdateDocumentResults = new HashMap<String, UpdatedDocument>();
        for (String successDocId : documentIdsToIndexInEs) {
            JsonNode afterUpdate = documentsResultToIgnore.containsKey(successDocId) ? JsonHandler.toJsonNode((Object)((Object)dbDocumentsById.get(successDocId))) : (JsonNode)transformedDocumentsToUpdateInMongo.get(successDocId);
            successUpdateDocumentResults.put(successDocId, new UpdatedDocument(successDocId, JsonHandler.toJsonNode((Object)((Object)dbDocumentsById.get(successDocId))), afterUpdate, true));
        }
        return successUpdateDocumentResults;
    }

    private List<WriteModel<MetadataDocument<?>>> prepareDbBulkOperations(Map<String, ObjectNode> transformedUpdatedDocuments, Map<String, MetadataDocument> dbDocumentsById) {
        ArrayList bulkOperations = new ArrayList();
        for (Map.Entry<String, ObjectNode> entryTransformedDoc : transformedUpdatedDocuments.entrySet()) {
            MetadataDocument currentDocument = dbDocumentsById.get(entryTransformedDoc.getKey());
            MetadataDocument transformedDocument = (MetadataDocument)currentDocument.newInstance((JsonNode)entryTransformedDoc.getValue());
            Bson filter = this.getUpdateDocumentFilter(currentDocument.getAtomicVersion(), entryTransformedDoc.getKey());
            bulkOperations.add((WriteModel<MetadataDocument<?>>)new ReplaceOneModel(filter, (Object)transformedDocument));
        }
        return bulkOperations;
    }

    private Map<String, UpdatedDocument> retrieveIgnoredDocumentForUpdate(MetadataCollections metadataCollection, boolean forceUpdate, Set<RequestById> requestsToApply, Map<String, MetadataDocument> dbDocumentsById, Map<String, ObjectNode> transformedUpdatedDocuments, Map<String, UpdatedDocument> updateDocumentResults) throws InvalidParseOperationException {
        if (metadataCollection == MetadataCollections.UNIT) {
            for (RequestById request : requestsToApply) {
                String documentId = request.getDocumentId();
                MetadataDocument currentDocument = dbDocumentsById.get(documentId);
                ObjectNode transformedUpdatedDocument = transformedUpdatedDocuments.get(documentId);
                JsonNode currentJsonDocument = JsonHandler.toJsonNode((Object)((Object)currentDocument));
                if (forceUpdate || this.hasModificationOfUnitDescriptiveMetadata(currentJsonDocument, (JsonNode)transformedUpdatedDocument)) continue;
                updateDocumentResults.put(documentId, new UpdatedDocument(documentId, currentJsonDocument, currentJsonDocument, false));
            }
        }
        return updateDocumentResults;
    }

    private Set<String> retrieveDocumentIdsAlreadyUpdatedByCurrentProcess(Set<RequestById> remainRequests, Map<String, MetadataDocument> dbDocumentsById, Map<String, UpdatedDocument> updateDocumentResults) throws InvalidParseOperationException {
        HashSet<String> alreadyUpdatedDocumentBefore = new HashSet<String>();
        for (RequestById request : remainRequests) {
            String documentId;
            MetadataDocument currentDocument;
            RequestParserMultiple requestParser = request.getRequest();
            if (!this.noChangesAndOpsAlreadyContainingOperation(requestParser, currentDocument = dbDocumentsById.get(documentId = request.getDocumentId()))) continue;
            alreadyUpdatedDocumentBefore.add(documentId);
            JsonNode currentJsonDocument = JsonHandler.toJsonNode((Object)((Object)currentDocument));
            updateDocumentResults.put(documentId, new UpdatedDocument(documentId, currentJsonDocument, currentJsonDocument, true));
        }
        return alreadyUpdatedDocumentBefore;
    }

    private Map<String, ObjectNode> transformDocumentsToUpdate(Set<RequestById> requestsToHandle, Map<String, MetadataDocument> oldDocuments, DynamicParserTokens parserTokens, OntologyValidator ontologyValidator, MetadataCollections metadataCollection, UnitValidator unitValidator, Map<String, UpdatedDocument> failedUpdateDocuments) throws InvalidParseOperationException {
        LOGGER.debug("Handling transformation for bulk update for a set of " + requestsToHandle.size());
        HashMap<String, ObjectNode> transformedDocumentsToUpdate = new HashMap<String, ObjectNode>();
        for (RequestById request : requestsToHandle) {
            String documentId = request.getDocumentId();
            RequestParserMultiple requestParser = request.getRequest();
            MetadataDocument currentDocument = oldDocuments.get(documentId);
            JsonNode currentJsonDocument = JsonHandler.toJsonNode((Object)((Object)currentDocument));
            try {
                MongoDbInMemory mongoInMemory = new MongoDbInMemory(currentJsonDocument, parserTokens);
                ObjectNode updatedJsonDocument = (ObjectNode)mongoInMemory.getUpdateJson((AbstractParser)requestParser);
                if (metadataCollection == MetadataCollections.UNIT) {
                    this.fieldHistoryManager.trigger(currentJsonDocument, (JsonNode)updatedJsonDocument);
                }
                Integer docVersion = currentDocument.getVersion();
                int newDocVersion = this.incrementDocumentVersionIfRequired(metadataCollection, mongoInMemory, docVersion);
                updatedJsonDocument.put("_v", newDocVersion);
                Integer atomicVersion = currentDocument.getAtomicVersion();
                int newAtomicVersion = atomicVersion == null ? newDocVersion : atomicVersion + 1;
                updatedJsonDocument.put("_av", newAtomicVersion);
                ObjectNode transformedUpdatedDocument = ontologyValidator.verifyAndReplaceFields((JsonNode)updatedJsonDocument);
                if (newDocVersion != docVersion) {
                    transformedUpdatedDocument.put("_aud", LocalDateUtil.nowFormatted());
                }
                if (metadataCollection == MetadataCollections.UNIT) {
                    unitValidator.validateUnit(transformedUpdatedDocument);
                }
                LOGGER.debug("DEBUG update {}", (Object)transformedUpdatedDocument);
                transformedDocumentsToUpdate.put(documentId, transformedUpdatedDocument);
            }
            catch (MetadataValidationException e) {
                LOGGER.error("Failed to validate document with id:  " + documentId + " error" + e.getMessage());
                failedUpdateDocuments.put(documentId, new UpdatedDocument(documentId, currentJsonDocument, currentJsonDocument, false, e.getErrorCode(), e.getMessage()));
            }
        }
        return transformedDocumentsToUpdate;
    }

    private Set<RequestById> retrieveFailedDocuments(Set<RequestById> remainRequestsToHandle, Set<String> successUpdatedDocumentsIds) {
        return remainRequestsToHandle.stream().filter(requestById -> successUpdatedDocumentsIds.contains(requestById.getDocumentId())).collect(Collectors.toSet());
    }

    private Bson getUpdateDocumentFilter(Integer atomicVersion, String documentId) {
        Bson condition = atomicVersion == null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)documentId), Filters.exists((String)"_av", (boolean)false)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)documentId), Filters.eq((String)"_av", (Object)atomicVersion)});
        return condition;
    }

    private void indexSuccessDocumentsInES(MetadataCollections metadataCollection, Set<String> documentIdsToIndex, Map<String, MetadataDocument> dbDocumentsById, Map<String, ObjectNode> updatedDocuments, boolean withRefreshIndex) throws MetaDataExecutionException {
        if (CollectionUtils.isEmpty(documentIdsToIndex)) {
            return;
        }
        ArrayList documentsToIndex = new ArrayList();
        for (String successDocId : documentIdsToIndex) {
            if (!updatedDocuments.containsKey(successDocId)) continue;
            MetadataDocument currentDoc = dbDocumentsById.get(successDocId);
            documentsToIndex.add((MetadataDocument)currentDoc.newInstance((JsonNode)updatedDocuments.get(successDocId)));
        }
        this.indexUpdatedDocuments(metadataCollection, documentsToIndex, withRefreshIndex);
    }

    private Set<String> extractSuccessUpdatedDocumentIds(BulkWriteResult bulkWriteResult, MetadataCollections metadataCollection, int bulkedDocumentCount, Set<String> documentIdsRequestToUpdate, Integer tenantId) {
        HashSet<String> successDocumentsId = new HashSet();
        if (bulkWriteResult.getModifiedCount() == bulkedDocumentCount) {
            successDocumentsId = documentIdsRequestToUpdate;
        } else {
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)tenantId), Filters.in((String)"_id", documentIdsRequestToUpdate), Filters.eq((String)"_ops", (Object)VitamThreadUtils.getVitamSession().getRequestId())});
            try (MongoCursor cursor = metadataCollection.getCollection().find(filter).projection((Bson)ID_PROJECTION).iterator();){
                while (cursor.hasNext()) {
                    MetadataDocument document = (MetadataDocument)((Object)cursor.next());
                    successDocumentsId.add(document.getId());
                }
            }
        }
        return successDocumentsId;
    }

    private List<MetadataDocument> loadDocumentsFromDb(Set<String> documentIds, MetadataCollections collection) throws MetaDataNotFoundException {
        LOGGER.debug("Loading documents from for documents id " + String.join((CharSequence)", ", documentIds));
        ArrayList<MetadataDocument> documents = new ArrayList<MetadataDocument>();
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.in((String)"_id", documentIds), Filters.eq((String)"_tenant", (Object)VitamThreadUtils.getVitamSession().getTenantId())});
        try (MongoCursor cursor = collection.getCollection().find(filter).iterator();){
            while (cursor.hasNext()) {
                MetadataDocument document = (MetadataDocument)((Object)cursor.next());
                documents.add(document);
            }
        }
        if (documents.size() != documentIds.size()) {
            throw new MetaDataNotFoundException("Number of documents found is different to the requested document list, the document nb requested is:  " + documents.size() + "but document found is :  " + documentIds.size());
        }
        return documents;
    }

    private boolean hasModificationOfUnitDescriptiveMetadata(JsonNode oldDocument, JsonNode newDocument) {
        List diffLines = VitamDocument.getConcernedDiffLines((List)VitamDocument.getUnifiedDiff((String)JsonHandler.prettyPrint((Object)oldDocument), (String)JsonHandler.prettyPrint((Object)newDocument)));
        long metadataModifications = diffLines.stream().filter(line -> !line.contains("\"_v\"")).filter(line -> !line.contains("\"_av\"")).filter(line -> !line.contains("\"_glpd\"")).filter(line -> !line.contains("\"_ops\"")).filter(line -> !line.contains("\"_acd\"")).filter(line -> !line.contains("\"_aud\"")).filter(line -> !line.contains("\"_history\"")).count();
        return metadataModifications > 0L;
    }

    private boolean noChangesAndOpsAlreadyContainingOperation(RequestParserMultiple requestParser, MetadataDocument<?> document) {
        Optional<Action> actionWithOp = requestParser.getRequest().getActions().stream().filter(a -> !a.getCurrentAction().at(JSON_POINTER_TO_OPS).isMissingNode()).findFirst();
        if (actionWithOp.isEmpty()) {
            return false;
        }
        String opsToAdd = actionWithOp.get().getCurrentObject().at(JSON_POINTER_TO_OPS).asText();
        Collection existingOps = document.getCollectionOrEmpty("_ops");
        return existingOps.contains(opsToAdd);
    }

    private int incrementDocumentVersionIfRequired(MetadataCollections metadataCollection, MongoDbInMemory mongoInMemory, int documentVersion) {
        Set computedFields;
        Set updatedFields = mongoInMemory.getUpdatedFields();
        Set set = computedFields = metadataCollection == MetadataCollections.UNIT ? MetadataDocumentHelper.getComputedUnitFields() : MetadataDocumentHelper.getComputedObjectGroupFields();
        if (computedFields.containsAll(updatedFields)) {
            return documentVersion;
        }
        return documentVersion + 1;
    }

    private void indexUpdatedDocuments(MetadataCollections collection, Collection<MetadataDocument<?>> updatedDocuments, boolean withRefreshIndex) throws MetaDataExecutionException {
        if (collection == MetadataCollections.UNIT) {
            this.indexUpdatedDocuments(updatedDocuments, ParameterHelper.getTenantParameter(), withRefreshIndex);
        } else {
            this.indexUpdatedOGDocuments(updatedDocuments, ParameterHelper.getTenantParameter(), withRefreshIndex);
        }
    }

    private void indexUpdatedDocuments(Collection<MetadataDocument<?>> updatedDocuments, Integer tenantId, boolean withRefreshIndex) throws MetaDataExecutionException {
        MetadataCollections.UNIT.getEsClient().insertFullDocumentsWithRefreshSettings(MetadataCollections.UNIT, tenantId, updatedDocuments, withRefreshIndex);
    }

    private void indexFieldsUpdated(MetadataDocument<?> updatedDocument, Integer tenantId) throws MetaDataExecutionException {
        MetadataCollections.UNIT.getEsClient().updateFullDocument(MetadataCollections.UNIT, tenantId, updatedDocument.getId(), updatedDocument);
    }

    private void indexUpdatedOGDocuments(Collection<MetadataDocument<?>> updatedDocuments, Integer tenantId, boolean withRefreshIndex) throws MetaDataExecutionException {
        MetadataCollections.OBJECTGROUP.getEsClient().insertFullDocumentsWithRefreshSettings(MetadataCollections.OBJECTGROUP, tenantId, updatedDocuments, withRefreshIndex);
    }

    private void removeOGIndexFields(Result<MetadataDocument<?>> last) throws Exception {
        Integer tenantId = ParameterHelper.getTenantParameter();
        if (last.getCurrentIds().isEmpty()) {
            LOGGER.error("ES delete in error since no results to delete");
            return;
        }
        MetadataCollections.OBJECTGROUP.getEsClient().deleteBulkOGEntriesIndexes(last.getCurrentIds(), tenantId);
    }

    private void removeUnitIndexFields(Result<MetadataDocument<?>> last) throws Exception {
        Integer tenantId = ParameterHelper.getTenantParameter();
        if (last.getCurrentIds().isEmpty()) {
            LOGGER.error("ES delete in error since no results to delete");
            return;
        }
        MetadataCollections.UNIT.getEsClient().deleteBulkUnitsEntriesIndexes(last.getCurrentIds(), tenantId);
    }

    @Deprecated
    public void execInsertUnitRequest(InsertParserMultiple requestParser) throws MetaDataExecutionException, MetaDataNotFoundException {
        LOGGER.debug("Exec db insert unit request: %s", (Object)requestParser);
        this.execInsertUnitRequests(Collections.singletonList(requestParser));
    }

    public void execInsertObjectGroupRequests(List<InsertParserMultiple> requestParsers) throws MetaDataExecutionException, InvalidParseOperationException {
        LOGGER.debug("Exec db insert object group request: %s", requestParsers);
        boolean withRefreshIndex = true;
        Integer tenantId = ParameterHelper.getTenantParameter();
        ArrayList<ObjectGroup> objectGroups = new ArrayList<ObjectGroup>();
        for (InsertParserMultiple insertParserMultiple : requestParsers) {
            InsertToMongodb requestToMongodb = (InsertToMongodb)RequestToMongodb.getRequestToMongoDb((AbstractParser)insertParserMultiple);
            ObjectGroup og = new ObjectGroup(requestToMongodb.getFinalData());
            this.setDateCreationAndModification(og);
            objectGroups.add(og);
        }
        Stopwatch mongoWatch = Stopwatch.createStarted();
        this.mongoDbObjectGroupRepository.insert(objectGroups);
        PerformanceLogger.getInstance().log("STP_OBJ_STORING", "OG_METADATA_INDEXATION", "storeMongo", mongoWatch.elapsed(TimeUnit.MILLISECONDS));
        this.persistInElasticSearch(MetadataCollections.OBJECTGROUP, tenantId, objectGroups, "STP_OBJ_STORING", "OG_METADATA_INDEXATION", withRefreshIndex);
    }

    private void persistInElasticSearch(MetadataCollections collection, Integer tenantId, List<? extends MetadataDocument<?>> documents, String logKey, String logAction, boolean withRefreshIndex) throws MetaDataExecutionException {
        Stopwatch stopWatch = Stopwatch.createStarted();
        collection.getEsClient().insertFullDocumentsWithRefreshSettings(collection, tenantId, documents, withRefreshIndex);
        PerformanceLogger.getInstance().log(logKey, logAction, "storeElastic", stopWatch.elapsed(TimeUnit.MILLISECONDS));
    }

    protected Result<MetadataDocument<?>> lastDeleteFilterProjection(DeleteToMongodb requestToMongodb, Result<MetadataDocument<?>> last) throws MetaDataExecutionException {
        Bson roots = QueryToMongodb.getRoots((String)"_id", last.getCurrentIds());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("To Delete: " + MongoDbHelper.bsonToString((Bson)roots, (boolean)false));
        }
        if (!requestToMongodb.isMultiple() && last.getNbResult() > 1L) {
            throw new MetaDataExecutionException("Delete Request is not multiple but found multiples entities to delete");
        }
        BuilderToken.FILTERARGS model = requestToMongodb.model();
        try {
            if (model == BuilderToken.FILTERARGS.UNITS) {
                DeleteResult result = MongoDbMetadataHelper.delete(MetadataCollections.UNIT, roots, last.getCurrentIds().size());
                if (result.getDeletedCount() != last.getNbResult()) {
                    LOGGER.warn("Deleted items different than specified");
                }
                this.removeUnitIndexFields(last);
                return last;
            }
            DeleteResult result = MongoDbMetadataHelper.delete(MetadataCollections.OBJECTGROUP, roots, last.getCurrentIds().size());
            if (result.getDeletedCount() != last.getNbResult()) {
                LOGGER.warn("Deleted items different than specified");
            }
            this.removeOGIndexFields(last);
            last.setTotal(last.getNbResult());
            return last;
        }
        catch (MetaDataExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetaDataExecutionException("Delete concern", (Throwable)e);
        }
    }

    public void execInsertUnitRequests(List<InsertParserMultiple> requests) throws MetaDataExecutionException, MetaDataNotFoundException {
        LOGGER.debug("Exec db insert unit request: %s", requests);
        boolean withRefreshIndex = true;
        ArrayList unitToSave = Lists.newArrayList();
        HashMap<String, ObjectGroupGraphUpdates> objectGroupGraphUpdatesMap = new HashMap<String, ObjectGroupGraphUpdates>();
        Integer tenantId = ParameterHelper.getTenantParameter();
        try (GraphLoader graphLoader = new GraphLoader(this.mongoDbUnitRepository);){
            HashSet allRoots = new HashSet();
            for (InsertParserMultiple entry : requests) {
                allRoots.addAll(entry.getRequest().getRoots());
            }
            Stopwatch loadParentAU = Stopwatch.createStarted();
            Map<String, UnitGraphModel> parentGraphs = graphLoader.loadGraphInfo(allRoots);
            PerformanceLogger.getInstance().log("STP_UNIT_METADATA", "UNIT_METADATA_INDEXATION", "loadParentAU", loadParentAU.elapsed(TimeUnit.MILLISECONDS));
            Stopwatch computeAU = Stopwatch.createStarted();
            for (InsertParserMultiple entry : requests) {
                Unit unit = new Unit((JsonNode)entry.getRequest().getData());
                Set roots = entry.getRequest().getRoots();
                UnitGraphModel unitGraphModel = new UnitGraphModel(unit);
                roots.forEach(parentId -> {
                    UnitGraphModel parentGraphModel = (UnitGraphModel)parentGraphs.get(parentId);
                    unitGraphModel.addParent(parentGraphModel);
                });
                unit.mergeWith(unitGraphModel);
                this.setDateCreationAndModification(unit);
                unitToSave.add(unit);
                String ogId = unit.getString("_og");
                if (!StringUtils.isNotEmpty((String)ogId)) continue;
                ObjectGroupGraphUpdates objectGroupGraphUpdates = objectGroupGraphUpdatesMap.computeIfAbsent(ogId, id -> new ObjectGroupGraphUpdates());
                objectGroupGraphUpdates.buildParentGraph(unit);
            }
            PerformanceLogger.getInstance().log("STP_UNIT_METADATA", "UNIT_METADATA_INDEXATION", "computeAU", computeAU.elapsed(TimeUnit.MILLISECONDS));
            if (!unitToSave.isEmpty()) {
                Stopwatch saveAU = Stopwatch.createStarted();
                this.mongoDbUnitRepository.insert(unitToSave);
                PerformanceLogger.getInstance().log("STP_UNIT_METADATA", "UNIT_METADATA_INDEXATION", "saveUnitInMongo", saveAU.elapsed(TimeUnit.MILLISECONDS));
                this.persistInElasticSearch(MetadataCollections.UNIT, tenantId, unitToSave, "STP_UNIT_METADATA", "UNIT_METADATA_INDEXATION", withRefreshIndex);
            }
            if (!objectGroupGraphUpdatesMap.isEmpty()) {
                Stopwatch saveGOT = Stopwatch.createStarted();
                Map<String, Bson> updates = objectGroupGraphUpdatesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((ObjectGroupGraphUpdates)item.getValue()).toBsonUpdate()));
                this.mongoDbObjectGroupRepository.update(updates);
                PerformanceLogger.getInstance().log("STP_UNIT_METADATA", "UNIT_METADATA_INDEXATION", "saveGOTInMongo", saveGOT.elapsed(TimeUnit.MILLISECONDS));
                saveGOT = Stopwatch.createStarted();
                List<ObjectGroup> objectGroups = this.mongoDbObjectGroupRepository.selectByIds(updates.keySet(), null);
                MetadataCollections.OBJECTGROUP.getEsClient().insertFullDocuments(MetadataCollections.OBJECTGROUP, tenantId, objectGroups);
                PerformanceLogger.getInstance().log("STP_UNIT_METADATA", "UNIT_METADATA_INDEXATION", "saveGOTInElastic", saveGOT.elapsed(TimeUnit.MILLISECONDS));
            }
        }
        catch (MongoException e) {
            throw new MetaDataExecutionException("Insert concern", (Throwable)e);
        }
    }

    private void setDateCreationAndModification(MetadataDocument<? extends MetadataDocument<?>> metadataDocument) {
        LocalDateTime now = LocalDateUtil.now();
        metadataDocument.setApproximateCreationDate(now);
        metadataDocument.setApproximateUpdateDate(now);
    }

    public void deleteUnits(List<String> documentsToDelete) throws MetaDataExecutionException {
        if (documentsToDelete.isEmpty()) {
            return;
        }
        Integer tenantId = ParameterHelper.getTenantParameter();
        MetadataCollections.UNIT.getEsClient().deleteBulkUnitsEntriesIndexes(documentsToDelete, tenantId);
        ArrayList<Unit> documents = new ArrayList<Unit>();
        for (String id : documentsToDelete) {
            documents.add((Unit)new Unit().append("_id", id).append("_tenant", (Object)tenantId));
        }
        this.mongoDbUnitRepository.delete(documents);
    }

    public void deleteObjectGroups(List<String> documentsToDelete) throws MetaDataExecutionException {
        if (documentsToDelete.isEmpty()) {
            return;
        }
        Integer tenantId = ParameterHelper.getTenantParameter();
        MetadataCollections.OBJECTGROUP.getEsClient().deleteBulkOGEntriesIndexes(documentsToDelete, tenantId);
        ArrayList<ObjectGroup> documents = new ArrayList<ObjectGroup>();
        for (String id : documentsToDelete) {
            documents.add((ObjectGroup)new ObjectGroup().append("_id", id).append("_tenant", (Object)tenantId));
        }
        this.mongoDbObjectGroupRepository.delete(documents);
    }

    public void clearEsScrollId(String scrollId) {
        try {
            MetadataCollections.UNIT.getEsClient().clearScroll(scrollId);
        }
        catch (DatabaseException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }
}

