/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.config;

import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.common.model.config.CollectionConfigurationUtils;
import fr.gouv.vitam.common.model.config.TenantRange;
import fr.gouv.vitam.common.model.config.TenantRangeParser;
import fr.gouv.vitam.metadata.core.config.DedicatedTenantConfiguration;
import fr.gouv.vitam.metadata.core.config.GroupedTenantConfiguration;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.config.MetadataIndexationConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public final class MetaDataConfigurationValidator {
    private static final String TENANT_GROUP_NAME_PATTERN = "^[a-z][a-z0-9]{1,63}$";

    private MetaDataConfigurationValidator() {
    }

    public static void validateConfiguration(MetaDataConfiguration metaDataConfiguration) {
        if (metaDataConfiguration == null) {
            throw new IllegalStateException("Invalid configuration. Null config");
        }
        MetaDataConfigurationValidator.validateElasticsearchIndexationConfiguration(metaDataConfiguration.getIndexationConfiguration());
    }

    private static void validateElasticsearchIndexationConfiguration(MetadataIndexationConfiguration indexationConfiguration) {
        if (indexationConfiguration == null) {
            throw new IllegalStateException("Invalid configuration. Missing ES tenant indexation");
        }
        MetaDataConfigurationValidator.validateDefaultConfig(indexationConfiguration);
        MetaDataConfigurationValidator.validateTenantGroupNames(indexationConfiguration);
        MetaDataConfigurationValidator.validateTenantRanges(indexationConfiguration);
        MetaDataConfigurationValidator.validateCollectionConfiguration(indexationConfiguration);
    }

    private static void validateDefaultConfig(MetadataIndexationConfiguration config) throws IllegalStateException {
        if (config.getDefaultCollectionConfiguration() == null) {
            throw new IllegalStateException("Invalid configuration. Missing default configuration");
        }
        CollectionConfigurationUtils.validate((CollectionConfiguration)config.getDefaultCollectionConfiguration().getUnit(), (boolean)false);
        CollectionConfigurationUtils.validate((CollectionConfiguration)config.getDefaultCollectionConfiguration().getObjectgroup(), (boolean)false);
    }

    private static void validateTenantGroupNames(MetadataIndexationConfiguration indexationConfiguration) {
        if (CollectionUtils.isEmpty(indexationConfiguration.getGroupedTenantConfiguration())) {
            return;
        }
        HashSet tenantGroupNames = new HashSet();
        indexationConfiguration.getGroupedTenantConfiguration().stream().map(GroupedTenantConfiguration::getName).forEach(name -> {
            if (name == null) {
                throw new IllegalStateException("Invalid configuration. Missing tenant group name");
            }
            if (!name.matches(TENANT_GROUP_NAME_PATTERN)) {
                throw new IllegalStateException("Invalid configuration. Tenant group name '" + name + "' does not match regex ^[a-z][a-z0-9]{1,63}$");
            }
            if (!tenantGroupNames.add(name)) {
                throw new IllegalStateException("Invalid configuration. Duplicate tenant group name " + name);
            }
        });
    }

    private static void validateTenantRanges(MetadataIndexationConfiguration indexationConfiguration) {
        ArrayList tenantRangeStrings = new ArrayList();
        if (CollectionUtils.isNotEmpty(indexationConfiguration.getGroupedTenantConfiguration())) {
            indexationConfiguration.getGroupedTenantConfiguration().stream().map(GroupedTenantConfiguration::getTenants).forEach(tenantRangeStrings::add);
        }
        if (CollectionUtils.isNotEmpty(indexationConfiguration.getDedicatedTenantConfiguration())) {
            indexationConfiguration.getDedicatedTenantConfiguration().stream().map(DedicatedTenantConfiguration::getTenants).forEach(tenantRangeStrings::add);
        }
        if (tenantRangeStrings.contains(null)) {
            throw new IllegalStateException("Invalid configuration. Missing tenants from dedicated tenant or grouped tenant configuration");
        }
        List tenantRanges = tenantRangeStrings.stream().flatMap(tenantRangeString -> TenantRangeParser.parseTenantRanges((String)tenantRangeString).stream()).collect(Collectors.toList());
        for (int i = 0; i < tenantRanges.size(); ++i) {
            for (int j = i + 1; j < tenantRanges.size(); ++j) {
                if (!TenantRangeParser.doRangesIntersect((TenantRange)((TenantRange)tenantRanges.get(i)), (TenantRange)((TenantRange)tenantRanges.get(j)))) continue;
                throw new IllegalStateException("Invalid configuration. Overlapping tenant ranges " + tenantRanges.get(i) + " and " + tenantRanges.get(j));
            }
        }
    }

    private static void validateCollectionConfiguration(MetadataIndexationConfiguration indexationConfiguration) {
        if (CollectionUtils.isNotEmpty(indexationConfiguration.getDedicatedTenantConfiguration())) {
            for (DedicatedTenantConfiguration dedicatedTenantConfiguration : indexationConfiguration.getDedicatedTenantConfiguration()) {
                if (dedicatedTenantConfiguration.getUnit() != null) {
                    CollectionConfigurationUtils.validate((CollectionConfiguration)dedicatedTenantConfiguration.getUnit(), (boolean)true);
                }
                if (dedicatedTenantConfiguration.getObjectgroup() == null) continue;
                CollectionConfigurationUtils.validate((CollectionConfiguration)dedicatedTenantConfiguration.getObjectgroup(), (boolean)true);
            }
        }
        if (CollectionUtils.isNotEmpty(indexationConfiguration.getGroupedTenantConfiguration())) {
            for (GroupedTenantConfiguration groupedTenantConfiguration : indexationConfiguration.getGroupedTenantConfiguration()) {
                if (groupedTenantConfiguration.getUnit() != null) {
                    CollectionConfigurationUtils.validate((CollectionConfiguration)groupedTenantConfiguration.getUnit(), (boolean)true);
                }
                if (groupedTenantConfiguration.getObjectgroup() == null) continue;
                CollectionConfigurationUtils.validate((CollectionConfiguration)groupedTenantConfiguration.getObjectgroup(), (boolean)true);
            }
        }
    }
}

