/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.server.application.configuration.DbConfigurationImpl;
import fr.gouv.vitam.common.server.application.configuration.MongoDbNode;
import fr.gouv.vitam.common.server.application.configuration.MongoDbShardConf;
import fr.gouv.vitam.metadata.core.config.ElasticsearchExternalMetadataMapping;
import fr.gouv.vitam.metadata.core.config.MetadataIndexationConfiguration;
import fr.gouv.vitam.metadata.core.config.TimeToLiveConfiguration;
import fr.gouv.vitam.metadata.core.mapping.MappingLoader;
import java.util.List;

public class MetaDataConfiguration
extends DbConfigurationImpl {
    private String workspaceUrl;
    private String urlProcessing;
    private String clusterName;
    private List<ElasticsearchNode> elasticsearchNodes;
    private String contextPath;
    private Boolean collectModule = Boolean.FALSE;
    private int archiveUnitProfileCacheMaxEntries = 100;
    private int archiveUnitProfileCacheTimeoutInSeconds = 300;
    private int schemaValidatorCacheMaxEntries = 100;
    private int schemaValidatorCacheTimeoutInSeconds = 300;
    private int dipTimeToLiveInMinutes = 10080;
    private int criticalDipTimeToLiveInMinutes = 1440;
    private int transfersSIPTimeToLiveInMinutes = 10080;
    private int reconstructionMetricsCacheDurationInMinutes = 15;
    private List<ElasticsearchExternalMetadataMapping> elasticsearchExternalMetadataMappings;
    @JsonProperty(value="unitsStreamThreshold")
    private long unitsStreamThreshold = 1000000L;
    @JsonProperty(value="unitsStreamExecutionLimit")
    private short unitsStreamExecutionLimit = (short)3;
    @JsonProperty(value="objectsStreamThreshold")
    private long objectsStreamThreshold = 1000000L;
    @JsonProperty(value="objectsStreamExecutionLimit")
    private short objectsStreamExecutionLimit = (short)3;
    @JsonProperty(value="persistentIdentifierReconstructionDelayInMinutes")
    private long persistentIdentifierReconstructionDelayInMinutes = 1440L;
    @JsonProperty(value="persistentIdentifierReconstructionThreadPoolSize")
    private int persistentIdentifierReconstructionThreadPoolSize = 10;
    @JsonProperty(value="persistentIdentifierReconstructionBulkSize")
    private int persistentIdentifierReconstructionBulkSize = 1000;
    @JsonProperty(value="elasticsearchTenantIndexation")
    private MetadataIndexationConfiguration indexationConfiguration;
    @JsonProperty(value="isDataConsistencyAuditRunnable")
    private boolean isDataConsistencyAuditRunnable;
    @JsonProperty(value="enableDataConsistencyRectificationMode")
    private boolean enableDataConsistencyRectificationMode;
    @JsonProperty(value="dataConsistencyAuditOplogMaxSize")
    private Integer dataConsistencyAuditOplogMaxSize;
    @JsonProperty(value="mongodShardsConf")
    private MongoDbShardConf mongodShardsConf;
    @JsonProperty(value="refreshElasticIndexPostBulkIndexing")
    private Boolean refreshElasticIndexPostBulkIndexing;
    @JsonProperty(value="reconstructionPoolSize")
    private int reconstructionPoolSize = 16;
    @JsonProperty(value="reconstructionBatchSize")
    private int reconstructionBatchSize = 1000;
    @JsonProperty(value="reconstructionBatchLoadingTimeoutInSeconds")
    private int reconstructionBatchLoadingTimeoutInSeconds = 600;

    public MetaDataConfiguration(List<MongoDbNode> mongoDbNodes, String dbName, String clusterName, List<ElasticsearchNode> elasticsearchNodes, MappingLoader mappingLoader) {
        super(mongoDbNodes, dbName);
        ParametersChecker.checkParameter((String)"elasticsearch cluster name is a mandatory parameter", (String[])new String[]{clusterName});
        ParametersChecker.checkParameter((String)"elasticsearch nodes are a mandatory parameter", (Object[])new Object[]{elasticsearchNodes});
        this.clusterName = clusterName;
        this.elasticsearchNodes = elasticsearchNodes;
        this.elasticsearchExternalMetadataMappings = mappingLoader.getElasticsearchExternalMappings();
    }

    public MetaDataConfiguration(List<MongoDbNode> mongoDbNodes, String dbName, String clusterName, List<ElasticsearchNode> elasticsearchNodes, boolean dbAuthentication, String dbUserName, String dbPassword, MappingLoader mappingLoader) {
        super(mongoDbNodes, dbName, dbAuthentication, dbUserName, dbPassword);
        ParametersChecker.checkParameter((String)"elasticsearch cluster name is a mandatory parameter", (String[])new String[]{clusterName});
        ParametersChecker.checkParameter((String)"elasticsearch nodes are a mandatory parameter", (Object[])new Object[]{elasticsearchNodes});
        this.clusterName = clusterName;
        this.elasticsearchNodes = elasticsearchNodes;
        this.elasticsearchExternalMetadataMappings = mappingLoader.getElasticsearchExternalMappings();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public MetaDataConfiguration setContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public Boolean getCollectModule() {
        return this.collectModule;
    }

    public void setCollectModule(Boolean collectModule) {
        this.collectModule = collectModule;
    }

    public MetaDataConfiguration() {
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public MetaDataConfiguration setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public List<ElasticsearchNode> getElasticsearchNodes() {
        return this.elasticsearchNodes;
    }

    public MetaDataConfiguration setElasticsearchNodes(List<ElasticsearchNode> elasticsearchNodes) {
        this.elasticsearchNodes = elasticsearchNodes;
        return this;
    }

    public String getWorkspaceUrl() {
        return this.workspaceUrl;
    }

    public MetaDataConfiguration setWorkspaceUrl(String workspaceUrl) {
        this.workspaceUrl = workspaceUrl;
        return this;
    }

    public int getArchiveUnitProfileCacheMaxEntries() {
        return this.archiveUnitProfileCacheMaxEntries;
    }

    public MetaDataConfiguration setArchiveUnitProfileCacheMaxEntries(int archiveUnitProfileCacheMaxEntries) {
        this.archiveUnitProfileCacheMaxEntries = archiveUnitProfileCacheMaxEntries;
        return this;
    }

    public int getArchiveUnitProfileCacheTimeoutInSeconds() {
        return this.archiveUnitProfileCacheTimeoutInSeconds;
    }

    public MetaDataConfiguration setArchiveUnitProfileCacheTimeoutInSeconds(int archiveUnitProfileCacheTimeoutInSeconds) {
        this.archiveUnitProfileCacheTimeoutInSeconds = archiveUnitProfileCacheTimeoutInSeconds;
        return this;
    }

    public int getSchemaValidatorCacheMaxEntries() {
        return this.schemaValidatorCacheMaxEntries;
    }

    public MetaDataConfiguration setSchemaValidatorCacheMaxEntries(int schemaValidatorCacheMaxEntries) {
        this.schemaValidatorCacheMaxEntries = schemaValidatorCacheMaxEntries;
        return this;
    }

    public int getSchemaValidatorCacheTimeoutInSeconds() {
        return this.schemaValidatorCacheTimeoutInSeconds;
    }

    public MetaDataConfiguration setSchemaValidatorCacheTimeoutInSeconds(int schemaValidatorCacheTimeoutInSeconds) {
        this.schemaValidatorCacheTimeoutInSeconds = schemaValidatorCacheTimeoutInSeconds;
        return this;
    }

    public String getUrlProcessing() {
        return this.urlProcessing;
    }

    public void setUrlProcessing(String urlProcessing) {
        this.urlProcessing = urlProcessing;
    }

    public int getDipTimeToLiveInMinutes() {
        return this.dipTimeToLiveInMinutes;
    }

    public void setDipTimeToLiveInMinutes(int dipTimeToLiveInMinutes) {
        this.dipTimeToLiveInMinutes = dipTimeToLiveInMinutes;
    }

    public int getTransfersSIPTimeToLiveInMinutes() {
        return this.transfersSIPTimeToLiveInMinutes;
    }

    public void setTransfersSIPTimeToLiveInMinutes(int transfersSIPTimeToLiveInMinutes) {
        this.transfersSIPTimeToLiveInMinutes = transfersSIPTimeToLiveInMinutes;
    }

    public int getCriticalDipTimeToLiveInMinutes() {
        return this.criticalDipTimeToLiveInMinutes;
    }

    public void setCriticalDipTimeToLiveInMinutes(int criticalDipTimeToLiveInMinutes) {
        this.criticalDipTimeToLiveInMinutes = criticalDipTimeToLiveInMinutes;
    }

    public List<ElasticsearchExternalMetadataMapping> getElasticsearchExternalMetadataMappings() {
        return this.elasticsearchExternalMetadataMappings;
    }

    public void setElasticsearchExternalMetadataMappings(List<ElasticsearchExternalMetadataMapping> elasticsearchExternalMetadataMappings) {
        this.elasticsearchExternalMetadataMappings = elasticsearchExternalMetadataMappings;
    }

    public long getUnitsStreamThreshold() {
        return this.unitsStreamThreshold;
    }

    public void setUnitsStreamThreshold(long unitsStreamThreshold) {
        this.unitsStreamThreshold = unitsStreamThreshold;
    }

    public long getObjectsStreamThreshold() {
        return this.objectsStreamThreshold;
    }

    public void setObjectsStreamThreshold(long objectsStreamThreshold) {
        this.objectsStreamThreshold = objectsStreamThreshold;
    }

    public short getUnitsStreamExecutionLimit() {
        return this.unitsStreamExecutionLimit;
    }

    public void setUnitsStreamExecutionLimit(short unitsStreamExecutionLimit) {
        this.unitsStreamExecutionLimit = unitsStreamExecutionLimit;
    }

    public short getObjectsStreamExecutionLimit() {
        return this.objectsStreamExecutionLimit;
    }

    public void setObjectsStreamExecutionLimit(short objectsStreamExecutionLimit) {
        this.objectsStreamExecutionLimit = objectsStreamExecutionLimit;
    }

    public MetadataIndexationConfiguration getIndexationConfiguration() {
        return this.indexationConfiguration;
    }

    public MetaDataConfiguration setIndexationConfiguration(MetadataIndexationConfiguration indexationConfiguration) {
        this.indexationConfiguration = indexationConfiguration;
        return this;
    }

    public boolean getIsDataConsistencyAuditRunnable() {
        return this.isDataConsistencyAuditRunnable;
    }

    public void setIsDataConsistencyAuditRunnable(boolean dataConsistencyAuditRunnable) {
        this.isDataConsistencyAuditRunnable = dataConsistencyAuditRunnable;
    }

    public boolean isEnableDataConsistencyRectificationMode() {
        return this.enableDataConsistencyRectificationMode;
    }

    public MetaDataConfiguration setEnableDataConsistencyRectificationMode(boolean enableDataConsistencyRectificationMode) {
        this.enableDataConsistencyRectificationMode = enableDataConsistencyRectificationMode;
        return this;
    }

    public Integer getDataConsistencyAuditOplogMaxSize() {
        return this.dataConsistencyAuditOplogMaxSize;
    }

    public void setDataConsistencyAuditOplogMaxSize(Integer dataConsistencyAuditOplogMaxSize) {
        this.dataConsistencyAuditOplogMaxSize = dataConsistencyAuditOplogMaxSize;
    }

    public MongoDbShardConf getMongodShardsConf() {
        return this.mongodShardsConf;
    }

    public void setMongodShardsConf(MongoDbShardConf mongodShardsConf) {
        this.mongodShardsConf = mongodShardsConf;
    }

    @JsonIgnore
    public TimeToLiveConfiguration getTimeToLiveConfiguration() {
        return new TimeToLiveConfiguration(this.dipTimeToLiveInMinutes, this.criticalDipTimeToLiveInMinutes, this.transfersSIPTimeToLiveInMinutes);
    }

    public int getReconstructionMetricsCacheDurationInMinutes() {
        return this.reconstructionMetricsCacheDurationInMinutes;
    }

    public void setReconstructionMetricsCacheDurationInMinutes(int reconstructionMetricsCacheDurationInMinutes) {
        this.reconstructionMetricsCacheDurationInMinutes = reconstructionMetricsCacheDurationInMinutes;
    }

    public long getPersistentIdentifierReconstructionDelayInMinutes() {
        return this.persistentIdentifierReconstructionDelayInMinutes;
    }

    public void setPersistentIdentifierReconstructionDelayInMinutes(long persistentIdentifierReconstructionDelayInMinutes) {
        this.persistentIdentifierReconstructionDelayInMinutes = persistentIdentifierReconstructionDelayInMinutes;
    }

    @JsonIgnore
    public String getBaseUrl() {
        return this.contextPath;
    }

    public int getPersistentIdentifierReconstructionThreadPoolSize() {
        return this.persistentIdentifierReconstructionThreadPoolSize;
    }

    public void setPersistentIdentifierReconstructionThreadPoolSize(int persistentIdentifierReconstructionThreadPoolSize) {
        this.persistentIdentifierReconstructionThreadPoolSize = persistentIdentifierReconstructionThreadPoolSize;
    }

    public int getPersistentIdentifierReconstructionBulkSize() {
        return this.persistentIdentifierReconstructionBulkSize;
    }

    public void setPersistentIdentifierReconstructionBulkSize(int persistentIdentifierReconstructionBulkSize) {
        this.persistentIdentifierReconstructionBulkSize = persistentIdentifierReconstructionBulkSize;
    }

    public boolean getRefreshElasticIndexPostBulkIndexing() {
        return this.refreshElasticIndexPostBulkIndexing != null && this.refreshElasticIndexPostBulkIndexing != false;
    }

    public void setRefreshElasticIndexPostBulkIndexing(Boolean refreshElasticIndexPostBulkIndexing) {
        this.refreshElasticIndexPostBulkIndexing = refreshElasticIndexPostBulkIndexing;
    }

    public int getReconstructionPoolSize() {
        return this.reconstructionPoolSize;
    }

    public MetaDataConfiguration setReconstructionPoolSize(int reconstructionPoolSize) {
        this.reconstructionPoolSize = reconstructionPoolSize;
        return this;
    }

    public int getReconstructionBatchSize() {
        return this.reconstructionBatchSize;
    }

    public MetaDataConfiguration setReconstructionBatchSize(int reconstructionBatchSize) {
        this.reconstructionBatchSize = reconstructionBatchSize;
        return this;
    }

    public int getReconstructionBatchLoadingTimeoutInSeconds() {
        return this.reconstructionBatchLoadingTimeoutInSeconds;
    }

    public MetaDataConfiguration setReconstructionBatchLoadingTimeoutInSeconds(int reconstructionBatchLoadingTimeoutInSeconds) {
        this.reconstructionBatchLoadingTimeoutInSeconds = reconstructionBatchLoadingTimeoutInSeconds;
        return this;
    }
}

