/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.config;

import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAliasResolver;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexSettings;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchUtil;
import fr.gouv.vitam.common.exception.VitamFatalRuntimeException;
import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.common.model.config.CollectionConfigurationUtils;
import fr.gouv.vitam.common.model.config.TenantRange;
import fr.gouv.vitam.common.model.config.TenantRangeParser;
import fr.gouv.vitam.metadata.core.config.DedicatedTenantConfiguration;
import fr.gouv.vitam.metadata.core.config.GroupedTenantConfiguration;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.mapping.MappingLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class ElasticsearchMetadataIndexManager {
    private final List<Integer> tenantIds;
    private final Map<Integer, String> tenantToTenantGroupMap = new HashMap<Integer, String>();
    private final ListValuedMap<String, Integer> tenantGroupToTenantMap = new ArrayListValuedHashMap();
    private final Map<Integer, ElasticsearchIndexSettings> unitIndexSettingsMap = new HashMap<Integer, ElasticsearchIndexSettings>();
    private final Map<Integer, ElasticsearchIndexSettings> objectGroupIndexSettingsMap = new HashMap<Integer, ElasticsearchIndexSettings>();

    public ElasticsearchMetadataIndexManager(MetaDataConfiguration configuration, List<Integer> tenantIds, MappingLoader mappingLoader) {
        CollectionConfiguration objectGroupConfiguration;
        CollectionConfiguration unitConfiguration;
        List tenantRanges;
        this.tenantIds = tenantIds;
        HashMap<Integer, CollectionConfiguration> customTenantUnitConfiguration = new HashMap<Integer, CollectionConfiguration>();
        HashMap<String, CollectionConfiguration> groupedTenantUnitConfiguration = new HashMap<String, CollectionConfiguration>();
        HashMap<Integer, CollectionConfiguration> customTenantObjectGroupConfiguration = new HashMap<Integer, CollectionConfiguration>();
        HashMap<String, CollectionConfiguration> groupedTenantObjectGroupConfiguration = new HashMap<String, CollectionConfiguration>();
        CollectionConfiguration defaultUnitConfiguration = configuration.getIndexationConfiguration().getDefaultCollectionConfiguration().getUnit();
        CollectionConfiguration defaultObjectGroupConfiguration = configuration.getIndexationConfiguration().getDefaultCollectionConfiguration().getObjectgroup();
        if (configuration.getIndexationConfiguration().getDedicatedTenantConfiguration() != null) {
            for (DedicatedTenantConfiguration dedicatedTenantConfiguration : configuration.getIndexationConfiguration().getDedicatedTenantConfiguration()) {
                tenantRanges = TenantRangeParser.parseTenantRanges((String)dedicatedTenantConfiguration.getTenants());
                unitConfiguration = CollectionConfigurationUtils.merge((CollectionConfiguration)dedicatedTenantConfiguration.getUnit(), (CollectionConfiguration)defaultUnitConfiguration);
                objectGroupConfiguration = CollectionConfigurationUtils.merge((CollectionConfiguration)dedicatedTenantConfiguration.getObjectgroup(), (CollectionConfiguration)defaultObjectGroupConfiguration);
                for (TenantRange tenantRange : tenantRanges) {
                    for (int tenantId2 : tenantIds) {
                        if (!tenantRange.isInRange(tenantId2)) continue;
                        customTenantUnitConfiguration.put(tenantId2, unitConfiguration);
                        customTenantObjectGroupConfiguration.put(tenantId2, objectGroupConfiguration);
                    }
                }
            }
        }
        if (configuration.getIndexationConfiguration().getGroupedTenantConfiguration() != null) {
            for (GroupedTenantConfiguration groupedTenantConfiguration : configuration.getIndexationConfiguration().getGroupedTenantConfiguration()) {
                tenantRanges = TenantRangeParser.parseTenantRanges((String)groupedTenantConfiguration.getTenants());
                unitConfiguration = CollectionConfigurationUtils.merge((CollectionConfiguration)groupedTenantConfiguration.getUnit(), (CollectionConfiguration)defaultUnitConfiguration);
                groupedTenantUnitConfiguration.put(groupedTenantConfiguration.getName(), unitConfiguration);
                objectGroupConfiguration = CollectionConfigurationUtils.merge((CollectionConfiguration)groupedTenantConfiguration.getObjectgroup(), (CollectionConfiguration)defaultObjectGroupConfiguration);
                groupedTenantObjectGroupConfiguration.put(groupedTenantConfiguration.getName(), objectGroupConfiguration);
                for (TenantRange tenantRange : tenantRanges) {
                    for (int tenantId2 : tenantIds) {
                        if (!tenantRange.isInRange(tenantId2)) continue;
                        this.tenantToTenantGroupMap.put(tenantId2, groupedTenantConfiguration.getName());
                        this.tenantGroupToTenantMap.get((Object)groupedTenantConfiguration.getName()).add(tenantId2);
                    }
                }
            }
        }
        Supplier<String> unitMappingLoader = this.getEsMappingLoader(mappingLoader, MetadataCollections.UNIT);
        Supplier<String> objectGroupMappingLoader = this.getEsMappingLoader(mappingLoader, MetadataCollections.OBJECTGROUP);
        tenantIds.stream().filter(Predicate.not(this.tenantToTenantGroupMap::containsKey)).forEach(tenantId -> {
            CollectionConfiguration unitConfiguration = customTenantUnitConfiguration.getOrDefault(tenantId, defaultUnitConfiguration);
            ElasticsearchIndexSettings unitElasticsearchIndexSettings = new ElasticsearchIndexSettings(unitConfiguration.getNumberOfShards().intValue(), unitConfiguration.getNumberOfReplicas().intValue(), unitMappingLoader);
            this.unitIndexSettingsMap.put((Integer)tenantId, unitElasticsearchIndexSettings);
            CollectionConfiguration objectGroupConfiguration = customTenantObjectGroupConfiguration.getOrDefault(tenantId, defaultObjectGroupConfiguration);
            ElasticsearchIndexSettings objectGroupElasticsearchIndexSettings = new ElasticsearchIndexSettings(objectGroupConfiguration.getNumberOfShards().intValue(), objectGroupConfiguration.getNumberOfReplicas().intValue(), objectGroupMappingLoader);
            this.objectGroupIndexSettingsMap.put((Integer)tenantId, objectGroupElasticsearchIndexSettings);
        });
        this.tenantGroupToTenantMap.keySet().forEach(tenantGroupName -> {
            CollectionConfiguration unitConfiguration = (CollectionConfiguration)groupedTenantUnitConfiguration.get(tenantGroupName);
            ElasticsearchIndexSettings unitElasticsearchIndexSettings = new ElasticsearchIndexSettings(unitConfiguration.getNumberOfShards().intValue(), unitConfiguration.getNumberOfReplicas().intValue(), unitMappingLoader);
            CollectionConfiguration objectGroupConfiguration = (CollectionConfiguration)groupedTenantObjectGroupConfiguration.get(tenantGroupName);
            ElasticsearchIndexSettings objectGroupElasticsearchIndexSettings = new ElasticsearchIndexSettings(objectGroupConfiguration.getNumberOfShards().intValue(), objectGroupConfiguration.getNumberOfReplicas().intValue(), objectGroupMappingLoader);
            for (Integer tenantId : this.tenantGroupToTenantMap.get(tenantGroupName)) {
                this.unitIndexSettingsMap.put(tenantId, unitElasticsearchIndexSettings);
                this.objectGroupIndexSettingsMap.put(tenantId, objectGroupElasticsearchIndexSettings);
            }
        });
    }

    private Supplier<String> getEsMappingLoader(MappingLoader mappingLoader, MetadataCollections collection) {
        return () -> {
            try {
                return ElasticsearchUtil.transferJsonToMapping((InputStream)mappingLoader.loadMapping(collection.name()));
            }
            catch (IOException e) {
                throw new VitamFatalRuntimeException("Could not load mapping for collection " + MetadataCollections.UNIT.getName(), (Throwable)e);
            }
        };
    }

    public ElasticsearchIndexAliasResolver getElasticsearchIndexAliasResolver(MetadataCollections collection) {
        switch (collection) {
            case UNIT: 
            case OBJECTGROUP: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown collection " + collection);
            }
        }
        return tenantId -> {
            if (this.tenantToTenantGroupMap.containsKey(tenantId)) {
                return ElasticsearchIndexAlias.ofMultiTenantCollection((String)collection.getName(), (String)this.tenantToTenantGroupMap.get(tenantId));
            }
            return ElasticsearchIndexAlias.ofMultiTenantCollection((String)collection.getName(), (int)tenantId);
        };
    }

    public ElasticsearchIndexSettings getElasticsearchIndexSettings(MetadataCollections collection, int tenantId) {
        switch (collection) {
            case UNIT: {
                return this.unitIndexSettingsMap.get(tenantId);
            }
            case OBJECTGROUP: {
                return this.objectGroupIndexSettingsMap.get(tenantId);
            }
        }
        throw new IllegalStateException("Unknown collection " + collection);
    }

    public Collection<Integer> getDedicatedTenants() {
        return this.tenantIds.stream().filter(Predicate.not(this.tenantToTenantGroupMap::containsKey)).collect(Collectors.toList());
    }

    public Collection<String> getTenantGroups() {
        return this.tenantGroupToTenantMap.keySet();
    }

    public List<Integer> getTenantGroupTenants(String tenantGroupName) {
        if (!this.tenantGroupToTenantMap.containsKey((Object)tenantGroupName)) {
            throw new IllegalStateException("No such tenant group " + tenantGroupName);
        }
        return this.tenantGroupToTenantMap.get((Object)tenantGroupName);
    }

    public boolean isGroupedTenant(Integer tenantId) {
        return this.tenantToTenantGroupMap.containsKey(tenantId);
    }

    public String getTenantGroup(int tenantId) {
        if (!this.tenantToTenantGroupMap.containsKey(tenantId)) {
            throw new IllegalStateException("Tenant " + tenantId + " does not belong to a tenant group");
        }
        return this.tenantToTenantGroupMap.get(tenantId);
    }
}

