/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core;

import com.mongodb.client.MongoClient;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.core.ElasticsearchAccessMetadataFactory;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.database.collections.ElasticsearchAccessMetadata;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.database.collections.MetadataSnapshot;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbAccessMetadataImpl;
import java.util.ArrayList;

public class MongoDbAccessMetadataFactory {
    public static final String COLLECT_PREFIX = "collect_";

    public static MongoDbAccessMetadataImpl create(MetaDataConfiguration configuration, ElasticsearchMetadataIndexManager elasticsearchMetadataIndexManager) {
        ElasticsearchAccessMetadata esClient;
        ParametersChecker.checkParameter((String)"configuration is a mandatory parameter", (Object[])new Object[]{configuration});
        try {
            esClient = ElasticsearchAccessMetadataFactory.create(configuration, elasticsearchMetadataIndexManager);
        }
        catch (MetaDataException e1) {
            throw new IllegalArgumentException(e1);
        }
        ArrayList<Class<VitamDocument>> classList = new ArrayList<Class<VitamDocument>>();
        for (MetadataCollections e : (MetadataCollections[])MetadataCollections.class.getEnumConstants()) {
            classList.add(e.getClasz());
        }
        classList.add(MetadataSnapshot.class);
        MongoClient mongoClient = MongoDbAccess.createMongoClient((DbConfiguration)configuration, classList);
        MetadataCollections unitCollection = MetadataCollections.UNIT;
        MetadataCollections objectCollection = MetadataCollections.OBJECTGROUP;
        if (Boolean.TRUE.equals(configuration.getCollectModule())) {
            unitCollection.setPrefix(COLLECT_PREFIX);
            objectCollection.setPrefix(COLLECT_PREFIX);
        } else {
            unitCollection.setPrefix("");
            objectCollection.setPrefix("");
        }
        return new MongoDbAccessMetadataImpl(mongoClient, configuration.getDbName(), false, esClient, unitCollection, objectCollection);
    }
}

