/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.facet.FacetHelper;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.collections.CachedOntologyLoader;
import fr.gouv.vitam.common.database.facet.model.FacetOrder;
import fr.gouv.vitam.common.database.index.model.ReindexationKO;
import fr.gouv.vitam.common.database.index.model.ReindexationOK;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.multiple.InsertParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAliasResolver;
import fr.gouv.vitam.common.database.server.elasticsearch.IndexationHelper;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.exception.VitamThreadAccessException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.DatabaseCursor;
import fr.gouv.vitam.common.model.DurationData;
import fr.gouv.vitam.common.model.FacetBucket;
import fr.gouv.vitam.common.model.FacetResult;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.client.AdminManagementOntologyLoader;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterDetail;
import fr.gouv.vitam.functional.administration.common.server.AccessionRegisterSymbolic;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.api.model.ObjectGroupPerOriginatingAgency;
import fr.gouv.vitam.metadata.api.model.UpdateUnit;
import fr.gouv.vitam.metadata.api.model.UpdateUnitKey;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.database.collections.DbRequest;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.database.collections.MetadataDocument;
import fr.gouv.vitam.metadata.core.database.collections.MetadataSnapshot;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbAccessMetadataImpl;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbVarNameAdapter;
import fr.gouv.vitam.metadata.core.database.collections.Result;
import fr.gouv.vitam.metadata.core.model.MetadataResult;
import fr.gouv.vitam.metadata.core.model.RequestById;
import fr.gouv.vitam.metadata.core.model.UpdatedDocument;
import fr.gouv.vitam.metadata.core.utils.MetadataJsonResponseUtils;
import fr.gouv.vitam.metadata.core.utils.OriginatingAgencyBucketResult;
import fr.gouv.vitam.metadata.core.validation.CachedArchiveUnitProfileLoader;
import fr.gouv.vitam.metadata.core.validation.CachedSchemaValidatorLoader;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationException;
import fr.gouv.vitam.metadata.core.validation.OntologyValidator;
import fr.gouv.vitam.metadata.core.validation.UnitValidator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.Nested;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.metrics.ValueCount;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public class MetaDataImpl {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetaDataImpl.class);
    private static final String REQUEST_IS_NULL = "Request select is null or is empty";
    private static final String UNSUPPORTED_RULES_PROJECTION = "Projection field $rules is no longer supported.";
    private static final MongoDbVarNameAdapter DEFAULT_VARNAME_ADAPTER = new MongoDbVarNameAdapter();
    public static final int MAX_PRECISION_THRESHOLD = 40000;
    private static final int AGGREGATION_SIZE = 10000;
    public static final String SNAPSHOT_COLLECTION = "Snapshot";
    public static final String FILTER = "$filter";
    public static final String OFFSET = "$offset";
    public static final String LIMIT = "$limit";
    public static final String ORIGINATING_AGENCY = "originatingAgency";
    public static final String ORIGINATING_AGENCIES = "originatingAgencies";
    public static final String NESTED_VERSIONS = "nestedVersions";
    public static final String BINARY_OBJECT_SIZE = "binaryObjectSize";
    public static final String BINARY_OBJECT_COUNT = "binaryObjectCount";
    private final MongoDbAccessMetadataImpl mongoDbAccess;
    private final IndexationHelper indexationHelper;
    private final DbRequest dbRequest;
    private final UnitValidator unitValidator;
    private final OntologyValidator unitOntologyValidator;
    private final OntologyValidator objectGroupOntologyValidator;
    private final OntologyLoader unitOntologyLoader;
    private final OntologyLoader objectGroupOntologyLoader;
    private final ElasticsearchMetadataIndexManager indexManager;

    public MetaDataImpl(MongoDbAccessMetadataImpl mongoDbAccess, int ontologyCacheMaxEntries, int ontologyCacheTimeoutInSeconds, int archiveUnitProfileCacheMaxEntries, int archiveUnitProfileCacheTimeoutInSeconds, int schemaValidatorCacheMaxEntries, int schemaValidatorCacheTimeoutInSeconds, ElasticsearchMetadataIndexManager indexManager) {
        this(mongoDbAccess, AdminManagementClientFactory.getInstance(), IndexationHelper.getInstance(), new DbRequest(), ontologyCacheMaxEntries, ontologyCacheTimeoutInSeconds, archiveUnitProfileCacheMaxEntries, archiveUnitProfileCacheTimeoutInSeconds, schemaValidatorCacheMaxEntries, schemaValidatorCacheTimeoutInSeconds, indexManager);
    }

    @VisibleForTesting
    public MetaDataImpl(MongoDbAccessMetadataImpl mongoDbAccess, AdminManagementClientFactory adminManagementClientFactory, IndexationHelper indexationHelper, DbRequest dbRequest, int ontologyCacheMaxEntries, int ontologyCacheTimeoutInSeconds, int archiveUnitProfileCacheMaxEntries, int archiveUnitProfileCacheTimeoutInSeconds, int schemaValidatorCacheMaxEntries, int schemaValidatorCacheTimeoutInSeconds, ElasticsearchMetadataIndexManager indexManager) {
        this.mongoDbAccess = mongoDbAccess;
        this.indexationHelper = indexationHelper;
        this.dbRequest = dbRequest;
        this.indexManager = indexManager;
        this.unitOntologyLoader = new CachedOntologyLoader(ontologyCacheMaxEntries, ontologyCacheTimeoutInSeconds, (OntologyLoader)new AdminManagementOntologyLoader(adminManagementClientFactory, Optional.of(MetadataType.UNIT.getName())));
        this.objectGroupOntologyLoader = new CachedOntologyLoader(ontologyCacheMaxEntries, ontologyCacheTimeoutInSeconds, (OntologyLoader)new AdminManagementOntologyLoader(adminManagementClientFactory, Optional.of(MetadataType.OBJECTGROUP.getName())));
        this.unitOntologyValidator = new OntologyValidator(this.unitOntologyLoader);
        this.objectGroupOntologyValidator = new OntologyValidator(this.objectGroupOntologyLoader);
        CachedArchiveUnitProfileLoader archiveUnitProfileLoader = new CachedArchiveUnitProfileLoader(adminManagementClientFactory, archiveUnitProfileCacheMaxEntries, archiveUnitProfileCacheTimeoutInSeconds);
        CachedSchemaValidatorLoader schemaValidatorLoader = new CachedSchemaValidatorLoader(schemaValidatorCacheMaxEntries, schemaValidatorCacheTimeoutInSeconds);
        this.unitValidator = new UnitValidator(archiveUnitProfileLoader, schemaValidatorLoader);
    }

    public static MetaDataImpl newMetadata(MongoDbAccessMetadataImpl mongoDbAccessMetadata, int ontologyCacheMaxEntries, int ontologyCacheTimeoutInSeconds, int archiveUnitProfileCacheMaxEntries, int archiveUnitProfileCacheTimeoutInSeconds, int schemaValidatorCacheMaxEntries, int schemaValidatorCacheTimeoutInSeconds, ElasticsearchMetadataIndexManager indexManager) {
        return new MetaDataImpl(mongoDbAccessMetadata, ontologyCacheMaxEntries, ontologyCacheTimeoutInSeconds, archiveUnitProfileCacheMaxEntries, archiveUnitProfileCacheTimeoutInSeconds, schemaValidatorCacheMaxEntries, schemaValidatorCacheTimeoutInSeconds, indexManager);
    }

    public MongoDbAccessMetadataImpl getMongoDbAccess() {
        return this.mongoDbAccess;
    }

    public void insertUnits(List<JsonNode> unitRequest) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException {
        try {
            List<InsertParserMultiple> collect = unitRequest.stream().map(insertRequest -> {
                InsertParserMultiple insertParser = new InsertParserMultiple((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
                try {
                    insertParser.parse(insertRequest);
                }
                catch (InvalidParseOperationException e) {
                    throw new VitamRuntimeException((Throwable)e);
                }
                return insertParser;
            }).collect(Collectors.toList());
            this.dbRequest.execInsertUnitRequests(collect);
        }
        catch (VitamRuntimeException e) {
            if (e.getCause() instanceof InvalidParseOperationException) {
                throw (InvalidParseOperationException)e.getCause();
            }
            throw e;
        }
    }

    public void deleteUnits(List<String> idList) throws IllegalArgumentException, MetaDataExecutionException {
        this.dbRequest.deleteUnits(idList);
    }

    public void deleteObjectGroups(List<String> idList) throws IllegalArgumentException, MetaDataExecutionException {
        this.dbRequest.deleteObjectGroups(idList);
    }

    public void insertObjectGroup(JsonNode objectGroupRequest) throws InvalidParseOperationException, MetaDataExecutionException {
        InsertParserMultiple insertParser = new InsertParserMultiple((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
        insertParser.parse(objectGroupRequest);
        insertParser.getRequest().addHintFilter(new String[]{BuilderToken.FILTERARGS.OBJECTGROUPS.exactToken()});
        this.dbRequest.execInsertObjectGroupRequests(Collections.singletonList(insertParser));
    }

    public void insertObjectGroups(List<JsonNode> objectGroupRequest) throws InvalidParseOperationException, MetaDataExecutionException {
        try {
            List<InsertParserMultiple> collect = objectGroupRequest.stream().map(insertRequest -> {
                InsertParserMultiple insertParser = new InsertParserMultiple((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
                try {
                    insertParser.parse(insertRequest);
                }
                catch (InvalidParseOperationException e) {
                    throw new VitamRuntimeException((Throwable)e);
                }
                return insertParser;
            }).collect(Collectors.toList());
            this.dbRequest.execInsertObjectGroupRequests(collect);
        }
        catch (VitamRuntimeException e) {
            if (e.getCause() instanceof InvalidParseOperationException) {
                throw (InvalidParseOperationException)e.getCause();
            }
            throw e;
        }
    }

    public List<FacetBucket> selectOwnAccessionRegisterOnUnitByOperationId(String operationId) throws MetaDataExecutionException {
        SelectParserMultiple request = new SelectParserMultiple((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
        SelectMultiQuery select = new SelectMultiQuery();
        try {
            BooleanQuery query = QueryHelper.and().add(new Query[]{QueryHelper.eq((String)BuilderToken.PROJECTIONARGS.INITIAL_OPERATION.exactToken(), (String)operationId), QueryHelper.ne((String)BuilderToken.PROJECTIONARGS.UNITTYPE.exactToken(), (String)UnitType.HOLDING_UNIT.name())});
            select.addQueries(new Query[]{query});
            Facet facet = FacetHelper.terms((String)AccessionRegisterDetail.class.getSimpleName(), (String)BuilderToken.PROJECTIONARGS.ORIGINATING_AGENCY.exactToken(), (Integer)Integer.MAX_VALUE, (FacetOrder)FacetOrder.ASC);
            select.addFacets(new Facet[]{facet});
            select.setLimitFilter(0L, 1L);
            request.parse((JsonNode)select.getFinalSelect());
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new MetaDataExecutionException(e);
        }
        try {
            FacetResult facetResult;
            ArrayList facetResults;
            List ontologies = request.model() == BuilderToken.FILTERARGS.UNITS ? this.unitOntologyLoader.loadOntologies() : this.objectGroupOntologyLoader.loadOntologies();
            Result<MetadataDocument<?>> result = this.dbRequest.execRequest((RequestParserMultiple)request, ontologies);
            ArrayList arrayList = facetResults = result != null ? result.getFacet() : new ArrayList();
            if (!CollectionUtils.isEmpty(facetResults) && null != (facetResult = (FacetResult)facetResults.iterator().next()) && !CollectionUtils.isEmpty((Collection)facetResult.getBuckets())) {
                return facetResult.getBuckets();
            }
        }
        catch (BadRequestException | InvalidParseOperationException | VitamDBException e) {
            throw new MetaDataExecutionException(e);
        }
        return new ArrayList<FacetBucket>();
    }

    public List<Document> createAccessionRegisterSymbolic(Integer tenant) throws MetaDataExecutionException {
        Aggregations aUAccessionRegisterInfo = this.selectArchiveUnitAccessionRegisterInformation(tenant);
        Aggregations oGAccessionRegisterInfo = this.selectObjectGroupAccessionRegisterInformation(tenant);
        String creationDate = LocalDateUtil.nowFormatted();
        return this.createWithInformations(aUAccessionRegisterInfo, oGAccessionRegisterInfo, creationDate, tenant);
    }

    private List<Document> createWithInformations(Aggregations archiveUnitAccessionRegisterInformation, Aggregations objectGroupAccessionRegisterInformation, String creationDate, Integer tenant) {
        Map<String, AccessionRegisterSymbolic> accessionRegisterSymbolicByOriginatingAgency = this.fillWithArchiveUnitInformation(archiveUnitAccessionRegisterInformation, creationDate, tenant);
        this.updateExistingAccessionRegisterWithObjectGroupInformation(objectGroupAccessionRegisterInformation, creationDate, tenant, accessionRegisterSymbolicByOriginatingAgency);
        return new ArrayList<AccessionRegisterSymbolic>(accessionRegisterSymbolicByOriginatingAgency.values());
    }

    private void updateExistingAccessionRegisterWithObjectGroupInformation(Aggregations objectGroupAccessionRegisterInformation, String creationDate, Integer tenant, Map<String, AccessionRegisterSymbolic> accessionRegisterSymbolicByOriginatingAgency) {
        Terms objectGroupOriginatingAgencies = (Terms)objectGroupAccessionRegisterInformation.get(ORIGINATING_AGENCIES);
        Terms objectGroupOriginatingAgency = (Terms)objectGroupAccessionRegisterInformation.get(ORIGINATING_AGENCY);
        Map<String, OriginatingAgencyBucketResult> objectGroupByOriginatingAgency = objectGroupOriginatingAgency.getBuckets().stream().map(bucket -> OriginatingAgencyBucketResult.of(bucket.getKeyAsString(), bucket.getDocCount(), (Nested)bucket.getAggregations().get(NESTED_VERSIONS))).collect(Collectors.toMap(e -> e.originatingAgency, e -> e));
        objectGroupOriginatingAgencies.getBuckets().forEach(bucket -> this.updateAccessionsRegister(creationDate, tenant, accessionRegisterSymbolicByOriginatingAgency, objectGroupByOriginatingAgency, OriginatingAgencyBucketResult.of(bucket.getKeyAsString(), bucket.getDocCount(), (Nested)bucket.getAggregations().get(NESTED_VERSIONS))));
    }

    private void updateAccessionsRegister(String creationDate, Integer tenant, Map<String, AccessionRegisterSymbolic> accessionRegisterSymbolicByOriginatingAgency, Map<String, OriginatingAgencyBucketResult> objectGroupByOriginatingAgency, OriginatingAgencyBucketResult objectGroup) {
        OriginatingAgencyBucketResult originatingAgencyBucketResult = objectGroupByOriginatingAgency.getOrDefault(objectGroup.originatingAgency, OriginatingAgencyBucketResult.empty());
        long groupObjectsCount = objectGroup.docCount - originatingAgencyBucketResult.docCount;
        long objectCount = objectGroup.objectCount - originatingAgencyBucketResult.objectCount;
        double binaryObjectSize = objectGroup.binaryObjectSize - originatingAgencyBucketResult.binaryObjectSize;
        AccessionRegisterSymbolic existingAccessionRegister = accessionRegisterSymbolicByOriginatingAgency.get(objectGroup.originatingAgency);
        if (groupObjectsCount > 0L && existingAccessionRegister != null) {
            existingAccessionRegister.setObjectGroup(groupObjectsCount).setBinaryObject(objectCount).setBinaryObjectSize(binaryObjectSize);
            return;
        }
        if (groupObjectsCount <= 0L && existingAccessionRegister != null) {
            existingAccessionRegister.setObjectGroup(0L).setBinaryObject(0L).setBinaryObjectSize(0.0);
            return;
        }
        if (groupObjectsCount > 0L) {
            accessionRegisterSymbolicByOriginatingAgency.put(objectGroup.originatingAgency, new AccessionRegisterSymbolic().setId(GUIDFactory.newAccessionRegisterSymbolicGUID((int)tenant).getId()).setCreationDate(creationDate).setTenant(tenant.intValue()).setOriginatingAgency(objectGroup.originatingAgency).setArchiveUnit(0L).setObjectGroup(groupObjectsCount).setBinaryObject(objectCount).setBinaryObjectSize(binaryObjectSize));
        }
    }

    private Map<String, AccessionRegisterSymbolic> fillWithArchiveUnitInformation(Aggregations archiveUnitAccessionRegisterformation, String creationDate, Integer tenant) {
        Terms archiveUnitOriginatingAgencies = (Terms)archiveUnitAccessionRegisterformation.get(ORIGINATING_AGENCIES);
        Terms archiveUnitOriginatingAgency = (Terms)archiveUnitAccessionRegisterformation.get(ORIGINATING_AGENCY);
        Map<String, Long> archiveUnitByOriginatingAgency = archiveUnitOriginatingAgency.getBuckets().stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, MultiBucketsAggregation.Bucket::getDocCount));
        return archiveUnitOriginatingAgencies.getBuckets().stream().map(e -> {
            long archiveUnitCount = e.getDocCount() - archiveUnitByOriginatingAgency.getOrDefault(e.getKeyAsString(), 0L);
            if (archiveUnitCount <= 0L) {
                return null;
            }
            return new AccessionRegisterSymbolic().setId(GUIDFactory.newAccessionRegisterSymbolicGUID((int)tenant).getId()).setCreationDate(creationDate).setTenant(tenant.intValue()).setOriginatingAgency(e.getKeyAsString()).setArchiveUnit(archiveUnitCount);
        }).filter(Objects::nonNull).collect(Collectors.toMap(AccessionRegisterSymbolic::getOriginatingAgency, e -> e));
    }

    private Aggregations selectObjectGroupAccessionRegisterInformation(Integer tenant) throws MetaDataExecutionException {
        TermsAggregationBuilder ogs = (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)ORIGINATING_AGENCIES).field("_sps")).size(10000).subAggregation((AggregationBuilder)((NestedAggregationBuilder)AggregationBuilders.nested((String)NESTED_VERSIONS, (String)"_qualifiers.versions").subAggregation((AggregationBuilder)AggregationBuilders.sum((String)BINARY_OBJECT_SIZE).field("_qualifiers.versions.Size"))).subAggregation((AggregationBuilder)AggregationBuilders.count((String)BINARY_OBJECT_COUNT).field("_qualifiers.versions._id")));
        TermsAggregationBuilder og = (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)ORIGINATING_AGENCY).field("_sp")).size(10000).subAggregation((AggregationBuilder)((NestedAggregationBuilder)AggregationBuilders.nested((String)NESTED_VERSIONS, (String)"_qualifiers.versions").subAggregation((AggregationBuilder)AggregationBuilders.sum((String)BINARY_OBJECT_SIZE).field("_qualifiers.versions.Size"))).subAggregation((AggregationBuilder)AggregationBuilders.count((String)BINARY_OBJECT_COUNT).field("_qualifiers.versions._id")));
        return MetadataCollections.OBJECTGROUP.getEsClient().basicAggregationSearch(MetadataCollections.OBJECTGROUP, tenant, Arrays.asList(og, ogs), (QueryBuilder)QueryBuilders.matchAllQuery());
    }

    private Aggregations selectArchiveUnitAccessionRegisterInformation(Integer tenant) throws MetaDataExecutionException {
        List<AggregationBuilder> aggregations = Arrays.asList(((TermsAggregationBuilder)AggregationBuilders.terms((String)ORIGINATING_AGENCY).field("_sp")).size(10000), ((TermsAggregationBuilder)AggregationBuilders.terms((String)ORIGINATING_AGENCIES).field("_sps")).size(10000));
        return MetadataCollections.UNIT.getEsClient().basicAggregationSearch(MetadataCollections.UNIT, tenant, aggregations, (QueryBuilder)QueryBuilders.matchAllQuery());
    }

    public List<ObjectGroupPerOriginatingAgency> selectOwnAccessionRegisterOnObjectGroupByOperationId(Integer tenant, String operationId) throws MetaDataExecutionException {
        AggregationBuilder originatingAgencyAgg = this.aggregationForObjectGroupAccessionRegisterByOperationId(operationId);
        QueryBuilder query = this.queryForObjectGroupAccessionRegisterByOperationId(tenant, operationId);
        Aggregations result = MetadataCollections.OBJECTGROUP.getEsClient().basicAggregationSearch(MetadataCollections.OBJECTGROUP, tenant, Collections.singletonList(originatingAgencyAgg), query);
        ArrayList<ObjectGroupPerOriginatingAgency> listOgsPerSps = new ArrayList<ObjectGroupPerOriginatingAgency>();
        Terms originatingAgencyResult = (Terms)result.get(ORIGINATING_AGENCY);
        for (Terms.Bucket originatingAgencyBucket : originatingAgencyResult.getBuckets()) {
            String sp = originatingAgencyBucket.getKeyAsString();
            ObjectGroupPerOriginatingAgency ogPerSp = new ObjectGroupPerOriginatingAgency(operationId, sp, 0L, 0L, 0L);
            Terms operationResult = (Terms)originatingAgencyBucket.getAggregations().get("operation");
            for (Terms.Bucket operationBucket : operationResult.getBuckets()) {
                String opi = operationBucket.getKeyAsString();
                Nested versionResult = (Nested)operationBucket.getAggregations().get("version");
                Filter versionOperationResult = (Filter)versionResult.getAggregations().get("versionOperation");
                Cardinality gotCountResult = (Cardinality)versionOperationResult.getAggregations().get("gotCount");
                Sum binaryObjectSizeResult = (Sum)versionOperationResult.getAggregations().get(BINARY_OBJECT_SIZE);
                ValueCount binaryObjectCountResult = (ValueCount)versionOperationResult.getAggregations().get(BINARY_OBJECT_COUNT);
                long gotCount = gotCountResult.getValue();
                long binaryObjectSize = (long)binaryObjectSizeResult.getValue();
                long binaryObjectCount = binaryObjectCountResult.getValue();
                if (opi.equals(operationId)) {
                    ogPerSp.setNumberOfGOT(ogPerSp.getNumberOfGOT() + gotCount);
                }
                ogPerSp.setSize(ogPerSp.getSize() + binaryObjectSize);
                ogPerSp.setNumberOfObject(ogPerSp.getNumberOfObject() + binaryObjectCount);
            }
            listOgsPerSps.add(ogPerSp);
        }
        return listOgsPerSps;
    }

    private QueryBuilder queryForObjectGroupAccessionRegisterByOperationId(Integer tenant, String operationId) {
        MatchQueryBuilder operationQuery = QueryBuilders.matchQuery((String)"_ops", (Object)operationId);
        NestedQueryBuilder nestedOperationQuery = QueryBuilders.nestedQuery((String)"_qualifiers.versions", (QueryBuilder)QueryBuilders.matchQuery((String)"_qualifiers.versions._opi", (Object)operationId), (ScoreMode)ScoreMode.Avg);
        return QueryBuilders.boolQuery().must((QueryBuilder)operationQuery).must((QueryBuilder)nestedOperationQuery);
    }

    private AggregationBuilder aggregationForObjectGroupAccessionRegisterByOperationId(String operationId) {
        CardinalityAggregationBuilder gotCountAgg = ((CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)"gotCount").field("_qualifiers.versions.DataObjectGroupId")).precisionThreshold(40000L);
        ValuesSourceAggregationBuilder binaryObjectSizeAgg = AggregationBuilders.sum((String)BINARY_OBJECT_SIZE).field("_qualifiers.versions.Size");
        ValuesSourceAggregationBuilder binaryObjectCountAgg = AggregationBuilders.count((String)BINARY_OBJECT_COUNT).field("_qualifiers.versions._id");
        AbstractAggregationBuilder versionOperationAgg = ((FilterAggregationBuilder)((FilterAggregationBuilder)AggregationBuilders.filter((String)"versionOperation", (QueryBuilder)QueryBuilders.matchQuery((String)"_qualifiers.versions._opi", (Object)operationId)).subAggregation((AggregationBuilder)binaryObjectCountAgg)).subAggregation((AggregationBuilder)binaryObjectSizeAgg)).subAggregation((AggregationBuilder)gotCountAgg);
        AbstractAggregationBuilder versionAgg = AggregationBuilders.nested((String)"version", (String)"_qualifiers.versions").subAggregation((AggregationBuilder)versionOperationAgg);
        AbstractAggregationBuilder operationAgg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"operation").field("_opi")).subAggregation((AggregationBuilder)versionAgg);
        return ((TermsAggregationBuilder)AggregationBuilders.terms((String)ORIGINATING_AGENCY).field("_sp")).subAggregation((AggregationBuilder)operationAgg);
    }

    public MetadataResult selectUnitsByQuery(JsonNode selectQuery) throws MetaDataExecutionException, InvalidParseOperationException, MetaDataDocumentSizeException, MetaDataNotFoundException, BadRequestException, VitamDBException {
        LOGGER.debug("SelectUnitsByQuery/ selectQuery: " + selectQuery);
        return this.selectMetadataObject(selectQuery, null, Collections.singletonList(BuilderToken.FILTERARGS.UNITS));
    }

    public MetadataResult selectObjectGroupsByQuery(JsonNode selectQuery) throws MetaDataExecutionException, InvalidParseOperationException, MetaDataDocumentSizeException, MetaDataNotFoundException, BadRequestException, VitamDBException {
        LOGGER.debug("selectObjectGroupsByQuery/ selectQuery: " + selectQuery);
        return this.selectMetadataObject(selectQuery, null, Collections.singletonList(BuilderToken.FILTERARGS.OBJECTGROUPS));
    }

    public MetadataResult selectUnitsById(JsonNode selectQuery, String unitId) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataDocumentSizeException, MetaDataNotFoundException, BadRequestException, VitamDBException {
        LOGGER.debug("SelectUnitsById/ selectQuery: " + selectQuery);
        return this.selectMetadataObject(selectQuery, unitId, Collections.singletonList(BuilderToken.FILTERARGS.UNITS));
    }

    public MetadataResult selectObjectGroupById(JsonNode selectQuery, String objectGroupId) throws InvalidParseOperationException, MetaDataDocumentSizeException, MetaDataExecutionException, MetaDataNotFoundException, BadRequestException, VitamDBException {
        LOGGER.debug("SelectObjectGroupById - objectGroupId : " + objectGroupId);
        LOGGER.debug("SelectObjectGroupById - selectQuery : " + selectQuery);
        return this.selectMetadataObject(selectQuery, objectGroupId, Collections.singletonList(BuilderToken.FILTERARGS.OBJECTGROUPS));
    }

    private MetadataResult selectMetadataObject(JsonNode selectQuery, String unitOrObjectGroupId, List<BuilderToken.FILTERARGS> filters) throws MetaDataExecutionException, InvalidParseOperationException, MetaDataDocumentSizeException, MetaDataNotFoundException, BadRequestException, VitamDBException {
        RequestMultiple request;
        if (selectQuery.isNull()) {
            throw new InvalidParseOperationException(REQUEST_IS_NULL);
        }
        JsonNode queryCopy = selectQuery.deepCopy();
        long offset = 0L;
        long limit = 0L;
        if (selectQuery.get(FILTER) != null) {
            if (selectQuery.get(FILTER).get(OFFSET) != null) {
                offset = selectQuery.get(FILTER).get(OFFSET).asLong();
            }
            if (selectQuery.get(FILTER).get(LIMIT) != null) {
                limit = selectQuery.get(FILTER).get(LIMIT).asLong();
            }
        }
        SelectParserMultiple selectRequest = new SelectParserMultiple((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
        selectRequest.parse(selectQuery);
        ObjectNode fieldsProjection = (ObjectNode)selectRequest.getRequest().getProjection().get(BuilderToken.PROJECTION.FIELDS.exactToken());
        if (fieldsProjection != null && fieldsProjection.get(BuilderToken.GLOBAL.RULES.exactToken()) != null) {
            throw new InvalidParseOperationException(UNSUPPORTED_RULES_PROJECTION);
        }
        if (unitOrObjectGroupId != null && !unitOrObjectGroupId.isEmpty() && (request = selectRequest.getRequest()) != null) {
            LOGGER.debug("Reset $roots id with :" + unitOrObjectGroupId);
            request.resetRoots().addRoots(new String[]{unitOrObjectGroupId});
        }
        if (filters != null && !filters.isEmpty() && (request = selectRequest.getRequest()) != null) {
            Object[] hints = (String[])filters.stream().map(BuilderToken.FILTERARGS::exactToken).toArray(String[]::new);
            LOGGER.debug("Adding given $hint filters: " + Arrays.toString(hints));
            request.addHintFilter((String[])hints);
        }
        List ontologies = selectRequest.model() == BuilderToken.FILTERARGS.UNITS ? this.unitOntologyLoader.loadOntologies() : this.objectGroupOntologyLoader.loadOntologies();
        Result<MetadataDocument<?>> result = this.dbRequest.execRequest((RequestParserMultiple)selectRequest, ontologies);
        ArrayNode arrayNodeResponse = MetadataJsonResponseUtils.populateJSONObjectResponse(result, (RequestParserMultiple)selectRequest);
        List res = JsonHandler.toArrayList((ArrayNode)arrayNodeResponse);
        ArrayList<FacetResult> facetResults = result != null ? result.getFacet() : new ArrayList<FacetResult>();
        long total = result != null ? result.getTotal() : (long)res.size();
        String scrollId = result != null ? result.getScrollId() : null;
        DatabaseCursor hits = scrollId != null ? new DatabaseCursor(total, offset, limit, (long)res.size(), scrollId) : new DatabaseCursor(total, offset, limit, (long)res.size());
        return new MetadataResult(queryCopy, res, facetResults, total, scrollId, hits);
    }

    public void updateObjectGroupId(JsonNode updateQuery, String objectId, boolean forceUpdate, boolean withRefreshIndex) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetadataValidationException {
        if (updateQuery.isNull()) {
            throw new InvalidParseOperationException(REQUEST_IS_NULL);
        }
        UpdateParserMultiple updateRequest = new UpdateParserMultiple((VarNameAdapter)new MongoDbVarNameAdapter());
        updateRequest.parse(updateQuery);
        this.dbRequest.execUpdateRequest(List.of(new RequestById(objectId, (RequestParserMultiple)updateRequest)), MetadataCollections.OBJECTGROUP, this.objectGroupOntologyValidator, null, this.objectGroupOntologyLoader.loadOntologies(), forceUpdate, withRefreshIndex);
    }

    public List<UpdateUnit> updateUnits(List<RequestById> bulkRequests, boolean forceUpdate, boolean withRefreshIndex) throws InvalidParseOperationException {
        List<String> unitIds = bulkRequests.stream().map(RequestById::getDocumentId).collect(Collectors.toList());
        LOGGER.debug("Start updating units with count " + unitIds.size());
        try {
            if (CollectionUtils.isEmpty(bulkRequests)) {
                return new ArrayList<UpdateUnit>();
            }
            List<UpdatedDocument> updatedDocuments = this.dbRequest.execUpdateRequest(bulkRequests, MetadataCollections.UNIT, this.unitOntologyValidator, this.unitValidator, this.unitOntologyLoader.loadOntologies(), forceUpdate, withRefreshIndex);
            return this.mapResponseWithDiffs(updatedDocuments);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("An error occurred during unit update " + String.join((CharSequence)",", List.of()), (Throwable)e);
            return this.errors(unitIds, StatusCode.KO, UpdateUnitKey.CHECK_UNIT_SCHEMA, e.getMessage());
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error("Unit not found during unit update " + String.join((CharSequence)",", List.of()), (Throwable)e);
            return this.errors(unitIds, StatusCode.KO, UpdateUnitKey.UNIT_UNKNOWN_OR_FORBIDDEN, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during unit update " + String.join((CharSequence)",", List.of()), (Throwable)e);
            return this.errors(unitIds, StatusCode.FATAL, UpdateUnitKey.UNIT_METADATA_UPDATE, e.getMessage());
        }
    }

    private List<UpdateUnit> mapResponseWithDiffs(Collection<UpdatedDocument> updatedDocuments) {
        ArrayList<UpdateUnit> updatedUnits = new ArrayList<UpdateUnit>();
        for (UpdatedDocument updatedDocument : updatedDocuments) {
            String diffs = String.join((CharSequence)"\n", VitamDocument.getConcernedDiffLines((List)VitamDocument.getUnifiedDiff((String)JsonHandler.prettyPrint((Object)updatedDocument.getBeforeUpdate()), (String)JsonHandler.prettyPrint((Object)updatedDocument.getAfterUpdate()))));
            switch (updatedDocument.getStatus()) {
                case SUCCESS: {
                    if (diffs.isEmpty()) {
                        if (!updatedDocument.isUpdated()) {
                            LOGGER.info(String.format("No new data updates for unit update %s.", updatedDocument.getDocumentId()));
                            updatedUnits.add(new UpdateUnit(updatedDocument.getDocumentId(), StatusCode.OK, UpdateUnitKey.UNIT_METADATA_NO_NEW_DATA, "Unit not updated.", "No diff, there are no new changes."));
                            break;
                        }
                        LOGGER.warn(String.format("UNKNOWN updates for unit update %s.", updatedDocument.getDocumentId()));
                        updatedUnits.add(new UpdateUnit(updatedDocument.getDocumentId(), StatusCode.OK, UpdateUnitKey.UNIT_METADATA_NO_CHANGES, "Unit updated with UNKNOWN changes.", "UNKNOWN diff, there are some changes but they cannot be trace."));
                        break;
                    }
                    updatedUnits.add(new UpdateUnit(updatedDocument.getDocumentId(), StatusCode.OK, UpdateUnitKey.UNIT_METADATA_UPDATE, "Update unit OK.", diffs));
                    break;
                }
                case FAILED: {
                    LOGGER.error(String.format("Failed to update for unit update %s. with message %s", updatedDocument.getDocumentId(), updatedDocument.getFailureMessage()));
                    updatedUnits.add(new UpdateUnit(updatedDocument.getDocumentId(), StatusCode.KO, UpdateUnitKey.CHECK_UNIT_SCHEMA, String.format(updatedDocument.getFailureMessage(), new Object[0]), "No diff due to failing status"));
                }
            }
        }
        return updatedUnits;
    }

    public RequestResponse<UpdateUnit> updateUnitsRules(List<String> unitIds, RuleActions ruleActions, Map<String, DurationData> bindRuleToDuration) {
        List ontologies = this.unitOntologyLoader.loadOntologies();
        List unitRules = unitIds.stream().map(unitId -> this.updateAndTransformUnitRules((String)unitId, ruleActions, bindRuleToDuration, ontologies)).collect(Collectors.toList());
        return new RequestResponseOK().addAllResults(unitRules).setTotal((long)unitRules.size());
    }

    private UpdateUnit updateAndTransformUnitRules(String unitId, RuleActions ruleActions, Map<String, DurationData> bindRuleToDuration, List<OntologyModel> ontologies) {
        try {
            UpdatedDocument updatedDocument = this.dbRequest.execRuleRequest(unitId, ruleActions, bindRuleToDuration, this.unitOntologyValidator, this.unitValidator, ontologies);
            String diffs = String.join((CharSequence)"\n", VitamDocument.getConcernedDiffLines((List)VitamDocument.getUnifiedDiff((String)JsonHandler.prettyPrint((Object)updatedDocument.getBeforeUpdate()), (String)JsonHandler.prettyPrint((Object)updatedDocument.getAfterUpdate()))));
            if (diffs.isEmpty()) {
                LOGGER.warn(String.format("UNKNOWN updates for unit update %s.", unitId));
                return new UpdateUnit(unitId, StatusCode.OK, UpdateUnitKey.UNIT_METADATA_NO_CHANGES, "Unit updated with UNKNOWN changes.", "UNKNOWN diff, there are some changes but they cannot be trace.");
            }
            return new UpdateUnit(unitId, StatusCode.OK, UpdateUnitKey.UNIT_METADATA_UPDATE, "Update unit rules OK.", diffs);
        }
        catch (MetadataValidationException e) {
            LOGGER.error("An error occurred during unit update " + unitId, (Throwable)e);
            return this.error(unitId, StatusCode.KO, UpdateUnitKey.CHECK_UNIT_SCHEMA, e.getMessage());
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error("Unit not found during unit update " + unitId, (Throwable)e);
            return this.error(unitId, StatusCode.KO, UpdateUnitKey.UNIT_UNKNOWN_OR_FORBIDDEN, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during unit update " + unitId, (Throwable)e);
            return this.error(unitId, StatusCode.FATAL, UpdateUnitKey.UNIT_METADATA_UPDATE, e.getMessage());
        }
    }

    private List<UpdateUnit> errors(Collection<String> unitIds, StatusCode status, UpdateUnitKey key, String message) {
        return unitIds.stream().map(unitId -> this.error((String)unitId, status, key, StringUtils.defaultIfBlank((String)message, (String)"Unknown error"))).collect(Collectors.toList());
    }

    private UpdateUnit error(String unitId, StatusCode status, UpdateUnitKey key, String message) {
        return new UpdateUnit(unitId, status, key, StringUtils.defaultIfBlank((String)message, (String)"Unknown error"), "no diff");
    }

    public UpdateUnit updateUnitById(JsonNode updateQuery, String unitId, boolean forceUpdate, boolean withRefreshIndex) throws MetaDataNotFoundException, InvalidParseOperationException, MetaDataExecutionException, MetadataValidationException {
        UpdateParserMultiple updateRequest = new UpdateParserMultiple((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
        updateRequest.parse(updateQuery);
        updateRequest.getRequest().addRoots(new String[]{unitId});
        RequestById bulkRequest = new RequestById(unitId, (RequestParserMultiple)updateRequest);
        List<UpdatedDocument> updatedDocuments = this.dbRequest.execUpdateRequest(List.of(bulkRequest), MetadataCollections.UNIT, this.unitOntologyValidator, this.unitValidator, this.unitOntologyLoader.loadOntologies(), forceUpdate, withRefreshIndex);
        Optional updatedDocumentOpt = updatedDocuments.stream().findFirst();
        if (!updatedDocumentOpt.isPresent()) {
            throw new IllegalStateException("No response found");
        }
        UpdatedDocument updatedDocument = (UpdatedDocument)updatedDocumentOpt.get();
        String diffs = String.join((CharSequence)"\n", VitamDocument.getConcernedDiffLines((List)VitamDocument.getUnifiedDiff((String)JsonHandler.prettyPrint((Object)updatedDocument.getBeforeUpdate()), (String)JsonHandler.prettyPrint((Object)updatedDocument.getAfterUpdate()))));
        if (UpdatedDocument.UpdatedDocumentStatus.SUCCESS.equals((Object)updatedDocument.getStatus())) {
            return new UpdateUnit(unitId, StatusCode.OK, UpdateUnitKey.UNIT_METADATA_UPDATE, "Update unit OK.", diffs);
        }
        throw new MetadataValidationException(updatedDocument.getValidationErrorCode(), updatedDocument.getFailureMessage());
    }

    public void refreshUnit() throws IllegalArgumentException, VitamThreadAccessException, MetaDataExecutionException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        this.mongoDbAccess.getEsClient().refreshIndex(MetadataCollections.UNIT, tenantId);
    }

    public void refreshObjectGroup() throws IllegalArgumentException, VitamThreadAccessException, MetaDataExecutionException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        this.mongoDbAccess.getEsClient().refreshIndex(MetadataCollections.OBJECTGROUP, tenantId);
    }

    public ReindexationResult reindex(IndexParameters indexParameters) {
        MetadataCollections collection;
        try {
            collection = MetadataCollections.valueOf(indexParameters.getCollectionName().toUpperCase());
        }
        catch (IllegalArgumentException exc) {
            String message = "Invalid collection '" + indexParameters.getCollectionName() + "'";
            LOGGER.error(message, (Throwable)exc);
            return this.indexationHelper.getFullKOResult(indexParameters, message);
        }
        switch (collection) {
            case UNIT: 
            case OBJECTGROUP: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + collection);
            }
        }
        if (CollectionUtils.isEmpty((Collection)indexParameters.getTenants())) {
            String message = String.format("Missing tenants for %s collection reindexation", indexParameters.getCollectionName());
            LOGGER.error(message);
            return this.indexationHelper.getFullKOResult(indexParameters, message);
        }
        ReindexationResult indexationResult = new ReindexationResult();
        indexationResult.setCollectionName(indexParameters.getCollectionName());
        this.processDedicatedTenants(indexParameters, collection, indexationResult);
        this.processGroupedTenants(indexParameters, collection, indexationResult);
        return indexationResult;
    }

    private void processDedicatedTenants(IndexParameters indexParameters, MetadataCollections collection, ReindexationResult indexationResult) {
        ElasticsearchIndexAliasResolver indexAliasResolver = this.indexManager.getElasticsearchIndexAliasResolver(collection);
        List dedicatedTenantToProcess = indexParameters.getTenants().stream().filter(Predicate.not(this.indexManager::isGroupedTenant)).collect(Collectors.toList());
        for (Integer tenantId : dedicatedTenantToProcess) {
            try {
                ReindexationOK reindexResult = this.indexationHelper.reindex(collection.getCollection(), (ElasticsearchAccess)collection.getEsClient(), indexAliasResolver.resolveIndexName(tenantId), this.indexManager.getElasticsearchIndexSettings(collection, tenantId), collection.getElasticsearchCollection(), Collections.singletonList(tenantId), null);
                indexationResult.addIndexOK(reindexResult);
            }
            catch (Exception exc) {
                String message = "Cannot reindex collection " + collection.name() + " for tenant " + tenantId + ". Unexpected error";
                LOGGER.error(message, (Throwable)exc);
                indexationResult.addIndexKO(new ReindexationKO(Collections.singletonList(tenantId), null, message));
            }
        }
    }

    private void processGroupedTenants(IndexParameters indexParameters, MetadataCollections collection, ReindexationResult indexationResult) {
        ElasticsearchIndexAliasResolver indexAliasResolver = this.indexManager.getElasticsearchIndexAliasResolver(collection);
        HashSetValuedHashMap tenantGroupTenantsMap = new HashSetValuedHashMap();
        indexParameters.getTenants().stream().filter(this.indexManager::isGroupedTenant).forEach(arg_0 -> this.lambda$processGroupedTenants$11((SetValuedMap)tenantGroupTenantsMap, arg_0));
        for (String tenantGroupName : tenantGroupTenantsMap.keySet()) {
            List<Integer> allTenantGroupTenants = this.indexManager.getTenantGroupTenants(tenantGroupName);
            if (allTenantGroupTenants.size() == tenantGroupTenantsMap.get((Object)tenantGroupName).size()) continue;
            SetUtils.SetView missingTenants = SetUtils.difference(new HashSet<Integer>(allTenantGroupTenants), (Set)tenantGroupTenantsMap.get((Object)tenantGroupName));
            LOGGER.warn("Missing tenants " + missingTenants + " of tenant group " + tenantGroupName + " will also be reindexed for collection " + collection);
        }
        TreeSet tenantGroupNamesToProcess = new TreeSet(tenantGroupTenantsMap.keySet());
        for (String tenantGroupName : tenantGroupNamesToProcess) {
            List<Integer> tenantIds = this.indexManager.getTenantGroupTenants(tenantGroupName);
            try {
                ReindexationOK reindexResult = this.indexationHelper.reindex(collection.getCollection(), (ElasticsearchAccess)collection.getEsClient(), indexAliasResolver.resolveIndexName(tenantIds.get(0)), this.indexManager.getElasticsearchIndexSettings(collection, tenantIds.get(0)), collection.getElasticsearchCollection(), tenantIds, tenantGroupName);
                indexationResult.addIndexOK(reindexResult);
            }
            catch (Exception exc) {
                String message = "Cannot reindex collection " + collection.name() + " for tenant group " + tenantGroupName + ". Unexpected error";
                LOGGER.error(message, (Throwable)exc);
                indexationResult.addIndexKO(new ReindexationKO(tenantIds, tenantGroupName, message));
            }
        }
    }

    public SwitchIndexResult switchIndex(String alias, String newIndexName) throws DatabaseException {
        try {
            return this.indexationHelper.switchIndex(ElasticsearchIndexAlias.ofFullIndexName((String)alias), ElasticsearchIndexAlias.ofFullIndexName((String)newIndexName), (ElasticsearchAccess)this.mongoDbAccess.getEsClient());
        }
        catch (DatabaseException exc) {
            LOGGER.error("Cannot switch alias {} to index {}", (Object)alias, (Object)newIndexName);
            throw exc;
        }
    }

    public void checkStreamUnits(int tenantId, short unitsStreamExecutionLimit) throws MetaDataException {
        this.checkStream(tenantId, unitsStreamExecutionLimit, MetadataSnapshot.PARAMETERS.UnitsScrollDate, MetadataSnapshot.PARAMETERS.UnitsScrollNumber);
    }

    public void checkStreamObjects(int tenantId, short objectsStreamExecutionLimit) throws MetaDataException {
        this.checkStream(tenantId, objectsStreamExecutionLimit, MetadataSnapshot.PARAMETERS.ObjectsScrollDate, MetadataSnapshot.PARAMETERS.ObjectsScrollNumber);
    }

    private void checkStream(int tenantId, short streamExecutionLimit, MetadataSnapshot.PARAMETERS scrollDate, MetadataSnapshot.PARAMETERS scrollNumber) throws MetaDataException {
        LocalDate unitsScrollLocalDate;
        MongoCollection snapshotCollection = this.mongoDbAccess.getMongoDatabase().getCollection(SNAPSHOT_COLLECTION, MetadataSnapshot.class);
        Bson unitsScrollDateFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)tenantId), Filters.eq((String)"Name", (Object)scrollDate.name())});
        Bson unitsScrollNumberFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)tenantId), Filters.eq((String)"Name", (Object)scrollNumber.name())});
        MetadataSnapshot unitsScrollDate = (MetadataSnapshot)((Object)snapshotCollection.find(unitsScrollDateFilter).first());
        if (unitsScrollDate != null && (unitsScrollLocalDate = LocalDateUtil.parseMongoFormattedDate((String)unitsScrollDate.getValue(String.class)).toLocalDate()).isBefore(LocalDateUtil.now().toLocalDate())) {
            snapshotCollection.updateOne(unitsScrollNumberFilter, Updates.set((String)"Value", (Object)0));
            return;
        }
        MetadataSnapshot unitsScrollNumber = (MetadataSnapshot)((Object)snapshotCollection.find(unitsScrollNumberFilter).first());
        if (streamExecutionLimit != 0 && unitsScrollNumber != null && unitsScrollNumber.getValue(Integer.class) >= streamExecutionLimit) {
            throw new MetaDataException("Scroll execution limit reached, please re-try next day");
        }
    }

    public void updateParameterStreamUnits(int tenantId) {
        this.updateParameterStream(tenantId, MetadataSnapshot.PARAMETERS.UnitsScrollDate, MetadataSnapshot.PARAMETERS.UnitsScrollNumber);
    }

    public void updateParameterStreamObjects(int tenantId) {
        this.updateParameterStream(tenantId, MetadataSnapshot.PARAMETERS.ObjectsScrollDate, MetadataSnapshot.PARAMETERS.ObjectsScrollNumber);
    }

    private void updateParameterStream(int tenantId, MetadataSnapshot.PARAMETERS scrollDate, MetadataSnapshot.PARAMETERS scrollNumber) {
        MongoCollection snapshotCollection = this.mongoDbAccess.getMongoDatabase().getCollection(SNAPSHOT_COLLECTION, MetadataSnapshot.class);
        Bson scrollDateFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)tenantId), Filters.eq((String)"Name", (Object)scrollDate.name())});
        Bson scrollNumberFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)tenantId), Filters.eq((String)"Name", (Object)scrollNumber.name())});
        snapshotCollection.updateOne(scrollNumberFilter, Updates.combine((Bson[])new Bson[]{Updates.setOnInsert((String)"_id", (Object)GUIDFactory.newGUID().getId()), Updates.inc((String)"Value", (Number)1)}), new UpdateOptions().upsert(true));
        snapshotCollection.updateOne(scrollDateFilter, Updates.combine((Bson[])new Bson[]{Updates.setOnInsert((String)"_id", (Object)GUIDFactory.newGUID().getId()), Updates.set((String)"Value", (Object)LocalDateUtil.nowFormatted())}), new UpdateOptions().upsert(true));
    }

    public void clearESScrollFilter(String scrollId) {
        this.dbRequest.clearEsScrollId(scrollId);
    }

    private /* synthetic */ void lambda$processGroupedTenants$11(SetValuedMap tenantGroupTenantsMap, Integer tenantId) {
        tenantGroupTenantsMap.put((Object)this.indexManager.getTenantGroup(tenantId), (Object)tenantId);
    }
}

