/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.ExportsPurge;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.core.config.TimeToLiveConfiguration;
import fr.gouv.vitam.storage.engine.client.OfferLogHelper;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.api.model.TimeToLive;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;

public class ExportsPurgeService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ExportsPurgeService.class);
    public static final String DIP_CONTAINER = "DIP";
    public static final String TRANSFERS_CONTAINER = "TRANSFER";
    private final WorkspaceClientFactory workspaceClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final TimeToLiveConfiguration timeToLiveConfiguration;

    public ExportsPurgeService(TimeToLiveConfiguration timeToLiveConfiguration) {
        this(WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM), StorageClientFactory.getInstance(), timeToLiveConfiguration);
    }

    @VisibleForTesting
    public ExportsPurgeService(WorkspaceClientFactory workspaceClientFactory, StorageClientFactory storageClientFactory, TimeToLiveConfiguration timeToLiveConfiguration) {
        this.workspaceClientFactory = workspaceClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.timeToLiveConfiguration = timeToLiveConfiguration;
    }

    public void purgeExpiredFiles(String container) throws ContentAddressableStorageServerException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            int timeToLiveInMinutes = this.getTimeToLiveInMinutes(container, workspaceClient);
            workspaceClient.purgeOldFilesInContainer(container, new TimeToLive(timeToLiveInMinutes, ChronoUnit.MINUTES));
        }
        catch (VitamClientException e) {
            throw new ContentAddressableStorageServerException((Throwable)e);
        }
    }

    private int getTimeToLiveInMinutes(String container, WorkspaceClient workspaceClient) throws VitamClientException {
        JsonNode percent = workspaceClient.getFreespacePercent();
        int freespace = percent.get("freespace").asInt();
        if (container.equals(DIP_CONTAINER)) {
            if (freespace <= VitamConfiguration.getWorkspaceFreespaceThreshold()) {
                return this.timeToLiveConfiguration.getCriticalDipTimeToLiveInMinutes();
            }
            return this.timeToLiveConfiguration.getDipTimeToLiveInMinutes();
        }
        return this.timeToLiveConfiguration.getTransfersSIPTimeToLiveInMinutes();
    }

    public void migrationPurgeDipFilesFromOffers() throws StorageServerClientException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            Iterator offerLogIterator = OfferLogHelper.getListing((StorageClientFactory)this.storageClientFactory, (String)VitamConfiguration.getDefaultStrategy(), null, (DataCategory)DataCategory.DIP, null, (Order)Order.ASC, (int)VitamConfiguration.getChunkSize(), null);
            block9: while (offerLogIterator.hasNext()) {
                OfferLog offerLog = (OfferLog)offerLogIterator.next();
                switch (offerLog.getAction()) {
                    case WRITE: {
                        LOGGER.info("Deleting DIP file " + offerLog.getFileName());
                        storageClient.delete(VitamConfiguration.getDefaultStrategy(), DataCategory.DIP, offerLog.getFileName());
                        continue block9;
                    }
                    case DELETE: {
                        continue block9;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + offerLog.getAction());
            }
        }
    }
}

