/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.simulator;

import com.google.common.util.concurrent.Uninterruptibles;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.offers.tape.dto.TapeCartridge;
import fr.gouv.vitam.storage.offers.tape.dto.TapeDrive;
import fr.gouv.vitam.storage.offers.tape.dto.TapeDriveSpec;
import fr.gouv.vitam.storage.offers.tape.dto.TapeDriveState;
import fr.gouv.vitam.storage.offers.tape.dto.TapeDriveStatus;
import fr.gouv.vitam.storage.offers.tape.dto.TapeLibrarySpec;
import fr.gouv.vitam.storage.offers.tape.dto.TapeLibraryState;
import fr.gouv.vitam.storage.offers.tape.dto.TapeSlot;
import fr.gouv.vitam.storage.offers.tape.dto.TapeSlotType;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCommandException;
import fr.gouv.vitam.storage.offers.tape.simulator.VirtualChanger;
import fr.gouv.vitam.storage.offers.tape.simulator.VirtualChangerState;
import fr.gouv.vitam.storage.offers.tape.simulator.VirtualDrive;
import fr.gouv.vitam.storage.offers.tape.simulator.VirtualDriveState;
import fr.gouv.vitam.storage.offers.tape.simulator.VirtualSlot;
import fr.gouv.vitam.storage.offers.tape.simulator.VirtualSlotState;
import fr.gouv.vitam.storage.offers.tape.simulator.VirtualTape;
import fr.gouv.vitam.storage.offers.tape.spec.TapeDriveCommandService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeLoadUnloadService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeReadWriteService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.BoundedInputStream;

public class TapeLibrarySimulator {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TapeLibrarySimulator.class);
    private final Object syncRoot = new Object();
    private final VirtualChanger changer;
    private final List<VirtualDrive> drives;
    private final List<VirtualSlot> slots;
    private final TestTapeLoadUnloadService tapeLoadUnloadService;
    private final List<TapeReadWriteService> tapeReadWriteServices;
    private final List<TapeDriveCommandService> tapeDriveCommandServices;
    private final List<Exception> failures;
    private final int maxTapeCapacityInBytes;
    private final String cartridgeType;
    private volatile int sleepDelayMillis;

    public TapeLibrarySimulator(Path inputDirectory, Path tempOutputStorageDirectory, int nbDrives, int nbSlots, int nbTapes, int maxTapeCapacityInBytes, String cartridgeType, int sleepDelayMillis) {
        ParametersChecker.checkParameter((String)"Missing inputDirectory", (Object[])new Object[]{inputDirectory});
        ParametersChecker.checkParameter((String)"Missing tempOutputStorageDirectory", (Object[])new Object[]{tempOutputStorageDirectory});
        ParametersChecker.checkValue((String)"Invalid nbDrives", (long)nbDrives, (long)1L);
        ParametersChecker.checkValue((String)"Invalid nbSlots", (long)nbSlots, (long)1L);
        ParametersChecker.checkValue((String)"Invalid nbTapes", (long)nbTapes, (long)1L);
        ParametersChecker.checkValue((String)"Invalid maxTapeCapacityInBytes", (long)maxTapeCapacityInBytes, (long)1L);
        ParametersChecker.checkValue((String)"nbTapes must be <= nbSlots", (long)nbSlots, (long)nbTapes);
        ParametersChecker.checkParameter((String)"Missing cartridgeType", (String[])new String[]{cartridgeType});
        this.failures = Collections.synchronizedList(new ArrayList());
        this.changer = new VirtualChanger().setChangerStatus(VirtualChangerState.READY);
        this.drives = IntStream.range(0, nbDrives).mapToObj(driveIndex -> new VirtualDrive(driveIndex).setCurrentTape(null).setState(VirtualDriveState.EMPTY)).collect(Collectors.toList());
        this.slots = IntStream.rangeClosed(1, nbSlots).mapToObj(slotNumber -> new VirtualSlot(slotNumber).setCurrentTape(null).setState(VirtualSlotState.EMPTY)).collect(Collectors.toList());
        for (int i = 0; i < nbTapes; ++i) {
            VirtualSlot virtualSlot = this.slots.get(i);
            virtualSlot.setCurrentTape(new VirtualTape("TAPE-" + i, "ALT-TAPE-TAG-" + i, maxTapeCapacityInBytes));
            virtualSlot.setState(VirtualSlotState.LOADED);
        }
        this.tapeLoadUnloadService = new TestTapeLoadUnloadService();
        this.tapeReadWriteServices = new ArrayList<TapeReadWriteService>();
        this.tapeDriveCommandServices = new ArrayList<TapeDriveCommandService>();
        for (int driveIndex2 = 0; driveIndex2 < nbDrives; ++driveIndex2) {
            this.tapeReadWriteServices.add(new TestTapeReadWriteService(driveIndex2, inputDirectory, tempOutputStorageDirectory));
            this.tapeDriveCommandServices.add(new TestTapeDriveCommandService(driveIndex2));
        }
        this.maxTapeCapacityInBytes = maxTapeCapacityInBytes;
        this.cartridgeType = cartridgeType;
        this.sleepDelayMillis = sleepDelayMillis;
    }

    public TapeLoadUnloadService getTapeLoadUnloadService() {
        return this.tapeLoadUnloadService;
    }

    public List<TapeReadWriteService> getTapeReadWriteServices() {
        return Collections.unmodifiableList(this.tapeReadWriteServices);
    }

    public List<TapeDriveCommandService> getTapeDriveCommandServices() {
        return Collections.unmodifiableList(this.tapeDriveCommandServices);
    }

    public List<Exception> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    private void ensureTapeLoaded(VirtualDrive drive) throws TapeCommandException {
        switch (drive.getState()) {
            case EMPTY: {
                throw this.createAndReportSevereTapeCommandException("No loaded tape in drive " + drive.getDriveIndex());
            }
            case LOADED: {
                LOGGER.info("OK, tape " + drive.getCurrentTape().getVolumeTag() + " is loaded into drive " + drive.getDriveIndex());
                break;
            }
            case EJECTED: {
                throw this.createAndReportSevereTapeCommandException("Tape " + drive.getCurrentTape().getVolumeTag() + " has already been ejected from drive " + drive.getDriveIndex());
            }
            case BUSY: {
                throw this.createAndReportSevereTapeCommandException("Drive " + drive.getDriveIndex() + " is busy !");
            }
            default: {
                throw this.createAndReportIllegalStateException("Unexpected value: " + drive.getState());
            }
        }
    }

    private void ensureChargerIsReady(VirtualChanger changer) throws TapeCommandException {
        switch (changer.getChangerStatus()) {
            case READY: {
                LOGGER.info("OK, charger is ready");
                break;
            }
            case BUSY: {
                throw this.createAndReportSevereTapeCommandException("Changer is busy !");
            }
            default: {
                throw this.createAndReportIllegalStateException("Unexpected value: " + changer.getChangerStatus());
            }
        }
    }

    private void checkSlotNumber(int slotNumber) {
        if (slotNumber < 1 || slotNumber > this.slots.size()) {
            throw this.createAndReportIllegalStateException("Invalid slotNumber: " + slotNumber);
        }
    }

    private void checkDriveIndex(int driveIndex) {
        if (driveIndex < 0 || driveIndex >= this.drives.size()) {
            throw this.createAndReportIllegalStateException("Invalid driveIndex: " + driveIndex);
        }
    }

    private TapeCommandException createAndReportSevereTapeCommandException(String msg) {
        TapeCommandException tapeCommandException = new TapeCommandException(msg);
        this.failures.add((Exception)tapeCommandException);
        return tapeCommandException;
    }

    private TapeCommandException createAndReportSevereTapeCommandException(String msg, Throwable cause) {
        TapeCommandException tapeCommandException = new TapeCommandException(msg, (Object)cause);
        this.failures.add((Exception)tapeCommandException);
        return tapeCommandException;
    }

    private IllegalStateException createAndReportIllegalStateException(String msg) {
        IllegalStateException illegalStateException = new IllegalStateException(msg);
        this.failures.add(illegalStateException);
        return illegalStateException;
    }

    public TapeLibrarySimulator setSleepDelayMillis(int sleepDelayMillis) {
        this.sleepDelayMillis = sleepDelayMillis;
        return this;
    }

    private class TestTapeLoadUnloadService
    implements TapeLoadUnloadService {
        private TestTapeLoadUnloadService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TapeLibrarySpec status() throws TapeCommandException {
            Object object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                TapeLibrarySimulator.this.ensureChargerIsReady(TapeLibrarySimulator.this.changer);
                TapeLibrarySimulator.this.changer.setChangerStatus(VirtualChangerState.BUSY);
            }
            Uninterruptibles.sleepUninterruptibly((long)TapeLibrarySimulator.this.sleepDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                TapeLibraryState result = new TapeLibraryState();
                result.setDevice("Changer");
                result.setDriveCount(TapeLibrarySimulator.this.drives.size());
                result.setSlotsCount(TapeLibrarySimulator.this.slots.size());
                result.setMailBoxCount(0);
                ArrayList<TapeDrive> tapeDrives = new ArrayList<TapeDrive>();
                for (int driveIndex = 0; driveIndex < TapeLibrarySimulator.this.drives.size(); ++driveIndex) {
                    VirtualDrive virtualDrive = TapeLibrarySimulator.this.drives.get(driveIndex);
                    TapeDrive tapeDrive = new TapeDrive();
                    tapeDrive.setIndex(Integer.valueOf(driveIndex));
                    tapeDrive.setTape(this.toTapeCartridge(virtualDrive.getCurrentTape(), null));
                    tapeDrives.add(tapeDrive);
                }
                result.setDrives(tapeDrives);
                ArrayList<TapeSlot> tapeSlots = new ArrayList<TapeSlot>();
                for (int slotNumber = 1; slotNumber <= TapeLibrarySimulator.this.slots.size(); ++slotNumber) {
                    VirtualSlot virtualSlot = TapeLibrarySimulator.this.slots.get(slotNumber - 1);
                    TapeSlot tapeSlot = new TapeSlot();
                    tapeSlot.setIndex(Integer.valueOf(slotNumber));
                    tapeSlot.setStorageElementType(TapeSlotType.SLOT);
                    tapeSlot.setTape(this.toTapeCartridge(virtualSlot.getCurrentTape(), slotNumber));
                    tapeSlots.add(tapeSlot);
                }
                result.setSlots(tapeSlots);
                TapeLibrarySimulator.this.changer.setChangerStatus(VirtualChangerState.READY);
                return result;
            }
        }

        private TapeCartridge toTapeCartridge(VirtualTape virtualTape, Integer slotNumber) {
            if (virtualTape == null) {
                return null;
            }
            TapeCartridge tapeCartridge = new TapeCartridge();
            tapeCartridge.setVolumeTag(virtualTape.getVolumeTag());
            tapeCartridge.setAlternateVolumeTag(virtualTape.getAlternateVolumeTag());
            tapeCartridge.setSlotIndex(slotNumber);
            return tapeCartridge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadTape(int slotNumber, int driveIndex) throws TapeCommandException {
            Object object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                TapeLibrarySimulator.this.checkSlotNumber(slotNumber);
                TapeLibrarySimulator.this.checkDriveIndex(driveIndex);
                TapeLibrarySimulator.this.ensureChargerIsReady(TapeLibrarySimulator.this.changer);
                VirtualSlot virtualSlot = TapeLibrarySimulator.this.slots.get(slotNumber - 1);
                switch (virtualSlot.getState()) {
                    case EMPTY: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Cannot load tape from slot " + slotNumber + " into drive " + driveIndex + ". Slot is empty");
                    }
                    case LOADED: {
                        LOGGER.info("OK. Slot " + slotNumber + " contains tape " + virtualSlot.getCurrentTape().getVolumeTag());
                        break;
                    }
                    case BUSY: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Slot " + slotNumber + " is busy !");
                    }
                    default: {
                        throw TapeLibrarySimulator.this.createAndReportIllegalStateException("Unexpected value: " + virtualSlot.getState());
                    }
                }
                VirtualDrive virtualDrive = TapeLibrarySimulator.this.drives.get(driveIndex);
                switch (virtualDrive.getState()) {
                    case EMPTY: {
                        LOGGER.info("OK. Drive " + driveIndex + " is empty");
                        break;
                    }
                    case LOADED: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Cannot load tape from slot " + slotNumber + " into drive " + driveIndex + ". Drive is full");
                    }
                    case EJECTED: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Drive " + driveIndex + " has ejected the tape " + virtualDrive.getCurrentTape().getVolumeTag() + " but has not yet unloaded it into a slot!");
                    }
                    case BUSY: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Drive " + driveIndex + " is busy !");
                    }
                    default: {
                        throw TapeLibrarySimulator.this.createAndReportIllegalStateException("Unexpected value: " + virtualDrive.getState());
                    }
                }
                TapeLibrarySimulator.this.changer.setChangerStatus(VirtualChangerState.BUSY);
                virtualSlot.setState(VirtualSlotState.BUSY);
                virtualDrive.setState(VirtualDriveState.BUSY);
            }
            Uninterruptibles.sleepUninterruptibly((long)TapeLibrarySimulator.this.sleepDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                VirtualDrive virtualDrive = TapeLibrarySimulator.this.drives.get(driveIndex);
                VirtualSlot virtualSlot = TapeLibrarySimulator.this.slots.get(slotNumber - 1);
                VirtualTape virtualTape = virtualSlot.getCurrentTape();
                virtualSlot.setState(VirtualSlotState.EMPTY);
                virtualSlot.setCurrentTape(null);
                virtualDrive.setState(VirtualDriveState.LOADED);
                virtualDrive.setCurrentTape(virtualTape);
                virtualDrive.setFilePosition(0);
                virtualDrive.setBeginningOfTape(true);
                virtualDrive.setEndOfFile(false);
                virtualDrive.setEndOfData(false);
                virtualDrive.setPreviousTapeSlot(slotNumber);
                TapeLibrarySimulator.this.changer.setChangerStatus(VirtualChangerState.READY);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unloadTape(int slotNumber, int driveIndex) throws TapeCommandException {
            Object object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                TapeLibrarySimulator.this.checkSlotNumber(slotNumber);
                TapeLibrarySimulator.this.checkDriveIndex(driveIndex);
                TapeLibrarySimulator.this.ensureChargerIsReady(TapeLibrarySimulator.this.changer);
                VirtualSlot virtualSlot = TapeLibrarySimulator.this.slots.get(slotNumber - 1);
                switch (virtualSlot.getState()) {
                    case EMPTY: {
                        LOGGER.info("OK. Slot " + slotNumber + " is empty");
                        break;
                    }
                    case LOADED: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Cannot load tape from drive " + driveIndex + " into slot " + slotNumber + ". Slot is full");
                    }
                    case BUSY: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Slot " + slotNumber + " is busy !");
                    }
                    default: {
                        throw TapeLibrarySimulator.this.createAndReportIllegalStateException("Unexpected value: " + virtualSlot.getState());
                    }
                }
                VirtualDrive virtualDrive = TapeLibrarySimulator.this.drives.get(driveIndex);
                switch (virtualDrive.getState()) {
                    case EMPTY: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Cannot unload tape from drive " + driveIndex + " into slot " + slotNumber + ". Drive is empty");
                    }
                    case LOADED: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Cannot unload tape from drive " + driveIndex + " into slot " + slotNumber + ". Tape " + virtualDrive.getCurrentTape().getVolumeTag() + " has not yet been ejected");
                    }
                    case EJECTED: {
                        LOGGER.info("OK. Drive " + driveIndex + " has an ejected tape " + virtualDrive.getCurrentTape().getVolumeTag());
                        break;
                    }
                    case BUSY: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Drive " + driveIndex + " is busy !");
                    }
                    default: {
                        throw TapeLibrarySimulator.this.createAndReportIllegalStateException("Unexpected value: " + virtualDrive.getState());
                    }
                }
                TapeLibrarySimulator.this.changer.setChangerStatus(VirtualChangerState.BUSY);
                virtualSlot.setState(VirtualSlotState.BUSY);
                virtualDrive.setState(VirtualDriveState.BUSY);
            }
            Uninterruptibles.sleepUninterruptibly((long)TapeLibrarySimulator.this.sleepDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                VirtualDrive virtualDrive = TapeLibrarySimulator.this.drives.get(driveIndex);
                VirtualSlot virtualSlot = TapeLibrarySimulator.this.slots.get(slotNumber - 1);
                VirtualTape virtualTape = virtualDrive.getCurrentTape();
                virtualSlot.setState(VirtualSlotState.LOADED);
                virtualSlot.setCurrentTape(virtualTape);
                virtualDrive.setState(VirtualDriveState.EMPTY);
                virtualDrive.setCurrentTape(null);
                virtualDrive.setFilePosition(null);
                virtualDrive.setBeginningOfTape(null);
                virtualDrive.setEndOfFile(null);
                virtualDrive.setEndOfData(null);
                virtualDrive.setPreviousTapeSlot(null);
                TapeLibrarySimulator.this.changer.setChangerStatus(VirtualChangerState.READY);
            }
        }
    }

    private class TestTapeDriveCommandService
    implements TapeDriveCommandService {
        private final int driveIndex;
        private final VirtualDrive drive;

        private TestTapeDriveCommandService(int driveIndex) {
            this.driveIndex = driveIndex;
            this.drive = TapeLibrarySimulator.this.drives.get(driveIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TapeDriveSpec status() throws TapeCommandException {
            VirtualDriveState driveState;
            Object object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                driveState = this.drive.getState();
                switch (driveState) {
                    case EMPTY: 
                    case LOADED: 
                    case EJECTED: {
                        LOGGER.info("OK. Drive state is " + driveState + ".");
                        break;
                    }
                    case BUSY: {
                        throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Drive " + this.driveIndex + " is busy !");
                    }
                    default: {
                        throw TapeLibrarySimulator.this.createAndReportIllegalStateException("Unexpected value: " + driveState);
                    }
                }
                this.drive.setState(VirtualDriveState.BUSY);
            }
            Uninterruptibles.sleepUninterruptibly((long)TapeLibrarySimulator.this.sleepDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                this.drive.setState(driveState);
                TapeDriveState result = new TapeDriveState();
                switch (driveState) {
                    case EMPTY: 
                    case EJECTED: {
                        result.setCartridge(null);
                        result.setDriveStatuses(List.of(TapeDriveStatus.DR_OPEN, TapeDriveStatus.IM_REP_EN));
                        result.setTapeBlockSize(null);
                        result.setFileNumber(null);
                        break;
                    }
                    case LOADED: {
                        result.setCartridge(TapeLibrarySimulator.this.cartridgeType);
                        ArrayList<TapeDriveStatus> driveStatuses = new ArrayList<TapeDriveStatus>();
                        driveStatuses.add(TapeDriveStatus.ONLINE);
                        driveStatuses.add(TapeDriveStatus.IM_REP_EN);
                        if (this.drive.getEndOfData().booleanValue()) {
                            driveStatuses.add(TapeDriveStatus.EOD);
                        }
                        if (this.drive.getEndOfFile().booleanValue()) {
                            driveStatuses.add(TapeDriveStatus.EOF);
                        }
                        if (this.drive.getBeginningOfTape().booleanValue()) {
                            driveStatuses.add(TapeDriveStatus.BOT);
                        }
                        result.setDriveStatuses(driveStatuses);
                        result.setBlockNumber(Integer.valueOf(0));
                        result.setTapeBlockSize(Long.valueOf(0L));
                        result.setFileNumber(this.drive.getFilePosition());
                        break;
                    }
                    default: {
                        throw TapeLibrarySimulator.this.createAndReportIllegalStateException("Unexpected value: " + driveState);
                    }
                }
                result.setDescription("DRIVE-" + this.drive.getDriveIndex());
                result.setErrorCountSinceLastStatus(Integer.valueOf(0));
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void move(int position, boolean isBackward) throws TapeCommandException {
            if (position < 1) {
                throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Position " + position + " cannot be negative or zero");
            }
            Object object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                TapeLibrarySimulator.this.ensureTapeLoaded(this.drive);
                this.drive.setState(VirtualDriveState.BUSY);
            }
            Uninterruptibles.sleepUninterruptibly((long)TapeLibrarySimulator.this.sleepDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                this.drive.setState(VirtualDriveState.LOADED);
                int currentPosition = this.drive.getFilePosition();
                if (isBackward) {
                    this.drive.setEndOfFile(false);
                    this.drive.setEndOfData(false);
                    if (currentPosition == position) {
                        this.drive.setFilePosition(0);
                        this.drive.setBeginningOfTape(true);
                    } else {
                        if (currentPosition <= position) {
                            this.drive.setFilePosition(0);
                            this.drive.setBeginningOfTape(true);
                            throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Cannot move drive " + position + " files backward. Previous tape " + this.drive.getCurrentTape().getVolumeTag() + " position: " + currentPosition + ". Beginning Of Tape reached.");
                        }
                        this.drive.setFilePosition(currentPosition - position);
                        this.drive.setBeginningOfTape(false);
                    }
                } else {
                    int fileCount = this.drive.getCurrentTape().getPersistedFiles().size();
                    this.drive.setEndOfFile(false);
                    this.drive.setBeginningOfTape(false);
                    if (currentPosition + position > fileCount) {
                        this.drive.setFilePosition(fileCount);
                        this.drive.setEndOfData(true);
                        if (currentPosition != 0) throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Cannot move drive " + position + " files forward. Current tape " + this.drive.getCurrentTape().getVolumeTag() + " position: " + currentPosition + ". End Of Data reached.");
                        if (!this.drive.getCurrentTape().getPersistedFiles().isEmpty()) throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Cannot move drive " + position + " files forward. Current tape " + this.drive.getCurrentTape().getVolumeTag() + " position: " + currentPosition + ". End Of Data reached.");
                        if (position != 1) throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Cannot move drive " + position + " files forward. Current tape " + this.drive.getCurrentTape().getVolumeTag() + " position: " + currentPosition + ". End Of Data reached.");
                        throw new TapeCommandException("Cannot move drive " + position + " files backward. Tape " + this.drive.getCurrentTape().getVolumeTag() + " is empty");
                    }
                    this.drive.setFilePosition(currentPosition + position);
                    this.drive.setEndOfData(false);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rewind() throws TapeCommandException {
            Object object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                TapeLibrarySimulator.this.ensureTapeLoaded(this.drive);
                this.drive.setState(VirtualDriveState.BUSY);
            }
            Uninterruptibles.sleepUninterruptibly((long)TapeLibrarySimulator.this.sleepDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                this.drive.setState(VirtualDriveState.LOADED);
                this.drive.setFilePosition(0);
                this.drive.setBeginningOfTape(true);
                this.drive.setEndOfFile(false);
                this.drive.setEndOfData(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void goToEnd() throws TapeCommandException {
            Object object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                TapeLibrarySimulator.this.ensureTapeLoaded(this.drive);
                this.drive.setState(VirtualDriveState.BUSY);
            }
            Uninterruptibles.sleepUninterruptibly((long)TapeLibrarySimulator.this.sleepDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                this.drive.setState(VirtualDriveState.LOADED);
                this.drive.setFilePosition(this.drive.getCurrentTape().getPersistedFiles().size());
                this.drive.setBeginningOfTape(false);
                this.drive.setEndOfFile(false);
                this.drive.setEndOfData(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eject() throws TapeCommandException {
            Object object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                TapeLibrarySimulator.this.ensureTapeLoaded(this.drive);
                this.drive.setState(VirtualDriveState.BUSY);
            }
            Uninterruptibles.sleepUninterruptibly((long)TapeLibrarySimulator.this.sleepDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                this.drive.setState(VirtualDriveState.EJECTED);
                this.drive.setFilePosition(null);
                this.drive.setBeginningOfTape(null);
                this.drive.setEndOfFile(null);
                this.drive.setEndOfData(null);
            }
        }
    }

    private class TestTapeReadWriteService
    implements TapeReadWriteService {
        private final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TestTapeReadWriteService.class);
        private final int driveIndex;
        private final VirtualDrive drive;
        private final Path inputDirectory;
        private final Path tmpOutputStorageFolder;

        private TestTapeReadWriteService(int driveIndex, Path inputDirectory, Path tmpOutputStorageFolder) {
            this.driveIndex = driveIndex;
            this.drive = TapeLibrarySimulator.this.drives.get(driveIndex);
            this.inputDirectory = inputDirectory;
            this.tmpOutputStorageFolder = tmpOutputStorageFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToTape(String inputPath) throws TapeCommandException {
            Integer filePosition;
            VirtualTape currentTape;
            if (inputPath == null) {
                throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Missing inputPath");
            }
            Object object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                TapeLibrarySimulator.this.ensureTapeLoaded(this.drive);
                currentTape = this.drive.getCurrentTape();
                filePosition = this.drive.getFilePosition();
                if (filePosition < currentTape.getPersistedFiles().size()) {
                    this.LOGGER.warn("WARNING : TAPE " + currentTape.getVolumeTag() + " is being overridden");
                    ListIterator<Path> filesToOverrideIterator = currentTape.getPersistedFiles().listIterator(filePosition);
                    while (filesToOverrideIterator.hasNext()) {
                        Path fileToOverride = filesToOverrideIterator.next();
                        try {
                            Files.delete(fileToOverride);
                        }
                        catch (IOException e) {
                            throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("IOError while overriding file " + fileToOverride + " of tape " + currentTape.getVolumeTag(), e);
                        }
                        filesToOverrideIterator.remove();
                    }
                }
                this.drive.setState(VirtualDriveState.BUSY);
            }
            Uninterruptibles.sleepUninterruptibly((long)TapeLibrarySimulator.this.sleepDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            Path destinationPath = null;
            int sizeToWrite = 0;
            try {
                destinationPath = this.tmpOutputStorageFolder.resolve(currentTape.getVolumeTag()).resolve("file" + currentTape.getPersistedFiles().size()).toAbsolutePath();
                Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
                Path sourceFile = this.inputDirectory.resolve(inputPath);
                int fileSize = (int)Files.size(sourceFile);
                if (fileSize == 0) {
                    throw TapeLibrarySimulator.this.createAndReportIllegalStateException("Empty source file " + (Path)sourceFile);
                }
                sizeToWrite = Math.min(TapeLibrarySimulator.this.maxTapeCapacityInBytes - currentTape.getUsedCapacity(), fileSize);
                this.LOGGER.info("Writing file " + (Path)sourceFile + " (" + FileUtils.byteCountToDisplaySize((long)fileSize) + ") to tape " + currentTape.getVolumeTag() + " at position " + currentTape.getPersistedFiles().size());
                try (InputStream sourceFileInputStream = Files.newInputStream(sourceFile, new OpenOption[0]);){
                    Files.copy((InputStream)new BoundedInputStream(sourceFileInputStream, (long)sizeToWrite), destinationPath, new CopyOption[0]);
                }
                if (sizeToWrite < fileSize) {
                    throw new TapeCommandException("IOError : No space left on device while writing " + inputPath + " to tape " + currentTape.getVolumeTag());
                }
            }
            catch (IOException e) {
                throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("IOError while writing " + inputPath + " to tape " + currentTape.getVolumeTag(), e);
            }
            finally {
                Object object2 = TapeLibrarySimulator.this.syncRoot;
                synchronized (object2) {
                    this.drive.setState(VirtualDriveState.LOADED);
                    this.drive.setFilePosition(filePosition + 1);
                    this.drive.setBeginningOfTape(false);
                    this.drive.setEndOfFile(true);
                    this.drive.setEndOfData(false);
                    if (destinationPath != null) {
                        currentTape.getPersistedFiles().add(destinationPath);
                    }
                    currentTape.setUsedCapacity(currentTape.getUsedCapacity() + sizeToWrite);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromTape(String outputPath) throws TapeCommandException {
            Path srcFilePath;
            Integer filePosition;
            VirtualTape currentTape;
            if (outputPath == null) {
                throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("Missing outputPath");
            }
            Object object = TapeLibrarySimulator.this.syncRoot;
            synchronized (object) {
                TapeLibrarySimulator.this.ensureTapeLoaded(this.drive);
                currentTape = this.drive.getCurrentTape();
                filePosition = this.drive.getFilePosition();
                if (filePosition >= currentTape.getPersistedFiles().size()) {
                    this.drive.setBeginningOfTape(false);
                    this.drive.setEndOfFile(false);
                    this.drive.setEndOfData(true);
                    throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("IOError. No more file to read from tape " + currentTape.getVolumeTag() + " in drive " + this.driveIndex);
                }
                srcFilePath = currentTape.getPersistedFiles().get(filePosition);
                this.drive.setState(VirtualDriveState.BUSY);
            }
            Uninterruptibles.sleepUninterruptibly((long)TapeLibrarySimulator.this.sleepDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            try {
                Path destinationPath = this.tmpOutputStorageFolder.resolve(outputPath);
                if (Files.exists(destinationPath, new LinkOption[0])) {
                    throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("IOError while reading file from tape " + currentTape.getVolumeTag() + ". OutputPath '" + outputPath + "'already exists");
                }
                this.LOGGER.info("Reading file at position " + filePosition + " of tape " + currentTape.getVolumeTag() + " into file " + (Path)destinationPath + " (" + FileUtils.byteCountToDisplaySize((long)Files.size(srcFilePath)) + ")");
                Files.copy(srcFilePath, destinationPath, new CopyOption[0]);
            }
            catch (IOException e) {
                throw TapeLibrarySimulator.this.createAndReportSevereTapeCommandException("IOError while copying tape " + currentTape.getVolumeTag() + " content into " + outputPath + "file", e);
            }
            finally {
                Object object2 = TapeLibrarySimulator.this.syncRoot;
                synchronized (object2) {
                    this.drive.setState(VirtualDriveState.LOADED);
                    this.drive.setFilePosition(filePosition + 1);
                    this.drive.setBeginningOfTape(false);
                    this.drive.setEndOfFile(true);
                    this.drive.setEndOfData(false);
                }
            }
        }

        public String getTmpOutputStorageFolder() {
            return this.tmpOutputStorageFolder.toString();
        }
    }
}

