/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.external.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.external.client.AbstractMockClient;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSummaryModel;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileStatus;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.ContextStatus;
import fr.gouv.vitam.common.model.administration.FileFormatModel;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.OntologyOrigin;
import fr.gouv.vitam.common.model.administration.OntologyType;
import fr.gouv.vitam.common.model.administration.PermissionModel;
import fr.gouv.vitam.common.model.administration.ProfileFormat;
import fr.gouv.vitam.common.model.administration.ProfileModel;
import fr.gouv.vitam.common.model.administration.ProfileStatus;
import fr.gouv.vitam.common.model.administration.RegisterValueDetailModel;
import fr.gouv.vitam.common.model.administration.RuleMeasurementEnum;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitam.common.model.administration.StorageDetailModel;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookLifecycle;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;

public class ClientMockResultHelper {
    private static final String RESULT = "{\"$query\":{},\"$hits\":{\"total\":100,\"offset\":0,\"limit\":100},\"$results\":";
    private static final String UNIT = "{\"DescriptionLevel\":\"Item\",\"Title\":[\"METADATA ENCODING AND TRANSMISSION STANDARD: PRIMER AND REFERENCE MANUAL\",\"Manuel METS revu et corrig\u00e9\"],\"Description\":[\"METSPrimerRevised.pdf\",\"Pseudo Archive METSPrimerRevised.pdf\"],\"Tag\":[\"METS\",\"norme internationale\"],\"TransactedDate\":\"2012-09-16T10:22:02\",\"Event\":[{\"EventType\":\"Cr\u00e9ation\",\"EventDateTime\":\"2010-01-01T10:22:02\"},{\"EventType\":\"Validation\",\"EventDateTime\":\"2010-02-01T10:22:02\"}],\"_uds\":[{\"aeaaaaaaaaaam7mxaa7hcakyq4z6soyaaaaq\":1}],\"#id\":\"aeaaaaaaaaaam7mxaa7hcakyq4z6spqaaaaq\",\"#nbunits\":0,\"#tenant\":0,\"#object\":\"aeaaaaaaaaaam7mxaa7hcakyq4z6sjqaaaaq\",\"#unitups\":[\"aeaaaaaaaaaam7mxaa7hcakyq4z6soyaaaaq\"],\"#min\":1,\"#max\":2,\"#allunitups\":[\"aeaaaaaaaaaam7mxaa7hcakyq4z6soyaaaaq\"],\"#operations\":[\"aedqaaaaacaam7mxabhniakyq4z4ewaaaaaq\"]}";
    private static final String LOGBOOK_OPERATION = "\"evId\": \"aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq\",\"evType\": \"Process_SIP_unitary\",\"evDateTime\": \"2016-06-10T11:56:35.914\",\"evIdProc\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"evTypeProc\": \"INGEST\",\"outcome\": \"STARTED\",\"outDetail\": null,\"outMessg\": \"SIP entry : SIP.zip\",\"agId\": \"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"ingest-external\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\",\"agIdApp\": null,\"evIdAppSession\": null,\"evIdReq\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"agIdExt\": null,\"obId\": null,\"obIdReq\": null,\"obIdIn\": null,\"events\": []}";
    private static final String ACCESSION_DETAIL = "{\"_id\": \"aedqaaaaacaam7mxabsakakygeje2uyaaaaq\",\"_tenant\": 0,\"OriginatingAgency\": \"FRAN_NP_005568\",\"SubmissionAgency\": \"FRAN_NP_005061\",\"EndDate\": \"2016-11-04T21:40:47.912+01:00\",\"StartDate\": \"2016-11-04T21:40:47.912+01:00\",\"Status\": \"STORED_AND_COMPLETED\",\"TotalObjectGroups\": {    \"total\": 1,    \"deleted\": 0,    \"remained\": 1},\"TotalUnits\": {    \"total\": 1,    \"deleted\": 0,    \"remained\": 1},\"TotalObjects\": {    \"total\": 4,    \"deleted\": 0,    \"remained\": 4},\"ObjectSize\": {    \"total\": 345042,    \"deleted\": 0,    \"remained\": 345042}}";
    private static final String TRACEABILITY_OPERATION = "{$hint: {'total':'1'},$context:{$query: {$eq: {\"id\" : \"1\" }}, $projection: {}, $filter: {}},$result: {\"LogType\":\"OPERATION\",\"StartDate\":\"2017-03-02T12:46:25.618\",\"EndDate\":\"2017-03-02T14:22:34.811\",\"Hash\":\"obu+Z7+M7JlaY5ney0dDNTzmWr4+r6Cf3GtwMrLKpCLIL7Bjqty8kfUNSGNQ9qlzO3YE7+zRdC2o/S+uUOJM4g==\",\"TimeStampToken\":\"MIIEZzAVAgEAMBAMDk9wZXJhdGlvbiBPa2F5MIIETAYJKoZIhvcNAQcCoIIEPTCCBDkCAQMxDzANBglghkgBZQMEAgMFADCBgAYLKoZIhvcNAQkQAQSgcQRvMG0CAQEGASkwUTANBglghkgBZQMEAgMFAARAMcCUdvY+87OSgJw3slg+aHgTt+j+UcybWmhG0G9wL7A0NE8eUO8JFJRD81Gb4wTu12AealKzWeUoLczLWRhACQIBARgPMjAxNzAzMDIxNDIyMzVaMYIDnjCCA5oCAQEwTzBKMQswCQYDVQQGEwJGUjEPMA0GA1UECBMGRnJhbmNlMQ4wDAYDVQQHEwVQQXJpczENMAsGA1UEChMERXRhdDELMAkGA1UECxMCRVQCAQEwDQYJYIZIAWUDBAIDBQCgggEgMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMTcwMzAyMTQyMjM1WjAtBgkqhkiG9w0BCTQxIDAeMA0GCWCGSAFlAwQCAwUAoQ0GCSqGSIb3DQEBDQUAME8GCSqGSIb3DQEJBDFCBECDgiYpV3Bd/9ckq0Nq+zm/TmPWO3rCt33o+cKA8DI5L9EGiEV2GtjO0z4jnw08/iZ3chanYRrR8hJk4u4Fmqk4MGQGCyqGSIb3DQEJEAIvMVUwUzBRME8wCwYJYIZIAWUDBAIDBEACrDhLC92Gcm2mclJwDuLADobFbVWY5HASuT8FL0/1nNexkoSVnVclwr0VkxJgmVAxa+g8ecGbwLzDs8vbT9AYMA0GCSqGSIb3DQEBDQUABIICABBtgwv5dZJhWu050wXM27HGZF6yFaU6AOPjjUIQccbly1nw/Sebg2xRenMv+jxAm8bAdW3eBPNrSa1iJKGLmgfYZuxIwt5AluzVuvTH2t1j08XSMmDQpilhN6Bx9dOS3aClNm89ZVygmdUz6N9HGmxZh1yis80SxD6jDjhnuK6R+xpmdmL6HIDzHa5mjOCbD1lXtr5tWWR+1K9Axv4qoLADlrUKmpCdbnfUBgVdbWJnJBcW6WoQXDpTD/JbV/m2s/yzK7FDt+IpERwVZGqiZF9WwzgX9AFJ352tFWWj+KhqfFN8UgfPKD5aCo6V5T+vMlkodiV+0XQBPKdcPBoo8PJtiCR5sFlJHbQ0qGwQq6P/06ApvrXOFKz434CkCGTbZLKVEHTs1SqgZuAg54bR6GbifOheVojOhWDFEMEXlnpD7PjCYscL9U83H92Iosr4rJhvYwSYbahmU7W1RlUP4cHy8nUYwvUO54ehYMcKcZ4idG4nbUfVYy8lClYruKG0rVcwWu3TZxeSaLePYRZwaeXJ00p36SttyZTLeN4rZatePQc/ff856jvKqDlDZlXIyhOcYCXot5xHFlv+zKZhB71uOv/XvqqmZFhentmkZFYK+qi2tH+Tahar2f3b4RJo+bm235g/v1rIvKQKe8rjkemgPIG7RzkCnss2SGIpfW5h\",\"NumberOfElements\":4,\"FileName\":\"0_LogbookOperation_20170302_142234.zip\",\"Size\":41807}}";
    private static final String TRACEABILITY_LOGBOOK_OPERATION = "{\"evId\": \"aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq\",\"evType\": \"CHECK_TRACEABILITY_OPERATION\",\"evDateTime\": \"2016-06-10T11:56:35.914\",\"evIdProc\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"evTypeProc\": \"TRACEABILITY\",\"outcome\": \"STARTED\",\"outDetail\": null,\"outMessg\": \"SIP entry : SIP.zip\",\"agId\": \"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"storage\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\",\"agIdApp\": null,\"evIdAppSession\": null,\"evIdReq\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"agIdExt\": null,\"obId\": null,\"obIdReq\": null,\"obIdIn\": null,\"events\": [{\"evTypeProc\": \"TRACEABILITY\",\"evDetData\": {\"LogType\":\"OPERATION\",\"StartDate\":\"2017-04-06T22:50:59.657\",\"EndDate\":\"2017-04-06T23:01:03.121\",\"Hash\":\"HASH_TEST\",\"TimeStampToken\":\"TimeStamp_TEST\",\"NumberOfElements\":4,\"FileName\":\"0_LogbookOperation_20170406_230103.zip\",\"Size\":4141}}]}";
    public static final String SECURITY_PROFILES = "{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetcaaaabbbcc\",\"Identifier\": \"SEC_PROFILE-000001\",\"Name\": \"TEST_PROFILE_1\",\"FullAccess\": false,\"Permissions\": [\"permission_one:read\",\"permission_one:id:write\"]}";

    private ClientMockResultHelper() {
    }

    public static List<LogbookOperation> getLogbookOperations() {
        ArrayList<LogbookOperation> logbookOperations = new ArrayList<LogbookOperation>();
        for (int i = 0; i < 100; ++i) {
            logbookOperations.add(ClientMockResultHelper.getLogbookOperationItem());
        }
        return logbookOperations;
    }

    private static LogbookLifecycle getLogbookLifecycleItem() {
        LogbookLifecycle logbookLifecycle = new LogbookLifecycle();
        logbookLifecycle.setId("aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq");
        logbookLifecycle.setEvId("aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq");
        logbookLifecycle.setEvType("LFC.LFC_CREATION");
        logbookLifecycle.setEvDateTime("2016-06-10T11:56:35.914");
        logbookLifecycle.setEvIdProc("aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq");
        logbookLifecycle.setEvTypeProc("INGEST");
        logbookLifecycle.setOutcome("OK");
        logbookLifecycle.setOutDetail(null);
        logbookLifecycle.setOutMessg("Cr\u00e9ation du journal du cycle de vie");
        logbookLifecycle.setAgId("\"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"ingest-external\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\"");
        return logbookLifecycle;
    }

    private static LogbookOperation getLogbookOperationItem() {
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setId("aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq");
        logbookOperation.setEvId("aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq");
        logbookOperation.setEvType("Process_SIP_unitary");
        logbookOperation.setEvDateTime("2016-06-10T11:56:35.914");
        logbookOperation.setEvIdProc("aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq");
        logbookOperation.setEvTypeProc("INGEST");
        LogbookEventOperation startEvent = new LogbookEventOperation();
        startEvent.setEvType("TNR_PERFORMANCE.STARTED");
        startEvent.setEvDateTime("2016-06-10T11:56:35.914");
        LogbookEventOperation endEvent = new LogbookEventOperation();
        endEvent.setEvType("TNR_PERFORMANCE.COMPLETED");
        endEvent.setEvDateTime("2016-06-10T11:58:35.914");
        logbookOperation.setEvents(Arrays.asList(startEvent, endEvent));
        logbookOperation.setOutcome("STARTED");
        logbookOperation.setOutDetail(null);
        logbookOperation.setOutMessg("\"SIP entry : SIP.zip");
        logbookOperation.setAgId("\"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"ingest-external\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\"");
        logbookOperation.setAgIdApp(null);
        logbookOperation.setEvIdAppSession(null);
        logbookOperation.setEvIdReq("aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq");
        return logbookOperation;
    }

    private static FileFormatModel getFormatItem() {
        FileFormatModel fileFormatModel = new FileFormatModel();
        fileFormatModel.setId("aeaaaaaaaahwaqr6aabrqak6k3jcp2yaaaka");
        fileFormatModel.setCreatedDate("2016-09-27T15:37:53");
        fileFormatModel.setVersionPronom("88");
        fileFormatModel.setMimeType("application/postscript");
        fileFormatModel.setPuid("x-fmt/20");
        fileFormatModel.setVersionPronom("1.0 / 1.1");
        fileFormatModel.setName("Adobe Illustrator");
        fileFormatModel.setExtensions((List)new ArrayList<String>(){
            {
                this.add("ai");
            }
        });
        fileFormatModel.setHasPriorityOverFileFormatIDs((List)new ArrayList<String>(){
            {
                this.add("fmt/122");
                this.add("fmt/123");
                this.add("fmt/124");
            }
        });
        fileFormatModel.setVersion("0");
        fileFormatModel.setAlert(Boolean.valueOf(false));
        return fileFormatModel;
    }

    private static FileRulesModel getRuleItem() {
        FileRulesModel rule = new FileRulesModel();
        rule.setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq");
        rule.setTenant(Integer.valueOf(0));
        rule.setRuleId("APP-00005");
        rule.setRuleType(RuleType.AppraisalRule);
        rule.setRuleValue("Pi\u00e8ces comptables (comptable)");
        rule.setRuleDescription("Dur\u00e9e de conservation des pi\u00e8ces comptables pour le comptable l\u2019\u00e9ch\u00e9ance est calcul\u00e9e \u00e0 partir de la date de solde comptable");
        rule.setRuleDuration("6");
        rule.setRuleMeasurement(RuleMeasurementEnum.YEAR);
        rule.setCreationDate("2016-11-02");
        rule.setUpdateDate("2016-11-03");
        return rule;
    }

    private static IngestContractModel getIngestContractItem() {
        IngestContractModel contract = new IngestContractModel();
        contract.setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq");
        contract.setTenant(Integer.valueOf(0));
        contract.setIdentifier("FAKE_IDENTIFIER");
        contract.setName("Un contrat");
        contract.setDescription("DESCRIPTION D'UN CONTRAT");
        contract.setStatus(ActivationStatus.ACTIVE);
        contract.setCreationdate("2016-11-02");
        contract.setLastupdate("2016-11-05");
        contract.setActivationdate("2016-11-04");
        contract.setDeactivationdate("2016-11-03");
        return contract;
    }

    private static AgenciesModel getAgenciesModel() {
        AgenciesModel model = new AgenciesModel();
        model.setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq");
        model.setTenant(Integer.valueOf(0));
        model.setIdentifier("FAKE_IDENTIFIER");
        model.setName("Une agency");
        model.setDescription("DESCRIPTION D'UNE AGENCE");
        return model;
    }

    private static AccessContractModel getAccessContractItem() {
        AccessContractModel contract = new AccessContractModel();
        contract.setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq");
        contract.setTenant(Integer.valueOf(0));
        contract.setIdentifier("FAKE_IDENTIFIER");
        contract.setName("Un contrat");
        contract.setDescription("DESCRIPTION D'UN CONTRAT");
        contract.setStatus(ActivationStatus.ACTIVE);
        contract.setCreationdate("2016-11-02");
        contract.setLastupdate("2016-11-05");
        contract.setActivationdate("2016-11-04");
        contract.setDeactivationdate("2016-11-03");
        contract.setDataObjectVersion((Set)new HashSet<String>(){
            {
                this.add("PhysicalMaster");
                this.add("BinaryMaster");
            }
        });
        contract.setWritingPermission(Boolean.valueOf(true));
        contract.setOriginatingAgencies((Set)new HashSet<String>(){
            {
                this.add("FR_ORG_AGEC");
                this.add("OriginatingAgency");
            }
        });
        contract.setEveryDataObjectVersion(Boolean.valueOf(false));
        contract.setEveryOriginatingAgency(Boolean.valueOf(false));
        return contract;
    }

    private static ManagementContractModel getManagementContractItem() {
        ManagementContractModel contract = new ManagementContractModel();
        contract.setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq");
        contract.setTenant(Integer.valueOf(0));
        contract.setIdentifier("FAKE_IDENTIFIER");
        contract.setName("Un contrat");
        contract.setDescription("DESCRIPTION D'UN CONTRAT");
        contract.setStatus(ActivationStatus.ACTIVE);
        contract.setCreationdate("2016-11-02");
        contract.setLastupdate("2016-11-05");
        contract.setActivationdate("2016-11-04");
        contract.setDeactivationdate("2016-11-03");
        contract.setStorage(new StorageDetailModel().setUnitStrategy("default").setObjectGroupStrategy("default").setObjectStrategy("default"));
        return contract;
    }

    private static ContextModel getContextItem() {
        final PermissionModel permission = new PermissionModel();
        permission.setTenant(Integer.valueOf(0));
        ContextModel context = new ContextModel();
        context.setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq");
        context.setIdentifier("FAKE_IDENTIFIER");
        context.setName("My_Context_1");
        context.setDeactivationdate("DESCRIPTION D'UN CONEXTE");
        context.setStatus(ContextStatus.ACTIVE);
        context.setCreationdate("2016-11-02");
        context.setLastupdate("2016-11-05");
        context.setActivationdate("2016-11-04");
        context.setDeactivationdate("2016-11-03");
        context.setPermissions((List)new ArrayList<PermissionModel>(){
            {
                this.add(permission);
            }
        });
        return context;
    }

    private static ProfileModel getProfileItem() {
        ProfileModel profile = new ProfileModel();
        profile.setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq");
        profile.setTenant(Integer.valueOf(0));
        profile.setIdentifier("FAKE_IDENTIFIER");
        profile.setName("Un Profile");
        profile.setDeactivationdate("DESCRIPTION D'UN PROFILE");
        profile.setStatus(ProfileStatus.ACTIVE);
        profile.setFormat(ProfileFormat.XSD);
        profile.setCreationdate("2016-11-02");
        profile.setLastupdate("2016-11-05");
        profile.setActivationdate("2016-11-04");
        profile.setDeactivationdate("2016-11-03");
        return profile;
    }

    private static ArchiveUnitProfileModel getArchiveUnitItem() {
        ArchiveUnitProfileModel profile = new ArchiveUnitProfileModel();
        profile.setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq");
        profile.setTenant(Integer.valueOf(0));
        profile.setIdentifier("FAKE_IDENTIFIER");
        profile.setName("Archive Unit Name");
        profile.setDeactivationdate("Description compl\u00e8te d'un Document Type");
        profile.setStatus(ArchiveUnitProfileStatus.ACTIVE);
        profile.setCreationdate("2016-11-02");
        profile.setLastupdate("2016-11-05");
        profile.setActivationdate("2016-11-04");
        profile.setDeactivationdate("2016-11-03");
        return profile;
    }

    private static OntologyModel getOntologyItem() {
        OntologyModel ontology = new OntologyModel();
        ontology.setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq");
        ontology.setTenant(Integer.valueOf(1));
        ontology.setIdentifier("_sps");
        ontology.setApiField("#originating_agencies");
        ontology.setSedaField("OriginatingAgencyIdentifier");
        ontology.setDescription("Internal ontology sample");
        ontology.setOrigin(OntologyOrigin.INTERNAL);
        ontology.setType(OntologyType.KEYWORD);
        ontology.setShortName("Originating Agency Identifier");
        ontology.setCollections((List)new ArrayList<String>(){
            {
                this.add("Unit");
                this.add("ObjectGroup");
            }
        });
        ontology.setVersion(Integer.valueOf(0));
        ontology.setCreationdate("2017-04-09");
        ontology.setLastupdate("2017-04-09");
        return ontology;
    }

    private static AccessionRegisterSummaryModel getAccessionRegisterSummaryItem() {
        AccessionRegisterSummaryModel accessionRegister = new AccessionRegisterSummaryModel();
        accessionRegister.setId("aedqaaaaacaam7mxabsakakygeje2uyaaaaq");
        accessionRegister.setTenant(Integer.valueOf(0));
        accessionRegister.setOriginatingAgency("FRAN_NP_005568");
        accessionRegister.setCreationDate("22016-11-04T20:40:49.030");
        accessionRegister.setTotalObjectsGroups(new RegisterValueDetailModel().setIngested(3L).setDeleted(0L).setRemained(3L));
        accessionRegister.setTotalUnits(new RegisterValueDetailModel().setIngested(3L).setDeleted(0L).setRemained(3L));
        accessionRegister.setTotalObjects(new RegisterValueDetailModel().setIngested(12L).setDeleted(0L).setRemained(12L));
        accessionRegister.setObjectSize(new RegisterValueDetailModel().setIngested(1035126L).setDeleted(0L).setRemained(1035126L));
        return accessionRegister;
    }

    private static ObjectNode getUnitSimpleItem() {
        ObjectNode node = JsonHandler.createObjectNode();
        node.put("#id", "aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq");
        node.put("Title", "Archive 1");
        node.put("DescriptionLevel", "Archive Mock");
        return node;
    }

    private static ObjectNode getGotSimpleItem() {
        ObjectNode got = JsonHandler.createObjectNode();
        ArrayNode versions = JsonHandler.createArrayNode();
        ObjectNode binaryMaster1 = JsonHandler.createObjectNode();
        binaryMaster1.put("#id", "aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq");
        binaryMaster1.put("DataObjectVersion", "BinaryMaster_1");
        binaryMaster1.put("Size", "6");
        binaryMaster1.put("LastModified", "2017-04-04T08:07:06.487+02:00");
        binaryMaster1.put("FormatLitteral", "Plain Text File");
        binaryMaster1.put("FileName", "Stalingrad.txt");
        binaryMaster1.put("LastModified", "2017-04-04T08:07:06.487+02:00");
        binaryMaster1.put("LastModified", "2017-04-04T08:07:06.487+02:00");
        binaryMaster1.put("LastModified", "2017-04-04T08:07:06.487+02:00");
        ObjectNode metadatas = JsonHandler.createObjectNode();
        metadatas.put("_id", "aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq");
        metadatas.put("DataObjectGroupId", "aebaaaaaaagc44lgabqraak63u6iq2aaaabq");
        metadatas.put("DataObjectVersion", "BinaryMaster_1");
        metadatas.put("Uri", "Content/ID55.txt");
        metadatas.put("MessageDigest", "86c0bc701ef6b5dd21b080bc5bb2af38097baa6237275da83a52f092c9eae3e4e4b0247391620bd732fe824d18bd3bb6c37e62ec73a8cf3585c6a799399861b1");
        metadatas.put("Algorithm", "SHA-512");
        ObjectNode formatIdentification = JsonHandler.createObjectNode();
        formatIdentification.put("FormatLitteral", "Plain Text File");
        formatIdentification.put("MimeType", "text/plain");
        formatIdentification.put("FormatId", "x-fmt/111");
        metadatas.set("FormatIdentification", (JsonNode)formatIdentification);
        ObjectNode fileInfo = JsonHandler.createObjectNode();
        fileInfo.put("Filename", "Stalingrad.txt");
        fileInfo.put("LastModified", "2017-04-04T08:07:06.487+02:00");
        metadatas.set("FileInfo", (JsonNode)fileInfo);
        binaryMaster1.set("metadatas", (JsonNode)metadatas);
        versions.add((JsonNode)binaryMaster1);
        got.put("nbObjects", 1);
        got.set("versions", (JsonNode)versions);
        return got;
    }

    @Deprecated
    public static JsonNode getLogbookResults() throws InvalidParseOperationException {
        StringBuilder result = new StringBuilder(RESULT).append("[");
        for (int i = 0; i < 100; ++i) {
            result.append("{\"_id\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaa").append(i).append("\",").append(LOGBOOK_OPERATION);
            if (i >= 99) continue;
            result.append(",");
        }
        result.append("]}");
        return JsonHandler.getFromString((String)result.toString());
    }

    @Deprecated
    public static RequestResponse getLogbooksRequestResponseJsonNode() throws InvalidParseOperationException {
        return RequestResponseOK.getFromJsonNode((JsonNode)ClientMockResultHelper.getLogbookResults());
    }

    public static RequestResponse<LogbookOperation> getLogbookOperationsRequestResponse() {
        return new RequestResponseOK().addAllResults(ClientMockResultHelper.getLogbookOperations()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<LogbookOperation> getLogbookOperationRequestResponse() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getLogbookOperationItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<LogbookLifecycle> getLogbookLifecycleRequestResponse() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getLogbookLifecycleItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static JsonNode getMetaDataResult() throws InvalidParseOperationException {
        return ClientMockResultHelper.getArchiveUnitResult().toJsonNode();
    }

    public static RequestResponse createReponse(Object s) {
        return new RequestResponseOK().addResult(s);
    }

    public static RequestResponse<JsonNode> createReponse(String s) throws InvalidParseOperationException {
        RequestResponseOK responseOK = new RequestResponseOK();
        if (null != s) {
            responseOK.addResult((Object)JsonHandler.getFromString((String)s));
        }
        return responseOK.setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse createReponse(String s, int statuscode) throws InvalidParseOperationException {
        RequestResponseOK responseOK = new RequestResponseOK();
        if (null != s) {
            responseOK.addResult((Object)JsonHandler.getFromString((String)s));
        }
        return responseOK.setHttpCode(statuscode);
    }

    public static RequestResponse<AccessionRegisterSummaryModel> getAccessionRegisterSummary() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getAccessionRegisterSummaryItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse getAccessionRegisterDetail() throws InvalidParseOperationException {
        return ClientMockResultHelper.createReponse(ACCESSION_DETAIL);
    }

    public static RequestResponse<FileFormatModel> getFormat() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getFormatItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<FileFormatModel> getFormat(int statusCode) {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getFormatItem()).setHttpCode(statusCode);
    }

    public static RequestResponse<FileRulesModel> getRule() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getRuleItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<FileRulesModel> getRule(int statusCode) {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getRuleItem()).setHttpCode(statusCode);
    }

    public static RequestResponse<IngestContractModel> getIngestContracts() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getIngestContractItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<AccessContractModel> getAccessContracts() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getAccessContractItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<ManagementContractModel> getManagementContracts() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getManagementContractItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<AgenciesModel> getAgencies() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getAgenciesModel()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<AgenciesModel> getAgencies(int statusCode) {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getAgenciesModel()).setHttpCode(statusCode);
    }

    public static RequestResponse<ContextModel> getContexts(int statusCode) {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getContextItem()).setHttpCode(statusCode);
    }

    public static RequestResponse<ProfileModel> getProfiles(int statusCode) {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getProfileItem()).setHttpCode(statusCode);
    }

    public static RequestResponse<OntologyModel> getOntologies(int statusCode) {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getOntologyItem()).setHttpCode(statusCode);
    }

    public static RequestResponse<FileFormatModel> getFormatList() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getFormatItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<FileRulesModel> getRuleList() {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getRuleItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse getEmptyResult() {
        return new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse getArchiveUnitResult() throws InvalidParseOperationException {
        return ClientMockResultHelper.createReponse(UNIT);
    }

    public static RequestResponse<JsonNode> getArchiveUnitSimpleResult(JsonNode query) {
        return new RequestResponseOK(query).addResult((Object)ClientMockResultHelper.getUnitSimpleItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<JsonNode> getOperationSimpleResult(String itemId) throws VitamClientException {
        try {
            ItemStatus itemStatus = new ItemStatus(itemId);
            itemStatus.setGlobalState(ProcessState.RUNNING);
            itemStatus.increment(StatusCode.STARTED);
            return new RequestResponseOK().addResult((Object)JsonHandler.toJsonNode((Object)itemStatus)).setHttpCode(Response.Status.OK.getStatusCode());
        }
        catch (InvalidParseOperationException e) {
            throw new VitamClientException((Throwable)e);
        }
    }

    public static RequestResponse<JsonNode> getGotSimpleResult(JsonNode query) {
        return new RequestResponseOK(query).addResult((Object)ClientMockResultHelper.getGotSimpleItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static Response getObjectStream() {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Content-Disposition", (Object)"filename=\"test.txt\"");
        return new AbstractMockClient.FakeInboundResponse(Response.Status.OK, new ByteArrayInputStream("test".getBytes()), MediaType.APPLICATION_OCTET_STREAM_TYPE, (MultivaluedHashMap<String, Object>)headers);
    }

    public static ItemStatus getItemStatus(String id) throws InvalidParseOperationException {
        return new ItemStatus(id);
    }

    public static RequestResponse<JsonNode> checkOperationTraceability() throws InvalidParseOperationException {
        return ClientMockResultHelper.createReponse(TRACEABILITY_OPERATION);
    }

    public static RequestResponse getSecurityProfiles() throws VitamClientException {
        try {
            return ClientMockResultHelper.createReponse(SECURITY_PROFILES);
        }
        catch (InvalidParseOperationException e) {
            throw new VitamClientException((Throwable)e);
        }
    }

    public static RequestResponse getSecurityProfiles(int statusCode) throws VitamClientException {
        try {
            return ClientMockResultHelper.createReponse(SECURITY_PROFILES, statusCode);
        }
        catch (InvalidParseOperationException e) {
            throw new VitamClientException((Throwable)e);
        }
    }

    public static RequestResponse<JsonNode> getDIPSimpleResult(JsonNode dslRequest) {
        return new RequestResponseOK(dslRequest).addResult((Object)ClientMockResultHelper.getUnitSimpleItem()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse<JsonNode> getEvidenceAudit(int statusCode) {
        return new RequestResponseOK().addResult((Object)JsonHandler.createObjectNode()).setHttpCode(statusCode);
    }

    public static RequestResponse<ProfileModel> getProbativeValue(int statusCode) {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getProfileItem()).setHttpCode(statusCode);
    }

    public static RequestResponse<ArchiveUnitProfileModel> getArchiveUnitProfiles(int statusCode) {
        return new RequestResponseOK().addResult((Object)ClientMockResultHelper.getArchiveUnitItem()).setHttpCode(statusCode);
    }
}

