/**
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */
package fr.gouv.vitamui.referential.external.client;

import fr.gouv.vitamui.commons.rest.client.BaseRestClientFactory;
import fr.gouv.vitamui.commons.rest.client.configuration.HttpPoolConfiguration;
import fr.gouv.vitamui.commons.rest.client.configuration.RestClientConfiguration;
import fr.gouv.vitamui.commons.rest.client.logbook.LogbookExternalRestClient;
import org.springframework.boot.web.client.RestTemplateBuilder;

/**
 * A Rest client factory to create specialized Referential Rest clients
 */
public class ReferentialExternalRestClientFactory extends BaseRestClientFactory {

    public ReferentialExternalRestClientFactory(
        final RestClientConfiguration restClientConfiguration,
        final RestTemplateBuilder restTemplateBuilder
    ) {
        super(restClientConfiguration, restTemplateBuilder);
    }

    public ReferentialExternalRestClientFactory(
        final RestClientConfiguration restClientConfiguration,
        final HttpPoolConfiguration httpHostConfiguration,
        final RestTemplateBuilder restTemplateBuilder
    ) {
        super(restClientConfiguration, httpHostConfiguration, restTemplateBuilder);
    }

    public LogbookExternalRestClient getLogbookExternalRestClient() {
        return new LogbookExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public AccessContractExternalRestClient getAccessContractExternalRestClient() {
        return new AccessContractExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public IngestContractExternalRestClient getIngestContractExternalRestClient() {
        return new IngestContractExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public AgencyExternalRestClient getAgencyExternalRestClient() {
        return new AgencyExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public FileFormatExternalRestClient getFileFormatExternalRestClient() {
        return new FileFormatExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public ArchivalProfileUnitExternalRestClient getArchivalProfileExternalRestClient() {
        return new ArchivalProfileUnitExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public ContextExternalRestClient getContextExternalRestClient() {
        return new ContextExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public SecurityProfileExternalRestClient getSecurityProfileExternalRestClient() {
        return new SecurityProfileExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public OntologyExternalRestClient getOntologyRestClient() {
        return new OntologyExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public OperationExternalRestClient getOperationExternalRestClient() {
        return new OperationExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public AccessionRegisterSummaryExternalRestClient getAccessionRegisterExternalRestClient() {
        return new AccessionRegisterSummaryExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public AccessionRegisterDetailExternalRestClient getAccessionRegisterDetailExternalRestClient() {
        return new AccessionRegisterDetailExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public UnitExternalRestClient getUnitExternalRestClient() {
        return new UnitExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public ManagementContractExternalRestClient getManagementContractRestClient() {
        return new ManagementContractExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public ProfileExternalRestClient getProfileExternalRestClient() {
        return new ProfileExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public RuleExternalRestClient getRuleExternalRestClient() {
        return new RuleExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public LogbookManagementOperationExternalRestClient getLogbookManagementOperationExternalRestClient() {
        return new LogbookManagementOperationExternalRestClient(getRestTemplate(), getBaseUrl());
    }

    public SchemaClient getSchemaClient() {
        return new SchemaClient(getRestTemplate(), getBaseUrl());
    }
}
