(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["pastis-pastis-module"],{

/***/ "+eeL":
/*!*********************************************************************!*\
  !*** ./src/app/user-actions/save-profile/save-profile.component.ts ***!
  \*********************************************************************/
/*! exports provided: UserActionSaveProfileComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UserActionSaveProfileComponent", function() { return UserActionSaveProfileComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "EM62");
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/material/dialog */ "OZ4H");
/* harmony import */ var _angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material/snack-bar */ "W1gw");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ "sEIs");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ngx-translate/core */ "s2Ay");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ "+kfY");
/* harmony import */ var ui_frontend_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ui-frontend-common */ "OWX3");
/* harmony import */ var _ingest_src_app_shared_vitamui_snack_bar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../../ingest/src/app/shared/vitamui-snack-bar */ "i+Hv");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../environments/environment */ "AytR");
/* harmony import */ var _core_services_file_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/services/file.service */ "sINK");
/* harmony import */ var _core_services_notice_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/services/notice.service */ "djED");
/* harmony import */ var _core_services_notification_service__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/services/notification.service */ "Y4+Y");
/* harmony import */ var _core_services_popup_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/services/popup.service */ "HxGl");
/* harmony import */ var _core_services_profile_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../core/services/profile.service */ "FFoR");
/* harmony import */ var _core_services_toggle_sidenav_service__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../core/services/toggle-sidenav.service */ "OUc9");
/* harmony import */ var _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../models/profile-type.enum */ "tS00");
/* harmony import */ var _shared_data_generique_popup_service__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../shared/data-generique-popup.service */ "s95C");
/* harmony import */ var _create_notice_create_notice_component__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../create-notice/create-notice.component */ "EKv3");
/* harmony import */ var _save_profile_options_save_profile_options_component__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../save-profile-options/save-profile-options.component */ "r+Ga");
/* harmony import */ var _select_notice_select_notice_component__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../select-notice/select-notice.component */ "aCGB");
/*
Copyright © CINES - Centre Informatique National pour l'Enseignement Supérieur (2020)

[dad@cines.fr]

This software is a computer program whose purpose is to provide
a web application to create, edit, import and export archive
profiles based on the french SEDA standard
(https://redirect.francearchives.fr/seda/).


This software is governed by the CeCILL-C  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL-C
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C license and that you accept its terms.
*/

































const POPUP_SAVE_PATH = 'PROFILE.POP_UP_SAVE';
function constantToTranslate(edit) {
    if (edit) {
        this.popupSaveCreateNoticeTitleDialog = this.translated('.SAVE_PROFILE.POPUP_CREATE_NOTICE_TITLE_DIALOG_EDIT');
        this.popupSaveCreateNoticeSubTitleDialog = this.translated('.SAVE_PROFILE.POPUP_CREATE_NOTICE_SUBTITLE_DIALOG_EDIT');
    }
    else {
        this.popupSaveCreateNoticeTitleDialog = this.translated('.SAVE_PROFILE.POPUP_CREATE_NOTICE_TITLE_DIALOG');
        this.popupSaveCreateNoticeSubTitleDialog = this.translated('.SAVE_PROFILE.POPUP_CREATE_NOTICE_SUBTITLE_DIALOG');
    }
    this.popupSaveCancelLabel = this.translated('.SAVE_PROFILE.POPUP_SAVE_CANCEL_LABEL');
    this.popupSaveTitleDialog = this.translated('.SAVE_PROFILE.POPUP_SAVE_TITLE_DIALOG');
    this.popupSaveSubTitleDialog = this.translated('.SAVE_PROFILE.POPUP_SAVE_SUBTITLE_DIALOG');
    this.popupSaveOkLabel = this.translated('.SAVE_PROFILE.POPUP_SAVE_OK_LABEL');
    this.popupSaveCreateNoticeCancelLabel = this.translated('.SAVE_PROFILE.POPUP_CREATE_NOTICE_CANCEL_LABEL');
    this.popupSaveCreateNoticeOkLabel = this.translated('.SAVE_PROFILE.POPUP_CREATE_NOTICE_OK_LABEL');
    this.popupSaveSelectNoticeTitleDialog = this.translated('.SAVE_PROFILE.POPUP_SELECT_NOTICE_TITLE_DIALOG');
}
class UserActionSaveProfileComponent {
    constructor(profileService, popupService, fileService, startupService, snackBar, dataGeneriquePopupService, noticeService, translateService, dialog, router, notificationService, toggleService) {
        this.profileService = profileService;
        this.popupService = popupService;
        this.fileService = fileService;
        this.startupService = startupService;
        this.snackBar = snackBar;
        this.dataGeneriquePopupService = dataGeneriquePopupService;
        this.noticeService = noticeService;
        this.translateService = translateService;
        this.dialog = dialog;
        this.router = router;
        this.notificationService = notificationService;
        this.toggleService = toggleService;
        this.isStandalone = _environments_environment__WEBPACK_IMPORTED_MODULE_8__["environment"].standalone;
        this.data = [];
        this.subscriptions = new rxjs__WEBPACK_IMPORTED_MODULE_5__["Subscription"]();
        // tslint:disable-next-line:no-output-native
        this.close = new _angular_core__WEBPACK_IMPORTED_MODULE_0__["EventEmitter"]();
        this.blobToFile = (theBlob, fileName) => {
            const b = theBlob;
            b.lastModifiedDate = new Date();
            b.name = fileName;
            // Cast to a File() type
            return theBlob;
        };
        this.editProfile = this.router.url.substring(this.router.url.lastIndexOf('/') - 4, this.router.url.lastIndexOf('/')) === 'edit';
    }
    ngOnInit() {
        if (!this.isStandalone) {
            constantToTranslate.call(this, this.editProfile);
            this.translatedOnChange();
        }
        else if (this.isStandalone) {
            this.popupSaveCancelLabel = 'ANNULER';
            this.popupSaveTitleDialog = 'Sélectionner les options de votre enregistrement';
            this.popupSaveSubTitleDialog = 'Enregistrement';
            this.popupSaveOkLabel = 'VALIDER';
            this.popupSaveCreateNoticeCancelLabel = 'PRECEDENT';
            this.popupSaveCreateNoticeTitleDialog = 'Rédiger la notice de profil';
            this.popupSaveCreateNoticeSubTitleDialog = 'Enregistrement';
            this.popupSaveCreateNoticeOkLabel = 'TERMINER';
        }
        this.subscriptions.add(this.dataGeneriquePopupService.currentDonnee.subscribe((donnees) => (this.donnees = donnees)));
        this.isSlaveMode = this.popupService.externalIdentifierEnabled;
    }
    translatedOnChange() {
        this.subscriptions.add(this.translateService.onLangChange.subscribe((_) => {
            constantToTranslate.call(this);
        }));
    }
    translated(nameOfFieldToTranslate) {
        return this.translateService.instant(POPUP_SAVE_PATH + nameOfFieldToTranslate);
    }
    saveProfileToFile() {
        // Retrieve the current file tree data as a JSON
        this.data = this.fileService.allData.getValue();
        if (this.isStandalone) {
            this.downloadProfiles(true);
            return;
        }
        const donnees = ['Local', 'SAE', "Où souhaitez-vous l'enregistrer ?"];
        this.dataGeneriquePopupService.changeDonnees(donnees);
        const pastisDialogData = {};
        pastisDialogData.titleDialog = this.popupSaveTitleDialog;
        pastisDialogData.subTitleDialog = this.popupSaveSubTitleDialog;
        pastisDialogData.width = '800px';
        pastisDialogData.height = '800px';
        pastisDialogData.okLabel = this.popupSaveOkLabel;
        pastisDialogData.cancelLabel = this.popupSaveCancelLabel;
        const dialogRef = this.dialog.open(_save_profile_options_save_profile_options_component__WEBPACK_IMPORTED_MODULE_18__["SaveProfileOptionsComponent"], {
            width: '800px',
            panelClass: 'pastis-popup-modal-box',
            data: pastisDialogData,
        });
        this.subscriptions.add(dialogRef.afterClosed().subscribe((result) => {
            if (!result.success) {
                return;
            }
            if (result.action === 'local') {
                this.downloadProfiles(true);
            }
            else if (result.action === 'creation') {
                const modeProfile = this.profileService.profileMode;
                const createNoticeData = {};
                createNoticeData.titleDialog = this.popupSaveCreateNoticeTitleDialog;
                createNoticeData.subTitleDialog = this.popupSaveCreateNoticeSubTitleDialog;
                createNoticeData.okLabel = this.popupSaveCreateNoticeOkLabel;
                createNoticeData.cancelLabel = this.popupSaveCreateNoticeCancelLabel;
                createNoticeData.profileMode = modeProfile;
                createNoticeData.isSlaveMode = this.isSlaveMode;
                this.dialog
                    .open(_create_notice_create_notice_component__WEBPACK_IMPORTED_MODULE_17__["CreateNoticeComponent"], {
                    width: '800px',
                    panelClass: 'pastis-popup-modal-box',
                    data: createNoticeData,
                })
                    .afterClosed()
                    .subscribe((createNoticeComponentResult) => {
                    this.toggleService.showPending();
                    let retour;
                    if (createNoticeComponentResult.success) {
                        retour = createNoticeComponentResult.data;
                        if (createNoticeComponentResult.mode === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_15__["ProfileType"].PUA) {
                            if (!this.editProfile) {
                                this.profileDescription = Object.assign(this.noticeService.profileFromNotice(retour, this.editProfile, true), this.profileDescription);
                            }
                            else {
                                this.subscriptions.add(this.fileService.notice.subscribe((value) => {
                                    this.profileDescription = value;
                                }));
                            }
                            this.subscriptions.add(this.profileService
                                .uploadFile(this.data, this.profileDescription, createNoticeComponentResult.mode)
                                .subscribe((retrievedData) => {
                                retrievedData.text().then((result) => {
                                    const jsonObject = JSON.parse(result);
                                    this.archivalProfileUnit = jsonObject;
                                    // Create ro update existing PUA
                                    if (!this.editProfile) {
                                        this.profileService.createArchivalUnitProfile(this.archivalProfileUnit).subscribe(() => {
                                            this.toggleService.hidePending();
                                            this.success(this.translateService.instant('PROFILE.LIST_PROFILE.PROFILE_PREVIEW.CREATION_SUCCESS'));
                                        });
                                    }
                                    else {
                                        this.profileService.updateProfilePua(this.archivalProfileUnit).subscribe(() => {
                                            this.toggleService.hidePending();
                                            this.success(this.translateService.instant('PROFILE.LIST_PROFILE.PROFILE_PREVIEW.MODIFICATION_SUCCESS'));
                                        }, (error) => {
                                            this.toggleService.hidePending();
                                            const vitamUIException = error.error;
                                            this.displaySnackBar(vitamUIException);
                                        });
                                    }
                                });
                            }));
                        }
                        else if (createNoticeComponentResult.mode === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_15__["ProfileType"].PA) {
                            const profile = this.noticeService.paNotice(retour, true);
                            if (!this.editProfile) {
                                // CREER NOTICE PUIS ASSIGNER LE PROFIL A LA NOTICE
                                this.profile = Object.assign(profile, this.profile);
                                this.profileDescription = Object.assign(this.noticeService.profileFromNotice(retour, this.editProfile, false), this.profileDescription);
                            }
                            else {
                                this.subscriptions.add(this.fileService.notice.subscribe((value) => {
                                    this.profile = Object.assign(profile, value);
                                    this.profileDescription = value;
                                }));
                            }
                            // STEP 1 : Create or update Notice
                            this.savePA();
                        }
                    }
                });
            }
            else if (result.action === 'rattachement') {
                // tslint:disable-next-line:no-shadowed-variable
                const dataToSendToPopUp = {};
                dataToSendToPopUp.titleDialog = this.popupSaveSelectNoticeTitleDialog;
                dataToSendToPopUp.subTitleDialog = this.popupSaveCreateNoticeSubTitleDialog;
                dataToSendToPopUp.okLabel = this.popupSaveCreateNoticeOkLabel;
                dataToSendToPopUp.cancelLabel = this.popupSaveCreateNoticeCancelLabel;
                dataToSendToPopUp.profileMode = this.profileService.profileMode;
                // tslint:disable-next-line:no-shadowed-variable
                const selectNoticeDialog = this.dialog.open(_select_notice_select_notice_component__WEBPACK_IMPORTED_MODULE_19__["SelectNoticeComponent"], {
                    width: '800px',
                    panelClass: 'pastis-popup-modal-box',
                    data: dataToSendToPopUp,
                });
                // tslint:disable-next-line:no-shadowed-variable
                this.subscriptions.add(selectNoticeDialog.afterClosed().subscribe((selectNoticeResult) => {
                    this.toggleService.showPending();
                    let profileDescription;
                    if (selectNoticeResult.success) {
                        profileDescription = selectNoticeResult.data;
                        if (selectNoticeResult.mode === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_15__["ProfileType"].PUA) {
                            this.subscriptions.add(this.profileService.uploadFile(this.data, profileDescription, selectNoticeResult.mode).subscribe((retrievedData) => {
                                // tslint:disable-next-line:no-shadowed-variable
                                retrievedData.text().then((result) => {
                                    const jsonObject = JSON.parse(result);
                                    this.archivalProfileUnit = jsonObject;
                                    //  update existing PUA
                                    this.subscriptions.add(this.profileService.updateProfilePua(this.archivalProfileUnit).subscribe(() => {
                                        this.toggleService.hidePending();
                                        this.success(this.translateService.instant('PROFILE.LIST_PROFILE.PROFILE_PREVIEW.MODIFICATION_SUCCESS'));
                                    }, (_) => {
                                        this.toggleService.hidePending();
                                    }));
                                });
                            }));
                        }
                        else if (selectNoticeResult.mode === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_15__["ProfileType"].PA) {
                            this.profileService.uploadFile(this.data, profileDescription, selectNoticeResult.mode).subscribe((retrievedData) => {
                                const myFile = this.blobToFile(retrievedData, 'file');
                                this.profileService
                                    .updateProfileFilePa(this.noticeService.paNotice(profileDescription, false), myFile)
                                    .subscribe(() => {
                                    this.toggleService.hidePending();
                                    this.success(this.translateService.instant('PROFILE.LIST_PROFILE.PROFILE_PREVIEW.MODIFICATION_SUCCESS'));
                                });
                            });
                        }
                    }
                }));
            }
        }));
    }
    displaySnackBar(vitamUIException) {
        if (!vitamUIException || !vitamUIException.args || vitamUIException.args.length < 1) {
            return;
        }
        this.snackBar.openFromComponent(_ingest_src_app_shared_vitamui_snack_bar__WEBPACK_IMPORTED_MODULE_7__["VitamUISnackBarComponent"], {
            panelClass: 'vitamui-snack-bar',
            data: {
                type: 'otherType',
                messageKey: 'SNACKBAR.ERROR_WITH_LOGBOOK_OPERATION_ID',
                buttonAction: () => this.goToOperation(vitamUIException.args[0]),
                buttonMessageKey: 'SNACKBAR.ERROR_WITH_LOGBOOK_OPERATION_ID_BUTTON',
            },
        });
    }
    goToOperation(operationId) {
        window.location.href =
            this.startupService.getReferentialUrl() +
                '/logbook-operation/tenant/' +
                this.startupService.getTenantIdentifier() +
                '?guid=' +
                operationId;
    }
    savePA() {
        if (!this.editProfile) {
            this.profileService.createProfilePa(this.profile).subscribe((createdProfile) => {
                if (createdProfile) {
                    // STEP 2 : ASSIGNER LE PROFIL A LA NOTICE
                    this.profileService.uploadFile(this.data, this.profileDescription, _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_15__["ProfileType"].PA).subscribe((retrievedData) => {
                        const myFile = this.blobToFile(retrievedData, 'file');
                        this.profileService.updateProfileFilePa(createdProfile, myFile).subscribe(() => {
                            this.toggleService.hidePending();
                            this.success(this.translateService.instant('PROFILE.LIST_PROFILE.PROFILE_PREVIEW.CREATION_SUCCESS'));
                        });
                    });
                }
            });
        }
        else {
            this.profileService.updateProfilePa(this.profile).subscribe(() => {
                // STEP 2 : ASSIGNER LE PROFIL A LA NOTICE
                this.profileService.uploadFile(this.data, this.profileDescription, this.profileService.profileMode).subscribe((retrievedData) => {
                    const myFile = this.blobToFile(retrievedData, 'file');
                    this.profileService.updateProfileFilePa(this.noticeService.paNotice(this.profileDescription, false), myFile).subscribe(() => {
                        this.toggleService.hidePending();
                        this.success(this.translateService.instant('PROFILE.LIST_PROFILE.PROFILE_PREVIEW.MODIFICATION_SUCCESS'));
                    });
                });
            });
        }
    }
    success(msg) {
        this.notificationService.showSuccess(msg);
        // sleep 3 sec before return pastishome
        setTimeout(() => {
            this.router.navigate(['pastis']);
        }, 3000);
    }
    downloadFile(dataFile, notice) {
        let typeFile;
        let download;
        if (notice) {
            typeFile = 'application/json';
            download = 'pastis.json';
        }
        else {
            typeFile = this.profileService.profileMode === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_15__["ProfileType"].PA ? 'application/xml' : 'application/json';
            download = this.profileService.profileMode === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_15__["ProfileType"].PA ? 'pastis_profile.rng' : 'pastis.json';
        }
        const newBlob = new Blob([dataFile], { type: typeFile });
        if (window.navigator && window.navigator.msSaveOrOpenBlob) {
            window.navigator.msSaveOrOpenBlob(newBlob);
            return;
        }
        const data = window.URL.createObjectURL(newBlob);
        const link = document.createElement('a');
        link.href = data;
        link.download = download;
        // this is necessary as link.click() does not work on the latest firefox
        link.dispatchEvent(new MouseEvent('click', { bubbles: true, cancelable: true, view: window }));
        setTimeout(() => {
            // For Firefox it is necessary to delay revoking the ObjectURL
            window.URL.revokeObjectURL(data);
            link.remove();
        }, 100);
    }
    downloadProfiles(local) {
        if (this.data) {
            // Get Notice changement
            let notice;
            if (this.profileService.profileMode === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_15__["ProfileType"].PUA) {
                this.fileService.notice.subscribe((value) => {
                    notice = value;
                });
            }
            if (local && this.profileService.profileMode === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_15__["ProfileType"].PA && this.editProfile) {
                this.subscriptions.add(this.fileService.notice.subscribe((value) => {
                    this.downloadFile(JSON.stringify(value), true);
                }));
            }
            // Send the retrieved JSON data to profile service
            this.subscriptions.add(this.profileService.uploadFile(this.data, notice, this.profileService.profileMode).subscribe((retrievedData) => {
                this.downloadFile(retrievedData, false);
            }));
        }
    }
    ngOnDestroy() {
        this.subscriptions.unsubscribe();
    }
}
UserActionSaveProfileComponent.ɵfac = function UserActionSaveProfileComponent_Factory(t) { return new (t || UserActionSaveProfileComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_core_services_profile_service__WEBPACK_IMPORTED_MODULE_13__["ProfileService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_core_services_popup_service__WEBPACK_IMPORTED_MODULE_12__["PopupService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_core_services_file_service__WEBPACK_IMPORTED_MODULE_9__["FileService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](ui_frontend_common__WEBPACK_IMPORTED_MODULE_6__["StartupService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_2__["MatSnackBar"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_shared_data_generique_popup_service__WEBPACK_IMPORTED_MODULE_16__["DataGeneriquePopupService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_core_services_notice_service__WEBPACK_IMPORTED_MODULE_10__["NoticeService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__["TranslateService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialog"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_3__["Router"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_core_services_notification_service__WEBPACK_IMPORTED_MODULE_11__["NotificationService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_core_services_toggle_sidenav_service__WEBPACK_IMPORTED_MODULE_14__["ToggleSidenavService"])); };
UserActionSaveProfileComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: UserActionSaveProfileComponent, selectors: [["pastis-user-action-save-profile"]], outputs: { close: "close" }, decls: 3, vars: 0, consts: [["type", "submit", 1, "btn", "btn-circle", "primary", "large", 3, "click"], [1, "material-icons"]], template: function UserActionSaveProfileComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function UserActionSaveProfileComponent_Template_button_click_0_listener() { return ctx.saveProfileToFile(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "i", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "save");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } }, styles: ["@charset \"UTF-8\";\n\n\n\n\n\n\n\n.mat-select-trigger[_ngcontent-%COMP%] {\n  \n}\n.dropdown-font-text[_ngcontent-%COMP%], .pastis-dropdown-text[_ngcontent-%COMP%] {\n  padding-top: 4px;\n  height: 20px;\n  max-height: 51px;\n  \n  font-family: Roboto;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  \n}\n\n.dropdown[_ngcontent-%COMP%], .pastis-dropdown-border[_ngcontent-%COMP%], .pastis-dropdown-background[_ngcontent-%COMP%] {\n  border-radius: 50px;\n  height: 49px;\n  background: #ffffff;\n  max-height: 40px;\n}\n\n.pastis-table-input-border[_ngcontent-%COMP%] {\n  border-radius: 5px;\n  border: 1px solid #e0e0e0;\n  box-sizing: border-box;\n  box-shadow: 0px 0px 2px rgba(33, 33, 33, 0.2), 0px 1px 4px rgba(33, 33, 33, 0.05);\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n\n.pastis-primary-50[_ngcontent-%COMP%] {\n  color: #f7ebfa;\n}\n.pastis-primary-100[_ngcontent-%COMP%] {\n  color: #e6c3ef;\n}\n.pastis-primary-300[_ngcontent-%COMP%] {\n  color: #c672d9;\n}\n.pastis-primary-400[_ngcontent-%COMP%] {\n  color: #b54ace;\n}\n.pastis-primary-500[_ngcontent-%COMP%] {\n  color: #9c31b5;\n}\n.pastis-primary-700[_ngcontent-%COMP%] {\n  color: #571b64;\n}\n.pastis-secondary-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n}\n.pastis-secondary-50[_ngcontent-%COMP%] {\n  color: #eaf2fa;\n}\n.pastis-secondary-200[_ngcontent-%COMP%] {\n  color: #96bde8;\n}\n.pastis-secondary-300[_ngcontent-%COMP%] {\n  color: #6da2df;\n}\n.pastis-secondary-400[_ngcontent-%COMP%] {\n  color: #4388d6;\n}\n.pastis-secondary-500[_ngcontent-%COMP%] {\n  color: #2563a9;\n}\n.pastis-surface-tabs[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-surface-snackbar[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-black-low[_ngcontent-%COMP%], .pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  color: #c1c1c1;\n}\n.pastis-black-disabled[_ngcontent-%COMP%] {\n  color: #e7e5e5;\n}\n.pastis-black-medium[_ngcontent-%COMP%], .pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  color: #747272;\n}\n.pastis-black-height[_ngcontent-%COMP%] {\n  color: #232323;\n}\n.pastis-black-standard[_ngcontent-%COMP%] {\n  color: #474747;\n}\n.pastis-grey-900[_ngcontent-%COMP%], .pastis-font-h5[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-grey-600[_ngcontent-%COMP%] {\n  color: #757575;\n}\n.pastis-grey-400[_ngcontent-%COMP%] {\n  color: #bdbdbd;\n}\n.pastis-ligthly-purple[_ngcontent-%COMP%] {\n  color: #f6f3fb;\n}\n.pastis-white-highlight[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-white-disabled[_ngcontent-%COMP%] {\n  color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-bg-primary-50[_ngcontent-%COMP%] {\n  background: #f7ebfa;\n}\n.pastis-bg-primary-100[_ngcontent-%COMP%] {\n  background: #e6c3ef;\n}\n.pastis-bg-primary-300[_ngcontent-%COMP%] {\n  background: #c672d9;\n}\n.pastis-bg-primary-400[_ngcontent-%COMP%] {\n  background: #b54ace;\n}\n.pastis-bg-primary-500[_ngcontent-%COMP%] {\n  background: #9c31b5;\n}\n.pastis-bg-primary-700[_ngcontent-%COMP%] {\n  background: #571b64;\n}\n.pastis-bg-secondary-disabled[_ngcontent-%COMP%] {\n  background: #bdd9ec;\n}\n.pastis-bg-secondary-50[_ngcontent-%COMP%] {\n  background: #eaf2fa;\n}\n.pastis-bg-secondary-200[_ngcontent-%COMP%] {\n  background: #96bde8;\n}\n.pastis-bg-secondary-300[_ngcontent-%COMP%] {\n  background: #6da2df;\n}\n.pastis-bg-secondary-400[_ngcontent-%COMP%] {\n  background: #4388d6;\n}\n.pastis-bg-secondary-500[_ngcontent-%COMP%] {\n  background: #2563a9;\n}\n.pastis-bg-surface-tabs[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-surface-snackbar[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-black-low[_ngcontent-%COMP%] {\n  background: #c1c1c1;\n}\n.pastis-bg-black-disabled[_ngcontent-%COMP%] {\n  background: #e7e5e5;\n}\n.pastis-bg-black-medium[_ngcontent-%COMP%] {\n  background: #747272;\n}\n.pastis-bg-black-height[_ngcontent-%COMP%] {\n  background: #232323;\n}\n.pastis-bg-black-standard[_ngcontent-%COMP%] {\n  background: #474747;\n}\n.pastis-bg-grey-900[_ngcontent-%COMP%] {\n  background: #212121;\n}\n.pastis-bg-grey-600[_ngcontent-%COMP%] {\n  background: #757575;\n}\n.pastis-bg-grey-400[_ngcontent-%COMP%] {\n  background: #bdbdbd;\n}\n.pastis-bg-ligthly-purple[_ngcontent-%COMP%] {\n  background: #f6f3fb;\n}\n.pastis-bg-white-highlight[_ngcontent-%COMP%] {\n  background: #ffffff;\n}\n.pastis-bg-white-disabled[_ngcontent-%COMP%] {\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-bgcolor-primary-50[_ngcontent-%COMP%] {\n  background-color: #f7ebfa;\n}\n.pastis-bgcolor-primary-100[_ngcontent-%COMP%] {\n  background-color: #e6c3ef;\n}\n.pastis-bgcolor-primary-300[_ngcontent-%COMP%] {\n  background-color: #c672d9;\n}\n.pastis-bgcolor-primary-400[_ngcontent-%COMP%] {\n  background-color: #b54ace;\n}\n.pastis-bgcolor-primary-500[_ngcontent-%COMP%] {\n  background-color: #9c31b5;\n}\n.pastis-bgcolor-primary-700[_ngcontent-%COMP%] {\n  background-color: #571b64;\n}\n.pastis-bgcolor-secondary-disabled[_ngcontent-%COMP%] {\n  background-color: #bdd9ec;\n}\n.pastis-bgcolor-secondary-50[_ngcontent-%COMP%] {\n  background-color: #eaf2fa;\n}\n.pastis-bgcolor-secondary-200[_ngcontent-%COMP%] {\n  background-color: #96bde8;\n}\n.pastis-bgcolor-secondary-300[_ngcontent-%COMP%] {\n  background-color: #6da2df;\n}\n.pastis-bgcolor-secondary-400[_ngcontent-%COMP%] {\n  background-color: #4388d6;\n}\n.pastis-bgcolor-secondary-500[_ngcontent-%COMP%] {\n  background-color: #2563a9;\n}\n.pastis-bgcolor-surface-tabs[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-surface-snackbar[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-black-low[_ngcontent-%COMP%] {\n  background-color: #c1c1c1;\n}\n.pastis-bgcolor-black-disabled[_ngcontent-%COMP%] {\n  background-color: #e7e5e5;\n}\n.pastis-bgcolor-black-medium[_ngcontent-%COMP%] {\n  background-color: #747272;\n}\n.pastis-bgcolor-black-height[_ngcontent-%COMP%] {\n  background-color: #232323;\n}\n.pastis-bgcolor-black-standard[_ngcontent-%COMP%] {\n  background-color: #474747;\n}\n.pastis-bgcolor-grey-900[_ngcontent-%COMP%] {\n  background-color: #212121;\n}\n.pastis-bgcolor-grey-600[_ngcontent-%COMP%] {\n  background-color: #757575;\n}\n.pastis-bgcolor-grey-400[_ngcontent-%COMP%], .pastis-entete-1-separator[_ngcontent-%COMP%] {\n  background-color: #bdbdbd;\n}\n.pastis-bgcolor-ligthly-purple[_ngcontent-%COMP%] {\n  background-color: #f6f3fb;\n}\n.pastis-bgcolor-white-highlight[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n}\n.pastis-bgcolor-white-disabled[_ngcontent-%COMP%] {\n  background-color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-btn[_ngcontent-%COMP%], .pastis-btn-primary-enabled[_ngcontent-%COMP%], .pastis-btn-primary-disabled[_ngcontent-%COMP%], .pastis-btn-primary-hover[_ngcontent-%COMP%], .pastis-btn-primary-focus[_ngcontent-%COMP%], .pastis-btn-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-secondary-hover[_ngcontent-%COMP%], .pastis-btn-secondary-focus[_ngcontent-%COMP%], .pastis-btn-variant-enabled[_ngcontent-%COMP%], .pastis-btn-variant-disabled[_ngcontent-%COMP%], .pastis-btn-variant-hover[_ngcontent-%COMP%], .pastis-btn-variant-focus[_ngcontent-%COMP%], .pastis-btn-leading-enabled[_ngcontent-%COMP%], .pastis-btn-leading-disabled[_ngcontent-%COMP%], .pastis-btn-leading-hover[_ngcontent-%COMP%], .pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  border-radius: 100px !important;\n  border: 0px;\n  outline: none;\n}\n.pastis-btn-primary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary-50);\n}\n.pastis-btn-primary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-secondary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-secondary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-variant-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-variant-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #e7e5e5;\n}\n.pastis-btn-variant-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-variant-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-rounded[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%]:active, .pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 50px;\n  height: 50px;\n  outline-style: none;\n}\n.pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n}\n.pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: --vitamui-primary-200;\n}\n.pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  border: none;\n  background: --vitamui-primary-400;\n}\n.pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #bdd9ec;\n}\n.pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 30px;\n  height: 30px;\n  outline-style: none;\n}\n.pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-300);\n}\n.pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-dropdown-border-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid #bdd9ec;\n}\n.pastis-dropdown-border-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #5cbaa9;\n}\n.pastis-dropdown-background-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-text-button1-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button2-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-search-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-special-enabled[_ngcontent-%COMP%] {\n  color: #9d9d9d;\n}\n.pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  outline: none;\n  height: 50px;\n  box-sizing: border-box;\n  border-radius: 87px;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  border: 1px solid #65b2e4;\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  border: 1px solid #747272;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  border: 1px solid #ff0000;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  border: 1px solid #50d166;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n\n\n\n\n\n\n\n.mat-select-trigger[_ngcontent-%COMP%] {\n  \n}\n.dropdown-font-text[_ngcontent-%COMP%], .pastis-dropdown-text[_ngcontent-%COMP%] {\n  padding-top: 4px;\n  height: 20px;\n  max-height: 51px;\n  \n  font-family: Roboto;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  \n}\n\n.dropdown[_ngcontent-%COMP%], .pastis-dropdown-border[_ngcontent-%COMP%], .pastis-dropdown-background[_ngcontent-%COMP%] {\n  border-radius: 50px;\n  height: 49px;\n  background: #ffffff;\n  max-height: 40px;\n}\n\n.pastis-table-input-border[_ngcontent-%COMP%] {\n  border-radius: 5px;\n  border: 1px solid #e0e0e0;\n  box-sizing: border-box;\n  box-shadow: 0px 0px 2px rgba(33, 33, 33, 0.2), 0px 1px 4px rgba(33, 33, 33, 0.05);\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n\n.pastis-primary-50[_ngcontent-%COMP%] {\n  color: #f7ebfa;\n}\n.pastis-primary-100[_ngcontent-%COMP%] {\n  color: #e6c3ef;\n}\n.pastis-primary-300[_ngcontent-%COMP%] {\n  color: #c672d9;\n}\n.pastis-primary-400[_ngcontent-%COMP%] {\n  color: #b54ace;\n}\n.pastis-primary-500[_ngcontent-%COMP%] {\n  color: #9c31b5;\n}\n.pastis-primary-700[_ngcontent-%COMP%] {\n  color: #571b64;\n}\n.pastis-secondary-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n}\n.pastis-secondary-50[_ngcontent-%COMP%] {\n  color: #eaf2fa;\n}\n.pastis-secondary-200[_ngcontent-%COMP%] {\n  color: #96bde8;\n}\n.pastis-secondary-300[_ngcontent-%COMP%] {\n  color: #6da2df;\n}\n.pastis-secondary-400[_ngcontent-%COMP%] {\n  color: #4388d6;\n}\n.pastis-secondary-500[_ngcontent-%COMP%] {\n  color: #2563a9;\n}\n.pastis-surface-tabs[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-surface-snackbar[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-black-low[_ngcontent-%COMP%], .pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  color: #c1c1c1;\n}\n.pastis-black-disabled[_ngcontent-%COMP%] {\n  color: #e7e5e5;\n}\n.pastis-black-medium[_ngcontent-%COMP%], .pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  color: #747272;\n}\n.pastis-black-height[_ngcontent-%COMP%] {\n  color: #232323;\n}\n.pastis-black-standard[_ngcontent-%COMP%] {\n  color: #474747;\n}\n.pastis-grey-900[_ngcontent-%COMP%], .pastis-font-h5[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-grey-600[_ngcontent-%COMP%] {\n  color: #757575;\n}\n.pastis-grey-400[_ngcontent-%COMP%] {\n  color: #bdbdbd;\n}\n.pastis-ligthly-purple[_ngcontent-%COMP%] {\n  color: #f6f3fb;\n}\n.pastis-white-highlight[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-white-disabled[_ngcontent-%COMP%] {\n  color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-bg-primary-50[_ngcontent-%COMP%] {\n  background: #f7ebfa;\n}\n.pastis-bg-primary-100[_ngcontent-%COMP%] {\n  background: #e6c3ef;\n}\n.pastis-bg-primary-300[_ngcontent-%COMP%] {\n  background: #c672d9;\n}\n.pastis-bg-primary-400[_ngcontent-%COMP%] {\n  background: #b54ace;\n}\n.pastis-bg-primary-500[_ngcontent-%COMP%] {\n  background: #9c31b5;\n}\n.pastis-bg-primary-700[_ngcontent-%COMP%] {\n  background: #571b64;\n}\n.pastis-bg-secondary-disabled[_ngcontent-%COMP%] {\n  background: #bdd9ec;\n}\n.pastis-bg-secondary-50[_ngcontent-%COMP%] {\n  background: #eaf2fa;\n}\n.pastis-bg-secondary-200[_ngcontent-%COMP%] {\n  background: #96bde8;\n}\n.pastis-bg-secondary-300[_ngcontent-%COMP%] {\n  background: #6da2df;\n}\n.pastis-bg-secondary-400[_ngcontent-%COMP%] {\n  background: #4388d6;\n}\n.pastis-bg-secondary-500[_ngcontent-%COMP%] {\n  background: #2563a9;\n}\n.pastis-bg-surface-tabs[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-surface-snackbar[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-black-low[_ngcontent-%COMP%] {\n  background: #c1c1c1;\n}\n.pastis-bg-black-disabled[_ngcontent-%COMP%] {\n  background: #e7e5e5;\n}\n.pastis-bg-black-medium[_ngcontent-%COMP%] {\n  background: #747272;\n}\n.pastis-bg-black-height[_ngcontent-%COMP%] {\n  background: #232323;\n}\n.pastis-bg-black-standard[_ngcontent-%COMP%] {\n  background: #474747;\n}\n.pastis-bg-grey-900[_ngcontent-%COMP%] {\n  background: #212121;\n}\n.pastis-bg-grey-600[_ngcontent-%COMP%] {\n  background: #757575;\n}\n.pastis-bg-grey-400[_ngcontent-%COMP%] {\n  background: #bdbdbd;\n}\n.pastis-bg-ligthly-purple[_ngcontent-%COMP%] {\n  background: #f6f3fb;\n}\n.pastis-bg-white-highlight[_ngcontent-%COMP%] {\n  background: #ffffff;\n}\n.pastis-bg-white-disabled[_ngcontent-%COMP%] {\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-bgcolor-primary-50[_ngcontent-%COMP%] {\n  background-color: #f7ebfa;\n}\n.pastis-bgcolor-primary-100[_ngcontent-%COMP%] {\n  background-color: #e6c3ef;\n}\n.pastis-bgcolor-primary-300[_ngcontent-%COMP%] {\n  background-color: #c672d9;\n}\n.pastis-bgcolor-primary-400[_ngcontent-%COMP%] {\n  background-color: #b54ace;\n}\n.pastis-bgcolor-primary-500[_ngcontent-%COMP%] {\n  background-color: #9c31b5;\n}\n.pastis-bgcolor-primary-700[_ngcontent-%COMP%] {\n  background-color: #571b64;\n}\n.pastis-bgcolor-secondary-disabled[_ngcontent-%COMP%] {\n  background-color: #bdd9ec;\n}\n.pastis-bgcolor-secondary-50[_ngcontent-%COMP%] {\n  background-color: #eaf2fa;\n}\n.pastis-bgcolor-secondary-200[_ngcontent-%COMP%] {\n  background-color: #96bde8;\n}\n.pastis-bgcolor-secondary-300[_ngcontent-%COMP%] {\n  background-color: #6da2df;\n}\n.pastis-bgcolor-secondary-400[_ngcontent-%COMP%] {\n  background-color: #4388d6;\n}\n.pastis-bgcolor-secondary-500[_ngcontent-%COMP%] {\n  background-color: #2563a9;\n}\n.pastis-bgcolor-surface-tabs[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-surface-snackbar[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-black-low[_ngcontent-%COMP%] {\n  background-color: #c1c1c1;\n}\n.pastis-bgcolor-black-disabled[_ngcontent-%COMP%] {\n  background-color: #e7e5e5;\n}\n.pastis-bgcolor-black-medium[_ngcontent-%COMP%] {\n  background-color: #747272;\n}\n.pastis-bgcolor-black-height[_ngcontent-%COMP%] {\n  background-color: #232323;\n}\n.pastis-bgcolor-black-standard[_ngcontent-%COMP%] {\n  background-color: #474747;\n}\n.pastis-bgcolor-grey-900[_ngcontent-%COMP%] {\n  background-color: #212121;\n}\n.pastis-bgcolor-grey-600[_ngcontent-%COMP%] {\n  background-color: #757575;\n}\n.pastis-bgcolor-grey-400[_ngcontent-%COMP%], .pastis-entete-1-separator[_ngcontent-%COMP%] {\n  background-color: #bdbdbd;\n}\n.pastis-bgcolor-ligthly-purple[_ngcontent-%COMP%] {\n  background-color: #f6f3fb;\n}\n.pastis-bgcolor-white-highlight[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n}\n.pastis-bgcolor-white-disabled[_ngcontent-%COMP%] {\n  background-color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-btn[_ngcontent-%COMP%], .pastis-btn-primary-enabled[_ngcontent-%COMP%], .pastis-btn-primary-disabled[_ngcontent-%COMP%], .pastis-btn-primary-hover[_ngcontent-%COMP%], .pastis-btn-primary-focus[_ngcontent-%COMP%], .pastis-btn-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-secondary-hover[_ngcontent-%COMP%], .pastis-btn-secondary-focus[_ngcontent-%COMP%], .pastis-btn-variant-enabled[_ngcontent-%COMP%], .pastis-btn-variant-disabled[_ngcontent-%COMP%], .pastis-btn-variant-hover[_ngcontent-%COMP%], .pastis-btn-variant-focus[_ngcontent-%COMP%], .pastis-btn-leading-enabled[_ngcontent-%COMP%], .pastis-btn-leading-disabled[_ngcontent-%COMP%], .pastis-btn-leading-hover[_ngcontent-%COMP%], .pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  border-radius: 100px !important;\n  border: 0px;\n  outline: none;\n}\n.pastis-btn-primary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary-50);\n}\n.pastis-btn-primary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-secondary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-secondary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-variant-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-variant-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #e7e5e5;\n}\n.pastis-btn-variant-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-variant-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-rounded[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%]:active, .pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 50px;\n  height: 50px;\n  outline-style: none;\n}\n.pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n}\n.pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: --vitamui-primary-200;\n}\n.pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-save[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  border: none;\n  background: --vitamui-primary-400;\n}\n.pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #bdd9ec;\n}\n.pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 30px;\n  height: 30px;\n  outline-style: none;\n}\n.pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-300);\n}\n.pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-dropdown-border-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid #bdd9ec;\n}\n.pastis-dropdown-border-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #5cbaa9;\n}\n.pastis-dropdown-background-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-text-button1-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button2-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-search-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-special-enabled[_ngcontent-%COMP%] {\n  color: #9d9d9d;\n}\n.pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  outline: none;\n  height: 50px;\n  box-sizing: border-box;\n  border-radius: 87px;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  border: 1px solid #65b2e4;\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  border: 1px solid #747272;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  border: 1px solid #ff0000;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  border: 1px solid #50d166;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-header-no-sidebar[_ngcontent-%COMP%], .pastis-header-with-sidebar[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 1440px;\n  height: 288px;\n  left: 0px;\n  top: -2px;\n  background: #eceef3;\n}\n.pastis-header-with-sidebar[_ngcontent-%COMP%] {\n  width: 952px;\n}\n.pastis-content-metadata[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 778px;\n  height: 60px;\n  top: 359px;\n  right: 116px;\n  left: 58px;\n  background: #ffffff;\n}\n.pastis-slide-nav-profile[_ngcontent-%COMP%] {\n  max-width: 480px;\n  height: auto;\n  background: #ffffff;\n}\n.pastis-slide-nav-header[_ngcontent-%COMP%] {\n  position: absolute;\n  height: 200px;\n  background: #5cbaa9;\n}\n.pastis-page-container[_ngcontent-%COMP%] {\n  position: relative;\n  width: 100%;\n  height: 100%;\n}\n.pastis-tab-container[_ngcontent-%COMP%] {\n  right: 40px;\n  left: 40px;\n  height: 500px;\n  width: 100%;\n}\n.pastis-table[_ngcontent-%COMP%] {\n  width: 80%;\n  height: 612px;\n  left: 150px;\n  margin-right: 120px;\n  \n  height: auto;\n  overflow: auto;\n  background: #ffffff !important;\n  box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.14) !important;\n  border-radius: 5px !important;\n}\n.pastis-metadata-table[_ngcontent-%COMP%] {\n  background: #ffffff;\n  box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border-radius: 5px;\n}\n.pastis-col[_ngcontent-%COMP%], .pastis-metadata-table-col-large[_ngcontent-%COMP%], .pastis-metadata-table-col-medium[_ngcontent-%COMP%], .pastis-metadata-table-col-small[_ngcontent-%COMP%] {\n  text-align: left;\n}\n.pastis-col[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-large[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-medium[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-small[_ngcontent-%COMP%]:first-child {\n  border-top-left-radius: 5px;\n  border-bottom-left-radius: 5px;\n}\n.pastis-col[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-large[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-medium[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-small[_ngcontent-%COMP%]:last-child {\n  border-top-right-radius: 5px;\n  border-bottom-right-radius: 5px;\n}\n.pastis-metadata-table-col-large[_ngcontent-%COMP%] {\n  width: 203px;\n  height: 50px;\n}\n.pastis-metadata-table-col-medium[_ngcontent-%COMP%] {\n  width: 140px;\n  height: 50px;\n}\n.pastis-metadata-table-col-small[_ngcontent-%COMP%] {\n  width: 120px;\n  height: 50px;\n}\n.pastis-side-nav[_ngcontent-%COMP%] {\n  background: #ffffff;\n  box-shadow: 20px 20px 80px rgba(168, 153, 153, 0.5);\n}\n.pastis-ico-svg[_ngcontent-%COMP%], .pastis-ico-save[_ngcontent-%COMP%] {\n  display: block;\n  margin: auto;\n}\n.pastis-ico-arrow-right[_ngcontent-%COMP%] {\n  font-size: 14px;\n  line-height: 22px;\n  margin-left: 10px;\n  vertical-align: middle;\n}\n.pastis-popup-modal-box[_ngcontent-%COMP%]   mat-dialog-container[_ngcontent-%COMP%] {\n  background: #f7f8fb;\n  \n  box-shadow: 0px 11px 15px rgba(0, 0, 0, 0.1), 0px 9px 46px rgba(0, 0, 0, 0.06), 0px 24px 38px rgba(0, 0, 0, 0.07);\n  border-radius: 20px;\n  overflow: hidden;\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar {\n  width: 12px;\n  height: 12px;\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-track {\n  background: var(--vitamui-primary-50);\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-thumb {\n  border-radius: 100px;\n  background: var(--vitamui-primary);\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-thumb:hover {\n  background: var(--vitamui-primary-700);\n}\n\n[_ngcontent-%COMP%]:root {\n  scrollbar-color: var(--vitamui-primary) !important;\n  scrollbar-width: thin !important;\n  scrollbar-base-color: var(--vitamui-primary-50) !important;\n}\n.mat-checkbox[_ngcontent-%COMP%]   .mat-checkbox-ripple[_ngcontent-%COMP%] {\n  display: none !important;\n}\n\n.pastis-tooltip-class[_ngcontent-%COMP%] {\n  \n  background-color: var(--vitamui-primary) !important;\n  border-radius: 5px !important;\n  padding: 15px !important;\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: 0.4px;\n  \n  color: #ffffff;\n}\n\n.tooltip-right[_ngcontent-%COMP%]::after {\n  border-color: transparent var(--vitamui-primary) transparent transparent !important;\n}\n.tooltip-left[_ngcontent-%COMP%]::after {\n  border-color: transparent transparent transparent var(--vitamui-primary) !important;\n}\n.tooltip-top[_ngcontent-%COMP%]::after {\n  border-color: var(--vitamui-primary) transparent transparent transparent !important;\n}\n.tooltip-bottom[_ngcontent-%COMP%]::after {\n  border-color: transparent transparent var(--vitamui-primary) transparent !important;\n}\n.pastis-text-area[_ngcontent-%COMP%] {\n  height: 40px;\n  background: #ffffff;\n  outline: none;\n  display: flex;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.25px;\n  resize: none;\n  color: #757575;\n}\n\n\n.checkbox-label[_ngcontent-%COMP%] {\n  display: inline;\n  position: relative;\n  margin: auto;\n  cursor: pointer;\n  font-size: 22px;\n  line-height: 24px;\n  clear: both;\n  vertical-align: middle !important;\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  position: absolute;\n  opacity: 0;\n  cursor: pointer;\n}\n.checkbox-label[_ngcontent-%COMP%]   .checkbox-custom[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0px;\n  left: 0px;\n  height: 16px;\n  width: 16px;\n  background-color: transparent;\n  border-radius: 3px;\n  transition: all 0.3s ease-out;\n  -webkit-transition: all 0.3s ease-out;\n  -moz-transition: all 0.3s ease-out;\n  -ms-transition: all 0.3s ease-out;\n  -o-transition: all 0.3s ease-out;\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked    ~ .checkbox-custom[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n  border-radius: 3px;\n  transform: rotate(0deg) scale(1);\n  opacity: 1;\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.checkbox-label[_ngcontent-%COMP%]   .checkbox-custom[_ngcontent-%COMP%]::after {\n  position: absolute;\n  content: '';\n  left: 12px;\n  top: 12px;\n  height: 0px;\n  width: 0px;\n  border-radius: 3px;\n  border: 1px solid var(--vitamui-secondary-300);\n  border-width: 0 3px 3px 0;\n  transform: rotate(0deg) scale(0);\n  opacity: 1;\n  transition: all 0.3s ease-out;\n  -webkit-transition: all 0.3s ease-out;\n  -moz-transition: all 0.3s ease-out;\n  -ms-transition: all 0.3s ease-out;\n  -o-transition: all 0.3s ease-out;\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked    ~ .checkbox-custom[_ngcontent-%COMP%]::after {\n  transform: rotate(45deg) scale(1);\n  opacity: 1;\n  left: 6px;\n  top: 1px;\n  width: 3px;\n  height: 10px;\n  border: 1px solid var(--vitamui-secondary-300);\n  border-width: 0 2px 2px 0;\n  background-color: transparent;\n  border-radius: 0;\n}\n.list-profile-table[_ngcontent-%COMP%] {\n  width: 100%;\n  max-height: 365px;\n  border-spacing: 0 5px;\n  border-radius: 5px;\n  background-color: transparent;\n}\n.pastis-table-row-header[_ngcontent-%COMP%], .pastis-table-row[_ngcontent-%COMP%], .pastis-table-row[_ngcontent-%COMP%]:hover {\n  border-width: 5px;\n  border-color: transparent;\n  background-color: #ffffff;\n  border-radius: 5px;\n  height: 60px !important;\n}\n.pastis-table-row[_ngcontent-%COMP%]:hover {\n  background-color: #f6f3fb;\n  box-shadow: 0px 1px 4px rgba(33, 33, 33, 0.2), 0px 2px 8px rgba(33, 33, 33, 0.05);\n  cursor: pointer;\n}\n.pastis-panel-shadow-primary-500[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 4px rgba(112, 35, 130, 0.4), 0px 2px 8px rgba(112, 35, 130, 0.2);\n}\n.pastis-panel-shadow[_ngcontent-%COMP%] {\n  box-shadow: 0px 2px 8px rgba(33, 33, 33, 0.2), 0px 4px 16px rgba(33, 33, 33, 0.05);\n}\n.pastis-panel-radius-5[_ngcontent-%COMP%] {\n  border-radius: 5px;\n}\n.pastis-panel-radius-10[_ngcontent-%COMP%] {\n  border-radius: 10px;\n}\n.pastis-entete-1-separator[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 3px;\n  left: 90px;\n  top: 0.83%;\n  bottom: 0.83%;\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](UserActionSaveProfileComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                // tslint:disable-next-line:component-selector
                selector: 'pastis-user-action-save-profile',
                templateUrl: './save-profile.component.html',
                styleUrls: ['./save-profile.component.scss'],
            }]
    }], function () { return [{ type: _core_services_profile_service__WEBPACK_IMPORTED_MODULE_13__["ProfileService"] }, { type: _core_services_popup_service__WEBPACK_IMPORTED_MODULE_12__["PopupService"] }, { type: _core_services_file_service__WEBPACK_IMPORTED_MODULE_9__["FileService"] }, { type: ui_frontend_common__WEBPACK_IMPORTED_MODULE_6__["StartupService"] }, { type: _angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_2__["MatSnackBar"] }, { type: _shared_data_generique_popup_service__WEBPACK_IMPORTED_MODULE_16__["DataGeneriquePopupService"] }, { type: _core_services_notice_service__WEBPACK_IMPORTED_MODULE_10__["NoticeService"] }, { type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__["TranslateService"] }, { type: _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialog"] }, { type: _angular_router__WEBPACK_IMPORTED_MODULE_3__["Router"] }, { type: _core_services_notification_service__WEBPACK_IMPORTED_MODULE_11__["NotificationService"] }, { type: _core_services_toggle_sidenav_service__WEBPACK_IMPORTED_MODULE_14__["ToggleSidenavService"] }]; }, { close: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Output"]
        }] }); })();


/***/ }),

/***/ "0hN7":
/*!*******************************************************************************!*\
  !*** ./src/app/profile/edit-profile/file-tree/pipes/file-tree-filter.pipe.ts ***!
  \*******************************************************************************/
/*! exports provided: FiletreeFilterPipe */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FiletreeFilterPipe", function() { return FiletreeFilterPipe; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "EM62");
/*
Copyright © CINES - Centre Informatique National pour l'Enseignement Supérieur (2020)

[dad@cines.fr]

This software is a computer program whose purpose is to provide
a web application to create, edit, import and export archive
profiles based on the french SEDA standard
(https://redirect.francearchives.fr/seda/).


This software is governed by the CeCILL-C  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL-C
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C license and that you accept its terms.
*/


class FiletreeFilterPipe {
    transform() {
        return null;
    }
}
FiletreeFilterPipe.ɵfac = function FiletreeFilterPipe_Factory(t) { return new (t || FiletreeFilterPipe)(); };
FiletreeFilterPipe.ɵpipe = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefinePipe"]({ name: "filetreeFilter", type: FiletreeFilterPipe, pure: true });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FiletreeFilterPipe, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Pipe"],
        args: [{
                name: 'filetreeFilter',
            }]
    }], null, null); })();


/***/ }),

/***/ "1Nv8":
/*!***********************************************!*\
  !*** ./src/app/core/services/seda.service.ts ***!
  \***********************************************/
/*! exports provided: SedaService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SedaService", function() { return SedaService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "EM62");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ "+kfY");
/* harmony import */ var _assets_seda_json__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../assets/seda.json */ "8hMF");
var _assets_seda_json__WEBPACK_IMPORTED_MODULE_2___namespace = /*#__PURE__*/__webpack_require__.t(/*! ../../../assets/seda.json */ "8hMF", 1);
/* harmony import */ var _models_file_node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../models/file-node */ "HKpZ");
/*
Copyright © CINES - Centre Informatique National pour l'Enseignement Supérieur (2020)

[dad@cines.fr]

This software is a computer program whose purpose is to provide
a web application to create, edit, import and export archive
profiles based on the french SEDA standard
(https://redirect.francearchives.fr/seda/).


This software is governed by the CeCILL-C  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL-C
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C license and that you accept its terms.
*/





class SedaService {
    constructor() {
        this.selectedSedaNode = new rxjs__WEBPACK_IMPORTED_MODULE_1__["BehaviorSubject"](null);
        this.selectedSedaNodeParent = new rxjs__WEBPACK_IMPORTED_MODULE_1__["BehaviorSubject"](null);
        this.sedaTabNodeRootToSearch = new rxjs__WEBPACK_IMPORTED_MODULE_1__["BehaviorSubject"](null);
        this.sedaRulesTemp = _assets_seda_json__WEBPACK_IMPORTED_MODULE_2__;
        this.sedaRules = this.sedaRulesTemp;
    }
    getSedaNode(currentNode, nameNode) {
        if (currentNode && nameNode) {
            let i;
            let currentChild;
            if (nameNode === currentNode.Name) {
                return currentNode;
            }
            else {
                // Use a for loop instead of forEach to avoid nested functions
                // Otherwise "return" will not work properly
                if (currentNode.Children) {
                    for (i = 0; i < currentNode.Children.length; i += 1) {
                        currentChild = currentNode.Children[i];
                        // Search in the current child
                        const result = this.getSedaNode(currentChild, nameNode);
                        // Return the result if the node has been found
                        if (result) {
                            return result;
                        }
                    }
                }
                // The node has not been found and we have no more options
                return;
            }
        }
    }
    getSedaNodeRecursively(currentNode, nameNode) {
        let i;
        let currentChild;
        let resultNode;
        if (currentNode) {
            if (nameNode === currentNode.Name) {
                resultNode = currentNode;
            }
            else {
                // Use a for loop instead of forEach to avoid nested functions
                // Otherwise "return" will not work properly
                if (currentNode.Children) {
                    for (i = 0; i < currentNode.Children.length; i += 1) {
                        currentChild = currentNode.Children[i];
                        // Search in the current child
                        const result = this.getSedaNodeRecursively(currentChild, nameNode);
                        // Return the result if the node has been found
                        if (result) {
                            resultNode = result;
                        }
                    }
                }
            }
        }
        return resultNode;
    }
    // Get the seda node based on collection name and a node name.
    // Since the SEDA 2.1 model does not contain unique names,
    // the function will search the whole file and return a single metadata based on
    // a node name and a collection name;
    getSedaNodeCollection(sedaNode, nodeName, collectionName) {
        let resultNode;
        if (sedaNode) {
            if (sedaNode.Collection === collectionName && sedaNode.Name === nodeName) {
                resultNode = sedaNode;
            }
            for (const child of sedaNode.Children) {
                const nodeFound = this.getSedaNodeCollection(child, nodeName, collectionName);
                if (nodeFound) {
                    resultNode = nodeFound;
                }
            }
        }
        return resultNode;
    }
    // For all correspondent values beetween seda and tree elements,
    // return a SedaData array of elements that does not have
    // an optional (0-1) or an obligatory (1) cardinality.
    // If an element have an 'n' cardinality (e.g. 0-N), the element will
    // aways be included in the list
    findSelectableElementList(sedaNode, fileNode) {
        const fileNodesNames = fileNode.children.map((e) => e.name);
        const allowedSelectableList = sedaNode.Children.filter((x) => (!fileNodesNames.includes(x.Name) && x.Cardinality !== _models_file_node__WEBPACK_IMPORTED_MODULE_3__["CardinalityConstants"].Obligatoire.valueOf()) ||
            (fileNodesNames.includes(x.Name) &&
                (x.Cardinality === _models_file_node__WEBPACK_IMPORTED_MODULE_3__["CardinalityConstants"]['Zero or More'].valueOf() ||
                    x.Cardinality === _models_file_node__WEBPACK_IMPORTED_MODULE_3__["CardinalityConstants"]['One Or More'].valueOf())));
        return allowedSelectableList;
    }
    findCardinalityName(clickedNode, cardlinalityValues) {
        if (!clickedNode.cardinality) {
            return '1';
        }
        else {
            return cardlinalityValues.find((c) => c.value === clickedNode.cardinality).value;
        }
    }
    /**
     * Returns the list of all the attributes defined for the node
     * @param sedaNode the seda node we want to query
     */
    getAttributes(sedaNode, collection) {
        // if (!sedaNode) return;
        return sedaNode.Children.filter((children) => children.Element === 'Attribute' && sedaNode.Collection === collection);
    }
    isSedaNodeObligatory(nodeName, sedaParent) {
        if (sedaParent.Name === nodeName) {
            return sedaParent.Cardinality.startsWith('1');
        }
        if (sedaParent) {
            for (const child of sedaParent.Children) {
                if (child.Name === nodeName) {
                    return child.Cardinality.startsWith('1');
                }
            }
        }
    }
    isDuplicated(fieldName, sedaParent) {
        if (sedaParent.Name === fieldName) {
            return sedaParent.Cardinality.includes('N');
        }
        if (sedaParent) {
            for (const child of sedaParent.Children) {
                if (child.Name === fieldName) {
                    return child.Cardinality.includes('N');
                }
            }
        }
    }
    checkSedaElementType(nodeName, sedaNode) {
        if (sedaNode.Name === nodeName) {
            return sedaNode.Element;
        }
        const node = sedaNode.Children.find((c) => c.Name === nodeName);
        if (node) {
            return node.Element;
        }
    }
    findSedaChildByName(nodeName, sedaNode) {
        if (nodeName === sedaNode.Name) {
            return sedaNode;
        }
        const childFound = sedaNode.Children.find((c) => c.Name === nodeName);
        return childFound ? childFound : null;
    }
    setSedaTabNodeRoot(sedaNodeName) {
        const sedaRootNodeSearch = this.getSedaNodeRecursively(this.selectedSedaNode.getValue(), sedaNodeName);
        this.sedaTabNodeRootToSearch.next(sedaRootNodeSearch);
    }
    // Returns a list of cardinalities of a given a fileNode's children
    // If an attributte child doesn't not have a cardinality
    // then the seda child's cardinality will be added by default;
    getCardinalitiesOfSedaChildrenAttributes(fileNode, sedaNode) {
        const cardinalities = [];
        for (const fileChild of fileNode.children) {
            for (const sedaChild of sedaNode.Children) {
                if (fileChild.name === sedaChild.Name) {
                    fileChild.cardinality ? cardinalities.push(fileChild.cardinality) : cardinalities.push(sedaChild.Cardinality);
                }
            }
        }
        return cardinalities;
    }
}
SedaService.ɵfac = function SedaService_Factory(t) { return new (t || SedaService)(); };
SedaService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: SedaService, factory: SedaService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](SedaService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"],
        args: [{
                providedIn: 'root',
            }]
    }], function () { return []; }, null); })();


/***/ }),

/***/ "1bG9":
/*!*********************************************************************!*\
  !*** ./src/app/user-actions/add-metadata/add-metadata.component.ts ***!
  \*********************************************************************/
/*! exports provided: UserActionAddMetadataComponent, FilterByNamePipe */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UserActionAddMetadataComponent", function() { return UserActionAddMetadataComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilterByNamePipe", function() { return FilterByNamePipe; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "EM62");
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/material/dialog */ "OZ4H");
/* harmony import */ var _core_services_file_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/services/file.service */ "sINK");
/* harmony import */ var _core_services_popup_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/services/popup.service */ "HxGl");
/* harmony import */ var _core_services_profile_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/services/profile.service */ "FFoR");
/* harmony import */ var _core_services_seda_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/services/seda.service */ "1Nv8");
/* harmony import */ var _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../models/profile-type.enum */ "tS00");
/* harmony import */ var _models_seda_data__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../models/seda-data */ "bPuR");
/* harmony import */ var _shared_pastis_popup_metadata_language_pastis_popup_metadata_language_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../shared/pastis-popup-metadata-language/pastis-popup-metadata-language.service */ "FUaJ");
/* harmony import */ var ui_frontend_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ui-frontend-common */ "OWX3");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/common */ "2kYt");
/* harmony import */ var _angular_material_divider__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/divider */ "zmEM");
/* harmony import */ var _angular_material_list__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/list */ "nKqi");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/forms */ "nIj0");
/* harmony import */ var _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/tooltip */ "Y2X+");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @ngx-translate/core */ "s2Ay");
/*
Copyright © CINES - Centre Informatique National pour l'Enseignement Supérieur (2020)

[dad@cines.fr]

This software is a computer program whose purpose is to provide
a web application to create, edit, import and export archive
profiles based on the french SEDA standard
(https://redirect.francearchives.fr/seda/).


This software is governed by the CeCILL-C  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL-C
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C license and that you accept its terms.
*/























function UserActionAddMetadataComponent_div_4_div_1_i_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "i", 14);
} }
function UserActionAddMetadataComponent_div_4_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, UserActionAddMetadataComponent_div_4_div_1_i_3_Template, 1, 0, "i", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "span", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "mat-divider", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "span", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function UserActionAddMetadataComponent_div_4_div_1_Template_span_click_7_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r9); const item_r5 = ctx.$implicit; const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r8.onRemoveSelectedElement(item_r5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8, "\u00D7");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r5 = ctx.$implicit;
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r4.isElementComplex(item_r5));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r4.onResolveName(item_r5));
} }
function UserActionAddMetadataComponent_div_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, UserActionAddMetadataComponent_div_4_div_1_Template, 9, 2, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r0.addedItems);
} }
function UserActionAddMetadataComponent_mat_list_5_mat_list_9_Template(rf, ctx) { if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "mat-list", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "span", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function UserActionAddMetadataComponent_mat_list_5_mat_list_9_Template_span_click_4_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r13); const element_r11 = ctx.$implicit; const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r12.onAddSelectedElement(element_r11); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "mat-divider", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r11 = ctx.$implicit;
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("matTooltip", ctx_r10.getDefinition(element_r11));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("matTooltipShowDelay", 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r10.onResolveName(element_r11));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](6, 4, "USER_ACTION.ADD_METADATA.BOUTON_AJOUTER"));
} }
const _c0 = function (a0) { return { "margin-top": a0 }; };
function UserActionAddMetadataComponent_mat_list_5_Template(rf, ctx) { if (rf & 1) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "mat-list", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](5, "i", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "i", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "mat-divider", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "mat-selection-list", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngModelChange", function UserActionAddMetadataComponent_mat_list_5_Template_mat_selection_list_ngModelChange_8_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r15); const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r14.selectSedaElement($event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](9, UserActionAddMetadataComponent_mat_list_5_mat_list_9_Template, 8, 6, "mat-list", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](10, "filterByName");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](11, _c0, ctx_r1.atLeastOneIsSelected ? "40px" : "0px"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](4, 5, "USER_ACTION.ADD_METADATA.METADATA_ADD"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disableRipple", true)("ngModel", ctx_r1.addedItems);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind3"](10, 7, ctx_r1.allowedChildren, ctx_r1.filterName, ctx_r1.sedaLanguage));
} }
function UserActionAddMetadataComponent_ng_template_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "p", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "USER_ACTION.ADD_METADATA.MESSAGE_PLUS_METADONNEE"), " ");
} }
class UserActionAddMetadataComponent {
    constructor(dialogRef, fileService, sedaService, popUpService, sedaLanguageService, profileService) {
        this.dialogRef = dialogRef;
        this.fileService = fileService;
        this.sedaService = sedaService;
        this.popUpService = popUpService;
        this.sedaLanguageService = sedaLanguageService;
        this.profileService = profileService;
        this.namesFiltered = [];
        this.addedItems = [];
    }
    ngOnInit() {
        this.sedaLanguageSub = this.sedaLanguageService.sedaLanguage.subscribe((value) => {
            this.sedaLanguage = value;
        }, (error) => {
            console.log(error);
        });
        this.fileService.nodeChange.subscribe((fileNode) => {
            this.fileNode = fileNode;
        });
        this.sedaData = this.sedaService.sedaRules[0];
        this.sedaNodeFound = this.fileNode.sedaData;
        if (this.profileService.profileMode === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_6__["ProfileType"].PA) {
            this.allowedChildren = this.sedaService
                .findSelectableElementList(this.sedaNodeFound, this.fileNode)
                .filter((e) => e.Element !== _models_seda_data__WEBPACK_IMPORTED_MODULE_7__["SedaElementConstants"].attribute);
        }
        else if (this.profileService.profileMode === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_6__["ProfileType"].PUA) {
            if (this.fileNode.name === 'ArchiveUnit') {
                if (this.fileNode.children.map((nodeChildren) => nodeChildren.name).includes('ArchiveUnitProfile')) {
                    this.allowedChildren = this.sedaService
                        .findSelectableElementList(this.sedaNodeFound, this.fileNode)
                        .filter((e) => e.Element !== _models_seda_data__WEBPACK_IMPORTED_MODULE_7__["SedaElementConstants"].attribute)
                        .filter((e) => e.Name === 'Management');
                }
                else {
                    this.allowedChildren = this.sedaService
                        .findSelectableElementList(this.sedaNodeFound, this.fileNode)
                        .filter((e) => e.Element !== _models_seda_data__WEBPACK_IMPORTED_MODULE_7__["SedaElementConstants"].attribute)
                        .filter((e) => e.Name === 'Management' || e.Name === 'ArchiveUnitProfile');
                }
            }
            else {
                this.allowedChildren = this.sedaNodeFound.Children.filter((e) => e.Name !== 'id');
                if (this.fileNode.sedaData.Children.filter((e) => e.Name.endsWith('Rule')).length > 0) {
                    if (this.fileNode.children.filter((e) => e.name === 'PreventInheritance').length > 0) {
                        this.allowedChildren = this.allowedChildren.filter((e) => e.Name !== 'RefNonRuleId');
                    }
                    if (this.fileNode.children.filter((e) => e.name === 'RefNonRuleId').length > 0) {
                        this.allowedChildren = this.allowedChildren.filter((e) => e.Name !== 'PreventInheritance');
                    }
                }
            }
            this.fileNode.children.forEach((child) => {
                if (child.cardinality.endsWith('1')) {
                    this.allowedChildren = this.allowedChildren.filter((e) => e.Name !== child.name);
                }
            });
        }
        // Subscribe observer to button status and
        // set the inital state of the ok button to disabled
        this.popUpService.btnYesShoudBeDisabled.subscribe((status) => {
            this.btnIsDisabled = status;
        });
    }
    selectSedaElement(selectedElements) {
        if (selectedElements.length) {
            this.selectedSedaNode = this.sedaService.getSedaNode(this.sedaData, selectedElements[0]);
        }
    }
    isElementSelected(element) {
        if (this.addedItems) {
            return this.addedItems.includes(element);
        }
    }
    onRemoveSelectedElement(element) {
        const indexOfElement = this.addedItems.indexOf(element);
        if (indexOfElement >= 0) {
            this.addedItems.splice(indexOfElement, 1);
        }
        if (element.Cardinality !== (_models_seda_data__WEBPACK_IMPORTED_MODULE_7__["SedaCardinalityConstants"].zeroOrMore || _models_seda_data__WEBPACK_IMPORTED_MODULE_7__["SedaCardinalityConstants"].oreOrMore)) {
            this.allowedChildren.push(element);
            this.allowedChildren = this.allowedChildren.slice(0, this.allowedChildren.length);
        }
        const orderedNames = Object.values(this.allowedChildren);
        this.allowedChildren.sort((a, b) => {
            return orderedNames.indexOf(a) - orderedNames.indexOf(b);
        });
        this.addedItems.length > 0 ? (this.atLeastOneIsSelected = true) : (this.atLeastOneIsSelected = false);
        this.upateButtonStatusAndDataToSend();
    }
    onAddSelectedElement(element) {
        this.addedItems.push(element);
        if (element.Cardinality.endsWith('1')) {
            this.allowedChildren = this.allowedChildren.filter((e) => e !== element);
        }
        if (this.fileNode.sedaData.Children.filter((e) => e.Name.endsWith('Rule')).length > 0) {
            if (element.Name === 'PreventInheritance') {
                this.allowedChildren = this.allowedChildren.filter((e) => e.Name !== 'RefNonRuleId');
            }
            if (element.Name === 'RefNonRuleId') {
                this.allowedChildren = this.allowedChildren.filter((e) => e.Name !== 'PreventInheritance');
            }
        }
        this.addedItems.length > 0 ? (this.atLeastOneIsSelected = true) : (this.atLeastOneIsSelected = false);
        this.upateButtonStatusAndDataToSend();
    }
    upateButtonStatusAndDataToSend() {
        this.popUpService.setPopUpDataOnClose(this.addedItems);
        this.popUpService.disableYesButton(!this.atLeastOneIsSelected);
    }
    onAllItemsAdded() {
        return this.allowedChildren.length === this.addedItems.length;
    }
    isElementComplex(element) {
        if (element) {
            return element.Element === _models_seda_data__WEBPACK_IMPORTED_MODULE_7__["SedaElementConstants"].complex;
        }
    }
    getDefinition(element) {
        return element ? element.Definition : '';
    }
    onNoClick() {
        this.dialogRef.close();
    }
    onSearchSubmit(search) {
        this.filterName = search;
    }
    onResolveName(element) {
        if (this.sedaLanguage) {
            return element.Name;
        }
        else {
            if (element.NameFr) {
                return element.NameFr;
            }
        }
        return element.Name;
    }
    ngOnDestroy() {
        if (this.sedaLanguageSub != null) {
            this.sedaLanguageSub.unsubscribe();
        }
    }
}
UserActionAddMetadataComponent.ɵfac = function UserActionAddMetadataComponent_Factory(t) { return new (t || UserActionAddMetadataComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialogRef"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_core_services_file_service__WEBPACK_IMPORTED_MODULE_2__["FileService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_core_services_seda_service__WEBPACK_IMPORTED_MODULE_5__["SedaService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_core_services_popup_service__WEBPACK_IMPORTED_MODULE_3__["PopupService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_shared_pastis_popup_metadata_language_pastis_popup_metadata_language_service__WEBPACK_IMPORTED_MODULE_8__["PastisPopupMetadataLanguageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_core_services_profile_service__WEBPACK_IMPORTED_MODULE_4__["ProfileService"])); };
UserActionAddMetadataComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: UserActionAddMetadataComponent, selectors: [["pastis-user-action-add-metadata"]], decls: 8, vars: 6, consts: [[2, "margin-bottom", "20px"], [3, "searchbarPlaceholder", "search"], ["class", "pastis-container-selected-items", 4, "ngIf"], ["class", "list-box-head", 4, "ngIf", "ngIfElse"], ["noItemsLeftToAdd", ""], [1, "pastis-container-selected-items"], ["style", "display: inline-flex", 4, "ngFor", "ngForOf"], [2, "display", "inline-flex"], [1, "selected-items-box"], [2, "padding", "12px"], ["class", "vitamui-icon vitamui-icon-ic24-arborescence", 4, "ngIf"], [1, "item-text"], ["vertical", "", 1, "selected-items-separator"], [1, "selected-items-close", 3, "click"], [1, "vitamui-icon", "vitamui-icon-ic24-arborescence"], [1, "list-box-head"], [1, "list-box-content-title"], [1, "paragraph-metadata-subtitle", 3, "ngStyle"], [1, "vitamui-icon", "vitamui-icon-chevron-down", 2, "margin-left", "20px", "font-weight", "bold"], [1, "vita"], [1, "pastis-popup-separator"], [1, "list-box", 3, "disableRipple", "ngModel", "ngModelChange"], ["class", "list-item", 4, "ngFor", "ngForOf"], [1, "list-item"], [1, "list-box-content"], ["matTooltipClass", "pastis-tooltip-class", "placement", "right", 1, "text", "medium", 3, "matTooltipShowDelay", "matTooltip"], [1, "ajouter", 3, "click"], [1, "paragraph-metadata-subtitle", 2, "margin-top", "40px"]], template: function UserActionAddMetadataComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "vitamui-common-banner", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("search", function UserActionAddMetadataComponent_Template_vitamui_common_banner_search_2_listener($event) { return ctx.onSearchSubmit($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, UserActionAddMetadataComponent_div_4_Template, 2, 1, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, UserActionAddMetadataComponent_mat_list_5_Template, 11, 13, "mat-list", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](6, UserActionAddMetadataComponent_ng_template_6_Template, 3, 3, "ng-template", null, 4, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("searchbarPlaceholder", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 4, "USER_ACTION.ADD_METADATA.SEARCH_PLACEHOLDER"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", (ctx.addedItems == null ? null : ctx.addedItems.length) > 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.allowedChildren == null ? null : ctx.allowedChildren.length)("ngIfElse", _r2);
    } }, directives: function () { return [ui_frontend_common__WEBPACK_IMPORTED_MODULE_9__["ɵhf"], _angular_common__WEBPACK_IMPORTED_MODULE_10__["NgIf"], _angular_common__WEBPACK_IMPORTED_MODULE_10__["NgForOf"], _angular_material_divider__WEBPACK_IMPORTED_MODULE_11__["MatDivider"], _angular_material_list__WEBPACK_IMPORTED_MODULE_12__["MatList"], _angular_common__WEBPACK_IMPORTED_MODULE_10__["NgStyle"], _angular_material_list__WEBPACK_IMPORTED_MODULE_12__["MatSelectionList"], _angular_forms__WEBPACK_IMPORTED_MODULE_13__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_13__["NgModel"], _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_14__["MatTooltip"]]; }, pipes: function () { return [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_15__["TranslatePipe"], FilterByNamePipe]; }, styles: [".mat-select-trigger[_ngcontent-%COMP%] {\n  \n}\n.dropdown-font-text[_ngcontent-%COMP%], .pastis-dropdown-text[_ngcontent-%COMP%] {\n  padding-top: 4px;\n  height: 20px;\n  max-height: 51px;\n  \n  font-family: Roboto;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  \n}\n\n.dropdown[_ngcontent-%COMP%], .pastis-dropdown-border[_ngcontent-%COMP%], .pastis-dropdown-background[_ngcontent-%COMP%] {\n  border-radius: 50px;\n  height: 49px;\n  background: #ffffff;\n  max-height: 40px;\n}\n\n.pastis-table-input-border[_ngcontent-%COMP%] {\n  border-radius: 5px;\n  border: 1px solid #e0e0e0;\n  box-sizing: border-box;\n  box-shadow: 0px 0px 2px rgba(33, 33, 33, 0.2), 0px 1px 4px rgba(33, 33, 33, 0.05);\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%], .list-box-content[_ngcontent-%COMP%], .list-box-content-title[_ngcontent-%COMP%], .ajouter[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n\n.pastis-primary-50[_ngcontent-%COMP%] {\n  color: #f7ebfa;\n}\n.pastis-primary-100[_ngcontent-%COMP%] {\n  color: #e6c3ef;\n}\n.pastis-primary-300[_ngcontent-%COMP%] {\n  color: #c672d9;\n}\n.pastis-primary-400[_ngcontent-%COMP%] {\n  color: #b54ace;\n}\n.pastis-primary-500[_ngcontent-%COMP%] {\n  color: #9c31b5;\n}\n.pastis-primary-700[_ngcontent-%COMP%] {\n  color: #571b64;\n}\n.pastis-secondary-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n}\n.pastis-secondary-50[_ngcontent-%COMP%] {\n  color: #eaf2fa;\n}\n.pastis-secondary-200[_ngcontent-%COMP%] {\n  color: #96bde8;\n}\n.pastis-secondary-300[_ngcontent-%COMP%] {\n  color: #6da2df;\n}\n.pastis-secondary-400[_ngcontent-%COMP%] {\n  color: #4388d6;\n}\n.pastis-secondary-500[_ngcontent-%COMP%] {\n  color: #2563a9;\n}\n.pastis-surface-tabs[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-surface-snackbar[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-black-low[_ngcontent-%COMP%], .pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  color: #c1c1c1;\n}\n.pastis-black-disabled[_ngcontent-%COMP%] {\n  color: #e7e5e5;\n}\n.pastis-black-medium[_ngcontent-%COMP%], .pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%], .selected-items-close[_ngcontent-%COMP%]:hover {\n  color: #747272;\n}\n.pastis-black-height[_ngcontent-%COMP%] {\n  color: #232323;\n}\n.pastis-black-standard[_ngcontent-%COMP%] {\n  color: #474747;\n}\n.pastis-grey-900[_ngcontent-%COMP%], .pastis-font-h5[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-grey-600[_ngcontent-%COMP%] {\n  color: #757575;\n}\n.pastis-grey-400[_ngcontent-%COMP%] {\n  color: #bdbdbd;\n}\n.pastis-ligthly-purple[_ngcontent-%COMP%] {\n  color: #f6f3fb;\n}\n.pastis-white-highlight[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-white-disabled[_ngcontent-%COMP%] {\n  color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-bg-primary-50[_ngcontent-%COMP%] {\n  background: #f7ebfa;\n}\n.pastis-bg-primary-100[_ngcontent-%COMP%] {\n  background: #e6c3ef;\n}\n.pastis-bg-primary-300[_ngcontent-%COMP%] {\n  background: #c672d9;\n}\n.pastis-bg-primary-400[_ngcontent-%COMP%] {\n  background: #b54ace;\n}\n.pastis-bg-primary-500[_ngcontent-%COMP%] {\n  background: #9c31b5;\n}\n.pastis-bg-primary-700[_ngcontent-%COMP%] {\n  background: #571b64;\n}\n.pastis-bg-secondary-disabled[_ngcontent-%COMP%] {\n  background: #bdd9ec;\n}\n.pastis-bg-secondary-50[_ngcontent-%COMP%] {\n  background: #eaf2fa;\n}\n.pastis-bg-secondary-200[_ngcontent-%COMP%] {\n  background: #96bde8;\n}\n.pastis-bg-secondary-300[_ngcontent-%COMP%] {\n  background: #6da2df;\n}\n.pastis-bg-secondary-400[_ngcontent-%COMP%] {\n  background: #4388d6;\n}\n.pastis-bg-secondary-500[_ngcontent-%COMP%] {\n  background: #2563a9;\n}\n.pastis-bg-surface-tabs[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-surface-snackbar[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-black-low[_ngcontent-%COMP%] {\n  background: #c1c1c1;\n}\n.pastis-bg-black-disabled[_ngcontent-%COMP%] {\n  background: #e7e5e5;\n}\n.pastis-bg-black-medium[_ngcontent-%COMP%] {\n  background: #747272;\n}\n.pastis-bg-black-height[_ngcontent-%COMP%] {\n  background: #232323;\n}\n.pastis-bg-black-standard[_ngcontent-%COMP%] {\n  background: #474747;\n}\n.pastis-bg-grey-900[_ngcontent-%COMP%] {\n  background: #212121;\n}\n.pastis-bg-grey-600[_ngcontent-%COMP%] {\n  background: #757575;\n}\n.pastis-bg-grey-400[_ngcontent-%COMP%] {\n  background: #bdbdbd;\n}\n.pastis-bg-ligthly-purple[_ngcontent-%COMP%] {\n  background: #f6f3fb;\n}\n.pastis-bg-white-highlight[_ngcontent-%COMP%] {\n  background: #ffffff;\n}\n.pastis-bg-white-disabled[_ngcontent-%COMP%] {\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-bgcolor-primary-50[_ngcontent-%COMP%] {\n  background-color: #f7ebfa;\n}\n.pastis-bgcolor-primary-100[_ngcontent-%COMP%] {\n  background-color: #e6c3ef;\n}\n.pastis-bgcolor-primary-300[_ngcontent-%COMP%] {\n  background-color: #c672d9;\n}\n.pastis-bgcolor-primary-400[_ngcontent-%COMP%] {\n  background-color: #b54ace;\n}\n.pastis-bgcolor-primary-500[_ngcontent-%COMP%] {\n  background-color: #9c31b5;\n}\n.pastis-bgcolor-primary-700[_ngcontent-%COMP%] {\n  background-color: #571b64;\n}\n.pastis-bgcolor-secondary-disabled[_ngcontent-%COMP%] {\n  background-color: #bdd9ec;\n}\n.pastis-bgcolor-secondary-50[_ngcontent-%COMP%] {\n  background-color: #eaf2fa;\n}\n.pastis-bgcolor-secondary-200[_ngcontent-%COMP%] {\n  background-color: #96bde8;\n}\n.pastis-bgcolor-secondary-300[_ngcontent-%COMP%] {\n  background-color: #6da2df;\n}\n.pastis-bgcolor-secondary-400[_ngcontent-%COMP%] {\n  background-color: #4388d6;\n}\n.pastis-bgcolor-secondary-500[_ngcontent-%COMP%] {\n  background-color: #2563a9;\n}\n.pastis-bgcolor-surface-tabs[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-surface-snackbar[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-black-low[_ngcontent-%COMP%] {\n  background-color: #c1c1c1;\n}\n.pastis-bgcolor-black-disabled[_ngcontent-%COMP%] {\n  background-color: #e7e5e5;\n}\n.pastis-bgcolor-black-medium[_ngcontent-%COMP%] {\n  background-color: #747272;\n}\n.pastis-bgcolor-black-height[_ngcontent-%COMP%] {\n  background-color: #232323;\n}\n.pastis-bgcolor-black-standard[_ngcontent-%COMP%] {\n  background-color: #474747;\n}\n.pastis-bgcolor-grey-900[_ngcontent-%COMP%] {\n  background-color: #212121;\n}\n.pastis-bgcolor-grey-600[_ngcontent-%COMP%] {\n  background-color: #757575;\n}\n.pastis-bgcolor-grey-400[_ngcontent-%COMP%] {\n  background-color: #bdbdbd;\n}\n.pastis-bgcolor-ligthly-purple[_ngcontent-%COMP%] {\n  background-color: #f6f3fb;\n}\n.pastis-bgcolor-white-highlight[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n}\n.pastis-bgcolor-white-disabled[_ngcontent-%COMP%] {\n  background-color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-btn[_ngcontent-%COMP%], .pastis-btn-primary-enabled[_ngcontent-%COMP%], .pastis-btn-primary-disabled[_ngcontent-%COMP%], .pastis-btn-primary-hover[_ngcontent-%COMP%], .pastis-btn-primary-focus[_ngcontent-%COMP%], .pastis-btn-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-secondary-hover[_ngcontent-%COMP%], .pastis-btn-secondary-focus[_ngcontent-%COMP%], .pastis-btn-variant-enabled[_ngcontent-%COMP%], .pastis-btn-variant-disabled[_ngcontent-%COMP%], .pastis-btn-variant-hover[_ngcontent-%COMP%], .pastis-btn-variant-focus[_ngcontent-%COMP%], .pastis-btn-leading-enabled[_ngcontent-%COMP%], .pastis-btn-leading-disabled[_ngcontent-%COMP%], .pastis-btn-leading-hover[_ngcontent-%COMP%], .pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  border-radius: 100px !important;\n  border: 0px;\n  outline: none;\n}\n.pastis-btn-primary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary-50);\n}\n.pastis-btn-primary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-secondary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-secondary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-variant-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-variant-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #e7e5e5;\n}\n.pastis-btn-variant-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-variant-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-rounded[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 50px;\n  height: 50px;\n  outline-style: none;\n}\n.pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n}\n.pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: --vitamui-primary-200;\n}\n.pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: --vitamui-primary-400;\n}\n.pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #bdd9ec;\n}\n.pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 30px;\n  height: 30px;\n  outline-style: none;\n}\n.pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-300);\n}\n.pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-dropdown-border-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid #bdd9ec;\n}\n.pastis-dropdown-border-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #5cbaa9;\n}\n.pastis-dropdown-background-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-text-button1-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button2-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-search-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-special-enabled[_ngcontent-%COMP%] {\n  color: #9d9d9d;\n}\n.pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  outline: none;\n  height: 50px;\n  box-sizing: border-box;\n  border-radius: 87px;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  border: 1px solid #65b2e4;\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  border: 1px solid #747272;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  border: 1px solid #ff0000;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  border: 1px solid #50d166;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%], .list-box-content[_ngcontent-%COMP%], .list-box-content-title[_ngcontent-%COMP%], .ajouter[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.paragraph-metadata-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 22px;\n  align-items: center;\n  letter-spacing: 0.1px;\n  color: var(--vitamui-grey-900);\n}\n.vitamui-icon-ic24-arborescence[_ngcontent-%COMP%]:before {\n  color: #ffffff;\n}\n.list-box[_ngcontent-%COMP%] {\n  background: #ffffff;\n  box-sizing: border-box;\n  border-radius: 5px;\n  padding-top: 0px;\n  max-height: 256px;\n  overflow: auto;\n  outline: none;\n}\nmat-divider[_ngcontent-%COMP%] {\n  height: 5px;\n  background-color: #f6f3fb;\n}\n.list-box-head[_ngcontent-%COMP%] {\n  background: #ffffff;\n  border: 1px solid #dfdfdf;\n  box-sizing: border-box;\n  border-radius: 5px;\n  outline: none;\n}\n.list-item[_ngcontent-%COMP%] {\n  border-bottom: 1px solid #ececec;\n  padding-top: 0;\n  background-color: #ffffff;\n  border-radius: 5px;\n}\n.list-item[_ngcontent-%COMP%]:last-child {\n  border-bottom: none;\n}\n.item-text[_ngcontent-%COMP%] {\n  vertical-align: middle;\n  padding-left: 4px;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 22px;\n  align-items: center;\n  letter-spacing: 0.1px;\n}\n.selected-items-box[_ngcontent-%COMP%] {\n  height: 50px;\n  background-color: var(--vitamui-secondary-300);\n  border: 1px solid #9c31b5;\n  box-sizing: border-box;\n  border-radius: 10px;\n  vertical-align: middle;\n  margin: 0.4125em 0 0 0.4125em;\n  display: inline-flex;\n  text-align: center;\n  text-justify: auto;\n  vertical-align: middle;\n  color: #ffffff;\n  padding: 0;\n}\n.selected-items-close[_ngcontent-%COMP%] {\n  padding-top: 12px;\n  margin: 0 10px 0 10px;\n  color: #ffffff;\n  font-weight: bold;\n  float: right;\n  font-size: 22px;\n  line-height: 20px;\n  cursor: pointer;\n  transition: 0.3s;\n}\n.list-box-content[_ngcontent-%COMP%] {\n  margin-left: 59px;\n  color: #808080;\n}\n.list-box-content-title[_ngcontent-%COMP%] {\n  margin-left: 20px;\n  color: var(--vitamui-grey-900);\n}\n.ajouter[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n  float: right;\n  margin-right: 33px;\n  cursor: pointer;\n  text-decoration: underline;\n  height: 50px;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 22px;\n  display: flex;\n  align-items: center;\n  letter-spacing: 0.1px;\n  text-transform: uppercase;\n}\n.ajouter[_ngcontent-%COMP%]:hover {\n  text-decoration: none;\n}\n#pastis-ico-complex-element[_ngcontent-%COMP%] {\n  margin-left: -39px;\n  margin-right: 22px;\n  vertical-align: middle;\n  display: inline-flex;\n}\n.selected-items-separator[_ngcontent-%COMP%] {\n  height: 49px;\n  width: 2px;\n  color: #ffffff;\n}\n.pastis-container-selected-items[_ngcontent-%COMP%] {\n  position: relative;\n  text-align: justify;\n  bottom: 15px;\n}"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](UserActionAddMetadataComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                // tslint:disable-next-line:component-selector
                selector: 'pastis-user-action-add-metadata',
                templateUrl: './add-metadata.component.html',
                styleUrls: ['./add-metadata.component.scss'],
            }]
    }], function () { return [{ type: _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialogRef"] }, { type: _core_services_file_service__WEBPACK_IMPORTED_MODULE_2__["FileService"] }, { type: _core_services_seda_service__WEBPACK_IMPORTED_MODULE_5__["SedaService"] }, { type: _core_services_popup_service__WEBPACK_IMPORTED_MODULE_3__["PopupService"] }, { type: _shared_pastis_popup_metadata_language_pastis_popup_metadata_language_service__WEBPACK_IMPORTED_MODULE_8__["PastisPopupMetadataLanguageService"] }, { type: _core_services_profile_service__WEBPACK_IMPORTED_MODULE_4__["ProfileService"] }]; }, null); })();
class FilterByNamePipe {
    transform(listOfElements, nameToFilter, sedaLanguage) {
        if (!listOfElements) {
            return null;
        }
        if (!nameToFilter) {
            return listOfElements;
        }
        if (sedaLanguage) {
            return listOfElements
                .filter((element) => element.Name !== undefined)
                .filter((element) => element.Name.toLowerCase().indexOf(nameToFilter.toLowerCase()) >= 0);
        }
        else {
            return listOfElements
                .filter((element) => element.NameFr !== undefined)
                .filter((element) => element.NameFr.toLowerCase().indexOf(nameToFilter.toLowerCase()) >= 0);
        }
    }
}
FilterByNamePipe.ɵfac = function FilterByNamePipe_Factory(t) { return new (t || FilterByNamePipe)(); };
FilterByNamePipe.ɵpipe = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefinePipe"]({ name: "filterByName", type: FilterByNamePipe, pure: true });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FilterByNamePipe, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Pipe"],
        args: [{ name: 'filterByName' }]
    }], null, null); })();


/***/ }),

/***/ "3vX4":
/*!****************************************************************!*\
  !*** ./src/app/profile/list-profile/list-profile.component.ts ***!
  \****************************************************************/
/*! exports provided: ListProfileComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ListProfileComponent", function() { return ListProfileComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "D57K");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "EM62");
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material/dialog */ "OZ4H");
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/material/table */ "FlRo");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "sEIs");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-translate/core */ "s2Ay");
/* harmony import */ var ng2_file_upload__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng2-file-upload */ "itEU");
/* harmony import */ var ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ui-frontend-common */ "OWX3");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../environments/environment */ "AytR");
/* harmony import */ var _core_classes_pastis_configuration__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/classes/pastis-configuration */ "GFJK");
/* harmony import */ var _core_services_notice_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/services/notice.service */ "djED");
/* harmony import */ var _core_services_profile_service__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/services/profile.service */ "FFoR");
/* harmony import */ var _core_services_toggle_sidenav_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/services/toggle-sidenav.service */ "OUc9");
/* harmony import */ var _shared_data_generique_popup_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../shared/data-generique-popup.service */ "s95C");
/* harmony import */ var _create_profile_create_profile_component__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../create-profile/create-profile.component */ "xgnY");
/* harmony import */ var _profile_preview_profile_information_tab_profile_information_tab_profile_information_tab_component__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../profile-preview/profile-information-tab/profile-information-tab/profile-information-tab.component */ "SHWT");
/* harmony import */ var _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../models/profile-type.enum */ "tS00");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/common */ "2kYt");
/* harmony import */ var _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @angular/material/sidenav */ "lQ7A");
/* harmony import */ var _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/material/progress-spinner */ "csyo");
/* harmony import */ var _profile_preview_profile_preview_component__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../profile-preview/profile-preview.component */ "Roos");
/* harmony import */ var _shared_pastis_popup_option_pastis_popup_option_component__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../shared/pastis-popup-option/pastis-popup-option.component */ "uibl");
/* harmony import */ var ngx_ui_loader__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ngx-ui-loader */ "LyM+");
/* harmony import */ var _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @angular/material/tooltip */ "Y2X+");
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @angular/material/menu */ "Jb3d");
/* harmony import */ var _pipes_filterByStringName_pipe__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./pipes/filterByStringName.pipe */ "sMKJ");
/* harmony import */ var _pipes_filterByType_pipe__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./pipes/filterByType.pipe */ "HiK5");

/*
Copyright © CINES - Centre Informatique National pour l'Enseignement Supérieur (2020)

[dad@cines.fr]

This software is a computer program whose purpose is to provide
a web application to create, edit, import and export archive
profiles based on the french SEDA standard
(https://redirect.francearchives.fr/seda/).


This software is governed by the CeCILL-C  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL-C
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C license and that you accept its terms.
*/





































function ListProfileComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "div");
} }
function ListProfileComponent_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "mat-spinner", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} }
function ListProfileComponent_profile_preview_6_Template(rf, ctx) { if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "profile-preview", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("previewClose", function ListProfileComponent_profile_preview_6_Template_profile_preview_previewClose_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r11); const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r10.closePanel(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("inputProfile", ctx_r4.openedItem);
} }
function ListProfileComponent_vitamui_common_title_breadcrumb_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "vitamui-common-title-breadcrumb");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "APPLICATION.PASTIS_APP.TITLE"), " ");
} }
function ListProfileComponent_button_12_Template(rf, ctx) { if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_button_12_Template_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13); const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r12.createProfile(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "i", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "span", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 1, "PROFILE.LIST_PROFILE.CREER_NOUVEAU_PROFIL"));
} }
function ListProfileComponent_button_13_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "button", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_button_13_Template_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r16); const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](6); return _r14.click(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "i", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "span", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "input", 27, 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ListProfileComponent_button_13_Template_input_change_5_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r16); const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r17.uploadProfile($event.target.files); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 2, "PROFILE.LIST_PROFILE.IMPORTER_PROFIL"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("uploader", ctx_r7.uploader);
} }
function ListProfileComponent_pastis_popup_option_14_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "pastis-popup-option", 29);
} if (rf & 2) {
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("sedaUrl", ctx_r8.sedaUrl)("newProfileUrl", ctx_r8.newProfileUrl);
} }
function ListProfileComponent_div_36_div_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "PROFILE.LIST_PROFILE.TABLE.TYPE"), " ");
} }
function ListProfileComponent_div_36_div_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "PROFILE.LIST_PROFILE.TABLE.TYPE_ETAT"), " ");
} }
function ListProfileComponent_div_36_div_21_div_4_i_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "i", 55);
} }
function ListProfileComponent_div_36_div_21_div_4_i_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "i", 56);
} }
function ListProfileComponent_div_36_div_21_div_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, ListProfileComponent_div_36_div_21_div_4_i_1_Template, 1, 0, "i", 53);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, ListProfileComponent_div_36_div_21_div_4_i_2_Template, 1, 0, "i", 54);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", element_r21.status == "ACTIVE");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", element_r21.status == "INACTIVE");
} }
function ListProfileComponent_div_36_div_21_button_17_Template(rf, ctx) { if (rf & 1) {
    const _r30 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "button", 57);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_div_36_div_21_button_17_Template_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r30); const element_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r28.changeExpand(element_r21); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "i", 58);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", !element_r21.isEditable);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("font-size", 25, "px");
} }
function ListProfileComponent_div_36_div_21_div_18_Template(rf, ctx) { if (rf & 1) {
    const _r34 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 59);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "button", 60);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_div_36_div_21_div_18_Template_button_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r34); const _r32 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](8); return _r32.click(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](2, "i", 61);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3, " \u00A0\u00A0\u00A0 ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "span", 62);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "input", 27, 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ListProfileComponent_div_36_div_21_div_18_Template_input_change_7_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r34); const element_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r35 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r35.updateProfileNotice(element_r21, $event.target.files); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](6, 2, "PROFILE.LIST_PROFILE.LOAD_PROFILE"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("uploader", ctx_r24.uploader);
} }
function ListProfileComponent_div_36_div_21_Template(rf, ctx) { if (rf & 1) {
    const _r38 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_div_36_div_21_Template_div_click_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r38); const element_r21 = ctx.$implicit; const ctx_r37 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r37.showProfile(element_r21); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, ListProfileComponent_div_36_div_21_div_4_Template, 3, 2, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_div_36_div_21_Template_div_click_5_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r38); const element_r21 = ctx.$implicit; const ctx_r39 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r39.showProfile(element_r21); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "div", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_div_36_div_21_Template_div_click_7_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r38); const element_r21 = ctx.$implicit; const ctx_r40 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r40.showProfile(element_r21); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "div", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_div_36_div_21_Template_div_click_9_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r38); const element_r21 = ctx.$implicit; const ctx_r41 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r41.showProfile(element_r21); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](11, "dateTime");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 48);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "button", 49);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_div_36_div_21_Template_button_click_14_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r38); const element_r21 = ctx.$implicit; const ctx_r42 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r42.editProfile(element_r21); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](15, "i", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](16, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](17, ListProfileComponent_div_36_div_21_button_17_Template, 2, 3, "button", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](18, ListProfileComponent_div_36_div_21_div_18_Template, 9, 4, "div", 52);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r21 = ctx.$implicit;
    const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", element_r21.type, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx_r20.isStandalone);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](element_r21.identifier);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](element_r21.name);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](11, 11, element_r21.lastUpdate, "medium"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", (!element_r21.controlSchema || element_r21.controlSchema === "{}") && element_r21.type === "PUA" || !element_r21.path && element_r21.type === "PA" || element_r21.status === "INACTIVE");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("font-size", 25, "px");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("matTooltip", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](16, 14, "PROFILE.LIST_PROFILE.MODIFIER_PROFIL_TOOLTIP"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx_r20.isStandalone);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r20.expanded && element_r21.isEditable);
} }
function ListProfileComponent_div_36_Template(rf, ctx) { if (rf & 1) {
    const _r44 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, ListProfileComponent_div_36_div_5_Template, 3, 3, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, ListProfileComponent_div_36_div_6_Template, 3, 3, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "vitamui-common-order-by-button", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("directionChange", function ListProfileComponent_div_36_Template_vitamui_common_order_by_button_directionChange_7_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r44); const ctx_r43 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r43.direction = $event; })("orderByChange", function ListProfileComponent_div_36_Template_vitamui_common_order_by_button_orderByChange_7_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r44); const ctx_r45 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r45.orderBy = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "div", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "vitamui-common-order-by-button", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("directionChange", function ListProfileComponent_div_36_Template_vitamui_common_order_by_button_directionChange_11_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r44); const ctx_r46 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r46.direction = $event; })("orderByChange", function ListProfileComponent_div_36_Template_vitamui_common_order_by_button_orderByChange_11_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r44); const ctx_r47 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r47.orderBy = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](14, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "vitamui-common-order-by-button", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("directionChange", function ListProfileComponent_div_36_Template_vitamui_common_order_by_button_directionChange_15_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r44); const ctx_r48 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r48.direction = $event; })("orderByChange", function ListProfileComponent_div_36_Template_vitamui_common_order_by_button_orderByChange_15_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r44); const ctx_r49 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r49.orderBy = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](18, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "vitamui-common-order-by-button", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("directionChange", function ListProfileComponent_div_36_Template_vitamui_common_order_by_button_directionChange_19_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r44); const ctx_r50 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r50.direction = $event; })("orderByChange", function ListProfileComponent_div_36_Template_vitamui_common_order_by_button_orderByChange_19_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r44); const ctx_r51 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r51.orderBy = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "div", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](21, ListProfileComponent_div_36_div_21_Template, 19, 16, "div", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](22, "filterByStringName");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](23, "filterByType");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](24, "ngx-ui-loader", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("loaderId", "table-profiles");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r9.isStandalone);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx_r9.isStandalone);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("direction", ctx_r9.direction)("orderBy", ctx_r9.orderBy);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](10, 16, "PROFILE.LIST_PROFILE.TABLE.IDENTIFIANT"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("direction", ctx_r9.direction)("orderBy", ctx_r9.orderBy);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](14, 18, "PROFILE.LIST_PROFILE.TABLE.INTITULE"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("direction", ctx_r9.direction)("orderBy", ctx_r9.orderBy);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](18, 20, "PROFILE.LIST_PROFILE.TABLE.DERNIERES_MODIFICATIONS"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("direction", ctx_r9.direction)("orderBy", ctx_r9.orderBy);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](22, 22, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](23, 25, ctx_r9.retrievedProfiles, ctx_r9.filterType), ctx_r9.search));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("loaderId", "table-profiles");
} }
const _c0 = function (a0, a1) { return { "pa-pua-card": a0, "total-profile-card": a1 }; };
const _c1 = function (a0, a1) { return { "pa-pua-label": a0, "total-profile-label": a1 }; };
const _c2 = function (a0, a1) { return { "pa-pua-num-label": a0, "total-profilenum-label": a1 }; };
const POPUP_CREATION_PATH = 'PROFILE.POP_UP_CREATION';
function constantToTranslate() {
    this.popupCreationCancelLabel = this.translated('.POPUP_CREATION_CANCEL_LABEL');
    this.popupCreationTitleDialog = this.translated('.POPUP_CREATION_TITLE_DIALOG');
    this.popupCreationSubTitleDialog = this.translated('.POPUP_CREATION_SUBTITLE_DIALOG');
    this.popupCreationOkLabel = this.translated('.POPUP_CREATION_OK_LABEL');
}
class ListProfileComponent extends ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["SidenavPage"] {
    constructor(profileService, noticeService, router, dialog, startupService, pastisConfig, route, globalEventService, dataGeneriquePopupService, translateService, toggleService) {
        super(route, globalEventService);
        this.profileService = profileService;
        this.noticeService = noticeService;
        this.router = router;
        this.dialog = dialog;
        this.startupService = startupService;
        this.pastisConfig = pastisConfig;
        this.route = route;
        this.dataGeneriquePopupService = dataGeneriquePopupService;
        this.translateService = translateService;
        this.toggleService = toggleService;
        this.uploader = new ng2_file_upload__WEBPACK_IMPORTED_MODULE_6__["FileUploader"]({ url: '' });
        this.retrievedProfiles = [];
        this.isStandalone = _environments_environment__WEBPACK_IMPORTED_MODULE_8__["environment"].standalone;
        this.direction = ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["Direction"].ASCENDANT;
        this.orderBy = 'identifier';
        this.sedaUrl = this.pastisConfig.pastisPathPrefix + (this.isStandalone ? '' : this.startupService.getTenantIdentifier()) + this.pastisConfig.sedaUrl;
        this.newProfileUrl = this.pastisConfig.pastisNewProfile;
        this.docPath = this.isStandalone
            ? 'assets/doc/Standalone - Documentation APP - PASTIS.pdf'
            : 'assets/doc/VITAM UI - Documentation APP - PASTIS.pdf';
        this.subscriptions = [];
        this.profilesChargees = false;
        this.expanded = false;
        this.pendingSub = this.toggleService.isPending.subscribe((status) => {
            this.pending = status;
        });
    }
    ngOnInit() {
        if (!this.isStandalone) {
            constantToTranslate.call(this);
            this.translatedOnChange();
        }
        else if (this.isStandalone) {
            this.popupCreationCancelLabel = 'Annuler';
            this.popupCreationTitleDialog = 'Choix du type de profil';
            this.popupCreationSubTitleDialog = "Création d'un profil";
            this.popupCreationOkLabel = 'VALIDER';
        }
        this.dataGeneriquePopupService.currentDonnee.subscribe((donnees) => (this.donnees = donnees));
        this.breadcrumbDataTop = [
            {
                label: 'PROFILE.EDIT_PROFILE.BREADCRUMB.PORTAIL',
                url: this.startupService.getPortalUrl(),
                external: true,
            },
            { label: 'PROFILE.EDIT_PROFILE.BREADCRUMB.CREER_ET_GERER_PROFIL', url: '/' },
        ];
        this.subscription1$ = this.refreshListProfiles();
        this.subscriptions.push(this.subscription1$);
    }
    isEditable(profileDescription) {
        return ((profileDescription.type === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__["ProfileType"].PA && !profileDescription.path && profileDescription.status === 'ACTIVE') ||
            (profileDescription.type === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__["ProfileType"].PUA &&
                profileDescription.status === 'ACTIVE' &&
                (!profileDescription.controlSchema || profileDescription.controlSchema === '{}')));
    }
    refreshListProfiles() {
        this.toggleService.showPending();
        this.profileService.refreshListProfiles();
        return this.profileService.retrievedProfiles.subscribe((profileList) => {
            if (profileList) {
                this.retrievedProfiles = profileList;
                this.retrievedProfiles.forEach((profileDescription) => {
                    profileDescription.isEditable = this.isEditable(profileDescription);
                });
                this.profilesChargees = true;
                this.toggleService.hidePending();
            }
            this.matDataSource = new _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatTableDataSource"](this.retrievedProfiles);
            this.numPA = this.retrievePAorPUA(_models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__["ProfileType"].PA, false);
            this.numPUA = this.retrievePAorPUA(_models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__["ProfileType"].PUA, false);
            this.totalProfileNum = this.retrievedProfiles ? this.retrievedProfiles.length : 0;
        });
    }
    translatedOnChange() {
        this.translateService.onLangChange.subscribe(() => {
            constantToTranslate.call(this);
            // console.log(event.lang);
        });
    }
    translated(nameOfFieldToTranslate) {
        return this.translateService.instant(POPUP_CREATION_PATH + nameOfFieldToTranslate);
    }
    retrievePAorPUA(term, filter) {
        const profiles = filter === false ? this.retrievedProfiles : this.numProfilesFiltered;
        const profileNum = profiles.filter((p) => p.type === term).length;
        return profileNum ? profileNum : 0;
    }
    navigate(d) {
        if (d.external) {
            window.location.assign(d.url);
        }
        else {
            this.router.navigate([d.url], { skipLocationChange: false });
        }
    }
    editProfile(element) {
        this.profileService.controlSchema.next(element === null || element === void 0 ? void 0 : element.controlSchema);
        this.router.navigate([this.pastisConfig.pastisEditPage, element.id], {
            state: element,
            relativeTo: this.route,
            skipLocationChange: false,
        });
    }
    uploadProfile(files) {
        const fileToUpload = files[0];
        if (fileToUpload) {
            const formData = new FormData();
            formData.append('file', fileToUpload, fileToUpload.name);
            this._uploadProfileSub = this.profileService.uploadProfile(formData).subscribe((response) => {
                if (response) {
                    this.router.navigate([this.pastisConfig.pastisNewProfile], { state: response, relativeTo: this.route });
                }
            });
            this.subscriptions.push(this._uploadProfileSub);
        }
    }
    createProfile() {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            const dataToSendToPopUp = {};
            dataToSendToPopUp.titleDialog = this.popupCreationTitleDialog;
            dataToSendToPopUp.subTitleDialog = this.popupCreationSubTitleDialog;
            dataToSendToPopUp.width = '800px';
            dataToSendToPopUp.height = '800px';
            dataToSendToPopUp.okLabel = this.popupCreationOkLabel;
            dataToSendToPopUp.cancelLabel = this.popupCreationCancelLabel;
            const dialogRef = this.dialog.open(_create_profile_create_profile_component__WEBPACK_IMPORTED_MODULE_14__["CreateProfileComponent"], {
                width: '800px',
                panelClass: 'pastis-popup-modal-box',
                data: dataToSendToPopUp,
            });
            this.subscription2$ = dialogRef.afterClosed().subscribe((result) => {
                if (result.success) {
                    // console.log(result.action + ' PA ou PUA ?');
                    if (result.action === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__["ProfileType"].PA || result.action === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__["ProfileType"].PUA) {
                        this.profileService
                            .createProfile(this.pastisConfig.createProfileByTypeUrl, result.action)
                            .subscribe((response) => {
                            if (response) {
                                this.router.navigate([this.pastisConfig.pastisNewProfile], { state: response, relativeTo: this.route });
                            }
                        });
                    }
                }
            });
            this.subscriptions.push(this.subscription2$);
        });
    }
    onSearchSubmit(search) {
        if (!search) {
            search = '';
        }
        this.search = search;
        const profileDescriptions = this.retrievedProfiles.filter((profile) => profile.identifier.toLowerCase().indexOf(search.toLowerCase()) >= 0 ||
            profile.name.toLowerCase().indexOf(search.toLowerCase()) >= 0);
        // console.log(this.retrievedProfiles)
        this.totalProfileNum = profileDescriptions.length;
        this.numPA = profileDescriptions.filter((profile) => profile.type === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__["ProfileType"].PA).length;
        this.numPUA = profileDescriptions.filter((profile) => profile.type === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__["ProfileType"].PUA).length;
    }
    isRowHovered(elementId) {
        return this.hoveredElementId === elementId;
    }
    onMouseOver(row) {
        this.buttonIsClicked = false;
        this.hoveredElementId = row.id;
    }
    onMouseLeave() {
        if (!this.buttonIsClicked) {
            this.hoveredElementId = 0;
        }
    }
    changeType(type) {
        if (type !== undefined) {
            this.filterType = type;
        }
    }
    ngOnDestroy() {
        this.profileService.retrievedProfiles.next([]);
        this.subscriptions.forEach((subscriptions) => subscriptions.unsubscribe());
        if (this.pendingSub)
            this.pendingSub.unsubscribe();
    }
    showProfile(element) {
        // console.log('showProfile')
        if (!this.isStandalone) {
            this.openPanel(element);
        }
    }
    updateProfileNotice(profileDescription, files) {
        const fileToUpload = files[0];
        let profile;
        let archivalProfileUnit;
        if (profileDescription.type === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__["ProfileType"].PA) {
            profile = this.noticeService.profileDescriptionToPaProfile(profileDescription);
            this.profileService.updateProfileFilePa(profile, fileToUpload).subscribe(() => {
                this.expanded = !this.expanded;
                this.refreshListProfiles();
            });
        }
        if (profileDescription.type === _models_profile_type_enum__WEBPACK_IMPORTED_MODULE_16__["ProfileType"].PUA) {
            if (fileToUpload) {
                let jsonObj;
                const fileReader = new FileReader();
                fileReader.readAsText(fileToUpload, 'UTF-8');
                fileReader.onload = () => {
                    // console.log(fileReader.result.toString());
                    jsonObj = JSON.parse(fileReader.result.toString());
                    // console.log(jsonObj.controlSchema);
                    profileDescription.controlSchema = jsonObj.controlSchema;
                    archivalProfileUnit = this.noticeService.profileDescriptionToPuaProfile(profileDescription);
                    this.profileService.updateProfilePua(archivalProfileUnit).subscribe(() => {
                        this.expanded = !this.expanded;
                        this.refreshListProfiles();
                    });
                };
                fileReader.onerror = (error) => {
                    console.error(error);
                };
            }
        }
    }
    changeExpand(element) {
        if (element.isEditable) {
            this.expanded = !this.expanded;
        }
    }
}
ListProfileComponent.ɵfac = function ListProfileComponent_Factory(t) { return new (t || ListProfileComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_core_services_profile_service__WEBPACK_IMPORTED_MODULE_11__["ProfileService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_core_services_notice_service__WEBPACK_IMPORTED_MODULE_10__["NoticeService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_2__["MatDialog"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["StartupService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_core_classes_pastis_configuration__WEBPACK_IMPORTED_MODULE_9__["PastisConfiguration"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["GlobalEventService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_shared_data_generique_popup_service__WEBPACK_IMPORTED_MODULE_13__["DataGeneriquePopupService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__["TranslateService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_core_services_toggle_sidenav_service__WEBPACK_IMPORTED_MODULE_12__["ToggleSidenavService"])); };
ListProfileComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: ListProfileComponent, selectors: [["pastis-list-profile"]], viewQuery: function ListProfileComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstaticViewQuery"](_profile_preview_profile_information_tab_profile_information_tab_profile_information_tab_component__WEBPACK_IMPORTED_MODULE_15__["ProfileInformationTabComponent"], true);
    } if (rf & 2) {
        var _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.profileInformationTabComponent = _t.first);
    } }, inputs: { uploader: "uploader" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 37, vars: 59, consts: [[4, "ngIf", "ngIfThen"], ["loadingSpinner", ""], [3, "autosize", "hasBackdrop"], ["mode", "side", "position", "end", 3, "fixedInViewport"], ["panel", ""], [3, "inputProfile", "previewClose", 4, "ngIf"], ["vitamuiCommonInfiniteScroll", ""], [1, "vitamui-heading"], [4, "ngIf"], [3, "searchbarPlaceholder", "search"], ["class", "btn primary ml-5", 3, "click", 4, "ngIf"], ["class", "btn secondary ml-3", 3, "click", 4, "ngIf"], [3, "sedaUrl", "newProfileUrl", 4, "ngIf"], [1, "vitamui-content"], [1, "text", "bold"], [3, "ngClass", "click"], [3, "ngClass"], ["id", "test", 1, "test"], ["blur", "0", "class", "vitamui-table-body", "ngxUiLoaderBlurred", "", "style", "margin-top: 30px", 3, "loaderId", 4, "ngIf"], [1, "steackhouse"], [1, "vitamui-spinner", "x-large", "my-3"], [3, "inputProfile", "previewClose"], [1, "btn", "primary", "ml-5", 3, "click"], [1, "vitamui-icon", "vitamui-icon-plus", "mr-3"], [2, "align-items", "center", "margin", "auto"], [1, "btn", "secondary", "ml-3", 3, "click"], [1, "vitamui-icon", "vitamui-icon-deposit", "mr-3"], ["accept", ".json, .rng", "ng2FileSelect", "", "type", "file", 1, "buttons", 2, "display", "none", 3, "uploader", "change"], ["fileInput", ""], [3, "sedaUrl", "newProfileUrl"], ["blur", "0", "ngxUiLoaderBlurred", "", 1, "vitamui-table-body", 2, "margin-top", "30px", 3, "loaderId"], [1, "vitamui-table"], [1, "vitamui-table-head"], [1, "col-2", "d-flex", "align-items-center"], ["orderByKey", "type", 3, "direction", "orderBy", "directionChange", "orderByChange"], [1, "col-3", "d-flex", "align-items-center"], ["orderByKey", "id", 3, "direction", "orderBy", "directionChange", "orderByChange"], ["orderByKey", "baseName", 3, "direction", "orderBy", "directionChange", "orderByChange"], [1, "col-4", "d-flex", "align-items-center"], ["orderByKey", "lastModified", 3, "direction", "orderBy", "directionChange", "orderByChange"], [1, "vitamui-table-body"], ["class", "vitamui-table-rows", 4, "ngFor", "ngForOf"], [3, "loaderId"], [1, "vitamui-table-rows"], [1, "vitamui-row", "d-flex", "align-items-center"], [1, "col-2", "clickable", 3, "click"], [1, "col-3", "clickable", 2, "word-wrap", "break-word", 3, "click"], [1, "col-2", "mr-3", "clickable", 3, "click"], [1, "col-2", "actions"], [1, "btn", "btn-circle", "primary", "mr-3", 3, "disabled", "click"], ["matTooltipPosition", "above", "matTooltipClass", "modifierToolTip", 1, "vitamui-icon", "vitamui-icon-edit", 3, "matTooltip"], ["class", "btn btn-circle outlin outline-primary mr-3", 3, "disabled", "click", 4, "ngIf"], ["class", "pastis-vitamui-option-container", 4, "ngIf"], ["class", "status-badge-green ml-3", 4, "ngIf"], ["class", "status-badge-red ml-3", 4, "ngIf"], [1, "status-badge-green", "ml-3"], [1, "status-badge-red", "ml-3"], [1, "btn", "btn-circle", "outlin", "outline-primary", "mr-3", 3, "disabled", "click"], [1, "vitamui-icon", "vitamui-icon-more-horiz"], [1, "pastis-vitamui-option-container"], ["mat-menu-item", "", 3, "click"], [1, "vitamui-icon", "vitamui-icon-download"], [1, "text", "normal"]], template: function ListProfileComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, ListProfileComponent_div_0_Template, 1, 0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, ListProfileComponent_ng_template_1_Template, 2, 0, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "mat-sidenav-container", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "mat-sidenav", 3, 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, ListProfileComponent_profile_preview_6_Template, 1, 1, "profile-preview", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "mat-sidenav-content", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](9, ListProfileComponent_vitamui_common_title_breadcrumb_9_Template, 3, 3, "vitamui-common-title-breadcrumb", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "vitamui-common-banner", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("search", function ListProfileComponent_Template_vitamui_common_banner_search_10_listener($event) { return ctx.onSearchSubmit($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](12, ListProfileComponent_button_12_Template, 5, 3, "button", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](13, ListProfileComponent_button_13_Template, 7, 4, "button", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](14, ListProfileComponent_pastis_popup_option_14_Template, 1, 2, "pastis-popup-option", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "div", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "p", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "div", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_Template_div_click_19_listener() { return ctx.changeType("ALL"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "p", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](22, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "p", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](24);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](25, "div", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_Template_div_click_25_listener() { return ctx.changeType("PA"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](26, "p", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](27, "PA");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "p", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](29);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "div", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ListProfileComponent_Template_div_click_30_listener() { return ctx.changeType("PUA"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](31, "p", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](32, "PUA");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](33, "p", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](34);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](35, "div", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](36, ListProfileComponent_div_36_Template, 25, 28, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.pending)("ngIfThen", _r1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("autosize", true)("hasBackdrop", false);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("fixedInViewport", true);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.openedItem);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.isStandalone);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("searchbarPlaceholder", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](11, 26, "PROFILE.LIST_PROFILE.SEARCH_PLACEHOLDER"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", true);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.isStandalone);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.isStandalone);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](18, 28, "PROFILE.LIST_PROFILE.LISTE_DES_PROFILS"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](32, _c0, ctx.filterType == "PA" || ctx.filterType == "PUA", ctx.filterType == "ALL" || ctx.filterType != "PUA" && ctx.filterType != "PA"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](35, _c1, ctx.filterType == "PA" || ctx.filterType == "PUA", ctx.filterType == "ALL" || ctx.filterType != "PUA" && ctx.filterType != "PA"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](22, 30, "PROFILE.LIST_PROFILE.TOUS_LES_PROFILS"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](38, _c2, ctx.filterType == "PA" || ctx.filterType == "PUA" || !ctx.filterType, ctx.filterType == "ALL" || ctx.filterType != "PUA" && ctx.filterType != "PA"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.totalProfileNum, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](41, _c0, ctx.filterType != "PA", ctx.filterType == "PA"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](44, _c1, ctx.filterType != "PA", ctx.filterType == "PA"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](47, _c2, ctx.filterType != "PA", ctx.filterType == "PA"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.numPA);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](50, _c0, ctx.filterType != "PUA", ctx.filterType == "PUA"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](53, _c1, ctx.filterType != "PUA", ctx.filterType == "PUA"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"](56, _c2, ctx.filterType != "PUA", ctx.filterType == "PUA"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.numPUA, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.profilesChargees);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_17__["NgIf"], _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_18__["MatSidenavContainer"], _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_18__["MatSidenav"], _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_18__["MatSidenavContent"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["InfiniteScrollDirective"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["ɵhf"], _angular_common__WEBPACK_IMPORTED_MODULE_17__["NgClass"], _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_19__["MatSpinner"], _profile_preview_profile_preview_component__WEBPACK_IMPORTED_MODULE_20__["ProfilePreviewComponent"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["ɵes"], ng2_file_upload__WEBPACK_IMPORTED_MODULE_6__["FileSelectDirective"], _shared_pastis_popup_option_pastis_popup_option_component__WEBPACK_IMPORTED_MODULE_21__["PastisPopupOptionComponent"], ngx_ui_loader__WEBPACK_IMPORTED_MODULE_22__["ɵc"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["OrderByButtonComponent"], _angular_common__WEBPACK_IMPORTED_MODULE_17__["NgForOf"], ngx_ui_loader__WEBPACK_IMPORTED_MODULE_22__["ɵb"], _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_23__["MatTooltip"], _angular_material_menu__WEBPACK_IMPORTED_MODULE_24__["MatMenuItem"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__["TranslatePipe"], _pipes_filterByStringName_pipe__WEBPACK_IMPORTED_MODULE_25__["FilterByStringNamePipe"], _pipes_filterByType_pipe__WEBPACK_IMPORTED_MODULE_26__["FilterByTypePipe"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["ɵo"]], styles: ["@charset \"UTF-8\";\n\n\n\n\n\n\n\n.mat-select-trigger[_ngcontent-%COMP%] {\n  \n}\n.dropdown-font-text[_ngcontent-%COMP%], .pastis-dropdown-text[_ngcontent-%COMP%] {\n  padding-top: 4px;\n  height: 20px;\n  max-height: 51px;\n  \n  font-family: Roboto;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  \n}\n\n.dropdown[_ngcontent-%COMP%], .pastis-dropdown-border[_ngcontent-%COMP%], .pastis-dropdown-background[_ngcontent-%COMP%] {\n  border-radius: 50px;\n  height: 49px;\n  background: #ffffff;\n  max-height: 40px;\n}\n\n.pastis-table-input-border[_ngcontent-%COMP%] {\n  border-radius: 5px;\n  border: 1px solid #e0e0e0;\n  box-sizing: border-box;\n  box-shadow: 0px 0px 2px rgba(33, 33, 33, 0.2), 0px 1px 4px rgba(33, 33, 33, 0.05);\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%], .total-profile-label[_ngcontent-%COMP%], .pa-pua-label[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%], .total-profile-label[_ngcontent-%COMP%], .pa-pua-label[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%], .total-profilenum-label[_ngcontent-%COMP%], .pa-pua-num-label[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%], .total-profilenum-label[_ngcontent-%COMP%], .pa-pua-num-label[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n\n.pastis-primary-50[_ngcontent-%COMP%], .total-profile-label[_ngcontent-%COMP%] {\n  color: #f7ebfa;\n}\n.pastis-primary-100[_ngcontent-%COMP%] {\n  color: #e6c3ef;\n}\n.pastis-primary-300[_ngcontent-%COMP%] {\n  color: #c672d9;\n}\n.pastis-primary-400[_ngcontent-%COMP%] {\n  color: #b54ace;\n}\n.pastis-primary-500[_ngcontent-%COMP%] {\n  color: #9c31b5;\n}\n.pastis-primary-700[_ngcontent-%COMP%] {\n  color: #571b64;\n}\n.pastis-secondary-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n}\n.pastis-secondary-50[_ngcontent-%COMP%] {\n  color: #eaf2fa;\n}\n.pastis-secondary-200[_ngcontent-%COMP%] {\n  color: #96bde8;\n}\n.pastis-secondary-300[_ngcontent-%COMP%] {\n  color: #6da2df;\n}\n.pastis-secondary-400[_ngcontent-%COMP%] {\n  color: #4388d6;\n}\n.pastis-secondary-500[_ngcontent-%COMP%] {\n  color: #2563a9;\n}\n.pastis-surface-tabs[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-surface-snackbar[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-black-low[_ngcontent-%COMP%], .pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  color: #c1c1c1;\n}\n.pastis-black-disabled[_ngcontent-%COMP%] {\n  color: #e7e5e5;\n}\n.pastis-black-medium[_ngcontent-%COMP%], .pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  color: #747272;\n}\n.pastis-black-height[_ngcontent-%COMP%] {\n  color: #232323;\n}\n.pastis-black-standard[_ngcontent-%COMP%] {\n  color: #474747;\n}\n.pastis-grey-900[_ngcontent-%COMP%], .pastis-font-h5[_ngcontent-%COMP%], .pa-pua-num-label[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-grey-600[_ngcontent-%COMP%], .pa-pua-label[_ngcontent-%COMP%] {\n  color: #757575;\n}\n.pastis-grey-400[_ngcontent-%COMP%] {\n  color: #bdbdbd;\n}\n.pastis-ligthly-purple[_ngcontent-%COMP%] {\n  color: #f6f3fb;\n}\n.pastis-white-highlight[_ngcontent-%COMP%], .total-profilenum-label[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-white-disabled[_ngcontent-%COMP%] {\n  color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-bg-primary-50[_ngcontent-%COMP%] {\n  background: #f7ebfa;\n}\n.pastis-bg-primary-100[_ngcontent-%COMP%] {\n  background: #e6c3ef;\n}\n.pastis-bg-primary-300[_ngcontent-%COMP%] {\n  background: #c672d9;\n}\n.pastis-bg-primary-400[_ngcontent-%COMP%] {\n  background: #b54ace;\n}\n.pastis-bg-primary-500[_ngcontent-%COMP%] {\n  background: #9c31b5;\n}\n.pastis-bg-primary-700[_ngcontent-%COMP%] {\n  background: #571b64;\n}\n.pastis-bg-secondary-disabled[_ngcontent-%COMP%] {\n  background: #bdd9ec;\n}\n.pastis-bg-secondary-50[_ngcontent-%COMP%] {\n  background: #eaf2fa;\n}\n.pastis-bg-secondary-200[_ngcontent-%COMP%] {\n  background: #96bde8;\n}\n.pastis-bg-secondary-300[_ngcontent-%COMP%] {\n  background: #6da2df;\n}\n.pastis-bg-secondary-400[_ngcontent-%COMP%] {\n  background: #4388d6;\n}\n.pastis-bg-secondary-500[_ngcontent-%COMP%] {\n  background: #2563a9;\n}\n.pastis-bg-surface-tabs[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-surface-snackbar[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-black-low[_ngcontent-%COMP%] {\n  background: #c1c1c1;\n}\n.pastis-bg-black-disabled[_ngcontent-%COMP%] {\n  background: #e7e5e5;\n}\n.pastis-bg-black-medium[_ngcontent-%COMP%] {\n  background: #747272;\n}\n.pastis-bg-black-height[_ngcontent-%COMP%] {\n  background: #232323;\n}\n.pastis-bg-black-standard[_ngcontent-%COMP%] {\n  background: #474747;\n}\n.pastis-bg-grey-900[_ngcontent-%COMP%] {\n  background: #212121;\n}\n.pastis-bg-grey-600[_ngcontent-%COMP%] {\n  background: #757575;\n}\n.pastis-bg-grey-400[_ngcontent-%COMP%] {\n  background: #bdbdbd;\n}\n.pastis-bg-ligthly-purple[_ngcontent-%COMP%] {\n  background: #f6f3fb;\n}\n.pastis-bg-white-highlight[_ngcontent-%COMP%] {\n  background: #ffffff;\n}\n.pastis-bg-white-disabled[_ngcontent-%COMP%] {\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-bgcolor-primary-50[_ngcontent-%COMP%] {\n  background-color: #f7ebfa;\n}\n.pastis-bgcolor-primary-100[_ngcontent-%COMP%] {\n  background-color: #e6c3ef;\n}\n.pastis-bgcolor-primary-300[_ngcontent-%COMP%] {\n  background-color: #c672d9;\n}\n.pastis-bgcolor-primary-400[_ngcontent-%COMP%] {\n  background-color: #b54ace;\n}\n.pastis-bgcolor-primary-500[_ngcontent-%COMP%], .total-profile-card[_ngcontent-%COMP%] {\n  background-color: #9c31b5;\n}\n.pastis-bgcolor-primary-700[_ngcontent-%COMP%] {\n  background-color: #571b64;\n}\n.pastis-bgcolor-secondary-disabled[_ngcontent-%COMP%] {\n  background-color: #bdd9ec;\n}\n.pastis-bgcolor-secondary-50[_ngcontent-%COMP%] {\n  background-color: #eaf2fa;\n}\n.pastis-bgcolor-secondary-200[_ngcontent-%COMP%] {\n  background-color: #96bde8;\n}\n.pastis-bgcolor-secondary-300[_ngcontent-%COMP%] {\n  background-color: #6da2df;\n}\n.pastis-bgcolor-secondary-400[_ngcontent-%COMP%] {\n  background-color: #4388d6;\n}\n.pastis-bgcolor-secondary-500[_ngcontent-%COMP%] {\n  background-color: #2563a9;\n}\n.pastis-bgcolor-surface-tabs[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-surface-snackbar[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-black-low[_ngcontent-%COMP%] {\n  background-color: #c1c1c1;\n}\n.pastis-bgcolor-black-disabled[_ngcontent-%COMP%] {\n  background-color: #e7e5e5;\n}\n.pastis-bgcolor-black-medium[_ngcontent-%COMP%] {\n  background-color: #747272;\n}\n.pastis-bgcolor-black-height[_ngcontent-%COMP%] {\n  background-color: #232323;\n}\n.pastis-bgcolor-black-standard[_ngcontent-%COMP%] {\n  background-color: #474747;\n}\n.pastis-bgcolor-grey-900[_ngcontent-%COMP%] {\n  background-color: #212121;\n}\n.pastis-bgcolor-grey-600[_ngcontent-%COMP%] {\n  background-color: #757575;\n}\n.pastis-bgcolor-grey-400[_ngcontent-%COMP%], .pastis-entete-1-separator[_ngcontent-%COMP%] {\n  background-color: #bdbdbd;\n}\n.pastis-bgcolor-ligthly-purple[_ngcontent-%COMP%] {\n  background-color: #f6f3fb;\n}\n.pastis-bgcolor-white-highlight[_ngcontent-%COMP%], .pa-pua-card[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n}\n.pastis-bgcolor-white-disabled[_ngcontent-%COMP%] {\n  background-color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-btn[_ngcontent-%COMP%], .pastis-btn-primary-enabled[_ngcontent-%COMP%], .pastis-btn-primary-disabled[_ngcontent-%COMP%], .pastis-btn-primary-hover[_ngcontent-%COMP%], .pastis-btn-primary-focus[_ngcontent-%COMP%], .pastis-btn-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-secondary-hover[_ngcontent-%COMP%], .pastis-btn-secondary-focus[_ngcontent-%COMP%], .pastis-btn-variant-enabled[_ngcontent-%COMP%], .pastis-btn-variant-disabled[_ngcontent-%COMP%], .pastis-btn-variant-hover[_ngcontent-%COMP%], .pastis-btn-variant-focus[_ngcontent-%COMP%], .pastis-btn-leading-enabled[_ngcontent-%COMP%], .pastis-btn-leading-disabled[_ngcontent-%COMP%], .pastis-btn-leading-hover[_ngcontent-%COMP%], .pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  border-radius: 100px !important;\n  border: 0px;\n  outline: none;\n}\n.pastis-btn-primary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary-50);\n}\n.pastis-btn-primary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-secondary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-secondary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-variant-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-variant-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #e7e5e5;\n}\n.pastis-btn-variant-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-variant-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-rounded[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 50px;\n  height: 50px;\n  outline-style: none;\n}\n.pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n}\n.pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: --vitamui-primary-200;\n}\n.pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: --vitamui-primary-400;\n}\n.pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #bdd9ec;\n}\n.pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%], .btn-search[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled, .btn-search[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover, .btn-search[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active, .btn-search[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 30px;\n  height: 30px;\n  outline-style: none;\n}\n.pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%], .btn-search[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled, .btn-search[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover, .btn-search[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active, .btn-search[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-300);\n}\n.pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-dropdown-border-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid #bdd9ec;\n}\n.pastis-dropdown-border-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #5cbaa9;\n}\n.pastis-dropdown-background-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-text-button1-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button2-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-search-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-special-enabled[_ngcontent-%COMP%] {\n  color: #9d9d9d;\n}\n.pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  outline: none;\n  height: 50px;\n  box-sizing: border-box;\n  border-radius: 87px;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  border: 1px solid #65b2e4;\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  border: 1px solid #747272;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  border: 1px solid #ff0000;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  border: 1px solid #50d166;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n\n\n\n\n\n\n\n.mat-select-trigger[_ngcontent-%COMP%] {\n  \n}\n.dropdown-font-text[_ngcontent-%COMP%], .pastis-dropdown-text[_ngcontent-%COMP%] {\n  padding-top: 4px;\n  height: 20px;\n  max-height: 51px;\n  \n  font-family: Roboto;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  \n}\n\n.dropdown[_ngcontent-%COMP%], .pastis-dropdown-border[_ngcontent-%COMP%], .pastis-dropdown-background[_ngcontent-%COMP%] {\n  border-radius: 50px;\n  height: 49px;\n  background: #ffffff;\n  max-height: 40px;\n}\n\n.pastis-table-input-border[_ngcontent-%COMP%] {\n  border-radius: 5px;\n  border: 1px solid #e0e0e0;\n  box-sizing: border-box;\n  box-shadow: 0px 0px 2px rgba(33, 33, 33, 0.2), 0px 1px 4px rgba(33, 33, 33, 0.05);\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%], .total-profile-label[_ngcontent-%COMP%], .pa-pua-label[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%], .total-profile-label[_ngcontent-%COMP%], .pa-pua-label[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%], .total-profilenum-label[_ngcontent-%COMP%], .pa-pua-num-label[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%], .total-profilenum-label[_ngcontent-%COMP%], .pa-pua-num-label[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n\n.pastis-primary-50[_ngcontent-%COMP%], .total-profile-label[_ngcontent-%COMP%] {\n  color: #f7ebfa;\n}\n.pastis-primary-100[_ngcontent-%COMP%] {\n  color: #e6c3ef;\n}\n.pastis-primary-300[_ngcontent-%COMP%] {\n  color: #c672d9;\n}\n.pastis-primary-400[_ngcontent-%COMP%] {\n  color: #b54ace;\n}\n.pastis-primary-500[_ngcontent-%COMP%] {\n  color: #9c31b5;\n}\n.pastis-primary-700[_ngcontent-%COMP%] {\n  color: #571b64;\n}\n.pastis-secondary-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n}\n.pastis-secondary-50[_ngcontent-%COMP%] {\n  color: #eaf2fa;\n}\n.pastis-secondary-200[_ngcontent-%COMP%] {\n  color: #96bde8;\n}\n.pastis-secondary-300[_ngcontent-%COMP%] {\n  color: #6da2df;\n}\n.pastis-secondary-400[_ngcontent-%COMP%] {\n  color: #4388d6;\n}\n.pastis-secondary-500[_ngcontent-%COMP%] {\n  color: #2563a9;\n}\n.pastis-surface-tabs[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-surface-snackbar[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-black-low[_ngcontent-%COMP%], .pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  color: #c1c1c1;\n}\n.pastis-black-disabled[_ngcontent-%COMP%] {\n  color: #e7e5e5;\n}\n.pastis-black-medium[_ngcontent-%COMP%], .pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  color: #747272;\n}\n.pastis-black-height[_ngcontent-%COMP%] {\n  color: #232323;\n}\n.pastis-black-standard[_ngcontent-%COMP%] {\n  color: #474747;\n}\n.pastis-grey-900[_ngcontent-%COMP%], .pastis-font-h5[_ngcontent-%COMP%], .pa-pua-num-label[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-grey-600[_ngcontent-%COMP%], .pa-pua-label[_ngcontent-%COMP%] {\n  color: #757575;\n}\n.pastis-grey-400[_ngcontent-%COMP%] {\n  color: #bdbdbd;\n}\n.pastis-ligthly-purple[_ngcontent-%COMP%] {\n  color: #f6f3fb;\n}\n.pastis-white-highlight[_ngcontent-%COMP%], .total-profilenum-label[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-white-disabled[_ngcontent-%COMP%] {\n  color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-bg-primary-50[_ngcontent-%COMP%] {\n  background: #f7ebfa;\n}\n.pastis-bg-primary-100[_ngcontent-%COMP%] {\n  background: #e6c3ef;\n}\n.pastis-bg-primary-300[_ngcontent-%COMP%] {\n  background: #c672d9;\n}\n.pastis-bg-primary-400[_ngcontent-%COMP%] {\n  background: #b54ace;\n}\n.pastis-bg-primary-500[_ngcontent-%COMP%] {\n  background: #9c31b5;\n}\n.pastis-bg-primary-700[_ngcontent-%COMP%] {\n  background: #571b64;\n}\n.pastis-bg-secondary-disabled[_ngcontent-%COMP%] {\n  background: #bdd9ec;\n}\n.pastis-bg-secondary-50[_ngcontent-%COMP%] {\n  background: #eaf2fa;\n}\n.pastis-bg-secondary-200[_ngcontent-%COMP%] {\n  background: #96bde8;\n}\n.pastis-bg-secondary-300[_ngcontent-%COMP%] {\n  background: #6da2df;\n}\n.pastis-bg-secondary-400[_ngcontent-%COMP%] {\n  background: #4388d6;\n}\n.pastis-bg-secondary-500[_ngcontent-%COMP%] {\n  background: #2563a9;\n}\n.pastis-bg-surface-tabs[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-surface-snackbar[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-black-low[_ngcontent-%COMP%] {\n  background: #c1c1c1;\n}\n.pastis-bg-black-disabled[_ngcontent-%COMP%] {\n  background: #e7e5e5;\n}\n.pastis-bg-black-medium[_ngcontent-%COMP%] {\n  background: #747272;\n}\n.pastis-bg-black-height[_ngcontent-%COMP%] {\n  background: #232323;\n}\n.pastis-bg-black-standard[_ngcontent-%COMP%] {\n  background: #474747;\n}\n.pastis-bg-grey-900[_ngcontent-%COMP%] {\n  background: #212121;\n}\n.pastis-bg-grey-600[_ngcontent-%COMP%] {\n  background: #757575;\n}\n.pastis-bg-grey-400[_ngcontent-%COMP%] {\n  background: #bdbdbd;\n}\n.pastis-bg-ligthly-purple[_ngcontent-%COMP%] {\n  background: #f6f3fb;\n}\n.pastis-bg-white-highlight[_ngcontent-%COMP%] {\n  background: #ffffff;\n}\n.pastis-bg-white-disabled[_ngcontent-%COMP%] {\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-bgcolor-primary-50[_ngcontent-%COMP%] {\n  background-color: #f7ebfa;\n}\n.pastis-bgcolor-primary-100[_ngcontent-%COMP%] {\n  background-color: #e6c3ef;\n}\n.pastis-bgcolor-primary-300[_ngcontent-%COMP%] {\n  background-color: #c672d9;\n}\n.pastis-bgcolor-primary-400[_ngcontent-%COMP%] {\n  background-color: #b54ace;\n}\n.pastis-bgcolor-primary-500[_ngcontent-%COMP%], .total-profile-card[_ngcontent-%COMP%] {\n  background-color: #9c31b5;\n}\n.pastis-bgcolor-primary-700[_ngcontent-%COMP%] {\n  background-color: #571b64;\n}\n.pastis-bgcolor-secondary-disabled[_ngcontent-%COMP%] {\n  background-color: #bdd9ec;\n}\n.pastis-bgcolor-secondary-50[_ngcontent-%COMP%] {\n  background-color: #eaf2fa;\n}\n.pastis-bgcolor-secondary-200[_ngcontent-%COMP%] {\n  background-color: #96bde8;\n}\n.pastis-bgcolor-secondary-300[_ngcontent-%COMP%] {\n  background-color: #6da2df;\n}\n.pastis-bgcolor-secondary-400[_ngcontent-%COMP%] {\n  background-color: #4388d6;\n}\n.pastis-bgcolor-secondary-500[_ngcontent-%COMP%] {\n  background-color: #2563a9;\n}\n.pastis-bgcolor-surface-tabs[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-surface-snackbar[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-black-low[_ngcontent-%COMP%] {\n  background-color: #c1c1c1;\n}\n.pastis-bgcolor-black-disabled[_ngcontent-%COMP%] {\n  background-color: #e7e5e5;\n}\n.pastis-bgcolor-black-medium[_ngcontent-%COMP%] {\n  background-color: #747272;\n}\n.pastis-bgcolor-black-height[_ngcontent-%COMP%] {\n  background-color: #232323;\n}\n.pastis-bgcolor-black-standard[_ngcontent-%COMP%] {\n  background-color: #474747;\n}\n.pastis-bgcolor-grey-900[_ngcontent-%COMP%] {\n  background-color: #212121;\n}\n.pastis-bgcolor-grey-600[_ngcontent-%COMP%] {\n  background-color: #757575;\n}\n.pastis-bgcolor-grey-400[_ngcontent-%COMP%], .pastis-entete-1-separator[_ngcontent-%COMP%] {\n  background-color: #bdbdbd;\n}\n.pastis-bgcolor-ligthly-purple[_ngcontent-%COMP%] {\n  background-color: #f6f3fb;\n}\n.pastis-bgcolor-white-highlight[_ngcontent-%COMP%], .pa-pua-card[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n}\n.pastis-bgcolor-white-disabled[_ngcontent-%COMP%] {\n  background-color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-btn[_ngcontent-%COMP%], .pastis-btn-primary-enabled[_ngcontent-%COMP%], .pastis-btn-primary-disabled[_ngcontent-%COMP%], .pastis-btn-primary-hover[_ngcontent-%COMP%], .pastis-btn-primary-focus[_ngcontent-%COMP%], .pastis-btn-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-secondary-hover[_ngcontent-%COMP%], .pastis-btn-secondary-focus[_ngcontent-%COMP%], .pastis-btn-variant-enabled[_ngcontent-%COMP%], .pastis-btn-variant-disabled[_ngcontent-%COMP%], .pastis-btn-variant-hover[_ngcontent-%COMP%], .pastis-btn-variant-focus[_ngcontent-%COMP%], .pastis-btn-leading-enabled[_ngcontent-%COMP%], .pastis-btn-leading-disabled[_ngcontent-%COMP%], .pastis-btn-leading-hover[_ngcontent-%COMP%], .pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  border-radius: 100px !important;\n  border: 0px;\n  outline: none;\n}\n.pastis-btn-primary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary-50);\n}\n.pastis-btn-primary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-secondary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-secondary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-variant-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-variant-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #e7e5e5;\n}\n.pastis-btn-variant-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-variant-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-rounded[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 50px;\n  height: 50px;\n  outline-style: none;\n}\n.pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n}\n.pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: --vitamui-primary-200;\n}\n.pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: --vitamui-primary-400;\n}\n.pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #bdd9ec;\n}\n.pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%], .btn-search[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled, .btn-search[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover, .btn-search[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active, .btn-search[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 30px;\n  height: 30px;\n  outline-style: none;\n}\n.pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%], .btn-search[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled, .btn-search[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover, .btn-search[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active, .btn-search[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-300);\n}\n.pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-dropdown-border-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid #bdd9ec;\n}\n.pastis-dropdown-border-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #5cbaa9;\n}\n.pastis-dropdown-background-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-text-button1-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button2-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-search-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-special-enabled[_ngcontent-%COMP%] {\n  color: #9d9d9d;\n}\n.pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  outline: none;\n  height: 50px;\n  box-sizing: border-box;\n  border-radius: 87px;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  border: 1px solid #65b2e4;\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  border: 1px solid #747272;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  border: 1px solid #ff0000;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  border: 1px solid #50d166;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-header-no-sidebar[_ngcontent-%COMP%], .pastis-header-with-sidebar[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 1440px;\n  height: 288px;\n  left: 0px;\n  top: -2px;\n  background: #eceef3;\n}\n.pastis-header-with-sidebar[_ngcontent-%COMP%] {\n  width: 952px;\n}\n.pastis-content-metadata[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 778px;\n  height: 60px;\n  top: 359px;\n  right: 116px;\n  left: 58px;\n  background: #ffffff;\n}\n.pastis-slide-nav-profile[_ngcontent-%COMP%] {\n  max-width: 480px;\n  height: auto;\n  background: #ffffff;\n}\n.pastis-slide-nav-header[_ngcontent-%COMP%] {\n  position: absolute;\n  height: 200px;\n  background: #5cbaa9;\n}\n.pastis-page-container[_ngcontent-%COMP%] {\n  position: relative;\n  width: 100%;\n  height: 100%;\n}\n.pastis-tab-container[_ngcontent-%COMP%] {\n  right: 40px;\n  left: 40px;\n  height: 500px;\n  width: 100%;\n}\n.pastis-table[_ngcontent-%COMP%] {\n  width: 80%;\n  height: 612px;\n  left: 150px;\n  margin-right: 120px;\n  \n  height: auto;\n  overflow: auto;\n  background: #ffffff !important;\n  box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.14) !important;\n  border-radius: 5px !important;\n}\n.pastis-metadata-table[_ngcontent-%COMP%] {\n  background: #ffffff;\n  box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border-radius: 5px;\n}\n.pastis-col[_ngcontent-%COMP%], .pastis-metadata-table-col-large[_ngcontent-%COMP%], .pastis-metadata-table-col-medium[_ngcontent-%COMP%], .pastis-metadata-table-col-small[_ngcontent-%COMP%] {\n  text-align: left;\n}\n.pastis-col[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-large[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-medium[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-small[_ngcontent-%COMP%]:first-child {\n  border-top-left-radius: 5px;\n  border-bottom-left-radius: 5px;\n}\n.pastis-col[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-large[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-medium[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-small[_ngcontent-%COMP%]:last-child {\n  border-top-right-radius: 5px;\n  border-bottom-right-radius: 5px;\n}\n.pastis-metadata-table-col-large[_ngcontent-%COMP%] {\n  width: 203px;\n  height: 50px;\n}\n.pastis-metadata-table-col-medium[_ngcontent-%COMP%] {\n  width: 140px;\n  height: 50px;\n}\n.pastis-metadata-table-col-small[_ngcontent-%COMP%] {\n  width: 120px;\n  height: 50px;\n}\n.pastis-side-nav[_ngcontent-%COMP%] {\n  background: #ffffff;\n  box-shadow: 20px 20px 80px rgba(168, 153, 153, 0.5);\n}\n.pastis-ico-svg[_ngcontent-%COMP%] {\n  display: block;\n  margin: auto;\n}\n.pastis-ico-arrow-right[_ngcontent-%COMP%] {\n  font-size: 14px;\n  line-height: 22px;\n  margin-left: 10px;\n  vertical-align: middle;\n}\n.pastis-popup-modal-box[_ngcontent-%COMP%]   mat-dialog-container[_ngcontent-%COMP%] {\n  background: #f7f8fb;\n  \n  box-shadow: 0px 11px 15px rgba(0, 0, 0, 0.1), 0px 9px 46px rgba(0, 0, 0, 0.06), 0px 24px 38px rgba(0, 0, 0, 0.07);\n  border-radius: 20px;\n  overflow: hidden;\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar {\n  width: 12px;\n  height: 12px;\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-track {\n  background: var(--vitamui-primary-50);\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-thumb {\n  border-radius: 100px;\n  background: var(--vitamui-primary);\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-thumb:hover {\n  background: var(--vitamui-primary-700);\n}\n\n[_ngcontent-%COMP%]:root {\n  scrollbar-color: var(--vitamui-primary) !important;\n  scrollbar-width: thin !important;\n  scrollbar-base-color: var(--vitamui-primary-50) !important;\n}\n.mat-checkbox[_ngcontent-%COMP%]   .mat-checkbox-ripple[_ngcontent-%COMP%] {\n  display: none !important;\n}\n\n.pastis-tooltip-class[_ngcontent-%COMP%] {\n  \n  background-color: var(--vitamui-primary) !important;\n  border-radius: 5px !important;\n  padding: 15px !important;\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: 0.4px;\n  \n  color: #ffffff;\n}\n\n.tooltip-right[_ngcontent-%COMP%]::after {\n  border-color: transparent var(--vitamui-primary) transparent transparent !important;\n}\n.tooltip-left[_ngcontent-%COMP%]::after {\n  border-color: transparent transparent transparent var(--vitamui-primary) !important;\n}\n.tooltip-top[_ngcontent-%COMP%]::after {\n  border-color: var(--vitamui-primary) transparent transparent transparent !important;\n}\n.tooltip-bottom[_ngcontent-%COMP%]::after {\n  border-color: transparent transparent var(--vitamui-primary) transparent !important;\n}\n.pastis-text-area[_ngcontent-%COMP%] {\n  height: 40px;\n  background: #ffffff;\n  outline: none;\n  display: flex;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.25px;\n  resize: none;\n  color: #757575;\n}\n\n\n.checkbox-label[_ngcontent-%COMP%] {\n  display: inline;\n  position: relative;\n  margin: auto;\n  cursor: pointer;\n  font-size: 22px;\n  line-height: 24px;\n  clear: both;\n  vertical-align: middle !important;\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  position: absolute;\n  opacity: 0;\n  cursor: pointer;\n}\n.checkbox-label[_ngcontent-%COMP%]   .checkbox-custom[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0px;\n  left: 0px;\n  height: 16px;\n  width: 16px;\n  background-color: transparent;\n  border-radius: 3px;\n  transition: all 0.3s ease-out;\n  -webkit-transition: all 0.3s ease-out;\n  -moz-transition: all 0.3s ease-out;\n  -ms-transition: all 0.3s ease-out;\n  -o-transition: all 0.3s ease-out;\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked    ~ .checkbox-custom[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n  border-radius: 3px;\n  transform: rotate(0deg) scale(1);\n  opacity: 1;\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.checkbox-label[_ngcontent-%COMP%]   .checkbox-custom[_ngcontent-%COMP%]::after {\n  position: absolute;\n  content: '';\n  left: 12px;\n  top: 12px;\n  height: 0px;\n  width: 0px;\n  border-radius: 3px;\n  border: 1px solid var(--vitamui-secondary-300);\n  border-width: 0 3px 3px 0;\n  transform: rotate(0deg) scale(0);\n  opacity: 1;\n  transition: all 0.3s ease-out;\n  -webkit-transition: all 0.3s ease-out;\n  -moz-transition: all 0.3s ease-out;\n  -ms-transition: all 0.3s ease-out;\n  -o-transition: all 0.3s ease-out;\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked    ~ .checkbox-custom[_ngcontent-%COMP%]::after {\n  transform: rotate(45deg) scale(1);\n  opacity: 1;\n  left: 6px;\n  top: 1px;\n  width: 3px;\n  height: 10px;\n  border: 1px solid var(--vitamui-secondary-300);\n  border-width: 0 2px 2px 0;\n  background-color: transparent;\n  border-radius: 0;\n}\n.list-profile-table[_ngcontent-%COMP%] {\n  width: 100%;\n  max-height: 365px;\n  border-spacing: 0 5px;\n  border-radius: 5px;\n  background-color: transparent;\n}\n.pastis-table-row-header[_ngcontent-%COMP%], .pastis-table-row[_ngcontent-%COMP%], .pastis-table-row[_ngcontent-%COMP%]:hover {\n  border-width: 5px;\n  border-color: transparent;\n  background-color: #ffffff;\n  border-radius: 5px;\n  height: 60px !important;\n}\n.pastis-table-row[_ngcontent-%COMP%]:hover {\n  background-color: #f6f3fb;\n  box-shadow: 0px 1px 4px rgba(33, 33, 33, 0.2), 0px 2px 8px rgba(33, 33, 33, 0.05);\n  cursor: pointer;\n}\n.pastis-panel-shadow-primary-500[_ngcontent-%COMP%], .total-profile-card[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 4px rgba(112, 35, 130, 0.4), 0px 2px 8px rgba(112, 35, 130, 0.2);\n}\n.pastis-panel-shadow[_ngcontent-%COMP%], .pa-pua-card[_ngcontent-%COMP%] {\n  box-shadow: 0px 2px 8px rgba(33, 33, 33, 0.2), 0px 4px 16px rgba(33, 33, 33, 0.05);\n}\n.pastis-panel-radius-5[_ngcontent-%COMP%], .total-pa-pua-card[_ngcontent-%COMP%], .total-profile-card[_ngcontent-%COMP%], .pa-pua-card[_ngcontent-%COMP%] {\n  border-radius: 5px;\n}\n.pastis-panel-radius-10[_ngcontent-%COMP%] {\n  border-radius: 10px;\n}\n.pastis-entete-1-separator[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 3px;\n  left: 90px;\n  top: 0.83%;\n  bottom: 0.83%;\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%], .total-profile-label[_ngcontent-%COMP%], .pa-pua-label[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%], .total-profile-label[_ngcontent-%COMP%], .pa-pua-label[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%], .total-profilenum-label[_ngcontent-%COMP%], .pa-pua-num-label[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%], .total-profilenum-label[_ngcontent-%COMP%], .pa-pua-num-label[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n\n\n\n\n\n\n@font-face {\n  font-family: 'vitamui-icon';\n  src: url('/vitamui-icon.9c2630a33a9f51e9620d.eot');\n  src: url('/vitamui-icon.9c2630a33a9f51e9620d.eot') format(\"embedded-opentype\"), url('/vitamui-icon.f38dcafd580c19a9591e.ttf') format(\"truetype\"), url('/vitamui-icon.2a51d773162de3ad9bac.woff') format(\"woff\"), url('/vitamui-icon.cb3e082e46c6addde29b.svg') format(\"svg\");\n  font-weight: normal;\n  font-style: normal;\n  font-display: block;\n}\ni.vitamui-icon[_ngcontent-%COMP%] {\n  \n  font-family: 'vitamui-icon' !important;\n  speak: never;\n  font-style: normal;\n  font-weight: normal;\n  font-variant: normal;\n  text-transform: none;\n  line-height: 1;\n  \n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n.vitamui-icon-ic24-arborescence[_ngcontent-%COMP%]:before {\n  content: \"\\e961\";\n  color: #757575;\n}\n.vitamui-icon-ic24-PUA[_ngcontent-%COMP%]:before {\n  content: \"\\e990\";\n  color: #757575;\n}\n.vitamui-icon-ic40-dossier-physique[_ngcontent-%COMP%]:before {\n  content: \"\\e991\";\n  color: #757575;\n}\n.vitamui-icon-ic40-flux[_ngcontent-%COMP%]:before {\n  content: \"\\e977\";\n}\n.vitamui-icon-ic40-flux-industriel[_ngcontent-%COMP%]:before {\n  content: \"\\e978\";\n}\n.vitamui-icon-ic40-flux-manuel[_ngcontent-%COMP%]:before {\n  content: \"\\e979\";\n}\n.vitamui-icon-anomalie-2[_ngcontent-%COMP%]:before {\n  content: \"\\e975\";\n}\n.vitamui-icon-customers-supervision[_ngcontent-%COMP%]:before {\n  content: \"\\e974\";\n}\n.vitamui-icon-external-param-profil[_ngcontent-%COMP%]:before {\n  content: \"\\e973\";\n}\n.vitamui-icon-reporting[_ngcontent-%COMP%]:before {\n  content: \"\\e96f\";\n}\n.vitamui-icon-accession-register[_ngcontent-%COMP%]:before {\n  content: \"\\e970\";\n}\n.vitamui-icon-logbook-management-operation[_ngcontent-%COMP%]:before {\n  content: \"\\e971\";\n}\n.vitamui-icon-logbook-operations[_ngcontent-%COMP%]:before {\n  content: \"\\e972\";\n}\n.vitamui-icon-rules[_ngcontent-%COMP%]:before {\n  content: \"\\e96d\";\n}\n.vitamui-icon-security-profile[_ngcontent-%COMP%]:before {\n  content: \"\\e96e\";\n}\n.vitamui-icon-ontologie[_ngcontent-%COMP%]:before {\n  content: \"\\e964\";\n}\n.vitamui-icon-fichiers[_ngcontent-%COMP%]:before {\n  content: \"\\e965\";\n}\n.vitamui-icon-agent[_ngcontent-%COMP%]:before {\n  content: \"\\e966\";\n}\n.vitamui-icon-releve[_ngcontent-%COMP%]:before {\n  content: \"\\e967\";\n}\n.vitamui-icon-dsl[_ngcontent-%COMP%]:before {\n  content: \"\\e968\";\n}\n.vitamui-icon-operation[_ngcontent-%COMP%]:before {\n  content: \"\\e969\";\n}\n.vitamui-icon-contrat[_ngcontent-%COMP%]:before {\n  content: \"\\e96a\";\n}\n.vitamui-icon-securite[_ngcontent-%COMP%]:before {\n  content: \"\\e96b\";\n}\n.vitamui-icon-audit[_ngcontent-%COMP%]:before {\n  content: \"\\e96c\";\n}\n.vitamui-icon-trash[_ngcontent-%COMP%]:before {\n  content: \"\\e963\";\n}\n.vitamui-icon-import-csv[_ngcontent-%COMP%]:before {\n  content: \"\\e962\";\n}\n.vitamui-icon-ic24-user-transfer[_ngcontent-%COMP%]:before {\n  content: \"\\e95e\";\n}\n.vitamui-icon-ic24-limination[_ngcontent-%COMP%]:before {\n  content: \"\\e95f\";\n}\n.vitamui-icon-ic24-prservation[_ngcontent-%COMP%]:before {\n  content: \"\\e960\";\n}\n.vitamui-icon-filing-plan[_ngcontent-%COMP%]:before {\n  content: \"\\ea77\";\n}\n.vitamui-icon-add-basket[_ngcontent-%COMP%]:before {\n  content: \"\\ea74\";\n}\n.vitamui-icon-export-result[_ngcontent-%COMP%]:before {\n  content: \"\\ea75\";\n}\n.vitamui-icon-download-basic[_ngcontent-%COMP%]:before {\n  content: \"\\ea76\";\n}\n.vitamui-icon-mobile[_ngcontent-%COMP%]:before {\n  content: \"\\ea72\";\n}\n.vitamui-icon-gestion-de-profil[_ngcontent-%COMP%]:before {\n  content: \"\\ea73\";\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path1[_ngcontent-%COMP%]:before {\n  content: \"\\ea4d\";\n  color: #e2e2e1;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path2[_ngcontent-%COMP%]:before {\n  content: \"\\ea56\";\n  margin-left: -1.3505859375em;\n  color: #9a9a9a;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path3[_ngcontent-%COMP%]:before {\n  content: \"\\ea57\";\n  margin-left: -1.3505859375em;\n  color: #c5c5c5;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path4[_ngcontent-%COMP%]:before {\n  content: \"\\ea58\";\n  margin-left: -1.3505859375em;\n  color: #efefef;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path5[_ngcontent-%COMP%]:before {\n  content: \"\\ea5a\";\n  margin-left: -1.3505859375em;\n  color: #c5c5c5;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path6[_ngcontent-%COMP%]:before {\n  content: \"\\ea5b\";\n  margin-left: -1.3505859375em;\n  color: #9a9a9a;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path7[_ngcontent-%COMP%]:before {\n  content: \"\\ea5c\";\n  margin-left: -1.3505859375em;\n  color: #c5c5c5;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path8[_ngcontent-%COMP%]:before {\n  content: \"\\ea5d\";\n  margin-left: -1.3505859375em;\n  color: #c5c5c5;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path9[_ngcontent-%COMP%]:before {\n  content: \"\\ea5e\";\n  margin-left: -1.3505859375em;\n  color: #c5c5c5;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path10[_ngcontent-%COMP%]:before {\n  content: \"\\ea5f\";\n  margin-left: -1.3505859375em;\n  color: #efefef;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path11[_ngcontent-%COMP%]:before {\n  content: \"\\ea60\";\n  margin-left: -1.3505859375em;\n  color: #c5c5c5;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path12[_ngcontent-%COMP%]:before {\n  content: \"\\ea61\";\n  margin-left: -1.3505859375em;\n  color: #9a9a9a;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path13[_ngcontent-%COMP%]:before {\n  content: \"\\ea62\";\n  margin-left: -1.3505859375em;\n  color: #858585;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path14[_ngcontent-%COMP%]:before {\n  content: \"\\ea63\";\n  margin-left: -1.3505859375em;\n  color: #858585;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path15[_ngcontent-%COMP%]:before {\n  content: \"\\ea64\";\n  margin-left: -1.3505859375em;\n  color: #127b66;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path16[_ngcontent-%COMP%]:before {\n  content: \"\\ea65\";\n  margin-left: -1.3505859375em;\n  color: #127b66;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path17[_ngcontent-%COMP%]:before {\n  content: \"\\ea66\";\n  margin-left: -1.3505859375em;\n  color: #127b66;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path18[_ngcontent-%COMP%]:before {\n  content: \"\\ea67\";\n  margin-left: -1.3505859375em;\n  color: #127b66;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path19[_ngcontent-%COMP%]:before {\n  content: \"\\ea68\";\n  margin-left: -1.3505859375em;\n  color: black;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path20[_ngcontent-%COMP%]:before {\n  content: \"\\ea69\";\n  margin-left: -1.3505859375em;\n  color: #33b099;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path21[_ngcontent-%COMP%]:before {\n  content: \"\\ea6a\";\n  margin-left: -1.3505859375em;\n  color: #9cd2ce;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path22[_ngcontent-%COMP%]:before {\n  content: \"\\ea6b\";\n  margin-left: -1.3505859375em;\n  color: #127b66;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path23[_ngcontent-%COMP%]:before {\n  content: \"\\ea6c\";\n  margin-left: -1.3505859375em;\n  color: #33b099;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path24[_ngcontent-%COMP%]:before {\n  content: \"\\ea6d\";\n  margin-left: -1.3505859375em;\n  color: #127b66;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path25[_ngcontent-%COMP%]:before {\n  content: \"\\ea6f\";\n  margin-left: -1.3505859375em;\n  color: #f0f0f0;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path26[_ngcontent-%COMP%]:before {\n  content: \"\\ea70\";\n  margin-left: -1.3505859375em;\n  color: #f0f0f0;\n}\n.vitamui-icon-app_unknown[_ngcontent-%COMP%]   .path27[_ngcontent-%COMP%]:before {\n  content: \"\\ea71\";\n  margin-left: -1.3505859375em;\n  color: white;\n}\n.vitamui-icon-add[_ngcontent-%COMP%]:before {\n  content: \"\\ea4b\";\n}\n.vitamui-icon-anomalie[_ngcontent-%COMP%]:before {\n  content: \"\\ea4c\";\n}\n.vitamui-icon-arrow-back[_ngcontent-%COMP%]:before {\n  content: \"\\ea4e\";\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path1[_ngcontent-%COMP%]:before {\n  content: \"\\e97a\";\n  color: #757575;\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path2[_ngcontent-%COMP%]:before {\n  content: \"\\e97b\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path3[_ngcontent-%COMP%]:before {\n  content: \"\\e97c\";\n  margin-left: -1em;\n  color: white;\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path4[_ngcontent-%COMP%]:before {\n  content: \"\\e97d\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path5[_ngcontent-%COMP%]:before {\n  content: \"\\e97e\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path6[_ngcontent-%COMP%]:before {\n  content: \"\\e97f\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path7[_ngcontent-%COMP%]:before {\n  content: \"\\e980\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path8[_ngcontent-%COMP%]:before {\n  content: \"\\e981\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path9[_ngcontent-%COMP%]:before {\n  content: \"\\e982\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path10[_ngcontent-%COMP%]:before {\n  content: \"\\e983\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-attribution-liste[_ngcontent-%COMP%]   .path11[_ngcontent-%COMP%]:before {\n  content: \"\\e984\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-bordereau[_ngcontent-%COMP%]:before {\n  content: \"\\ea59\";\n}\n.vitamui-icon-calendar[_ngcontent-%COMP%]:before {\n  content: \"\\ea6e\";\n}\n.vitamui-icon-chevron-down[_ngcontent-%COMP%]:before {\n  content: \"\\ea7b\";\n}\n.vitamui-icon-chevron-down-1[_ngcontent-%COMP%]:before {\n  content: \"\\ea7c\";\n}\n.vitamui-icon-chevron-left[_ngcontent-%COMP%]:before {\n  content: \"\\ea7d\";\n}\n.vitamui-icon-chevron-up[_ngcontent-%COMP%]:before {\n  content: \"\\ea7e\";\n}\n.vitamui-icon-chevron-up-1[_ngcontent-%COMP%]:before {\n  content: \"\\ea7f\";\n}\n.vitamui-icon-client-proprietaire[_ngcontent-%COMP%]:before {\n  content: \"\\ea82\";\n}\n.vitamui-icon-close[_ngcontent-%COMP%]:before {\n  content: \"\\ea83\";\n}\n.vitamui-icon-comment[_ngcontent-%COMP%]:before {\n  content: \"\\ea86\";\n}\n.vitamui-icon-consultation-produit[_ngcontent-%COMP%]:before {\n  content: \"\\ea87\";\n}\n.vitamui-icon-content-copy[_ngcontent-%COMP%]:before {\n  content: \"\\ea88\";\n}\n.vitamui-icon-delete[_ngcontent-%COMP%]:before {\n  content: \"\\ea8a\";\n}\n.vitamui-icon-desktop[_ngcontent-%COMP%]:before {\n  content: \"\\ea8c\";\n}\n.vitamui-icon-document-seriel[_ngcontent-%COMP%]:before {\n  content: \"\\ea8d\";\n}\n.vitamui-icon-done[_ngcontent-%COMP%]:before {\n  content: \"\\ea95\";\n}\n.vitamui-icon-dossier-fichier[_ngcontent-%COMP%]:before {\n  content: \"\\ea98\";\n}\n.vitamui-icon-dossier-solidaire[_ngcontent-%COMP%]:before {\n  content: \"\\ea9e\";\n}\n.vitamui-icon-edit[_ngcontent-%COMP%]:before {\n  content: \"\\ea9f\";\n}\n.vitamui-icon-Edition[_ngcontent-%COMP%]:before {\n  content: \"\\eaa0\";\n}\n.vitamui-icon-edit-off[_ngcontent-%COMP%]:before {\n  content: \"\\eaa1\";\n}\n.vitamui-icon-entree[_ngcontent-%COMP%]:before {\n  content: \"\\eaa2\";\n}\n.vitamui-icon-filter-list[_ngcontent-%COMP%]:before {\n  content: \"\\eaa6\";\n}\n.vitamui-icon-flux-industriel-refus[_ngcontent-%COMP%]   .path1[_ngcontent-%COMP%]:before {\n  content: \"\\e985\";\n  color: #757575;\n}\n.vitamui-icon-flux-industriel-refus[_ngcontent-%COMP%]   .path2[_ngcontent-%COMP%]:before {\n  content: \"\\e986\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-flux-industriel-refus[_ngcontent-%COMP%]   .path3[_ngcontent-%COMP%]:before {\n  content: \"\\e987\";\n  margin-left: -1em;\n  color: #616161;\n}\n.vitamui-icon-flux-industriel-refus[_ngcontent-%COMP%]   .path4[_ngcontent-%COMP%]:before {\n  content: \"\\e988\";\n  margin-left: -1em;\n  color: white;\n}\n.vitamui-icon-flux-industriel-refus[_ngcontent-%COMP%]   .path5[_ngcontent-%COMP%]:before {\n  content: \"\\e989\";\n  margin-left: -1em;\n  color: white;\n}\n.vitamui-icon-flux-manuel-refus[_ngcontent-%COMP%]   .path1[_ngcontent-%COMP%]:before {\n  content: \"\\e98a\";\n  color: #757575;\n}\n.vitamui-icon-flux-manuel-refus[_ngcontent-%COMP%]   .path2[_ngcontent-%COMP%]:before {\n  content: \"\\e98b\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-flux-manuel-refus[_ngcontent-%COMP%]   .path3[_ngcontent-%COMP%]:before {\n  content: \"\\e98c\";\n  margin-left: -1em;\n  color: #757575;\n}\n.vitamui-icon-flux-manuel-refus[_ngcontent-%COMP%]   .path4[_ngcontent-%COMP%]:before {\n  content: \"\\e98d\";\n  margin-left: -1em;\n  color: #616161;\n}\n.vitamui-icon-flux-manuel-refus[_ngcontent-%COMP%]   .path5[_ngcontent-%COMP%]:before {\n  content: \"\\e98e\";\n  margin-left: -1em;\n  color: white;\n}\n.vitamui-icon-flux-manuel-refus[_ngcontent-%COMP%]   .path6[_ngcontent-%COMP%]:before {\n  content: \"\\e98f\";\n  margin-left: -1em;\n  color: white;\n}\n.vitamui-icon-gele[_ngcontent-%COMP%]:before {\n  content: \"\\eac1\";\n}\n.vitamui-icon-gestion-profil[_ngcontent-%COMP%]:before {\n  content: \"\\eac2\";\n}\n.vitamui-icon-home[_ngcontent-%COMP%]:before {\n  content: \"\\eac4\";\n}\n.vitamui-icon-home-add[_ngcontent-%COMP%]:before {\n  content: \"\\eac5\";\n}\n.vitamui-icon-import-export[_ngcontent-%COMP%]:before {\n  content: \"\\eaca\";\n}\n.vitamui-icon-info[_ngcontent-%COMP%]:before {\n  content: \"\\eacb\";\n}\n.vitamui-icon-lock-open[_ngcontent-%COMP%]:before {\n  content: \"\\eacc\";\n}\n.vitamui-icon-more-horiz[_ngcontent-%COMP%]:before {\n  content: \"\\eacd\";\n}\n.vitamui-icon-more-vert[_ngcontent-%COMP%]:before {\n  content: \"\\eace\";\n}\n.vitamui-icon-notifications[_ngcontent-%COMP%]:before {\n  content: \"\\eacf\";\n}\n.vitamui-icon-pause[_ngcontent-%COMP%]:before {\n  content: \"\\ead1\";\n}\n.vitamui-icon-phone[_ngcontent-%COMP%]:before {\n  content: \"\\ead8\";\n}\n.vitamui-icon-picking[_ngcontent-%COMP%]:before {\n  content: \"\\ead9\";\n}\n.vitamui-icon-plan-classement[_ngcontent-%COMP%]:before {\n  content: \"\\eada\";\n}\n.vitamui-icon-position[_ngcontent-%COMP%]:before {\n  content: \"\\eadc\";\n}\n.vitamui-icon-print[_ngcontent-%COMP%]:before {\n  content: \"\\eadf\";\n}\n.vitamui-icon-Rangement-Dplacement[_ngcontent-%COMP%]:before {\n  content: \"\\eae3\";\n}\n.vitamui-icon-recherche-postee[_ngcontent-%COMP%]:before {\n  content: \"\\eae4\";\n}\n.vitamui-icon-Regroupement[_ngcontent-%COMP%]:before {\n  content: \"\\eae5\";\n}\n.vitamui-icon-remove[_ngcontent-%COMP%]:before {\n  content: \"\\eae6\";\n}\n.vitamui-icon-repeat[_ngcontent-%COMP%]:before {\n  content: \"\\eae7\";\n}\n.vitamui-icon-salle[_ngcontent-%COMP%]:before {\n  content: \"\\eae8\";\n}\n.vitamui-icon-scanner[_ngcontent-%COMP%]:before {\n  content: \"\\eaec\";\n}\n.vitamui-icon-search[_ngcontent-%COMP%]:before {\n  content: \"\\eaed\";\n}\n.vitamui-icon-serie[_ngcontent-%COMP%]:before {\n  content: \"\\eaee\";\n}\n.vitamui-icon-settings[_ngcontent-%COMP%]:before {\n  content: \"\\eaf2\";\n}\n.vitamui-icon-share[_ngcontent-%COMP%]:before {\n  content: \"\\eaf3\";\n}\n.vitamui-icon-site[_ngcontent-%COMP%]:before {\n  content: \"\\eaf4\";\n}\n.vitamui-icon-Sortie-massive[_ngcontent-%COMP%]:before {\n  content: \"\\eaf5\";\n}\n.vitamui-icon-telecharger[_ngcontent-%COMP%]:before {\n  content: \"\\eaf9\";\n}\n.vitamui-icon-tenant-add[_ngcontent-%COMP%]:before {\n  content: \"\\eafb\";\n}\n.vitamui-icon-tenant-proprietaire[_ngcontent-%COMP%]:before {\n  content: \"\\eb02\";\n}\n.vitamui-icon-transfert[_ngcontent-%COMP%]:before {\n  content: \"\\eb03\";\n}\n.vitamui-icon-Transfert-intersite[_ngcontent-%COMP%]:before {\n  content: \"\\eb04\";\n}\n.vitamui-icon-type-archives[_ngcontent-%COMP%]:before {\n  content: \"\\eb09\";\n}\n.vitamui-icon-unfold-more[_ngcontent-%COMP%]:before {\n  content: \"\\eb19\";\n}\n.vitamui-icon-Utilisateur-attribuer[_ngcontent-%COMP%]:before {\n  content: \"\\eb1a\";\n}\n.vitamui-icon-Vrification-de-contenu[_ngcontent-%COMP%]:before {\n  content: \"\\eb1f\";\n}\n.vitamui-icon-versement[_ngcontent-%COMP%]:before {\n  content: \"\\eb20\";\n}\n.vitamui-icon-visibility[_ngcontent-%COMP%]:before {\n  content: \"\\eb24\";\n}\n.vitamui-icon-workflow[_ngcontent-%COMP%]:before {\n  content: \"\\eb25\";\n}\n.vitamui-icon-apps-colored[_ngcontent-%COMP%]   .path1[_ngcontent-%COMP%]:before {\n  content: \"\\e955\";\n  color: black;\n}\n.vitamui-icon-apps-colored[_ngcontent-%COMP%]   .path2[_ngcontent-%COMP%]:before {\n  content: \"\\e956\";\n  margin-left: -1em;\n  color: black;\n}\n.vitamui-icon-apps-colored[_ngcontent-%COMP%]   .path3[_ngcontent-%COMP%]:before {\n  content: \"\\e957\";\n  margin-left: -1em;\n  color: black;\n}\n.vitamui-icon-apps-colored[_ngcontent-%COMP%]   .path4[_ngcontent-%COMP%]:before {\n  content: \"\\e958\";\n  margin-left: -1em;\n  color: red;\n}\n.vitamui-icon-apps-colored[_ngcontent-%COMP%]   .path5[_ngcontent-%COMP%]:before {\n  content: \"\\e959\";\n  margin-left: -1em;\n  color: red;\n}\n.vitamui-icon-apps-colored[_ngcontent-%COMP%]   .path6[_ngcontent-%COMP%]:before {\n  content: \"\\e95a\";\n  margin-left: -1em;\n  color: red;\n}\n.vitamui-icon-apps-colored[_ngcontent-%COMP%]   .path7[_ngcontent-%COMP%]:before {\n  content: \"\\e95b\";\n  margin-left: -1em;\n  color: pink;\n}\n.vitamui-icon-apps-colored[_ngcontent-%COMP%]   .path8[_ngcontent-%COMP%]:before {\n  content: \"\\e95c\";\n  margin-left: -1em;\n  color: pink;\n}\n.vitamui-icon-apps-colored[_ngcontent-%COMP%]   .path9[_ngcontent-%COMP%]:before {\n  content: \"\\e95d\";\n  margin-left: -1em;\n  color: pink;\n}\n.vitamui-icon-barcode[_ngcontent-%COMP%]:before {\n  content: \"\\e954\";\n}\n.vitamui-icon-rack[_ngcontent-%COMP%]:before {\n  content: \"\\e952\";\n}\n.vitamui-icon-room[_ngcontent-%COMP%]:before {\n  content: \"\\e953\";\n}\n.vitamui-icon-folder-full[_ngcontent-%COMP%]:before {\n  content: \"\\e94f\";\n}\n.vitamui-icon-folder-with-file[_ngcontent-%COMP%]:before {\n  content: \"\\e950\";\n}\n.vitamui-icon-document-layers[_ngcontent-%COMP%]:before {\n  content: \"\\e94c\";\n}\n.vitamui-icon-file-cog-middle[_ngcontent-%COMP%]:before {\n  content: \"\\e94d\";\n}\n.vitamui-icon-file-cog-up[_ngcontent-%COMP%]:before {\n  content: \"\\e94e\";\n}\n.vitamui-icon-api-supervision[_ngcontent-%COMP%]:before {\n  content: \"\\e94b\";\n}\n.vitamui-icon-truck[_ngcontent-%COMP%]:before {\n  content: \"\\e94a\";\n}\n.vitamui-icon-physical-big-box[_ngcontent-%COMP%]:before {\n  content: \"\\e948\";\n}\n.vitamui-icon-physical-big-box-content[_ngcontent-%COMP%]:before {\n  content: \"\\e947\";\n}\n.vitamui-icon-physical-small-box[_ngcontent-%COMP%]:before {\n  content: \"\\e949\";\n}\n.vitamui-icon-physical-small-box-content[_ngcontent-%COMP%]:before {\n  content: \"\\e940\";\n}\n.vitamui-icon-folder[_ngcontent-%COMP%]:before {\n  content: \"\\e925\";\n}\n.vitamui-icon-folder-content[_ngcontent-%COMP%]:before {\n  content: \"\\e946\";\n}\n.vitamui-icon-archive-ingest[_ngcontent-%COMP%]:before {\n  content: \"\\e945\";\n}\n.vitamui-icon-tree-arrow[_ngcontent-%COMP%]:before {\n  content: \"\\e944\";\n}\n.vitamui-icon-tree-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e942\";\n}\n.vitamui-icon-tree-minus[_ngcontent-%COMP%]:before {\n  content: \"\\e943\";\n}\n.vitamui-icon-item[_ngcontent-%COMP%]:before {\n  content: \"\\e941\";\n}\n.vitamui-icon-circle-chevron[_ngcontent-%COMP%]:before {\n  content: \"\\e93f\";\n}\n.vitamui-icon-checklist-pen[_ngcontent-%COMP%]:before {\n  content: \"\\e93e\";\n}\n.vitamui-icon-gear[_ngcontent-%COMP%]:before {\n  content: \"\\e93d\";\n}\n.vitamui-icon-electronic-folder[_ngcontent-%COMP%]:before {\n  content: \"\\e93c\";\n}\n.vitamui-icon-electronic-file[_ngcontent-%COMP%]:before {\n  content: \"\\e93b\";\n}\n.vitamui-icon-support-check-list[_ngcontent-%COMP%]:before {\n  content: \"\\e938\";\n}\n.vitamui-icon-admin-check-list[_ngcontent-%COMP%]:before {\n  content: \"\\e939\";\n}\n.vitamui-icon-user-board[_ngcontent-%COMP%]:before {\n  content: \"\\e93a\";\n}\n.vitamui-icon-layer[_ngcontent-%COMP%]:before {\n  content: \"\\e935\";\n}\n.vitamui-icon-layers[_ngcontent-%COMP%]:before {\n  content: \"\\e936\";\n}\n.vitamui-icon-info-circle[_ngcontent-%COMP%]:before {\n  content: \"\\e937\";\n}\n.vitamui-icon-danger[_ngcontent-%COMP%]:before {\n  content: \"\\e932\";\n}\n.vitamui-icon-lock[_ngcontent-%COMP%]:before {\n  content: \"\\e933\";\n}\n.vitamui-icon-refresh[_ngcontent-%COMP%]:before {\n  content: \"\\e934\";\n}\n.vitamui-icon-cycle-gear[_ngcontent-%COMP%]:before {\n  content: \"\\e931\";\n}\n.vitamui-icon-docuware-logo[_ngcontent-%COMP%]:before {\n  content: \"\\e92f\";\n}\n.vitamui-icon-alfresco-logo[_ngcontent-%COMP%]:before {\n  content: \"\\e930\";\n}\n.vitamui-icon-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e92e\";\n}\n.vitamui-icon-chevron-right[_ngcontent-%COMP%]:before {\n  content: \"\\e92c\";\n}\n.vitamui-icon-chevron-right-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e92d\";\n}\n.vitamui-icon-user-key-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e92a\";\n}\n.vitamui-icon-user-key[_ngcontent-%COMP%]:before {\n  content: \"\\e92b\";\n}\n.vitamui-icon-exclamation-point[_ngcontent-%COMP%]:before {\n  content: \"\\e922\";\n}\n.vitamui-icon-file[_ngcontent-%COMP%]:before {\n  content: \"\\e926\";\n}\n.vitamui-icon-download[_ngcontent-%COMP%]:before {\n  content: \"\\e929\";\n}\n.vitamui-icon-safe-key-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e905\";\n}\n.vitamui-icon-admin-key-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e91b\";\n}\n.vitamui-icon-keys-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e921\";\n}\n.vitamui-icon-filing[_ngcontent-%COMP%]:before {\n  content: \"\\e923\";\n}\n.vitamui-icon-basket[_ngcontent-%COMP%]:before {\n  content: \"\\e924\";\n}\n.vitamui-icon-support-box[_ngcontent-%COMP%]:before {\n  content: \"\\e927\";\n}\n.vitamui-icon-admin-box[_ngcontent-%COMP%]:before {\n  content: \"\\e928\";\n}\n.vitamui-icon-triangle[_ngcontent-%COMP%]:before {\n  content: \"\\e920\";\n}\n.vitamui-icon-box[_ngcontent-%COMP%]:before {\n  content: \"\\e91f\";\n}\n.vitamui-icon-box-arrow[_ngcontent-%COMP%]:before {\n  content: \"\\e91a\";\n}\n.vitamui-icon-box-hand[_ngcontent-%COMP%]:before {\n  content: \"\\e91d\";\n}\n.vitamui-icon-box-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e91e\";\n}\n.vitamui-icon-user[_ngcontent-%COMP%]:before {\n  content: \"\\e90b\";\n}\n.vitamui-icon-user-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e919\";\n}\n.vitamui-icon-pin[_ngcontent-%COMP%]:before {\n  content: \"\\e90f\";\n}\n.vitamui-icon-bank-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e911\";\n}\n.vitamui-icon-key-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e918\";\n}\n.vitamui-icon-safe-plus[_ngcontent-%COMP%]:before {\n  content: \"\\e913\";\n}\n.vitamui-icon-key[_ngcontent-%COMP%]:before {\n  content: \"\\e914\";\n}\n.vitamui-icon-safe[_ngcontent-%COMP%]:before {\n  content: \"\\e915\";\n}\n.vitamui-icon-safe-gear[_ngcontent-%COMP%]:before {\n  content: \"\\e917\";\n}\n.vitamui-icon-light-bulb[_ngcontent-%COMP%]:before {\n  content: \"\\e90e\";\n}\n.vitamui-icon-link[_ngcontent-%COMP%]:before {\n  content: \"\\e901\";\n}\n.vitamui-icon-box-gear[_ngcontent-%COMP%]:before {\n  content: \"\\e902\";\n}\n.vitamui-icon-safe-key[_ngcontent-%COMP%]:before {\n  content: \"\\e906\";\n}\n.vitamui-icon-board[_ngcontent-%COMP%]:before {\n  content: \"\\e907\";\n}\n.vitamui-icon-deposit[_ngcontent-%COMP%]:before {\n  content: \"\\e908\";\n}\n.vitamui-icon-box-check[_ngcontent-%COMP%]:before {\n  content: \"\\e90a\";\n}\n.vitamui-icon-question-mark[_ngcontent-%COMP%]:before {\n  content: \"\\e90c\";\n}\n.vitamui-icon-user-keys[_ngcontent-%COMP%]:before {\n  content: \"\\e900\";\n}\n.vitamui-icon-admin-key[_ngcontent-%COMP%]:before {\n  content: \"\\e903\";\n}\n.vitamui-icon-bank[_ngcontent-%COMP%]:before {\n  content: \"\\e904\";\n}\n.vitamui-icon-keys[_ngcontent-%COMP%]:before {\n  content: \"\\e909\";\n}\n.vitamui-icon-link-key[_ngcontent-%COMP%]:before {\n  content: \"\\e90d\";\n}\n.vitamui-icon-return-box[_ngcontent-%COMP%]:before {\n  content: \"\\e910\";\n}\n.vitamui-icon-safe-search[_ngcontent-%COMP%]:before {\n  content: \"\\e912\";\n}\n.vitamui-icon-search-safe[_ngcontent-%COMP%]:before {\n  content: \"\\e916\";\n}\n.vitamui-icon-support-keys[_ngcontent-%COMP%]:before {\n  content: \"\\e91c\";\n}\n.vitamui-icon-cross[_ngcontent-%COMP%]:before {\n  content: \"\\ea0f\";\n}\n.vitamui-icon-archive-room[_ngcontent-%COMP%]:before {\n  content: \"\\e951\";\n}\n.vitamui-icon-loop2[_ngcontent-%COMP%]:before {\n  content: \"\\ea2e\";\n}\n.vitamui-icon-radio-checked[_ngcontent-%COMP%]:before {\n  content: \"\\ea78\";\n}\n.vitamui-icon-clock[_ngcontent-%COMP%]:before {\n  content: \"\\e976\";\n}\n.pastis-vitamui-option-container[_ngcontent-%COMP%] {\n  margin-top: 40px;\n  margin-left: 40px;\n  width: 200px;\n  height: 50px;\n  position: absolute;\n  background: #ffffff;\n  border: 1px solid #bdbdbd;\n  box-sizing: border-box;\n  border-radius: 10px;\n}\n  .mat-drawer-container {\n  height: -moz-fit-content;\n  height: fit-content;\n  overflow: initial;\n}\n  .vitamui-spinner.mat-progress-spinner circle, .vitamui-spinner[_ngcontent-%COMP%]   .mat-spinner[_ngcontent-%COMP%]   circle[_ngcontent-%COMP%] {\n  stroke: var(--vitamui-primary) !important;\n}\n.steackhouse[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  right: 50%;\n  top: 30%;\n  z-index: 1000;\n}\n  .modifierToolTip {\n  display: flex;\n  flex-direction: row;\n  justify-content: center;\n  align-items: center;\n  padding: 0;\n  background: var(--vitamui-primary);\n  font-family: Mulish, sans-serif;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  filter: drop-shadow(0px 0px 2px rgba(112, 35, 130, 0.4)) drop-shadow(0px 1px 4px rgba(112, 35, 130, 0.2));\n}\npastis-popup-option[_ngcontent-%COMP%] {\n  margin-right: 200px;\n  padding-left: 50px;\n}\n.btn-search[_ngcontent-%COMP%] {\n  margin-left: -40px;\n  vertical-align: middle;\n}\n.total-pa-pua-card[_ngcontent-%COMP%], .total-profile-card[_ngcontent-%COMP%], .pa-pua-card[_ngcontent-%COMP%] {\n  display: inline-block;\n  flex-direction: column;\n  align-items: flex-start;\n  padding: 0;\n  position: static;\n  width: 123px;\n  height: 69px;\n  margin: 0 10px;\n  margin-left: 0;\n}\n.profile-label[_ngcontent-%COMP%], .total-profile-label[_ngcontent-%COMP%], .pa-pua-label[_ngcontent-%COMP%] {\n  position: static;\n  width: 93px;\n  height: 16px;\n  left: calc(50% - 93px / 2);\n  flex: none;\n  order: 0;\n  align-self: stretch;\n  flex-grow: 0;\n  margin-left: 15px;\n  margin-top: 10px;\n  margin-bottom: 0;\n}\n.profile-num-label[_ngcontent-%COMP%], .total-profilenum-label[_ngcontent-%COMP%], .pa-pua-num-label[_ngcontent-%COMP%] {\n  position: static;\n  width: 37px;\n  height: 28px;\n  left: calc(50% - 37px / 2 - 28px);\n  bottom: 10px;\n  margin-left: 15px;\n  margin-bottom: 10px;\n  margin-top: 5px;\n}"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](ListProfileComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                // tslint:disable-next-line:component-selector
                selector: 'pastis-list-profile',
                templateUrl: './list-profile.component.html',
                styleUrls: ['./list-profile.component.scss'],
            }]
    }], function () { return [{ type: _core_services_profile_service__WEBPACK_IMPORTED_MODULE_11__["ProfileService"] }, { type: _core_services_notice_service__WEBPACK_IMPORTED_MODULE_10__["NoticeService"] }, { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"] }, { type: _angular_material_dialog__WEBPACK_IMPORTED_MODULE_2__["MatDialog"] }, { type: ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["StartupService"] }, { type: _core_classes_pastis_configuration__WEBPACK_IMPORTED_MODULE_9__["PastisConfiguration"] }, { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"] }, { type: ui_frontend_common__WEBPACK_IMPORTED_MODULE_7__["GlobalEventService"] }, { type: _shared_data_generique_popup_service__WEBPACK_IMPORTED_MODULE_13__["DataGeneriquePopupService"] }, { type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__["TranslateService"] }, { type: _core_services_toggle_sidenav_service__WEBPACK_IMPORTED_MODULE_12__["ToggleSidenavService"] }]; }, { profileInformationTabComponent: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"],
            args: [_profile_preview_profile_information_tab_profile_information_tab_profile_information_tab_component__WEBPACK_IMPORTED_MODULE_15__["ProfileInformationTabComponent"], { static: true }]
        }], uploader: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }] }); })();


/***/ }),

/***/ "4roS":
/*!**************************************************************!*\
  !*** ./src/app/core/services/archive-profile-api.service.ts ***!
  \**************************************************************/
/*! exports provided: ArchiveProfileApiService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ArchiveProfileApiService", function() { return ArchiveProfileApiService; });
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/common/http */ "vobO");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "EM62");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ "0Wlh");
/* harmony import */ var ui_frontend_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ui-frontend-common */ "OWX3");
/* harmony import */ var _classes_pastis_configuration__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../classes/pastis-configuration */ "GFJK");
/*
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */








const HTTP_STATUS_OK = 200;
class ArchiveProfileApiService extends ui_frontend_common__WEBPACK_IMPORTED_MODULE_3__["BaseHttpClient"] {
    // @ts-ignore
    constructor(http, baseUrl, pastisConfig) {
        // console.log('passage dans service archive API');
        super(http, baseUrl);
        this.pastisConfig = pastisConfig;
    }
    getAllByParams(params, headers) {
        return super.getAllByParams(params, headers);
    }
    getAllPaginated(pageRequest, embedded, headers) {
        return super.getAllPaginated(pageRequest, embedded, headers);
    }
    getOne(id, headers) {
        return super.getOne(id, headers);
    }
    download(id, headers) {
        return super.getHttp().get(super.getApiUrl() + this.pastisConfig.downloadProfile + '/' + id, { responseType: 'blob', headers });
    }
    uploadProfileArchivageFile(id, profile, headers) {
        return super
            .getHttp()
            .put(this.apiUrl + this.pastisConfig.importProfileInExistingNotice + '/' + id, profile, { responseType: 'json', headers });
    }
    updateProfilePa(profile, headers) {
        profile.path = null;
        return this.http.put(this.apiUrl + this.pastisConfig.archiveProfileApiPath + '/' + profile.id, profile, { headers });
    }
    patch(partialAgency, headers) {
        return super.patch(partialAgency, headers);
    }
    create(profile, headers) {
        return this.http.post(this.apiUrl + this.pastisConfig.archiveProfileApiPath + '/', profile, { headers });
    }
    check(profile, headers) {
        return super
            .getHttp()
            .post(super.getApiUrl() + this.pastisConfig.archiveProfileApiPath + '/check', profile, {
            observe: 'response',
            headers,
        })
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_2__["map"])((response) => response.status === HTTP_STATUS_OK));
    }
    delete(id, headers) {
        return super.getHttp().delete(super.getApiUrl() + '/' + id, { headers });
    }
}
ArchiveProfileApiService.ɵfac = function ArchiveProfileApiService_Factory(t) { return new (t || ArchiveProfileApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClient"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](ui_frontend_common__WEBPACK_IMPORTED_MODULE_3__["BASE_URL"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_classes_pastis_configuration__WEBPACK_IMPORTED_MODULE_4__["PastisConfiguration"])); };
ArchiveProfileApiService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: ArchiveProfileApiService, factory: ArchiveProfileApiService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](ArchiveProfileApiService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"],
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: _angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClient"] }, { type: undefined, decorators: [{
                type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"],
                args: [ui_frontend_common__WEBPACK_IMPORTED_MODULE_3__["BASE_URL"]]
            }] }, { type: _classes_pastis_configuration__WEBPACK_IMPORTED_MODULE_4__["PastisConfiguration"] }]; }, null); })();


/***/ }),

/***/ "5Qc/":
/*!********************************************************************************************!*\
  !*** ./src/app/profile/edit-profile/file-tree-metadata/attributes/attributes.component.ts ***!
  \********************************************************************************************/
/*! exports provided: AttributesPopupComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AttributesPopupComponent", function() { return AttributesPopupComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "EM62");
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/material/dialog */ "OZ4H");
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material/table */ "FlRo");
/* harmony import */ var projects_pastis_src_app_core_services_file_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! projects/pastis/src/app/core/services/file.service */ "sINK");
/* harmony import */ var projects_pastis_src_app_core_services_popup_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! projects/pastis/src/app/core/services/popup.service */ "HxGl");
/* harmony import */ var projects_pastis_src_app_core_services_seda_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! projects/pastis/src/app/core/services/seda.service */ "1Nv8");
/* harmony import */ var projects_pastis_src_app_shared_pastis_popup_metadata_language_pastis_popup_metadata_language_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! projects/pastis/src/app/shared/pastis-popup-metadata-language/pastis-popup-metadata-language.service */ "FUaJ");
/* harmony import */ var _models_file_node__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../models/file-node */ "HKpZ");
/* harmony import */ var _file_tree_metadata_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../file-tree-metadata.service */ "8wO3");
/* harmony import */ var _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/checkbox */ "+Tre");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/forms */ "nIj0");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/common */ "2kYt");
/* harmony import */ var _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/tooltip */ "Y2X+");
/* harmony import */ var ui_frontend_common__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ui-frontend-common */ "OWX3");
/* harmony import */ var _angular_material_select__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/select */ "R7+U");
/* harmony import */ var _angular_material_core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/material/core */ "mFH5");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @ngx-translate/core */ "s2Ay");
/*
Copyright © CINES - Centre Informatique National pour l'Enseignement Supérieur (2020)

[dad@cines.fr]

This software is a computer program whose purpose is to provide
a web application to create, edit, import and export archive
profiles based on the french SEDA standard
(https://redirect.francearchives.fr/seda/).


This software is governed by the CeCILL-C  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL-C
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C license and that you accept its terms.
*/

























function AttributesPopupComponent_th_3_Template(rf, ctx) { if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-checkbox", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function AttributesPopupComponent_th_3_Template_mat_checkbox_change_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r11); const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r10.toggleAllAttributes($event); })("click", function AttributesPopupComponent_th_3_Template_mat_checkbox_click_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r11); return $event.stopPropagation(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "\u00A0");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.isChecked());
} }
const _c0 = function (a0) { return { "mat-checkbox-checkmark-path": a0 }; };
function AttributesPopupComponent_td_4_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-checkbox", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngModelChange", function AttributesPopupComponent_td_4_Template_mat_checkbox_ngModelChange_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r16); const element_r13 = ctx.$implicit; return element_r13.selected = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r13 = ctx.$implicit;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngModel", element_r13.selected)("disabled", ctx_r1.isSedaObligatory(element_r13))("ngStyle", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](3, _c0, ctx_r1.isSedaObligatory(element_r13) ? "grey" : ""));
} }
function AttributesPopupComponent_th_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "PROFILE.EDIT_PROFILE.FILE_TREE_METADATA.ATTRIBUTS.NOM_ATTRIBUT"), " ");
} }
function AttributesPopupComponent_td_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r17 = ctx.$implicit;
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("matTooltip", ctx_r3.getSedaDefinition(element_r17.nomDuChamp));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx_r3.onResolveName(element_r17.nomDuChamp), " ");
} }
function AttributesPopupComponent_th_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "PROFILE.EDIT_PROFILE.FILE_TREE_METADATA.ATTRIBUTS.VALEUR_FIXE"), " ");
} }
function AttributesPopupComponent_td_10_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    const _r26 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "vitamui-common-editable-textarea", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngModelChange", function AttributesPopupComponent_td_10_ng_container_2_Template_vitamui_common_editable_textarea_ngModelChange_2_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r26); const element_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit; return element_r18.valeurFixe = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const element_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngModel", element_r18.valeurFixe)("maxlength", 120);
} }
function AttributesPopupComponent_td_10_ng_container_3_mat_option_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "mat-option", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "mat-checkbox", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const val_r29 = ctx.$implicit;
    const i_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2).index;
    const ctx_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", val_r29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", val_r29, "> ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r28.selected === i_r19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", val_r29, " ");
} }
function AttributesPopupComponent_td_10_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    const _r33 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-select", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngModelChange", function AttributesPopupComponent_td_10_ng_container_3_Template_mat_select_ngModelChange_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r33); const element_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit; return element_r18.valeurFixe = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](2, "mat-option", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, AttributesPopupComponent_td_10_ng_container_3_mat_option_3_Template, 4, 4, "mat-option", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const element_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngModel", element_r18.valeurFixe);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", element_r18.enumeration);
} }
function AttributesPopupComponent_td_10_ng_template_4_Template(rf, ctx) { }
function AttributesPopupComponent_td_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](1, 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, AttributesPopupComponent_td_10_ng_container_2_Template, 3, 2, "ng-container", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, AttributesPopupComponent_td_10_ng_container_3_Template, 4, 2, "ng-container", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, AttributesPopupComponent_td_10_ng_template_4_Template, 0, 0, "ng-template", null, 27, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r18 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngSwitch", ctx_r5.getAttributeInputType(element_r18));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngSwitchCase", "enumeration");
} }
function AttributesPopupComponent_th_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, "PROFILE.EDIT_PROFILE.FILE_TREE_METADATA.ATTRIBUTS.COMMENTAIRE"), " ");
} }
function AttributesPopupComponent_td_13_Template(rf, ctx) { if (rf & 1) {
    const _r38 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "vitamui-common-editable-textarea", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngModelChange", function AttributesPopupComponent_td_13_Template_vitamui_common_editable_textarea_ngModelChange_2_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r38); const element_r35 = ctx.$implicit; const ctx_r37 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r37.setElementComment(element_r35.nomDuChamp, $event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r35 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("maxlength", 120)("ngModel", element_r35.commentaire);
} }
function AttributesPopupComponent_tr_14_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "tr", 36);
} }
function AttributesPopupComponent_tr_15_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "tr", 37);
} }
class AttributesPopupComponent {
    constructor(dialogRef, dialogReceivedData, sedaService, fileService, fileTreeMetadataService, popUpService, sedaLanguageService) {
        this.dialogRef = dialogRef;
        this.dialogReceivedData = dialogReceivedData;
        this.sedaService = sedaService;
        this.fileService = fileService;
        this.fileTreeMetadataService = fileTreeMetadataService;
        this.popUpService = popUpService;
        this.sedaLanguageService = sedaLanguageService;
        this.displayedColumns = ['selected', 'nomDuChamp', 'valeurFixe', 'commentaire'];
        this.selected = -1;
    }
    ngOnInit() {
        this.sedaLanguageSub = this.sedaLanguageService.sedaLanguage.subscribe((value) => {
            this.sedaLanguage = value;
        }, (error) => {
            console.log(error);
        });
        this.fileService.currentTree.subscribe((fileTree) => {
            if (fileTree) {
                this.parentFileNode = fileTree[0];
            }
        });
        this.matDataSource = this.getDataSource(this.dialogReceivedData.fileNode.sedaData, this.dialogReceivedData.fileNode);
        this.initAttributeCardinality();
        // Subscribe any datasource change to setPopUpDataOnClose
        setTimeout(() => {
            this.popUpService.setPopUpDataOnClose(this.matDataSource.data);
        }, 50);
    }
    // Checks if a file node has an atttribute child
    initAttributeCardinality() {
        // tslint:disable-next-line:forin
        for (const index in this.matDataSource.data) {
            const fileNode = this.dialogReceivedData.fileNode;
            const att = this.matDataSource.data[index];
            const attSedaData = fileNode.sedaData.Children.find((child) => child.Name === att.nomDuChamp);
            if (attSedaData.Cardinality === _models_file_node__WEBPACK_IMPORTED_MODULE_7__["CardinalityConstants"].Obligatoire) {
                this.matDataSource.data[index].selected = true;
            }
            else {
                this.matDataSource.data[index].selected = att.selected;
            }
        }
    }
    setElementComment(elementName, newComment) {
        for (const idx in this.matDataSource.data) {
            if (this.matDataSource.data[idx].nomDuChamp === elementName) {
                this.matDataSource.data[idx].commentaire = newComment;
            }
        }
        // console.log('ParentFileNode : ', this.parentFileNode);
        for (const node of this.parentFileNode.children) {
            if (node.name === elementName) {
                node.documentation = newComment;
            }
        }
    }
    setElementValue(elementName, newValue) {
        for (const idx in this.matDataSource.data) {
            if (this.matDataSource.data[idx].nomDuChamp === elementName) {
                this.matDataSource.data[idx].valeurFixe = newValue;
            }
        }
        for (const node of this.parentFileNode.children) {
            if (node.name === elementName) {
                node.value = newValue;
            }
        }
    }
    /**
     * Function that computes the "checked" state of the "select all" checkbox
     * If all checkboxs are checked, then the "select all" checkbox is checked
     */
    isChecked() {
        return this.matDataSource.data.filter((a) => !a.selected).length === 0;
    }
    isSedaObligatory(attribute) {
        if (attribute) {
            const popUpData = this.popUpService.getPopUpDataOnOpen();
            if (popUpData) {
                const popSendSedaNodeFilted = popUpData.fileNode.sedaData.Children.find((child) => child.Name === attribute.nomDuChamp);
                return popSendSedaNodeFilted.Cardinality.startsWith('1');
            }
        }
        return;
    }
    toggleAllAttributes(toggleAllCheckChange) {
        const istoggleAllChecked = toggleAllCheckChange.checked;
        this.matDataSource.data.forEach((a) => {
            this.isSedaObligatory(a) ? (a.selected = true) : (a.selected = istoggleAllChecked);
            a.selectedCardinality = '1';
        });
    }
    toggleAttribute(change, elementName) {
        const element = this.matDataSource.data.find((a) => a.nomDuChamp === elementName);
        element.selected = change.checked;
    }
    /**
     * Returns the modified FileNode from the popup
     *
     * It parses the datasource of the DataTable to collect the attributes
     * and add them to the modified FileNode
     */
    getFileNodeFromPopup() {
        // We get the original FileNode that was passed to the popup
        const fileNode = this.dialogReceivedData.fileNode;
        this.fileService.deleteAllAttributes(fileNode);
        // Map all selected AttributeData to FileNode and add them as children of the fileNode
        this.matDataSource.data
            .filter((attributeData) => attributeData.selected)
            .forEach((attributeData) => {
            const attributeFileNode = {};
            attributeFileNode.id = window.crypto.getRandomValues(new Uint32Array(10))[0];
            attributeFileNode.cardinality = attributeData.selectedCardinality;
            attributeFileNode.children = [];
            attributeFileNode.dataType =
                _models_file_node__WEBPACK_IMPORTED_MODULE_7__["DataTypeConstants"][fileNode.sedaData.Children.find((child) => child.Name === attributeData.nomDuChamp).Type.toString()];
            attributeFileNode.documentation = attributeData.commentaire ? attributeData.commentaire : null;
            attributeFileNode.level = fileNode.level + 1;
            attributeFileNode.name = attributeData.nomDuChamp;
            attributeFileNode.parentId = fileNode.id;
            attributeFileNode.type = _models_file_node__WEBPACK_IMPORTED_MODULE_7__["TypeConstants"].attribute;
            attributeFileNode.value = attributeData.valeurFixe ? attributeData.valeurFixe : null;
            attributeFileNode.valueOrData = _models_file_node__WEBPACK_IMPORTED_MODULE_7__["ValueOrDataConstants"].value;
            // Add the attribute to the filenode
        });
        return fileNode;
    }
    /**
     * Get the datasource required to feed the datatable in the popup
     *
     * This datasource consists of a list of AttributeData
     *
     * @param sedaNode The seda definition of the node we want to edit
     * @param fileNode The node which we want to edit attributes
     */
    getDataSource(sedaNode, fileNode) {
        const attributeDataList = [];
        // Loop on all the attributes available for the node in the seda definition
        // Maps all the attributes node to AttributesData object
        this.sedaService.getAttributes(sedaNode, sedaNode.Collection).forEach((sedaAttribute) => {
            const attributeData = {};
            attributeData.nomDuChamp = sedaAttribute.Name;
            attributeData.type = sedaAttribute.Element;
            // Check if the attribute is already added to the current node
            const fileAttribute = fileNode.children.find((child) => child.name === attributeData.nomDuChamp);
            // let mattAttFound = this.matDataSource.data.find(att=> att.nomDuChamp === fileAttribute.name);
            if (fileAttribute) {
                // If the attribute is present in the FileNode
                // We fill in the fields with the corresponding values
                attributeData.valeurFixe = fileAttribute.value;
                attributeData.selected = true;
                attributeData.id = fileAttribute.id;
                attributeData.commentaire = fileAttribute.documentation;
                attributeData.cardinalities = this.fileTreeMetadataService.allowedCardinality.get(fileAttribute.cardinality);
                attributeData.selectedCardinality = fileAttribute.cardinality;
                attributeData.enumeration = sedaAttribute.Enumeration;
                attributeData.valeurFixe = fileAttribute.value;
            }
            else {
                // If the attribute is not present, we fill in defaults values
                attributeData.valeurFixe = null;
                attributeData.selected = false;
                attributeData.commentaire = null;
                attributeData.id = window.crypto.getRandomValues(new Uint32Array(10))[0];
                attributeData.cardinalities = this.fileTreeMetadataService.allowedCardinality.get(sedaAttribute.Cardinality);
                attributeData.selectedCardinality = null;
                attributeData.enumeration = sedaAttribute.Enumeration;
            }
            attributeDataList.push(attributeData);
        });
        // Create and return the datasource with the attribute's data
        const result = new _angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatTableDataSource"](attributeDataList);
        return result;
    }
    getAttributeInputType(element) {
        if (element.enumeration.length > 0) {
            return 'enumeration';
        }
    }
    getSedaDefinition(elementName) {
        if (this.dialogReceivedData.fileNode.sedaData) {
            for (const node of this.dialogReceivedData.fileNode.sedaData.Children) {
                if (node.Name === elementName) {
                    return node.Definition;
                }
            }
        }
        return '';
    }
    onResolveName(elementName) {
        if (this.dialogReceivedData.fileNode.sedaData) {
            for (const node of this.dialogReceivedData.fileNode.sedaData.Children) {
                if (node.Name === elementName) {
                    if (this.sedaLanguage) {
                        return node.Name;
                    }
                    else {
                        if (node.NameFr) {
                            return node.NameFr;
                        }
                        return node.Name;
                    }
                }
            }
        }
        return '';
    }
    ngOnDestroy() {
        if (this.sedaLanguageSub != null) {
            this.sedaLanguageSub.unsubscribe();
        }
    }
}
AttributesPopupComponent.ɵfac = function AttributesPopupComponent_Factory(t) { return new (t || AttributesPopupComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialogRef"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MAT_DIALOG_DATA"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](projects_pastis_src_app_core_services_seda_service__WEBPACK_IMPORTED_MODULE_5__["SedaService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](projects_pastis_src_app_core_services_file_service__WEBPACK_IMPORTED_MODULE_3__["FileService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_file_tree_metadata_service__WEBPACK_IMPORTED_MODULE_8__["FileTreeMetadataService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](projects_pastis_src_app_core_services_popup_service__WEBPACK_IMPORTED_MODULE_4__["PopupService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](projects_pastis_src_app_shared_pastis_popup_metadata_language_pastis_popup_metadata_language_service__WEBPACK_IMPORTED_MODULE_6__["PastisPopupMetadataLanguageService"])); };
AttributesPopupComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: AttributesPopupComponent, selectors: [["pastis-edit-attributes"]], decls: 16, vars: 4, consts: [[1, "table-container"], ["mat-table", "", 3, "dataSource"], ["matColumnDef", "selected"], ["class", "pastis-font-table-header col-selection", "mat-header-cell", "", 4, "matHeaderCellDef"], ["class", "pastis-metadata-table-col-large check-box", "mat-cell", "", 4, "matCellDef"], ["matColumnDef", "nomDuChamp"], ["class", "pastis-font-table-header col-nom", "mat-header-cell", "", 4, "matHeaderCellDef"], ["class", "pastis-metadata-table-col-large", "mat-cell", "", 4, "matCellDef"], ["matColumnDef", "valeurFixe"], ["class", "pastis-font-table-header pastis-col", "mat-header-cell", "", 4, "matHeaderCellDef"], ["class", "pastis-metadata-table-col-medium", "mat-cell", "", 4, "matCellDef"], ["matColumnDef", "commentaire"], ["mat-header-row", "", 4, "matHeaderRowDef", "matHeaderRowDefSticky"], ["mat-row", "", "style", "background: white", 4, "matRowDef", "matRowDefColumns"], ["mat-header-cell", "", 1, "pastis-font-table-header", "col-selection"], [3, "checked", "change", "click"], [1, "info-bulle"], ["mat-cell", "", 1, "pastis-metadata-table-col-large", "check-box"], [3, "ngModel", "disabled", "ngStyle", "ngModelChange"], ["mat-header-cell", "", 1, "pastis-font-table-header", "col-nom"], ["mat-cell", "", 1, "pastis-metadata-table-col-large"], ["matTooltipPosition", "right", 3, "ngClass", "matTooltip"], ["mat-header-cell", "", 1, "pastis-font-table-header", "pastis-col"], ["mat-cell", "", 1, "pastis-metadata-table-col-medium"], [3, "ngSwitch"], [4, "ngSwitchDefault"], [4, "ngSwitchCase"], ["simpleElement", ""], [1, "pastis-vitamui-container-editable-valeur-fixe"], [1, "valeur-fixe-pastis", 3, "ngModel", "maxlength", "ngModelChange"], ["placeholder", "Choisissez une valeur", 1, "mat-select-valeur-fixe", 3, "ngModel", "ngModelChange"], [3, "value"], [3, "value", 4, "ngFor", "ngForOf"], [3, "checked"], [1, "pastis-vitamui-container-editable-commentaire"], [1, "commentaire-pastis", 3, "maxlength", "ngModel", "ngModelChange"], ["mat-header-row", ""], ["mat-row", "", 2, "background", "white"]], template: function AttributesPopupComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "table", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](2, 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, AttributesPopupComponent_th_3_Template, 4, 1, "th", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, AttributesPopupComponent_td_4_Template, 2, 5, "td", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](5, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](6, AttributesPopupComponent_th_6_Template, 3, 3, "th", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](7, AttributesPopupComponent_td_7_Template, 3, 2, "td", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](8, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](9, AttributesPopupComponent_th_9_Template, 3, 3, "th", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](10, AttributesPopupComponent_td_10_Template, 6, 2, "td", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](11, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](12, AttributesPopupComponent_th_12_Template, 3, 3, "th", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](13, AttributesPopupComponent_td_13_Template, 3, 2, "td", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](14, AttributesPopupComponent_tr_14_Template, 1, 0, "tr", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](15, AttributesPopupComponent_tr_15_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("dataSource", ctx.matDataSource);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns)("matHeaderRowDefSticky", true);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
    } }, directives: [_angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatTable"], _angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatColumnDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatHeaderCellDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatCellDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatHeaderRowDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatRowDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatHeaderCell"], _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_9__["MatCheckbox"], _angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatCell"], _angular_forms__WEBPACK_IMPORTED_MODULE_10__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_10__["NgModel"], _angular_common__WEBPACK_IMPORTED_MODULE_11__["NgStyle"], _angular_common__WEBPACK_IMPORTED_MODULE_11__["NgClass"], _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_12__["MatTooltip"], _angular_common__WEBPACK_IMPORTED_MODULE_11__["NgSwitch"], _angular_common__WEBPACK_IMPORTED_MODULE_11__["NgSwitchDefault"], _angular_common__WEBPACK_IMPORTED_MODULE_11__["NgSwitchCase"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_13__["EditableTextareaComponent"], _angular_forms__WEBPACK_IMPORTED_MODULE_10__["MaxLengthValidator"], _angular_material_select__WEBPACK_IMPORTED_MODULE_14__["MatSelect"], _angular_material_core__WEBPACK_IMPORTED_MODULE_15__["MatOption"], _angular_common__WEBPACK_IMPORTED_MODULE_11__["NgForOf"], _angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatHeaderRow"], _angular_material_table__WEBPACK_IMPORTED_MODULE_2__["MatRow"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_16__["TranslatePipe"]], styles: ["@charset \"UTF-8\";\n\n.mat-select-trigger[_ngcontent-%COMP%] {\n  \n}\n.dropdown-font-text[_ngcontent-%COMP%], .pastis-dropdown-text[_ngcontent-%COMP%] {\n  padding-top: 4px;\n  height: 20px;\n  max-height: 51px;\n  \n  font-family: Roboto;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  \n}\n\n.dropdown[_ngcontent-%COMP%], .pastis-dropdown-border[_ngcontent-%COMP%], .pastis-dropdown-background[_ngcontent-%COMP%] {\n  border-radius: 50px;\n  height: 49px;\n  background: #ffffff;\n  max-height: 40px;\n}\n\n\n\n\n\n\n\n\n.mat-select-trigger[_ngcontent-%COMP%] {\n  \n}\n.dropdown-font-text[_ngcontent-%COMP%], .pastis-dropdown-text[_ngcontent-%COMP%] {\n  padding-top: 4px;\n  height: 20px;\n  max-height: 51px;\n  \n  font-family: Roboto;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  \n}\n\n.dropdown[_ngcontent-%COMP%], .pastis-dropdown-border[_ngcontent-%COMP%], .pastis-dropdown-background[_ngcontent-%COMP%] {\n  border-radius: 50px;\n  height: 49px;\n  background: #ffffff;\n  max-height: 40px;\n}\n\n.pastis-table-input-border[_ngcontent-%COMP%] {\n  border-radius: 5px;\n  border: 1px solid #e0e0e0;\n  box-sizing: border-box;\n  box-shadow: 0px 0px 2px rgba(33, 33, 33, 0.2), 0px 1px 4px rgba(33, 33, 33, 0.05);\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n\n.pastis-primary-50[_ngcontent-%COMP%] {\n  color: #f7ebfa;\n}\n.pastis-primary-100[_ngcontent-%COMP%] {\n  color: #e6c3ef;\n}\n.pastis-primary-300[_ngcontent-%COMP%] {\n  color: #c672d9;\n}\n.pastis-primary-400[_ngcontent-%COMP%] {\n  color: #b54ace;\n}\n.pastis-primary-500[_ngcontent-%COMP%] {\n  color: #9c31b5;\n}\n.pastis-primary-700[_ngcontent-%COMP%] {\n  color: #571b64;\n}\n.pastis-secondary-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n}\n.pastis-secondary-50[_ngcontent-%COMP%] {\n  color: #eaf2fa;\n}\n.pastis-secondary-200[_ngcontent-%COMP%] {\n  color: #96bde8;\n}\n.pastis-secondary-300[_ngcontent-%COMP%] {\n  color: #6da2df;\n}\n.pastis-secondary-400[_ngcontent-%COMP%] {\n  color: #4388d6;\n}\n.pastis-secondary-500[_ngcontent-%COMP%] {\n  color: #2563a9;\n}\n.pastis-surface-tabs[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-surface-snackbar[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-black-low[_ngcontent-%COMP%], .pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  color: #c1c1c1;\n}\n.pastis-black-disabled[_ngcontent-%COMP%] {\n  color: #e7e5e5;\n}\n.pastis-black-medium[_ngcontent-%COMP%], .pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  color: #747272;\n}\n.pastis-black-height[_ngcontent-%COMP%] {\n  color: #232323;\n}\n.pastis-black-standard[_ngcontent-%COMP%] {\n  color: #474747;\n}\n.pastis-grey-900[_ngcontent-%COMP%], .pastis-font-h5[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-grey-600[_ngcontent-%COMP%] {\n  color: #757575;\n}\n.pastis-grey-400[_ngcontent-%COMP%] {\n  color: #bdbdbd;\n}\n.pastis-ligthly-purple[_ngcontent-%COMP%] {\n  color: #f6f3fb;\n}\n.pastis-white-highlight[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-white-disabled[_ngcontent-%COMP%] {\n  color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-bg-primary-50[_ngcontent-%COMP%] {\n  background: #f7ebfa;\n}\n.pastis-bg-primary-100[_ngcontent-%COMP%] {\n  background: #e6c3ef;\n}\n.pastis-bg-primary-300[_ngcontent-%COMP%] {\n  background: #c672d9;\n}\n.pastis-bg-primary-400[_ngcontent-%COMP%] {\n  background: #b54ace;\n}\n.pastis-bg-primary-500[_ngcontent-%COMP%] {\n  background: #9c31b5;\n}\n.pastis-bg-primary-700[_ngcontent-%COMP%] {\n  background: #571b64;\n}\n.pastis-bg-secondary-disabled[_ngcontent-%COMP%] {\n  background: #bdd9ec;\n}\n.pastis-bg-secondary-50[_ngcontent-%COMP%] {\n  background: #eaf2fa;\n}\n.pastis-bg-secondary-200[_ngcontent-%COMP%] {\n  background: #96bde8;\n}\n.pastis-bg-secondary-300[_ngcontent-%COMP%] {\n  background: #6da2df;\n}\n.pastis-bg-secondary-400[_ngcontent-%COMP%] {\n  background: #4388d6;\n}\n.pastis-bg-secondary-500[_ngcontent-%COMP%] {\n  background: #2563a9;\n}\n.pastis-bg-surface-tabs[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-surface-snackbar[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-black-low[_ngcontent-%COMP%] {\n  background: #c1c1c1;\n}\n.pastis-bg-black-disabled[_ngcontent-%COMP%] {\n  background: #e7e5e5;\n}\n.pastis-bg-black-medium[_ngcontent-%COMP%] {\n  background: #747272;\n}\n.pastis-bg-black-height[_ngcontent-%COMP%] {\n  background: #232323;\n}\n.pastis-bg-black-standard[_ngcontent-%COMP%] {\n  background: #474747;\n}\n.pastis-bg-grey-900[_ngcontent-%COMP%] {\n  background: #212121;\n}\n.pastis-bg-grey-600[_ngcontent-%COMP%] {\n  background: #757575;\n}\n.pastis-bg-grey-400[_ngcontent-%COMP%] {\n  background: #bdbdbd;\n}\n.pastis-bg-ligthly-purple[_ngcontent-%COMP%] {\n  background: #f6f3fb;\n}\n.pastis-bg-white-highlight[_ngcontent-%COMP%] {\n  background: #ffffff;\n}\n.pastis-bg-white-disabled[_ngcontent-%COMP%] {\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-bgcolor-primary-50[_ngcontent-%COMP%] {\n  background-color: #f7ebfa;\n}\n.pastis-bgcolor-primary-100[_ngcontent-%COMP%] {\n  background-color: #e6c3ef;\n}\n.pastis-bgcolor-primary-300[_ngcontent-%COMP%] {\n  background-color: #c672d9;\n}\n.pastis-bgcolor-primary-400[_ngcontent-%COMP%] {\n  background-color: #b54ace;\n}\n.pastis-bgcolor-primary-500[_ngcontent-%COMP%] {\n  background-color: #9c31b5;\n}\n.pastis-bgcolor-primary-700[_ngcontent-%COMP%] {\n  background-color: #571b64;\n}\n.pastis-bgcolor-secondary-disabled[_ngcontent-%COMP%] {\n  background-color: #bdd9ec;\n}\n.pastis-bgcolor-secondary-50[_ngcontent-%COMP%] {\n  background-color: #eaf2fa;\n}\n.pastis-bgcolor-secondary-200[_ngcontent-%COMP%] {\n  background-color: #96bde8;\n}\n.pastis-bgcolor-secondary-300[_ngcontent-%COMP%] {\n  background-color: #6da2df;\n}\n.pastis-bgcolor-secondary-400[_ngcontent-%COMP%] {\n  background-color: #4388d6;\n}\n.pastis-bgcolor-secondary-500[_ngcontent-%COMP%] {\n  background-color: #2563a9;\n}\n.pastis-bgcolor-surface-tabs[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-surface-snackbar[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-black-low[_ngcontent-%COMP%] {\n  background-color: #c1c1c1;\n}\n.pastis-bgcolor-black-disabled[_ngcontent-%COMP%] {\n  background-color: #e7e5e5;\n}\n.pastis-bgcolor-black-medium[_ngcontent-%COMP%] {\n  background-color: #747272;\n}\n.pastis-bgcolor-black-height[_ngcontent-%COMP%] {\n  background-color: #232323;\n}\n.pastis-bgcolor-black-standard[_ngcontent-%COMP%] {\n  background-color: #474747;\n}\n.pastis-bgcolor-grey-900[_ngcontent-%COMP%] {\n  background-color: #212121;\n}\n.pastis-bgcolor-grey-600[_ngcontent-%COMP%] {\n  background-color: #757575;\n}\n.pastis-bgcolor-grey-400[_ngcontent-%COMP%], .pastis-entete-1-separator[_ngcontent-%COMP%] {\n  background-color: #bdbdbd;\n}\n.pastis-bgcolor-ligthly-purple[_ngcontent-%COMP%] {\n  background-color: #f6f3fb;\n}\n.pastis-bgcolor-white-highlight[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n}\n.pastis-bgcolor-white-disabled[_ngcontent-%COMP%] {\n  background-color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-btn[_ngcontent-%COMP%], .pastis-btn-primary-enabled[_ngcontent-%COMP%], .pastis-btn-primary-disabled[_ngcontent-%COMP%], .pastis-btn-primary-hover[_ngcontent-%COMP%], .pastis-btn-primary-focus[_ngcontent-%COMP%], .pastis-btn-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-secondary-hover[_ngcontent-%COMP%], .pastis-btn-secondary-focus[_ngcontent-%COMP%], .pastis-btn-variant-enabled[_ngcontent-%COMP%], .pastis-btn-variant-disabled[_ngcontent-%COMP%], .pastis-btn-variant-hover[_ngcontent-%COMP%], .pastis-btn-variant-focus[_ngcontent-%COMP%], .pastis-btn-leading-enabled[_ngcontent-%COMP%], .pastis-btn-leading-disabled[_ngcontent-%COMP%], .pastis-btn-leading-hover[_ngcontent-%COMP%], .pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  border-radius: 100px !important;\n  border: 0px;\n  outline: none;\n}\n.pastis-btn-primary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary-50);\n}\n.pastis-btn-primary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-secondary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-secondary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-variant-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-variant-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #e7e5e5;\n}\n.pastis-btn-variant-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-variant-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-rounded[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 50px;\n  height: 50px;\n  outline-style: none;\n}\n.pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n}\n.pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: --vitamui-primary-200;\n}\n.pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: --vitamui-primary-400;\n}\n.pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #bdd9ec;\n}\n.pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 30px;\n  height: 30px;\n  outline-style: none;\n}\n.pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-300);\n}\n.pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-dropdown-border-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid #bdd9ec;\n}\n.pastis-dropdown-border-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #5cbaa9;\n}\n.pastis-dropdown-background-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-text-button1-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button2-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-search-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-special-enabled[_ngcontent-%COMP%] {\n  color: #9d9d9d;\n}\n.pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  outline: none;\n  height: 50px;\n  box-sizing: border-box;\n  border-radius: 87px;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  border: 1px solid #65b2e4;\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  border: 1px solid #747272;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  border: 1px solid #ff0000;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  border: 1px solid #50d166;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-header-no-sidebar[_ngcontent-%COMP%], .pastis-header-with-sidebar[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 1440px;\n  height: 288px;\n  left: 0px;\n  top: -2px;\n  background: #eceef3;\n}\n.pastis-header-with-sidebar[_ngcontent-%COMP%] {\n  width: 952px;\n}\n.pastis-content-metadata[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 778px;\n  height: 60px;\n  top: 359px;\n  right: 116px;\n  left: 58px;\n  background: #ffffff;\n}\n.pastis-slide-nav-profile[_ngcontent-%COMP%] {\n  max-width: 480px;\n  height: auto;\n  background: #ffffff;\n}\n.pastis-slide-nav-header[_ngcontent-%COMP%] {\n  position: absolute;\n  height: 200px;\n  background: #5cbaa9;\n}\n.pastis-page-container[_ngcontent-%COMP%] {\n  position: relative;\n  width: 100%;\n  height: 100%;\n}\n.pastis-tab-container[_ngcontent-%COMP%] {\n  right: 40px;\n  left: 40px;\n  height: 500px;\n  width: 100%;\n}\n.pastis-table[_ngcontent-%COMP%] {\n  width: 80%;\n  height: 612px;\n  left: 150px;\n  margin-right: 120px;\n  \n  height: auto;\n  overflow: auto;\n  background: #ffffff !important;\n  box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.14) !important;\n  border-radius: 5px !important;\n}\n.pastis-metadata-table[_ngcontent-%COMP%] {\n  background: #ffffff;\n  box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border-radius: 5px;\n}\n.pastis-col[_ngcontent-%COMP%], .pastis-metadata-table-col-large[_ngcontent-%COMP%], .pastis-metadata-table-col-medium[_ngcontent-%COMP%], .pastis-metadata-table-col-small[_ngcontent-%COMP%] {\n  text-align: left;\n}\n.pastis-col[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-large[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-medium[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-small[_ngcontent-%COMP%]:first-child {\n  border-top-left-radius: 5px;\n  border-bottom-left-radius: 5px;\n}\n.pastis-col[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-large[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-medium[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-small[_ngcontent-%COMP%]:last-child {\n  border-top-right-radius: 5px;\n  border-bottom-right-radius: 5px;\n}\n.pastis-metadata-table-col-large[_ngcontent-%COMP%] {\n  width: 203px;\n  height: 50px;\n}\n.pastis-metadata-table-col-medium[_ngcontent-%COMP%] {\n  width: 140px;\n  height: 50px;\n}\n.pastis-metadata-table-col-small[_ngcontent-%COMP%] {\n  width: 120px;\n  height: 50px;\n}\n.pastis-side-nav[_ngcontent-%COMP%] {\n  background: #ffffff;\n  box-shadow: 20px 20px 80px rgba(168, 153, 153, 0.5);\n}\n.pastis-ico-svg[_ngcontent-%COMP%] {\n  display: block;\n  margin: auto;\n}\n.pastis-ico-arrow-right[_ngcontent-%COMP%] {\n  font-size: 14px;\n  line-height: 22px;\n  margin-left: 10px;\n  vertical-align: middle;\n}\n.pastis-popup-modal-box[_ngcontent-%COMP%]   mat-dialog-container[_ngcontent-%COMP%] {\n  background: #f7f8fb;\n  \n  box-shadow: 0px 11px 15px rgba(0, 0, 0, 0.1), 0px 9px 46px rgba(0, 0, 0, 0.06), 0px 24px 38px rgba(0, 0, 0, 0.07);\n  border-radius: 20px;\n  overflow: hidden;\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar {\n  width: 12px;\n  height: 12px;\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-track {\n  background: var(--vitamui-primary-50);\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-thumb {\n  border-radius: 100px;\n  background: var(--vitamui-primary);\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-thumb:hover {\n  background: var(--vitamui-primary-700);\n}\n\n[_ngcontent-%COMP%]:root {\n  scrollbar-color: var(--vitamui-primary) !important;\n  scrollbar-width: thin !important;\n  scrollbar-base-color: var(--vitamui-primary-50) !important;\n}\n.mat-checkbox[_ngcontent-%COMP%]   .mat-checkbox-ripple[_ngcontent-%COMP%] {\n  display: none !important;\n}\n\n.pastis-tooltip-class[_ngcontent-%COMP%] {\n  \n  background-color: var(--vitamui-primary) !important;\n  border-radius: 5px !important;\n  padding: 15px !important;\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: 0.4px;\n  \n  color: #ffffff;\n}\n\n.tooltip-right[_ngcontent-%COMP%]::after {\n  border-color: transparent var(--vitamui-primary) transparent transparent !important;\n}\n.tooltip-left[_ngcontent-%COMP%]::after {\n  border-color: transparent transparent transparent var(--vitamui-primary) !important;\n}\n.tooltip-top[_ngcontent-%COMP%]::after {\n  border-color: var(--vitamui-primary) transparent transparent transparent !important;\n}\n.tooltip-bottom[_ngcontent-%COMP%]::after {\n  border-color: transparent transparent var(--vitamui-primary) transparent !important;\n}\n.pastis-text-area[_ngcontent-%COMP%] {\n  height: 40px;\n  background: #ffffff;\n  outline: none;\n  display: flex;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.25px;\n  resize: none;\n  color: #757575;\n}\n\n\n.checkbox-label[_ngcontent-%COMP%] {\n  display: inline;\n  position: relative;\n  margin: auto;\n  cursor: pointer;\n  font-size: 22px;\n  line-height: 24px;\n  clear: both;\n  vertical-align: middle !important;\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  position: absolute;\n  opacity: 0;\n  cursor: pointer;\n}\n.checkbox-label[_ngcontent-%COMP%]   .checkbox-custom[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0px;\n  left: 0px;\n  height: 16px;\n  width: 16px;\n  background-color: transparent;\n  border-radius: 3px;\n  transition: all 0.3s ease-out;\n  -webkit-transition: all 0.3s ease-out;\n  -moz-transition: all 0.3s ease-out;\n  -ms-transition: all 0.3s ease-out;\n  -o-transition: all 0.3s ease-out;\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked    ~ .checkbox-custom[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n  border-radius: 3px;\n  transform: rotate(0deg) scale(1);\n  opacity: 1;\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.checkbox-label[_ngcontent-%COMP%]   .checkbox-custom[_ngcontent-%COMP%]::after {\n  position: absolute;\n  content: '';\n  left: 12px;\n  top: 12px;\n  height: 0px;\n  width: 0px;\n  border-radius: 3px;\n  border: 1px solid var(--vitamui-secondary-300);\n  border-width: 0 3px 3px 0;\n  transform: rotate(0deg) scale(0);\n  opacity: 1;\n  transition: all 0.3s ease-out;\n  -webkit-transition: all 0.3s ease-out;\n  -moz-transition: all 0.3s ease-out;\n  -ms-transition: all 0.3s ease-out;\n  -o-transition: all 0.3s ease-out;\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked    ~ .checkbox-custom[_ngcontent-%COMP%]::after {\n  transform: rotate(45deg) scale(1);\n  opacity: 1;\n  left: 6px;\n  top: 1px;\n  width: 3px;\n  height: 10px;\n  border: 1px solid var(--vitamui-secondary-300);\n  border-width: 0 2px 2px 0;\n  background-color: transparent;\n  border-radius: 0;\n}\n.list-profile-table[_ngcontent-%COMP%] {\n  width: 100%;\n  max-height: 365px;\n  border-spacing: 0 5px;\n  border-radius: 5px;\n  background-color: transparent;\n}\n.pastis-table-row-header[_ngcontent-%COMP%], .pastis-table-row[_ngcontent-%COMP%], .pastis-table-row[_ngcontent-%COMP%]:hover {\n  border-width: 5px;\n  border-color: transparent;\n  background-color: #ffffff;\n  border-radius: 5px;\n  height: 60px !important;\n}\n.pastis-table-row[_ngcontent-%COMP%]:hover {\n  background-color: #f6f3fb;\n  box-shadow: 0px 1px 4px rgba(33, 33, 33, 0.2), 0px 2px 8px rgba(33, 33, 33, 0.05);\n  cursor: pointer;\n}\n.pastis-panel-shadow-primary-500[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 4px rgba(112, 35, 130, 0.4), 0px 2px 8px rgba(112, 35, 130, 0.2);\n}\n.pastis-panel-shadow[_ngcontent-%COMP%] {\n  box-shadow: 0px 2px 8px rgba(33, 33, 33, 0.2), 0px 4px 16px rgba(33, 33, 33, 0.05);\n}\n.pastis-panel-radius-5[_ngcontent-%COMP%] {\n  border-radius: 5px;\n}\n.pastis-panel-radius-10[_ngcontent-%COMP%] {\n  border-radius: 10px;\n}\n.pastis-entete-1-separator[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 3px;\n  left: 90px;\n  top: 0.83%;\n  bottom: 0.83%;\n}\n.col-selection[_ngcontent-%COMP%] {\n  text-align: left;\n  padding-right: 0 !important;\n}\n.info-bulle[_ngcontent-%COMP%] {\n  padding-left: 28px;\n  padding-right: 2px;\n  vertical-align: baseline;\n  font-size: 24px;\n  color: var(--vitamui-secondary-300);\n}\n.col-nom[_ngcontent-%COMP%] {\n  width: 204px !important;\n}\ntable[_ngcontent-%COMP%] {\n  background: none;\n  max-height: 454px;\n  border-spacing: 0 5px;\n  margin-bottom: 30px;\n}\n.table-container[_ngcontent-%COMP%] {\n  max-height: 270px;\n  overflow: auto;\n}\nth[_ngcontent-%COMP%] {\n  border: none;\n  background: white;\n}\ntd[_ngcontent-%COMP%] {\n  border-radius: 5px;\n  border: none;\n}\n.check-box[_ngcontent-%COMP%] {\n  width: 150px;\n}\n  .mat-checkbox .mat-checkbox-frame {\n  border-radius: 3px;\n  border: 1px solid var(--vitamui-grey-400);\n  background: white;\n}\n  .mat-checkbox.mat-checkbox-checked .mat-checkbox-frame {\n  border-radius: 3px;\n  border: 1px solid var(--vitamui-primary);\n  background: var(--vitamui-primary);\n}\n  .mat-checkbox.mat-checkbox-checked .mat-checkbox-background,   .mat-checkbox .mat-checkbox-background {\n  background: transparent;\n  margin: 2px;\n}\n  .mat-checkbox .mat-checkbox-checkmark-path {\n  stroke: var(--vitamui-grey-font) !important;\n  stroke-width: 5px;\n}\n  .mat-checkbox span {\n  font-size: 14px;\n  color: var(--vitamui-grey-900);\n}\n  .mat-checkbox .mat-checkbox:checked {\n  background: yellow;\n  margin: 0px;\n  position: relative;\n}\n  .mat-checkbox .mat-checkbox:checked:before {\n  font-family: Mulish;\n  content: '\\f00c';\n  display: block;\n  color: #a61717;\n  font-size: 13px;\n  position: absolute;\n}\n  .mat-checkbox-checked.mat-accent.mat-checkbox-disabled .mat-checkbox-background, .mat-checkbox-indeterminate.mat-accent[_ngcontent-%COMP%]   .mat-checkbox-background[_ngcontent-%COMP%] {\n  border: none !important;\n  border-color: var(--vitamui-grey-700);\n  background-color: var(--vitamui-grey-300);\n}\n  .mat-checkbox-checked.mat-accent.mat-checkbox-disabled .mat-checkbox-background .mat-checkbox-checkmark-path, .mat-checkbox-indeterminate.mat-accent[_ngcontent-%COMP%]   .mat-checkbox-background[_ngcontent-%COMP%]   .mat-checkbox-checkmark-path[_ngcontent-%COMP%] {\n  stroke: var(--vitamui-grey-700) !important;\n}\n  .mat-checkbox-checked.mat-accent.mat-checkbox-disabled .mat-checkbox-background.mat-checkbox-checked .mat-checkbox-frame, .mat-checkbox-indeterminate.mat-accent[_ngcontent-%COMP%]   .mat-checkbox-background.mat-checkbox-checked[_ngcontent-%COMP%]   .mat-checkbox-frame[_ngcontent-%COMP%] {\n  border-radius: 3px;\n  border: 1px solid var(--vitamui-grey-700) !important;\n  background: var(--vitamui-grey-700);\n}\n  .mat-checkbox.mat-checkbox-disabled .mat-checkbox-frame {\n  border: 1px solid var(--vitamui-primary);\n  border-color: var(--vitamui-grey-700);\n  background-color: var(--vitamui-grey-300);\n}"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](AttributesPopupComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                // tslint:disable-next-line:component-selector
                selector: 'pastis-edit-attributes',
                templateUrl: './attributes.component.html',
                styleUrls: ['./attributes.component.scss'],
            }]
    }], function () { return [{ type: _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialogRef"] }, { type: undefined, decorators: [{
                type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Inject"],
                args: [_angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MAT_DIALOG_DATA"]]
            }] }, { type: projects_pastis_src_app_core_services_seda_service__WEBPACK_IMPORTED_MODULE_5__["SedaService"] }, { type: projects_pastis_src_app_core_services_file_service__WEBPACK_IMPORTED_MODULE_3__["FileService"] }, { type: _file_tree_metadata_service__WEBPACK_IMPORTED_MODULE_8__["FileTreeMetadataService"] }, { type: projects_pastis_src_app_core_services_popup_service__WEBPACK_IMPORTED_MODULE_4__["PopupService"] }, { type: projects_pastis_src_app_shared_pastis_popup_metadata_language_pastis_popup_metadata_language_service__WEBPACK_IMPORTED_MODULE_6__["PastisPopupMetadataLanguageService"] }]; }, null); })();


/***/ }),

/***/ "7pJH":
/*!*********************************************************************!*\
  !*** ./src/app/user-actions/download-doc/download-doc.component.ts ***!
  \*********************************************************************/
/*! exports provided: UserActionsDownloadDocComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UserActionsDownloadDocComponent", function() { return UserActionsDownloadDocComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "EM62");
/*
Copyright © CINES - Centre Informatique National pour l'Enseignement Supérieur (2020)

[dad@cines.fr]

This software is a computer program whose purpose is to provide
a web application to create, edit, import and export archive
profiles based on the french SEDA standard
(https://redirect.francearchives.fr/seda/).


This software is governed by the CeCILL-C  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL-C
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C license and that you accept its terms.
*/


class UserActionsDownloadDocComponent {
    constructor() { }
    ngOnInit() { }
}
UserActionsDownloadDocComponent.ɵfac = function UserActionsDownloadDocComponent_Factory(t) { return new (t || UserActionsDownloadDocComponent)(); };
UserActionsDownloadDocComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: UserActionsDownloadDocComponent, selectors: [["pastis-user-action-download-doc"]], decls: 3, vars: 0, consts: [["type", "submit", 1, "btn", "btn-circle", "secondary", "large"], [1, "material-icons"]], template: function UserActionsDownloadDocComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "i", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "settings");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } }, styles: ["@charset \"UTF-8\";\n\n\n\n\n\n\n\n.mat-select-trigger[_ngcontent-%COMP%] {\n  \n}\n.dropdown-font-text[_ngcontent-%COMP%], .pastis-dropdown-text[_ngcontent-%COMP%] {\n  padding-top: 4px;\n  height: 20px;\n  max-height: 51px;\n  \n  font-family: Roboto;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  \n}\n\n.dropdown[_ngcontent-%COMP%], .pastis-dropdown-border[_ngcontent-%COMP%], .pastis-dropdown-background[_ngcontent-%COMP%] {\n  border-radius: 50px;\n  height: 49px;\n  background: #ffffff;\n  max-height: 40px;\n}\n\n.pastis-table-input-border[_ngcontent-%COMP%] {\n  border-radius: 5px;\n  border: 1px solid #e0e0e0;\n  box-sizing: border-box;\n  box-shadow: 0px 0px 2px rgba(33, 33, 33, 0.2), 0px 1px 4px rgba(33, 33, 33, 0.05);\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n\n.pastis-primary-50[_ngcontent-%COMP%] {\n  color: #f7ebfa;\n}\n.pastis-primary-100[_ngcontent-%COMP%] {\n  color: #e6c3ef;\n}\n.pastis-primary-300[_ngcontent-%COMP%] {\n  color: #c672d9;\n}\n.pastis-primary-400[_ngcontent-%COMP%] {\n  color: #b54ace;\n}\n.pastis-primary-500[_ngcontent-%COMP%] {\n  color: #9c31b5;\n}\n.pastis-primary-700[_ngcontent-%COMP%] {\n  color: #571b64;\n}\n.pastis-secondary-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n}\n.pastis-secondary-50[_ngcontent-%COMP%] {\n  color: #eaf2fa;\n}\n.pastis-secondary-200[_ngcontent-%COMP%] {\n  color: #96bde8;\n}\n.pastis-secondary-300[_ngcontent-%COMP%] {\n  color: #6da2df;\n}\n.pastis-secondary-400[_ngcontent-%COMP%] {\n  color: #4388d6;\n}\n.pastis-secondary-500[_ngcontent-%COMP%] {\n  color: #2563a9;\n}\n.pastis-surface-tabs[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-surface-snackbar[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-black-low[_ngcontent-%COMP%], .pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  color: #c1c1c1;\n}\n.pastis-black-disabled[_ngcontent-%COMP%] {\n  color: #e7e5e5;\n}\n.pastis-black-medium[_ngcontent-%COMP%], .pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  color: #747272;\n}\n.pastis-black-height[_ngcontent-%COMP%] {\n  color: #232323;\n}\n.pastis-black-standard[_ngcontent-%COMP%] {\n  color: #474747;\n}\n.pastis-grey-900[_ngcontent-%COMP%], .pastis-font-h5[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-grey-600[_ngcontent-%COMP%] {\n  color: #757575;\n}\n.pastis-grey-400[_ngcontent-%COMP%] {\n  color: #bdbdbd;\n}\n.pastis-ligthly-purple[_ngcontent-%COMP%] {\n  color: #f6f3fb;\n}\n.pastis-white-highlight[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-white-disabled[_ngcontent-%COMP%] {\n  color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-bg-primary-50[_ngcontent-%COMP%] {\n  background: #f7ebfa;\n}\n.pastis-bg-primary-100[_ngcontent-%COMP%] {\n  background: #e6c3ef;\n}\n.pastis-bg-primary-300[_ngcontent-%COMP%] {\n  background: #c672d9;\n}\n.pastis-bg-primary-400[_ngcontent-%COMP%] {\n  background: #b54ace;\n}\n.pastis-bg-primary-500[_ngcontent-%COMP%] {\n  background: #9c31b5;\n}\n.pastis-bg-primary-700[_ngcontent-%COMP%] {\n  background: #571b64;\n}\n.pastis-bg-secondary-disabled[_ngcontent-%COMP%] {\n  background: #bdd9ec;\n}\n.pastis-bg-secondary-50[_ngcontent-%COMP%] {\n  background: #eaf2fa;\n}\n.pastis-bg-secondary-200[_ngcontent-%COMP%] {\n  background: #96bde8;\n}\n.pastis-bg-secondary-300[_ngcontent-%COMP%] {\n  background: #6da2df;\n}\n.pastis-bg-secondary-400[_ngcontent-%COMP%] {\n  background: #4388d6;\n}\n.pastis-bg-secondary-500[_ngcontent-%COMP%] {\n  background: #2563a9;\n}\n.pastis-bg-surface-tabs[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-surface-snackbar[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-black-low[_ngcontent-%COMP%] {\n  background: #c1c1c1;\n}\n.pastis-bg-black-disabled[_ngcontent-%COMP%] {\n  background: #e7e5e5;\n}\n.pastis-bg-black-medium[_ngcontent-%COMP%] {\n  background: #747272;\n}\n.pastis-bg-black-height[_ngcontent-%COMP%] {\n  background: #232323;\n}\n.pastis-bg-black-standard[_ngcontent-%COMP%] {\n  background: #474747;\n}\n.pastis-bg-grey-900[_ngcontent-%COMP%] {\n  background: #212121;\n}\n.pastis-bg-grey-600[_ngcontent-%COMP%] {\n  background: #757575;\n}\n.pastis-bg-grey-400[_ngcontent-%COMP%] {\n  background: #bdbdbd;\n}\n.pastis-bg-ligthly-purple[_ngcontent-%COMP%] {\n  background: #f6f3fb;\n}\n.pastis-bg-white-highlight[_ngcontent-%COMP%] {\n  background: #ffffff;\n}\n.pastis-bg-white-disabled[_ngcontent-%COMP%] {\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-bgcolor-primary-50[_ngcontent-%COMP%] {\n  background-color: #f7ebfa;\n}\n.pastis-bgcolor-primary-100[_ngcontent-%COMP%] {\n  background-color: #e6c3ef;\n}\n.pastis-bgcolor-primary-300[_ngcontent-%COMP%] {\n  background-color: #c672d9;\n}\n.pastis-bgcolor-primary-400[_ngcontent-%COMP%] {\n  background-color: #b54ace;\n}\n.pastis-bgcolor-primary-500[_ngcontent-%COMP%] {\n  background-color: #9c31b5;\n}\n.pastis-bgcolor-primary-700[_ngcontent-%COMP%] {\n  background-color: #571b64;\n}\n.pastis-bgcolor-secondary-disabled[_ngcontent-%COMP%] {\n  background-color: #bdd9ec;\n}\n.pastis-bgcolor-secondary-50[_ngcontent-%COMP%] {\n  background-color: #eaf2fa;\n}\n.pastis-bgcolor-secondary-200[_ngcontent-%COMP%] {\n  background-color: #96bde8;\n}\n.pastis-bgcolor-secondary-300[_ngcontent-%COMP%] {\n  background-color: #6da2df;\n}\n.pastis-bgcolor-secondary-400[_ngcontent-%COMP%] {\n  background-color: #4388d6;\n}\n.pastis-bgcolor-secondary-500[_ngcontent-%COMP%] {\n  background-color: #2563a9;\n}\n.pastis-bgcolor-surface-tabs[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-surface-snackbar[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-black-low[_ngcontent-%COMP%] {\n  background-color: #c1c1c1;\n}\n.pastis-bgcolor-black-disabled[_ngcontent-%COMP%] {\n  background-color: #e7e5e5;\n}\n.pastis-bgcolor-black-medium[_ngcontent-%COMP%] {\n  background-color: #747272;\n}\n.pastis-bgcolor-black-height[_ngcontent-%COMP%] {\n  background-color: #232323;\n}\n.pastis-bgcolor-black-standard[_ngcontent-%COMP%] {\n  background-color: #474747;\n}\n.pastis-bgcolor-grey-900[_ngcontent-%COMP%] {\n  background-color: #212121;\n}\n.pastis-bgcolor-grey-600[_ngcontent-%COMP%] {\n  background-color: #757575;\n}\n.pastis-bgcolor-grey-400[_ngcontent-%COMP%], .pastis-entete-1-separator[_ngcontent-%COMP%] {\n  background-color: #bdbdbd;\n}\n.pastis-bgcolor-ligthly-purple[_ngcontent-%COMP%] {\n  background-color: #f6f3fb;\n}\n.pastis-bgcolor-white-highlight[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n}\n.pastis-bgcolor-white-disabled[_ngcontent-%COMP%] {\n  background-color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-btn[_ngcontent-%COMP%], .pastis-btn-primary-enabled[_ngcontent-%COMP%], .pastis-btn-primary-disabled[_ngcontent-%COMP%], .pastis-btn-primary-hover[_ngcontent-%COMP%], .pastis-btn-primary-focus[_ngcontent-%COMP%], .pastis-btn-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-secondary-hover[_ngcontent-%COMP%], .pastis-btn-secondary-focus[_ngcontent-%COMP%], .pastis-btn-variant-enabled[_ngcontent-%COMP%], .pastis-btn-variant-disabled[_ngcontent-%COMP%], .pastis-btn-variant-hover[_ngcontent-%COMP%], .pastis-btn-variant-focus[_ngcontent-%COMP%], .pastis-btn-leading-enabled[_ngcontent-%COMP%], .pastis-btn-leading-disabled[_ngcontent-%COMP%], .pastis-btn-leading-hover[_ngcontent-%COMP%], .pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  border-radius: 100px !important;\n  border: 0px;\n  outline: none;\n}\n.pastis-btn-primary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary-50);\n}\n.pastis-btn-primary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-secondary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-secondary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-variant-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-variant-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #e7e5e5;\n}\n.pastis-btn-variant-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-variant-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-rounded[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%]:active, .pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 50px;\n  height: 50px;\n  outline-style: none;\n}\n.pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n}\n.pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: --vitamui-primary-200;\n}\n.pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: --vitamui-primary-400;\n}\n.pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #bdd9ec;\n}\n.pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 30px;\n  height: 30px;\n  outline-style: none;\n}\n.pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-300);\n}\n.pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-dropdown-border-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid #bdd9ec;\n}\n.pastis-dropdown-border-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #5cbaa9;\n}\n.pastis-dropdown-background-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-text-button1-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button2-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-search-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-special-enabled[_ngcontent-%COMP%] {\n  color: #9d9d9d;\n}\n.pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  outline: none;\n  height: 50px;\n  box-sizing: border-box;\n  border-radius: 87px;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  border: 1px solid #65b2e4;\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  border: 1px solid #747272;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  border: 1px solid #ff0000;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  border: 1px solid #50d166;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n\n\n\n\n\n\n\n.mat-select-trigger[_ngcontent-%COMP%] {\n  \n}\n.dropdown-font-text[_ngcontent-%COMP%], .pastis-dropdown-text[_ngcontent-%COMP%] {\n  padding-top: 4px;\n  height: 20px;\n  max-height: 51px;\n  \n  font-family: Roboto;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  \n}\n\n.dropdown[_ngcontent-%COMP%], .pastis-dropdown-border[_ngcontent-%COMP%], .pastis-dropdown-background[_ngcontent-%COMP%] {\n  border-radius: 50px;\n  height: 49px;\n  background: #ffffff;\n  max-height: 40px;\n}\n\n.pastis-table-input-border[_ngcontent-%COMP%] {\n  border-radius: 5px;\n  border: 1px solid #e0e0e0;\n  box-sizing: border-box;\n  box-shadow: 0px 0px 2px rgba(33, 33, 33, 0.2), 0px 1px 4px rgba(33, 33, 33, 0.05);\n}\n.pastis-font-button-white[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 38.89%;\n  right: 52.08%;\n  top: 93.27%;\n  bottom: 5.09%;\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 18px;\n  text-align: center;\n  color: #ffffff;\n}\n.pastis-font-table-header[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-font-button-icon[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-size: 14px;\n  line-height: 18px;\n  align-items: center;\n  letter-spacing: 0.5px;\n  text-transform: uppercase;\n  color: #ffffff;\n  flex: none;\n  margin: 0px 10px;\n}\n.pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  color: darkred;\n}\n\n.pastis-body-2[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  align-items: center;\n  text-align: center;\n}\n\n.pastis-font-roboto-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.75px;\n}\n\n.pastis-font-roboto-regular[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n}\n.pastis-font-roboto-snack[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  color: white;\n  opacity: 0.4;\n  \n}\n.pastis-font-headline-6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 28px;\n  \n  letter-spacing: 0.5px;\n}\n.pastis-font-informations[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px;\n  \n  font-variant: small-caps;\n}\n.pastis-font-label[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-small[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  font-variant: small-caps;\n  \n  letter-spacing: 0.75px;\n}\n.pastis-font-label-historique[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 16px;\n  display: flex;\n  align-items: center;\n  font-variant: small-caps;\n  letter-spacing: 0.75px;\n}\n.pastis-font-headline6[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n}\n.pastis-font-popup-subtitle[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-font-popup-title[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 26px;\n  line-height: 35px;\n  letter-spacing: 0.15px;\n  color: #485053;\n}\n.pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n}\n.pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  letter-spacing: 0.4px;\n}\n.pastis-font-menu[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 15px;\n  line-height: 18px;\n  display: flex;\n  align-items: center;\n}\n.pastis-font-add-metadata-items[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 60px;\n}\n.pastis-textarea-comment[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  display: flex;\n  align-items: center;\n  letter-spacing: 0.25px;\n  \n  color: #9d9d9d;\n}\n.pastis-toaster-font[_ngcontent-%COMP%]   .pastis-toaster-font[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 15px;\n  line-height: 20px;\n  \n  color: #ffffff;\n}\n.pastis-font-h1[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 96px;\n  line-height: 112px;\n  \n  letter-spacing: -1.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h2[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 300;\n  font-size: 60px;\n  line-height: 70px;\n  \n  letter-spacing: -0.5px;\n  color: #c4c4c4;\n}\n.pastis-font-h3[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h3-bold[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 48px;\n  line-height: 56px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-h4[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 34px;\n  line-height: 40px;\n  \n  letter-spacing: 0.25px;\n  color: #c4c4c4;\n}\n.pastis-font-h5[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 800;\n  font-size: 24px;\n  line-height: 32px;\n  letter-spacing: -0.5px;\n}\n.pastis-font-h6[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 20px;\n  line-height: 23px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 28px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-body-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 20px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-subtitle-regular[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 16px;\n  line-height: 24px;\n  \n  letter-spacing: 0.15px;\n  color: #c4c4c4;\n}\n.pastis-font-regular-medium[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-button[_ngcontent-%COMP%] {\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  \n  color: #c4c4c4;\n}\n.pastis-font-caption[_ngcontent-%COMP%], .pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: -0.2px;\n}\n.pastis-font-caption-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.pastis-font-text-large[_ngcontent-%COMP%], .pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 20px;\n  line-height: 28px;\n}\n.pastis-font-text-large-bold[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.text-text-normal[_ngcontent-%COMP%], .mat-select-trigger[_ngcontent-%COMP%], .pastis-table-content[_ngcontent-%COMP%], .pastis-table-content-with-errors[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n.text-text-medium[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 16px;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 24px;\n  letter-spacing: 0px;\n  text-align: left;\n}\n.text-text-normal-bold[_ngcontent-%COMP%], .pastis-font-table-header[_ngcontent-%COMP%] {\n  font-family: Mulish;\n  font-size: 14px;\n  font-style: normal;\n  font-weight: 700;\n  line-height: 22px;\n  letter-spacing: 0.10000000149011612px;\n  text-align: left;\n}\n\n.pastis-primary-50[_ngcontent-%COMP%] {\n  color: #f7ebfa;\n}\n.pastis-primary-100[_ngcontent-%COMP%] {\n  color: #e6c3ef;\n}\n.pastis-primary-300[_ngcontent-%COMP%] {\n  color: #c672d9;\n}\n.pastis-primary-400[_ngcontent-%COMP%] {\n  color: #b54ace;\n}\n.pastis-primary-500[_ngcontent-%COMP%] {\n  color: #9c31b5;\n}\n.pastis-primary-700[_ngcontent-%COMP%] {\n  color: #571b64;\n}\n.pastis-secondary-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n}\n.pastis-secondary-50[_ngcontent-%COMP%] {\n  color: #eaf2fa;\n}\n.pastis-secondary-200[_ngcontent-%COMP%] {\n  color: #96bde8;\n}\n.pastis-secondary-300[_ngcontent-%COMP%] {\n  color: #6da2df;\n}\n.pastis-secondary-400[_ngcontent-%COMP%] {\n  color: #4388d6;\n}\n.pastis-secondary-500[_ngcontent-%COMP%] {\n  color: #2563a9;\n}\n.pastis-surface-tabs[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-surface-snackbar[_ngcontent-%COMP%] {\n  color: #604379;\n}\n.pastis-black-low[_ngcontent-%COMP%], .pastis-input-placeholder-text[_ngcontent-%COMP%] {\n  color: #c1c1c1;\n}\n.pastis-black-disabled[_ngcontent-%COMP%] {\n  color: #e7e5e5;\n}\n.pastis-black-medium[_ngcontent-%COMP%], .pastis-input-text[_ngcontent-%COMP%], .pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  color: #747272;\n}\n.pastis-black-height[_ngcontent-%COMP%] {\n  color: #232323;\n}\n.pastis-black-standard[_ngcontent-%COMP%] {\n  color: #474747;\n}\n.pastis-grey-900[_ngcontent-%COMP%], .pastis-font-h5[_ngcontent-%COMP%] {\n  color: #212121;\n}\n.pastis-grey-600[_ngcontent-%COMP%] {\n  color: #757575;\n}\n.pastis-grey-400[_ngcontent-%COMP%] {\n  color: #bdbdbd;\n}\n.pastis-ligthly-purple[_ngcontent-%COMP%] {\n  color: #f6f3fb;\n}\n.pastis-white-highlight[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-white-disabled[_ngcontent-%COMP%] {\n  color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-bg-primary-50[_ngcontent-%COMP%] {\n  background: #f7ebfa;\n}\n.pastis-bg-primary-100[_ngcontent-%COMP%] {\n  background: #e6c3ef;\n}\n.pastis-bg-primary-300[_ngcontent-%COMP%] {\n  background: #c672d9;\n}\n.pastis-bg-primary-400[_ngcontent-%COMP%] {\n  background: #b54ace;\n}\n.pastis-bg-primary-500[_ngcontent-%COMP%] {\n  background: #9c31b5;\n}\n.pastis-bg-primary-700[_ngcontent-%COMP%] {\n  background: #571b64;\n}\n.pastis-bg-secondary-disabled[_ngcontent-%COMP%] {\n  background: #bdd9ec;\n}\n.pastis-bg-secondary-50[_ngcontent-%COMP%] {\n  background: #eaf2fa;\n}\n.pastis-bg-secondary-200[_ngcontent-%COMP%] {\n  background: #96bde8;\n}\n.pastis-bg-secondary-300[_ngcontent-%COMP%] {\n  background: #6da2df;\n}\n.pastis-bg-secondary-400[_ngcontent-%COMP%] {\n  background: #4388d6;\n}\n.pastis-bg-secondary-500[_ngcontent-%COMP%] {\n  background: #2563a9;\n}\n.pastis-bg-surface-tabs[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-surface-snackbar[_ngcontent-%COMP%] {\n  background: #604379;\n}\n.pastis-bg-black-low[_ngcontent-%COMP%] {\n  background: #c1c1c1;\n}\n.pastis-bg-black-disabled[_ngcontent-%COMP%] {\n  background: #e7e5e5;\n}\n.pastis-bg-black-medium[_ngcontent-%COMP%] {\n  background: #747272;\n}\n.pastis-bg-black-height[_ngcontent-%COMP%] {\n  background: #232323;\n}\n.pastis-bg-black-standard[_ngcontent-%COMP%] {\n  background: #474747;\n}\n.pastis-bg-grey-900[_ngcontent-%COMP%] {\n  background: #212121;\n}\n.pastis-bg-grey-600[_ngcontent-%COMP%] {\n  background: #757575;\n}\n.pastis-bg-grey-400[_ngcontent-%COMP%] {\n  background: #bdbdbd;\n}\n.pastis-bg-ligthly-purple[_ngcontent-%COMP%] {\n  background: #f6f3fb;\n}\n.pastis-bg-white-highlight[_ngcontent-%COMP%] {\n  background: #ffffff;\n}\n.pastis-bg-white-disabled[_ngcontent-%COMP%] {\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-bgcolor-primary-50[_ngcontent-%COMP%] {\n  background-color: #f7ebfa;\n}\n.pastis-bgcolor-primary-100[_ngcontent-%COMP%] {\n  background-color: #e6c3ef;\n}\n.pastis-bgcolor-primary-300[_ngcontent-%COMP%] {\n  background-color: #c672d9;\n}\n.pastis-bgcolor-primary-400[_ngcontent-%COMP%] {\n  background-color: #b54ace;\n}\n.pastis-bgcolor-primary-500[_ngcontent-%COMP%] {\n  background-color: #9c31b5;\n}\n.pastis-bgcolor-primary-700[_ngcontent-%COMP%] {\n  background-color: #571b64;\n}\n.pastis-bgcolor-secondary-disabled[_ngcontent-%COMP%] {\n  background-color: #bdd9ec;\n}\n.pastis-bgcolor-secondary-50[_ngcontent-%COMP%] {\n  background-color: #eaf2fa;\n}\n.pastis-bgcolor-secondary-200[_ngcontent-%COMP%] {\n  background-color: #96bde8;\n}\n.pastis-bgcolor-secondary-300[_ngcontent-%COMP%] {\n  background-color: #6da2df;\n}\n.pastis-bgcolor-secondary-400[_ngcontent-%COMP%] {\n  background-color: #4388d6;\n}\n.pastis-bgcolor-secondary-500[_ngcontent-%COMP%] {\n  background-color: #2563a9;\n}\n.pastis-bgcolor-surface-tabs[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-surface-snackbar[_ngcontent-%COMP%] {\n  background-color: #604379;\n}\n.pastis-bgcolor-black-low[_ngcontent-%COMP%] {\n  background-color: #c1c1c1;\n}\n.pastis-bgcolor-black-disabled[_ngcontent-%COMP%] {\n  background-color: #e7e5e5;\n}\n.pastis-bgcolor-black-medium[_ngcontent-%COMP%] {\n  background-color: #747272;\n}\n.pastis-bgcolor-black-height[_ngcontent-%COMP%] {\n  background-color: #232323;\n}\n.pastis-bgcolor-black-standard[_ngcontent-%COMP%] {\n  background-color: #474747;\n}\n.pastis-bgcolor-grey-900[_ngcontent-%COMP%] {\n  background-color: #212121;\n}\n.pastis-bgcolor-grey-600[_ngcontent-%COMP%] {\n  background-color: #757575;\n}\n.pastis-bgcolor-grey-400[_ngcontent-%COMP%], .pastis-entete-1-separator[_ngcontent-%COMP%] {\n  background-color: #bdbdbd;\n}\n.pastis-bgcolor-ligthly-purple[_ngcontent-%COMP%] {\n  background-color: #f6f3fb;\n}\n.pastis-bgcolor-white-highlight[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n}\n.pastis-bgcolor-white-disabled[_ngcontent-%COMP%] {\n  background-color: rgba(255, 255, 255, 0.57);\n}\n\n.pastis-btn[_ngcontent-%COMP%], .pastis-btn-primary-enabled[_ngcontent-%COMP%], .pastis-btn-primary-disabled[_ngcontent-%COMP%], .pastis-btn-primary-hover[_ngcontent-%COMP%], .pastis-btn-primary-focus[_ngcontent-%COMP%], .pastis-btn-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-secondary-hover[_ngcontent-%COMP%], .pastis-btn-secondary-focus[_ngcontent-%COMP%], .pastis-btn-variant-enabled[_ngcontent-%COMP%], .pastis-btn-variant-disabled[_ngcontent-%COMP%], .pastis-btn-variant-hover[_ngcontent-%COMP%], .pastis-btn-variant-focus[_ngcontent-%COMP%], .pastis-btn-leading-enabled[_ngcontent-%COMP%], .pastis-btn-leading-disabled[_ngcontent-%COMP%], .pastis-btn-leading-hover[_ngcontent-%COMP%], .pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  border-radius: 100px !important;\n  border: 0px;\n  outline: none;\n}\n.pastis-btn-primary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary-50);\n}\n.pastis-btn-primary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-primary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-secondary-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-secondary-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-secondary-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-variant-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-variant-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #e7e5e5;\n}\n.pastis-btn-variant-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-variant-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n  border: none;\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #c1c1c1;\n}\n.pastis-btn-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-disabled[_ngcontent-%COMP%] {\n  color: #bdd9ec;\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n  border: 1px solid var(--vitamui-secondary-300);\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: #ffffff;\n}\n.pastis-btn-rounded[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%]:active, .pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%], .pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 50px;\n  height: 50px;\n  outline-style: none;\n}\n.pastis-btn-rounded-standard-primary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-standard-primary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n}\n.pastis-btn-rounded-standard-primary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: --vitamui-primary-200;\n}\n.pastis-btn-rounded-standard-primary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: --vitamui-primary-400;\n}\n.pastis-btn-rounded-standard-secondary-enabled[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #bdd9ec;\n}\n.pastis-btn-rounded-standard-secondary-hover[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-secondary-focus[_ngcontent-%COMP%], .btn-rounded-setting[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  border: none;\n  background: var(--vitamui-secondary);\n}\n.pastis-btn-rounded-standard-white-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-standard-white-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-standard-white-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  border: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled, .pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover, .pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active, .pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  border-radius: 67px;\n  text-align: center;\n  width: 30px;\n  height: 30px;\n  outline-style: none;\n}\n.pastis-btn-rounded-mini-neutral-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  background: rgba(255, 255, 255, 0.57);\n}\n.pastis-btn-rounded-mini-neutral-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-neutral-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-neutral[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  background: #ffffff;\n}\n.pastis-btn-rounded-mini-primary-enabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-disabled[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:disabled {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-hover[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-primary-focus[_ngcontent-%COMP%], .pastis-btn-rounded-mini-primary[_ngcontent-%COMP%]:active {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-primary);\n}\n.pastis-btn-rounded-mini-secondary-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-300);\n}\n.pastis-btn-rounded-mini-secondary-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n  background: var(--vitamui-secondary-50);\n}\n.pastis-btn-rounded-mini-secondary-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-btn-rounded-mini-secondary-focus[_ngcontent-%COMP%] {\n  box-shadow: none;\n  font-family: Roboto;\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 16px;\n  text-align: center;\n}\n.pastis-dropdown-border-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-200);\n}\n.pastis-dropdown-border-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #f0f0f0;\n}\n.pastis-dropdown-border-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: 1px solid #bdd9ec;\n}\n.pastis-dropdown-border-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.pastis-dropdown-border-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  border: \"\";\n}\n.pastis-dropdown-border-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: \"\";\n}\n.pastis-dropdown-border-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border: 1px solid #5cbaa9;\n}\n.pastis-dropdown-background-button1-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button1-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-button2-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-leading-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-background-search-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-disabled[_ngcontent-%COMP%] {\n  box-shadow: \"\";\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-search-focus[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ff833c;\n}\n.pastis-dropdown-background-special-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n  background-color: #ffffff;\n}\n.pastis-dropdown-text-button1-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button1-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-button2-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-button2-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-primary);\n}\n.pastis-dropdown-text-leading-enabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-disabled[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-hover[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-leading-focus[_ngcontent-%COMP%] {\n  color: var(--vitamui-secondary-300);\n}\n.pastis-dropdown-text-search-enabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-disabled[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-hover[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-search-focus[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\n.pastis-dropdown-text-special-enabled[_ngcontent-%COMP%] {\n  color: #9d9d9d;\n}\n.pastis-input[_ngcontent-%COMP%], .pastis-input-enabled[_ngcontent-%COMP%], .pastis-input-disabled[_ngcontent-%COMP%], .pastis-input-hover[_ngcontent-%COMP%], .pastis-input-activated[_ngcontent-%COMP%], .pastis-input-error[_ngcontent-%COMP%], .pastis-input-valid[_ngcontent-%COMP%] {\n  outline: none;\n  height: 50px;\n  box-sizing: border-box;\n  border-radius: 87px;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  border: 1px solid #f0f0f0;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  border: 1px solid #65b2e4;\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  border: 1px solid #747272;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  border: 1px solid #ff0000;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  border: 1px solid #50d166;\n}\n.pastis-input-enabled[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.2), 0px 2px 2px rgba(0, 0, 0, 0.12), 0px 0px 2px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-disabled[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-hover[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.2), 0px 4px 5px rgba(0, 0, 0, 0.12), 0px 2px 4px rgba(0, 0, 0, 0.14);\n}\n.pastis-input-activated[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-error[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-input-valid[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.pastis-header-no-sidebar[_ngcontent-%COMP%], .pastis-header-with-sidebar[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 1440px;\n  height: 288px;\n  left: 0px;\n  top: -2px;\n  background: #eceef3;\n}\n.pastis-header-with-sidebar[_ngcontent-%COMP%] {\n  width: 952px;\n}\n.pastis-content-metadata[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 778px;\n  height: 60px;\n  top: 359px;\n  right: 116px;\n  left: 58px;\n  background: #ffffff;\n}\n.pastis-slide-nav-profile[_ngcontent-%COMP%] {\n  max-width: 480px;\n  height: auto;\n  background: #ffffff;\n}\n.pastis-slide-nav-header[_ngcontent-%COMP%] {\n  position: absolute;\n  height: 200px;\n  background: #5cbaa9;\n}\n.pastis-page-container[_ngcontent-%COMP%] {\n  position: relative;\n  width: 100%;\n  height: 100%;\n}\n.pastis-tab-container[_ngcontent-%COMP%] {\n  right: 40px;\n  left: 40px;\n  height: 500px;\n  width: 100%;\n}\n.pastis-table[_ngcontent-%COMP%] {\n  width: 80%;\n  height: 612px;\n  left: 150px;\n  margin-right: 120px;\n  \n  height: auto;\n  overflow: auto;\n  background: #ffffff !important;\n  box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.14) !important;\n  border-radius: 5px !important;\n}\n.pastis-metadata-table[_ngcontent-%COMP%] {\n  background: #ffffff;\n  box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.14);\n  border-radius: 5px;\n}\n.pastis-col[_ngcontent-%COMP%], .pastis-metadata-table-col-large[_ngcontent-%COMP%], .pastis-metadata-table-col-medium[_ngcontent-%COMP%], .pastis-metadata-table-col-small[_ngcontent-%COMP%] {\n  text-align: left;\n}\n.pastis-col[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-large[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-medium[_ngcontent-%COMP%]:first-child, .pastis-metadata-table-col-small[_ngcontent-%COMP%]:first-child {\n  border-top-left-radius: 5px;\n  border-bottom-left-radius: 5px;\n}\n.pastis-col[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-large[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-medium[_ngcontent-%COMP%]:last-child, .pastis-metadata-table-col-small[_ngcontent-%COMP%]:last-child {\n  border-top-right-radius: 5px;\n  border-bottom-right-radius: 5px;\n}\n.pastis-metadata-table-col-large[_ngcontent-%COMP%] {\n  width: 203px;\n  height: 50px;\n}\n.pastis-metadata-table-col-medium[_ngcontent-%COMP%] {\n  width: 140px;\n  height: 50px;\n}\n.pastis-metadata-table-col-small[_ngcontent-%COMP%] {\n  width: 120px;\n  height: 50px;\n}\n.pastis-side-nav[_ngcontent-%COMP%] {\n  background: #ffffff;\n  box-shadow: 20px 20px 80px rgba(168, 153, 153, 0.5);\n}\n.pastis-ico-svg[_ngcontent-%COMP%], .ico-setting[_ngcontent-%COMP%] {\n  display: block;\n  margin: auto;\n}\n.pastis-ico-arrow-right[_ngcontent-%COMP%] {\n  font-size: 14px;\n  line-height: 22px;\n  margin-left: 10px;\n  vertical-align: middle;\n}\n.pastis-popup-modal-box[_ngcontent-%COMP%]   mat-dialog-container[_ngcontent-%COMP%] {\n  background: #f7f8fb;\n  \n  box-shadow: 0px 11px 15px rgba(0, 0, 0, 0.1), 0px 9px 46px rgba(0, 0, 0, 0.06), 0px 24px 38px rgba(0, 0, 0, 0.07);\n  border-radius: 20px;\n  overflow: hidden;\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar {\n  width: 12px;\n  height: 12px;\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-track {\n  background: var(--vitamui-primary-50);\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-thumb {\n  border-radius: 100px;\n  background: var(--vitamui-primary);\n}\n\n[_ngcontent-%COMP%]::-webkit-scrollbar-thumb:hover {\n  background: var(--vitamui-primary-700);\n}\n\n[_ngcontent-%COMP%]:root {\n  scrollbar-color: var(--vitamui-primary) !important;\n  scrollbar-width: thin !important;\n  scrollbar-base-color: var(--vitamui-primary-50) !important;\n}\n.mat-checkbox[_ngcontent-%COMP%]   .mat-checkbox-ripple[_ngcontent-%COMP%] {\n  display: none !important;\n}\n\n.pastis-tooltip-class[_ngcontent-%COMP%] {\n  \n  background-color: var(--vitamui-primary) !important;\n  border-radius: 5px !important;\n  padding: 15px !important;\n  \n  font-family: Mulish;\n  font-style: normal;\n  font-weight: normal;\n  font-size: 12px;\n  line-height: 16px;\n  \n  letter-spacing: 0.4px;\n  \n  color: #ffffff;\n}\n\n.tooltip-right[_ngcontent-%COMP%]::after {\n  border-color: transparent var(--vitamui-primary) transparent transparent !important;\n}\n.tooltip-left[_ngcontent-%COMP%]::after {\n  border-color: transparent transparent transparent var(--vitamui-primary) !important;\n}\n.tooltip-top[_ngcontent-%COMP%]::after {\n  border-color: var(--vitamui-primary) transparent transparent transparent !important;\n}\n.tooltip-bottom[_ngcontent-%COMP%]::after {\n  border-color: transparent transparent var(--vitamui-primary) transparent !important;\n}\n.pastis-text-area[_ngcontent-%COMP%] {\n  height: 40px;\n  background: #ffffff;\n  outline: none;\n  display: flex;\n  align-items: center;\n  text-align: center;\n  letter-spacing: 0.25px;\n  resize: none;\n  color: #757575;\n}\n\n\n.checkbox-label[_ngcontent-%COMP%] {\n  display: inline;\n  position: relative;\n  margin: auto;\n  cursor: pointer;\n  font-size: 22px;\n  line-height: 24px;\n  clear: both;\n  vertical-align: middle !important;\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  position: absolute;\n  opacity: 0;\n  cursor: pointer;\n}\n.checkbox-label[_ngcontent-%COMP%]   .checkbox-custom[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0px;\n  left: 0px;\n  height: 16px;\n  width: 16px;\n  background-color: transparent;\n  border-radius: 3px;\n  transition: all 0.3s ease-out;\n  -webkit-transition: all 0.3s ease-out;\n  -moz-transition: all 0.3s ease-out;\n  -ms-transition: all 0.3s ease-out;\n  -o-transition: all 0.3s ease-out;\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked    ~ .checkbox-custom[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n  border-radius: 3px;\n  transform: rotate(0deg) scale(1);\n  opacity: 1;\n  border: 1px solid var(--vitamui-secondary-300);\n}\n.checkbox-label[_ngcontent-%COMP%]   .checkbox-custom[_ngcontent-%COMP%]::after {\n  position: absolute;\n  content: '';\n  left: 12px;\n  top: 12px;\n  height: 0px;\n  width: 0px;\n  border-radius: 3px;\n  border: 1px solid var(--vitamui-secondary-300);\n  border-width: 0 3px 3px 0;\n  transform: rotate(0deg) scale(0);\n  opacity: 1;\n  transition: all 0.3s ease-out;\n  -webkit-transition: all 0.3s ease-out;\n  -moz-transition: all 0.3s ease-out;\n  -ms-transition: all 0.3s ease-out;\n  -o-transition: all 0.3s ease-out;\n}\n.checkbox-label[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked    ~ .checkbox-custom[_ngcontent-%COMP%]::after {\n  transform: rotate(45deg) scale(1);\n  opacity: 1;\n  left: 6px;\n  top: 1px;\n  width: 3px;\n  height: 10px;\n  border: 1px solid var(--vitamui-secondary-300);\n  border-width: 0 2px 2px 0;\n  background-color: transparent;\n  border-radius: 0;\n}\n.list-profile-table[_ngcontent-%COMP%] {\n  width: 100%;\n  max-height: 365px;\n  border-spacing: 0 5px;\n  border-radius: 5px;\n  background-color: transparent;\n}\n.pastis-table-row-header[_ngcontent-%COMP%], .pastis-table-row[_ngcontent-%COMP%], .pastis-table-row[_ngcontent-%COMP%]:hover {\n  border-width: 5px;\n  border-color: transparent;\n  background-color: #ffffff;\n  border-radius: 5px;\n  height: 60px !important;\n}\n.pastis-table-row[_ngcontent-%COMP%]:hover {\n  background-color: #f6f3fb;\n  box-shadow: 0px 1px 4px rgba(33, 33, 33, 0.2), 0px 2px 8px rgba(33, 33, 33, 0.05);\n  cursor: pointer;\n}\n.pastis-panel-shadow-primary-500[_ngcontent-%COMP%] {\n  box-shadow: 0px 1px 4px rgba(112, 35, 130, 0.4), 0px 2px 8px rgba(112, 35, 130, 0.2);\n}\n.pastis-panel-shadow[_ngcontent-%COMP%] {\n  box-shadow: 0px 2px 8px rgba(33, 33, 33, 0.2), 0px 4px 16px rgba(33, 33, 33, 0.05);\n}\n.pastis-panel-radius-5[_ngcontent-%COMP%] {\n  border-radius: 5px;\n}\n.pastis-panel-radius-10[_ngcontent-%COMP%] {\n  border-radius: 10px;\n}\n.pastis-entete-1-separator[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 3px;\n  left: 90px;\n  top: 0.83%;\n  bottom: 0.83%;\n}"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](UserActionsDownloadDocComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                // tslint:disable-next-line:component-selector
                selector: 'pastis-user-action-download-doc',
                templateUrl: './download-doc.component.html',
                styleUrls: ['./download-doc.component.scss'],
            }]
    }], function () { return []; }, null); })();


/***/ }),

/***/ "7zxd":
/*!****************************************************************************************************************************!*\
  !*** /var/lib/jenkins/workspace/build_vitamui-build_7.1.3/ui/ui-frontend/dist/vitamui-library/fesm2015/vitamui-library.js ***!
  \****************************************************************************************************************************/
/*! exports provided: CARD_SELECT_VALUE_ACCESSOR, CardComponent, CardGroupComponent, CardGroupModule, CardModule, CardSelectComponent, CardSelectModule, ConfirmActionComponent, ConfirmActionModule, DescriptionLevel, DslQueryType, ExpandLevel, FILE_FORMAT_EXTERNAL_PREFIX, FileTypes, FilingPlanComponent, FilingPlanMode, FilingPlanModule, FilingPlanService, ManagementRuleValidators, MetadataApiService, MetadataService, NODE_SELECT_VALUE_ACCESSOR, NodeComponent, RADIO_GROUP_VALUE_ACCESSOR, RULE_ID_PATTERN_ERROR_KEY, SearchUnitApiService, SpinnerModule, SpinnerOverlayService, Status, UpdatedApplicationSelectContentComponent, UpdatedApplicationSelectContentModule, UpdatedVitamUIMenuTileComponent, UpdatedVitamUIMenuTileModule, VITAMUI_INPUT_VALUE_ACCESSOR, VitamUIInputComponent, VitamUIInputModule, VitamUILibraryModule, VitamUIRadioComponent, VitamUIRadioGroupComponent, VitamUIRadioGroupModule, VitamUIRadioModule, VitamUISelectAllOptionComponent, VitamUISelectAllOptionModule, VitamuiLibraryService, download, getBooleanValue, getKeywordValue, getMetadataPermission, getPositionType, oneIncludedNodeRequired */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CARD_SELECT_VALUE_ACCESSOR", function() { return CARD_SELECT_VALUE_ACCESSOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CardComponent", function() { return CardComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CardGroupComponent", function() { return CardGroupComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CardGroupModule", function() { return CardGroupModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CardModule", function() { return CardModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CardSelectComponent", function() { return CardSelectComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CardSelectModule", function() { return CardSelectModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConfirmActionComponent", function() { return ConfirmActionComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConfirmActionModule", function() { return ConfirmActionModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DescriptionLevel", function() { return DescriptionLevel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DslQueryType", function() { return DslQueryType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExpandLevel", function() { return ExpandLevel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FILE_FORMAT_EXTERNAL_PREFIX", function() { return FILE_FORMAT_EXTERNAL_PREFIX; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FileTypes", function() { return FileTypes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilingPlanComponent", function() { return FilingPlanComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilingPlanMode", function() { return FilingPlanMode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilingPlanModule", function() { return FilingPlanModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilingPlanService", function() { return FilingPlanService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ManagementRuleValidators", function() { return ManagementRuleValidators; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MetadataApiService", function() { return MetadataApiService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MetadataService", function() { return MetadataService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NODE_SELECT_VALUE_ACCESSOR", function() { return NODE_SELECT_VALUE_ACCESSOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NodeComponent", function() { return NodeComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RADIO_GROUP_VALUE_ACCESSOR", function() { return RADIO_GROUP_VALUE_ACCESSOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RULE_ID_PATTERN_ERROR_KEY", function() { return RULE_ID_PATTERN_ERROR_KEY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SearchUnitApiService", function() { return SearchUnitApiService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SpinnerModule", function() { return SpinnerModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SpinnerOverlayService", function() { return SpinnerOverlayService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Status", function() { return Status; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UpdatedApplicationSelectContentComponent", function() { return UpdatedApplicationSelectContentComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UpdatedApplicationSelectContentModule", function() { return UpdatedApplicationSelectContentModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UpdatedVitamUIMenuTileComponent", function() { return UpdatedVitamUIMenuTileComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UpdatedVitamUIMenuTileModule", function() { return UpdatedVitamUIMenuTileModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VITAMUI_INPUT_VALUE_ACCESSOR", function() { return VITAMUI_INPUT_VALUE_ACCESSOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VitamUIInputComponent", function() { return VitamUIInputComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VitamUIInputModule", function() { return VitamUIInputModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VitamUILibraryModule", function() { return VitamUILibraryModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VitamUIRadioComponent", function() { return VitamUIRadioComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VitamUIRadioGroupComponent", function() { return VitamUIRadioGroupComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VitamUIRadioGroupModule", function() { return VitamUIRadioGroupModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VitamUIRadioModule", function() { return VitamUIRadioModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VitamUISelectAllOptionComponent", function() { return VitamUISelectAllOptionComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VitamUISelectAllOptionModule", function() { return VitamUISelectAllOptionModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VitamuiLibraryService", function() { return VitamuiLibraryService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "download", function() { return download; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getBooleanValue", function() { return getBooleanValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getKeywordValue", function() { return getKeywordValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMetadataPermission", function() { return getMetadataPermission; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getPositionType", function() { return getPositionType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "oneIncludedNodeRequired", function() { return oneIncludedNodeRequired; });
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/common/http */ "vobO");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "EM62");
/* harmony import */ var ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ui-frontend-common */ "OWX3");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "2kYt");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "sEIs");
/* harmony import */ var _angular_material_card__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/card */ "Meci");
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/button */ "PBFl");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ "nIj0");
/* harmony import */ var _angular_cdk_coercion__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/cdk/coercion */ "5XID");
/* harmony import */ var _angular_material_input__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/input */ "Cd2c");
/* harmony import */ var _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/progress-spinner */ "csyo");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ngx-translate/core */ "s2Ay");
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/dialog */ "OZ4H");
/* harmony import */ var _angular_cdk_tree__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/cdk/tree */ "seVz");
/* harmony import */ var _angular_material_tree__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/tree */ "QcI7");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! uuid */ "pJ58");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! rxjs */ "+kfY");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! rxjs/operators */ "0Wlh");
/* harmony import */ var _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @angular/material/checkbox */ "+Tre");
/* harmony import */ var _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/material/tooltip */ "Y2X+");
/* harmony import */ var _angular_material_core__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @angular/material/core */ "mFH5");






















class MetadataApiService {
    constructor(http, baseUrl) {
        this.http = http;
        this.apiUrl = baseUrl + '/metadata';
    }
    searchMetadata(unitId, headers) {
        return this.http.get(this.apiUrl + '/' + unitId, { headers });
    }
}
/** @nocollapse */ MetadataApiService.ɵfac = function MetadataApiService_Factory(t) { return new (t || MetadataApiService)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"])(_angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClient"]), Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"])(ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["BASE_URL"])); };
/** @nocollapse */ MetadataApiService.ɵprov = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"])({ token: MetadataApiService, factory: MetadataApiService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(MetadataApiService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"],
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: _angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClient"] }, { type: undefined, decorators: [{
                type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"],
                args: [ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["BASE_URL"]]
            }] }]; }, null); })();

class SearchUnitApiService {
    constructor(http, baseUrl) {
        this.http = http;
        this.baseUrl = baseUrl;
        this.apiUrl = this.baseUrl + '/search';
    }
    check(unitId, headers) {
        return this.http.get(this.apiUrl + '/units/check/' + unitId, { headers });
    }
    getById(unitId, headers) {
        return this.http.get(this.apiUrl + '/units/' + unitId, { headers });
    }
    getByDsl(unitId, dsl, headers) {
        return this.http.post(this.apiUrl + '/units/dsl' + (unitId ? '/' + unitId : ''), dsl, { headers });
    }
    getUnitObjectsByDsl(unitId, dsl, headers) {
        return this.http.post(this.apiUrl + '/units/' + unitId + '/objects', dsl, { headers });
    }
    getFilingPlan(headers) {
        return this.http.get(this.apiUrl + '/filingplan', { headers });
    }
    // Manage filling and holding units
    getFilingHoldingScheme(headers) {
        return this.http.get(this.apiUrl + '/filingholdingscheme', { headers });
    }
}
/** @nocollapse */ SearchUnitApiService.ɵfac = function SearchUnitApiService_Factory(t) { return new (t || SearchUnitApiService)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"])(_angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClient"]), Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"])(ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["BASE_URL"])); };
/** @nocollapse */ SearchUnitApiService.ɵprov = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"])({ token: SearchUnitApiService, factory: SearchUnitApiService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(SearchUnitApiService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"],
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: _angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClient"] }, { type: undefined, decorators: [{
                type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"],
                args: [ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["BASE_URL"]]
            }] }]; }, null); })();

/* tslint:disable:component-selector */
function UpdatedVitamUIMenuTileComponent_a_0_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"])(0);
} }
function UpdatedVitamUIMenuTileComponent_a_0_Template(rf, ctx) { if (rf & 1) {
    const _r6 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "a", 3);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("click", function UpdatedVitamUIMenuTileComponent_a_0_Template_a_click_0_listener() { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r6); const ctx_r5 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r5.appSelected(); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(1, UpdatedVitamUIMenuTileComponent_a_0_ng_container_1_Template, 1, 0, "ng-container", 4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const ctx_r0 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    const _r2 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"])(3);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("href", ctx_r0.url, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsanitizeUrl"]);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngTemplateOutlet", _r2);
} }
function UpdatedVitamUIMenuTileComponent_a_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"])(0);
} }
function UpdatedVitamUIMenuTileComponent_a_1_Template(rf, ctx) { if (rf & 1) {
    const _r9 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "a", 5);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("click", function UpdatedVitamUIMenuTileComponent_a_1_Template_a_click_0_listener() { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r9); const ctx_r8 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r8.appSelected(); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(1, UpdatedVitamUIMenuTileComponent_a_1_ng_container_1_Template, 1, 0, "ng-container", 4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const ctx_r1 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    const _r2 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"])(3);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("routerLink", ctx_r1.url);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngTemplateOutlet", _r2);
} }
function UpdatedVitamUIMenuTileComponent_ng_template_2_i_3_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "i", 9);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(1, "chevron_right");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} }
function UpdatedVitamUIMenuTileComponent_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 6);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"])(1, "i", 7);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(2);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(3, UpdatedVitamUIMenuTileComponent_ng_template_2_i_3_Template, 2, 0, "i", 8);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const ctx_r3 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-app-box", ctx_r3.isModalMenu)("archive-tile", (ctx_r3.application == null ? null : ctx_r3.application.identifier) === "ARCHIVE_APP")("settings-app", (ctx_r3.application == null ? null : ctx_r3.application.category) === "settings")("admin-app", (ctx_r3.application == null ? null : ctx_r3.application.category) === "administrators")("user-app", (ctx_r3.application == null ? null : ctx_r3.application.category) === "users")("referential-app", (ctx_r3.application == null ? null : ctx_r3.application.category) === "referential")("opaudit-app", (ctx_r3.application == null ? null : ctx_r3.application.category) === "opaudit")("highlight", ctx_r3.application == null ? null : ctx_r3.application.hasHighlight);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"])("id", ctx_r3.application.identifier);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("vitamuiCommonTooltip", ctx_r3.application == null ? null : ctx_r3.application.tooltip)("vitamuiCommonTooltipShowDelay", 800);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngClass", ctx_r3.application == null ? null : ctx_r3.application.icon);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"])("", ctx_r3.application == null ? null : ctx_r3.application.name, " ");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", (ctx_r3.application == null ? null : ctx_r3.application.hasCustomerList) || (ctx_r3.application == null ? null : ctx_r3.application.hasTenantList));
} }
class UpdatedVitamUIMenuTileComponent {
    constructor(startupService) {
        this.startupService = startupService;
        this.sameApp = false;
        this.appSelect = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
    }
    set application(application) {
        this._application = application;
    }
    get application() {
        return this._application;
    }
    ngOnInit() {
        this.url = this._application.url;
        const uiUrl = this.startupService.getConfigStringValue('UI_URL');
        // to handle single domains we need to remove sameApp feature from portal
        if ((this._application.url.startsWith(uiUrl) && this.startupService.getPortalUrl() !== uiUrl) ||
            (!this._application.url.startsWith('http://') && !this._application.url.startsWith('https://'))) {
            this.sameApp = true;
            this.url = this._application.url.replace(uiUrl, '');
        }
    }
    appSelected() {
        this.appSelect.emit();
    }
}
/** @nocollapse */ UpdatedVitamUIMenuTileComponent.ɵfac = function UpdatedVitamUIMenuTileComponent_Factory(t) { return new (t || UpdatedVitamUIMenuTileComponent)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"])(ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["StartupService"])); };
/** @nocollapse */ UpdatedVitamUIMenuTileComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: UpdatedVitamUIMenuTileComponent, selectors: [["vitamui-common-menu-tile-updated"]], inputs: { isModalMenu: "isModalMenu", application: "application" }, outputs: { appSelect: "appSelect" }, decls: 4, vars: 2, consts: [[3, "href", "click", 4, "ngIf"], [3, "routerLink", "click", 4, "ngIf"], ["button", ""], [3, "href", "click"], [4, "ngTemplateOutlet"], [3, "routerLink", "click"], [1, "app-box", "clickable", "archive-tile", 3, "vitamuiCommonTooltip", "vitamuiCommonTooltipShowDelay", "id"], [3, "ngClass"], ["class", "material-icons chevron-icon", 4, "ngIf"], [1, "material-icons", "chevron-icon"]], template: function UpdatedVitamUIMenuTileComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(0, UpdatedVitamUIMenuTileComponent_a_0_Template, 2, 2, "a", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(1, UpdatedVitamUIMenuTileComponent_a_1_Template, 2, 2, "a", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(2, UpdatedVitamUIMenuTileComponent_ng_template_2_Template, 4, 22, "ng-template", null, 2, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", !ctx.sameApp);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", ctx.sameApp);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgTemplateOutlet"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterLinkWithHref"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["ɵdg"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgClass"]], styles: ["@import url(../../../sass/icons/vitamui-icons.css);.app-box[_ngcontent-%COMP%]{align-items:center;background:#fff;border-radius:10px;box-sizing:border-box;color:#474747;display:flex;font-size:17px;font-style:medium;font-weight:500;height:90px;margin-bottom:24px;padding-bottom:26px;padding-left:23px;padding-top:25px;transition:box-shadow .24s ease-out}.app-box[_ngcontent-%COMP%]:not(.disabled), .app-box[_ngcontent-%COMP%]:not(:disabled){box-shadow:0 1px 4px rgba(var(--vitamui-grey-rgb),.2),0 2px 8px rgba(var(--vitamui-grey-rgb),.05)}.app-box[_ngcontent-%COMP%]:not(.disabled):hover, .app-box[_ngcontent-%COMP%]:not(:disabled):hover{box-shadow:0 2px 8px rgba(var(--vitamui-grey-rgb),.2),0 4px 16px rgba(var(--vitamui-grey-rgb),.05)}.app-box.disabled[_ngcontent-%COMP%], .app-box[_ngcontent-%COMP%]:disabled{box-shadow:none!important}.app-box[_ngcontent-%COMP%]   i[_ngcontent-%COMP%]{font-size:42px;margin-right:15px}.user-app[_ngcontent-%COMP%]   i[_ngcontent-%COMP%]{color:var(--vitamui-primary)}.user-app[_ngcontent-%COMP%]   i.chevron-icon[_ngcontent-%COMP%]{font-size:24px;margin-left:auto}.user-app.highlight[_ngcontent-%COMP%]{border:1px solid var(--vitamui-primary)}.admin-app[_ngcontent-%COMP%]   i[_ngcontent-%COMP%]{color:var(--vitamui-primary-light)}.admin-app[_ngcontent-%COMP%]   i.chevron-icon[_ngcontent-%COMP%]{font-size:24px;margin-left:auto}.admin-app.highlight[_ngcontent-%COMP%]{border:1px solid var(--vitamui-primary-light)}.referential-app[_ngcontent-%COMP%]   i[_ngcontent-%COMP%]{color:var(--vitamui-primary-light)}.referential-app[_ngcontent-%COMP%]   i.chevron-icon[_ngcontent-%COMP%]{font-size:24px;margin-left:auto}.referential-app.highlight[_ngcontent-%COMP%]{border:1px solid var(--vitamui-primary-light)}.opaudit-app[_ngcontent-%COMP%]   i[_ngcontent-%COMP%]{color:var(--vitamui-primary-light)}.opaudit-app[_ngcontent-%COMP%]   i.chevron-icon[_ngcontent-%COMP%]{font-size:24px;margin-left:auto}.opaudit-app.highlight[_ngcontent-%COMP%]{border:1px solid var(--vitamui-primary-light)}.settings-app[_ngcontent-%COMP%]   i[_ngcontent-%COMP%]{color:var(--vitamui-secondary)}.settings-app[_ngcontent-%COMP%]   i.chevron-icon[_ngcontent-%COMP%]{font-size:24px;margin-left:auto}.settings-app.highlight[_ngcontent-%COMP%]{border:1px solid var(--vitamui-secondary)}.chevron-icon[_ngcontent-%COMP%]{font-size:24px;margin-left:auto}.archive-tile[_ngcontent-%COMP%]{background-color:var(--vitamui-primary);color:#fff}.archive-tile[_ngcontent-%COMP%]   i[_ngcontent-%COMP%]{color:#fff}.modal-app-box[_ngcontent-%COMP%]{font-size:14px;height:60px}.modal-app-box[_ngcontent-%COMP%]   i[_ngcontent-%COMP%]{font-size:30px}.clickable[_ngcontent-%COMP%]{cursor:pointer}a[_ngcontent-%COMP%]{text-decoration:none}"] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(UpdatedVitamUIMenuTileComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-common-menu-tile-updated',
                templateUrl: './vitamui-menu-tile.component.html',
                styleUrls: ['./vitamui-menu-tile.component.scss'],
            }]
    }], function () { return [{ type: ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["StartupService"] }]; }, { isModalMenu: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], application: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], appSelect: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"]
        }] }); })();

/* tslint:disable:component-selector */
function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_2_Template(rf, ctx) { if (rf & 1) {
    const _r13 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "vitamui-common-menu-tile-updated", 4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("appSelect", function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_2_Template_vitamui_common_menu_tile_updated_appSelect_0_listener($event) { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r13); const ctx_r12 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r12.selectApp($event); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const appUser_r11 = ctx.$implicit;
    const ctx_r0 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("application", appUser_r11)("isModalMenu", ctx_r0.isModalMenu);
} }
function UpdatedApplicationSelectContentComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 5);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵi18n"])(1, 6);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const ctx_r1 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-category", ctx_r1.isModalMenu);
} }
function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_6_Template(rf, ctx) { if (rf & 1) {
    const _r16 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "vitamui-common-menu-tile-updated", 4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("appSelect", function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_6_Template_vitamui_common_menu_tile_updated_appSelect_0_listener($event) { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r16); const ctx_r15 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r15.selectApp($event); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const appAdmin_r14 = ctx.$implicit;
    const ctx_r2 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("application", appAdmin_r14)("isModalMenu", ctx_r2.isModalMenu);
} }
function UpdatedApplicationSelectContentComponent_div_7_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 5);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵi18n"])(1, 7);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const ctx_r3 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-category", ctx_r3.isModalMenu);
} }
function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_10_Template(rf, ctx) { if (rf & 1) {
    const _r19 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "vitamui-common-menu-tile-updated", 4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("appSelect", function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_10_Template_vitamui_common_menu_tile_updated_appSelect_0_listener($event) { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r19); const ctx_r18 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r18.selectApp($event); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const appAdmin_r17 = ctx.$implicit;
    const ctx_r4 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("application", appAdmin_r17)("isModalMenu", ctx_r4.isModalMenu);
} }
function UpdatedApplicationSelectContentComponent_div_11_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 5);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵi18n"])(1, 8);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const ctx_r5 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-category", ctx_r5.isModalMenu);
} }
function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_14_Template(rf, ctx) { if (rf & 1) {
    const _r22 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "vitamui-common-menu-tile-updated", 4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("appSelect", function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_14_Template_vitamui_common_menu_tile_updated_appSelect_0_listener($event) { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r22); const ctx_r21 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r21.selectApp($event); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const appAdmin_r20 = ctx.$implicit;
    const ctx_r6 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("application", appAdmin_r20)("isModalMenu", ctx_r6.isModalMenu);
} }
function UpdatedApplicationSelectContentComponent_div_15_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 5);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵi18n"])(1, 9);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const ctx_r7 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-category", ctx_r7.isModalMenu);
} }
function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_18_Template(rf, ctx) { if (rf & 1) {
    const _r25 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "vitamui-common-menu-tile-updated", 4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("appSelect", function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_18_Template_vitamui_common_menu_tile_updated_appSelect_0_listener($event) { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r25); const ctx_r24 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r24.selectApp($event); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const appAdmin_r23 = ctx.$implicit;
    const ctx_r8 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("application", appAdmin_r23)("isModalMenu", ctx_r8.isModalMenu);
} }
function UpdatedApplicationSelectContentComponent_div_19_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 5);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵi18n"])(1, 10);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const ctx_r9 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-category", ctx_r9.isModalMenu);
} }
function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_22_Template(rf, ctx) { if (rf & 1) {
    const _r28 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "vitamui-common-menu-tile-updated", 4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("appSelect", function UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_22_Template_vitamui_common_menu_tile_updated_appSelect_0_listener($event) { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r28); const ctx_r27 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r27.selectApp($event); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const appSettings_r26 = ctx.$implicit;
    const ctx_r10 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("application", appSettings_r26)("isModalMenu", ctx_r10.isModalMenu);
} }
class UpdatedApplicationSelectContentComponent {
    constructor(authService) {
        this.authService = authService;
        this.applicationSelected = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
    }
    set applications(applications) {
        this._applications = applications;
        this.checkTenantNumberByApp(this.applications);
        const sortedApps = this._applications.sort((app1, app2) => app1.position - app2.position);
        this.userApplications = sortedApps.filter((app) => app.category === 'users');
        this.adminApplications = sortedApps.filter((app) => app.category === 'administrators');
        this.settingsApplications = sortedApps.filter((app) => app.category === 'settings');
        this.referentialApplications = sortedApps.filter((app) => app.category === 'referential');
        this.opauditApplications = sortedApps.filter((app) => app.category === 'opaudit');
        this.techAdminApplications = sortedApps.filter((app) => app.category === 'techadmin');
    }
    get applications() {
        return this._applications;
    }
    get target() {
        return '_blank';
    }
    checkTenantNumberByApp(apps) {
        apps.forEach((application) => {
            const app = this.authService.user.tenantsByApp.find((appToTest) => appToTest.name === application.id);
            if (app) {
                if (app.tenants && app.tenants.length > 1 && application.hasTenantList) {
                    application.hasTenantList = true;
                }
                else {
                    application.hasTenantList = false;
                }
            }
        });
    }
    selectApp(value) {
        this.applicationSelected.emit(value);
    }
}
/** @nocollapse */ UpdatedApplicationSelectContentComponent.ɵfac = function UpdatedApplicationSelectContentComponent_Factory(t) { return new (t || UpdatedApplicationSelectContentComponent)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"])(ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["AuthService"])); };
/** @nocollapse */ UpdatedApplicationSelectContentComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: UpdatedApplicationSelectContentComponent, selectors: [["vitamui-common-application-select-content-updated"]], inputs: { isModalMenu: "isModalMenu", applications: "applications" }, outputs: { applicationSelected: "applicationSelected" }, decls: 23, vars: 21, consts: function () { var i18n_0; if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @desc Referential category
         */
        const MSG_EXTERNAL_PortalReferentialCategory$$LIB_COMPONENTS_APPLICATION_SELECT_CONTENT_APPLICATION_SELECT_CONTENT_COMPONENT_TS__1 = goog.getMsg(" R\u00E9f\u00E9rentiels\n");
        i18n_0 = MSG_EXTERNAL_PortalReferentialCategory$$LIB_COMPONENTS_APPLICATION_SELECT_CONTENT_APPLICATION_SELECT_CONTENT_COMPONENT_TS__1;
    }
    else {
        i18n_0 = " R\xE9f\xE9rentiels\n";
    } var i18n_2; if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @desc operations and audits category
         */
        const MSG_EXTERNAL_PortalOpauditCategory$$LIB_COMPONENTS_APPLICATION_SELECT_CONTENT_APPLICATION_SELECT_CONTENT_COMPONENT_TS__3 = goog.getMsg(" Audits et op\u00E9rations\n");
        i18n_2 = MSG_EXTERNAL_PortalOpauditCategory$$LIB_COMPONENTS_APPLICATION_SELECT_CONTENT_APPLICATION_SELECT_CONTENT_COMPONENT_TS__3;
    }
    else {
        i18n_2 = " Audits et op\xE9rations\n";
    } var i18n_4; if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @desc operations and audits category
         */
        const MSG_EXTERNAL_PortalOpauditCategory$$LIB_COMPONENTS_APPLICATION_SELECT_CONTENT_APPLICATION_SELECT_CONTENT_COMPONENT_TS__5 = goog.getMsg(" Administration Technique\n");
        i18n_4 = MSG_EXTERNAL_PortalOpauditCategory$$LIB_COMPONENTS_APPLICATION_SELECT_CONTENT_APPLICATION_SELECT_CONTENT_COMPONENT_TS__5;
    }
    else {
        i18n_4 = " Administration Technique\n";
    } var i18n_6; if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @desc Management category
         */
        const MSG_EXTERNAL_PortalManagementCategory$$LIB_COMPONENTS_APPLICATION_SELECT_CONTENT_APPLICATION_SELECT_CONTENT_COMPONENT_TS__7 = goog.getMsg(" Management\n");
        i18n_6 = MSG_EXTERNAL_PortalManagementCategory$$LIB_COMPONENTS_APPLICATION_SELECT_CONTENT_APPLICATION_SELECT_CONTENT_COMPONENT_TS__7;
    }
    else {
        i18n_6 = " Management\n";
    } var i18n_8; if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @desc Settings category
         */
        const MSG_EXTERNAL_PortalSettingsCategory$$LIB_COMPONENTS_APPLICATION_SELECT_CONTENT_APPLICATION_SELECT_CONTENT_COMPONENT_TS__9 = goog.getMsg(" Param\u00E9trage\n");
        i18n_8 = MSG_EXTERNAL_PortalSettingsCategory$$LIB_COMPONENTS_APPLICATION_SELECT_CONTENT_APPLICATION_SELECT_CONTENT_COMPONENT_TS__9;
    }
    else {
        i18n_8 = " Param\xE9trage\n";
    } return [[1, "app-container"], [1, "row"], ["class", "col-sm-12 col-md-6 col-lg-4 col-xl-4", 3, "application", "isModalMenu", "appSelect", 4, "ngFor", "ngForOf"], ["class", "row category-header", 3, "modal-category", 4, "ngIf"], [1, "col-sm-12", "col-md-6", "col-lg-4", "col-xl-4", 3, "application", "isModalMenu", "appSelect"], [1, "row", "category-header"], i18n_0, i18n_2, i18n_4, i18n_6, i18n_8]; }, template: function UpdatedApplicationSelectContentComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "div", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(2, UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_2_Template, 1, 2, "vitamui-common-menu-tile-updated", 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(3, UpdatedApplicationSelectContentComponent_div_3_Template, 2, 2, "div", 3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(4, "div", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(5, "div", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(6, UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_6_Template, 1, 2, "vitamui-common-menu-tile-updated", 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(7, UpdatedApplicationSelectContentComponent_div_7_Template, 2, 2, "div", 3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(8, "div", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(9, "div", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(10, UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_10_Template, 1, 2, "vitamui-common-menu-tile-updated", 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(11, UpdatedApplicationSelectContentComponent_div_11_Template, 2, 2, "div", 3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(12, "div", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(13, "div", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(14, UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_14_Template, 1, 2, "vitamui-common-menu-tile-updated", 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(15, UpdatedApplicationSelectContentComponent_div_15_Template, 2, 2, "div", 3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(16, "div", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(17, "div", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(18, UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_18_Template, 1, 2, "vitamui-common-menu-tile-updated", 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(19, UpdatedApplicationSelectContentComponent_div_19_Template, 2, 2, "div", 3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(20, "div", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(21, "div", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(22, UpdatedApplicationSelectContentComponent_vitamui_common_menu_tile_updated_22_Template, 1, 2, "vitamui-common-menu-tile-updated", 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-container", ctx.isModalMenu);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngForOf", ctx.userApplications);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", (ctx.referentialApplications == null ? null : ctx.referentialApplications.length) > 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-container", ctx.isModalMenu);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngForOf", ctx.referentialApplications);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", (ctx.opauditApplications == null ? null : ctx.opauditApplications.length) > 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-container", ctx.isModalMenu);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngForOf", ctx.opauditApplications);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", (ctx.techAdminApplications == null ? null : ctx.techAdminApplications.length) > 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-container", ctx.isModalMenu);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngForOf", ctx.techAdminApplications);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", (ctx.adminApplications == null ? null : ctx.adminApplications.length) > 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("modal-container", ctx.isModalMenu);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngForOf", ctx.adminApplications);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", (ctx.settingsApplications == null ? null : ctx.settingsApplications.length) > 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngForOf", ctx.settingsApplications);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgForOf"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], UpdatedVitamUIMenuTileComponent], styles: [".app-container[_ngcontent-%COMP%]{margin-bottom:20px}.modal-container[_ngcontent-%COMP%]{margin-bottom:16px;margin-top:9px}.category-header[_ngcontent-%COMP%]{color:var(--vitamui-grey-900);font-size:20px;padding-bottom:10px;padding-left:25px}.modal-category[_ngcontent-%COMP%]{font-size:16px;padding-left:20px}"] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(UpdatedApplicationSelectContentComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-common-application-select-content-updated',
                templateUrl: './application-select-content.component.html',
                styleUrls: ['./application-select-content.component.scss'],
            }]
    }], function () { return [{ type: ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["AuthService"] }]; }, { isModalMenu: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], applications: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], applicationSelected: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"]
        }] }); })();

/*
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */
class UpdatedVitamUIMenuTileModule {
}
/** @nocollapse */ UpdatedVitamUIMenuTileModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: UpdatedVitamUIMenuTileModule });
/** @nocollapse */ UpdatedVitamUIMenuTileModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function UpdatedVitamUIMenuTileModule_Factory(t) { return new (t || UpdatedVitamUIMenuTileModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["TooltipModule"]]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(UpdatedVitamUIMenuTileModule, { declarations: [UpdatedVitamUIMenuTileComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["TooltipModule"]], exports: [UpdatedVitamUIMenuTileComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(UpdatedVitamUIMenuTileModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["TooltipModule"]],
                declarations: [UpdatedVitamUIMenuTileComponent],
                exports: [UpdatedVitamUIMenuTileComponent],
            }]
    }], null, null); })();

/*
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */
class UpdatedApplicationSelectContentModule {
}
/** @nocollapse */ UpdatedApplicationSelectContentModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: UpdatedApplicationSelectContentModule });
/** @nocollapse */ UpdatedApplicationSelectContentModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function UpdatedApplicationSelectContentModule_Factory(t) { return new (t || UpdatedApplicationSelectContentModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClientModule"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"], UpdatedVitamUIMenuTileModule]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(UpdatedApplicationSelectContentModule, { declarations: [UpdatedApplicationSelectContentComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClientModule"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"], UpdatedVitamUIMenuTileModule], exports: [UpdatedApplicationSelectContentComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(UpdatedApplicationSelectContentModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClientModule"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"], UpdatedVitamUIMenuTileModule],
                declarations: [UpdatedApplicationSelectContentComponent],
                exports: [UpdatedApplicationSelectContentComponent],
            }]
    }], null, null); })();

/* tslint:disable:component-selector */
function CardComponent_button_2_Template(rf, ctx) { if (rf & 1) {
    const _r2 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "button", 2);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("click", function CardComponent_button_2_Template_button_click_0_listener() { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r2); const ctx_r1 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r1.buttonClicked(); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "i", 3);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(2, "close");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} }
const _c0 = function (a0) { return { "card-fill": a0 }; };
class CardComponent {
    constructor() {
        this.showAction = true;
        this.buttonClick = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
    }
    ngOnInit() { }
    buttonClicked() {
        this.buttonClick.emit();
    }
}
/** @nocollapse */ CardComponent.ɵfac = function CardComponent_Factory(t) { return new (t || CardComponent)(); };
/** @nocollapse */ CardComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: CardComponent, selectors: [["vitamui-card"]], inputs: { value: "value", showAction: "showAction" }, outputs: { buttonClick: "buttonClick" }, decls: 3, vars: 5, consts: [[1, "vitamui-card", 3, "ngClass"], ["mat-button", "", 3, "click", 4, "ngIf"], ["mat-button", "", 3, "click"], [1, "material-icons"]], template: function CardComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "mat-card", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(2, CardComponent_button_2_Template, 3, 0, "button", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngClass", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"])(3, _c0, ctx.showAction));
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"])(" ", ctx.value, " ");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", ctx.showAction);
    } }, directives: [_angular_material_card__WEBPACK_IMPORTED_MODULE_5__["MatCard"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgClass"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], _angular_material_button__WEBPACK_IMPORTED_MODULE_6__["MatButton"]], styles: [".vitamui-card[_ngcontent-%COMP%]{border:1px solid #258a7a;border-radius:5px;box-shadow:0 0 2px rgba(var(--vitamui-grey-rgb),.2),0 1px 4px rgba(var(--vitamui-grey-rgb),.05);box-sizing:border-box;display:inline-block;margin-bottom:7px;margin-right:7px;min-width:140px;padding-right:50px}.vitamui-card[_ngcontent-%COMP%] > button[_ngcontent-%COMP%]{border:0;border-left:1px solid #5a9288;border-radius:0;height:100%;min-width:40px;padding:0;position:absolute;right:0;top:0}.vitamui-card.card-fill[_ngcontent-%COMP%]{background:#5cbaa9}"] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(CardComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-card',
                templateUrl: './card.component.html',
                styleUrls: ['./card.component.scss'],
            }]
    }], function () { return []; }, { value: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], showAction: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], buttonClick: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"]
        }] }); })();

/* tslint:disable:component-selector */
function CardGroupComponent_vitamui_card_0_Template(rf, ctx) { if (rf & 1) {
    const _r3 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "vitamui-card", 1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("buttonClick", function CardGroupComponent_vitamui_card_0_Template_vitamui_card_buttonClick_0_listener() { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r3); const value_r1 = ctx.$implicit; const ctx_r2 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r2.remove(value_r1); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const value_r1 = ctx.$implicit;
    const ctx_r0 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("value", value_r1)("showAction", ctx_r0.showAction);
} }
class CardGroupComponent {
    constructor() {
        this.valuesChange = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
    }
    ngOnInit() { }
    remove($event) {
        this.values.delete($event);
        this.valuesChange.emit(this.values);
    }
}
/** @nocollapse */ CardGroupComponent.ɵfac = function CardGroupComponent_Factory(t) { return new (t || CardGroupComponent)(); };
/** @nocollapse */ CardGroupComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: CardGroupComponent, selectors: [["vitamui-card-group"]], inputs: { values: "values", showAction: "showAction" }, outputs: { valuesChange: "valuesChange" }, decls: 1, vars: 1, consts: [[3, "value", "showAction", "buttonClick", 4, "ngFor", "ngForOf"], [3, "value", "showAction", "buttonClick"]], template: function CardGroupComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(0, CardGroupComponent_vitamui_card_0_Template, 1, 2, "vitamui-card", 0);
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngForOf", ctx.values);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgForOf"], CardComponent], styles: [""] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(CardGroupComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-card-group',
                templateUrl: './card-group.component.html',
                styleUrls: ['./card-group.component.scss'],
            }]
    }], function () { return []; }, { values: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], showAction: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], valuesChange: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"]
        }] }); })();

class CardModule {
}
/** @nocollapse */ CardModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: CardModule });
/** @nocollapse */ CardModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function CardModule_Factory(t) { return new (t || CardModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_material_card__WEBPACK_IMPORTED_MODULE_5__["MatCardModule"], _angular_material_button__WEBPACK_IMPORTED_MODULE_6__["MatButtonModule"]]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(CardModule, { declarations: [CardComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_material_card__WEBPACK_IMPORTED_MODULE_5__["MatCardModule"], _angular_material_button__WEBPACK_IMPORTED_MODULE_6__["MatButtonModule"]], exports: [CardComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(CardModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                declarations: [CardComponent],
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_material_card__WEBPACK_IMPORTED_MODULE_5__["MatCardModule"], _angular_material_button__WEBPACK_IMPORTED_MODULE_6__["MatButtonModule"]],
                exports: [CardComponent],
            }]
    }], null, null); })();

class CardGroupModule {
}
/** @nocollapse */ CardGroupModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: CardGroupModule });
/** @nocollapse */ CardGroupModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function CardGroupModule_Factory(t) { return new (t || CardGroupModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], CardModule]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(CardGroupModule, { declarations: [CardGroupComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], CardModule], exports: [CardGroupComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(CardGroupModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                declarations: [CardGroupComponent],
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], CardModule],
                exports: [CardGroupComponent],
            }]
    }], null, null); })();

/*
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */
const _c0$1 = ["input"];
function VitamUIInputComponent_span_3_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "span", 5);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(1, "*");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} }
function VitamUIInputComponent_div_6_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 6);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵprojection"])(1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} }
const _c1 = ["*"];
const VITAMUI_INPUT_VALUE_ACCESSOR = {
    provide: _angular_forms__WEBPACK_IMPORTED_MODULE_7__["NG_VALUE_ACCESSOR"],
    useExisting: Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["forwardRef"])(() => VitamUIInputComponent),
    multi: true,
};
class VitamUIInputComponent {
    constructor() {
        this.type = 'text';
        // tslint:disable-next-line:variable-name
        this._required = false;
        // tslint:disable-next-line:variable-name
        this._disabled = false;
        this.focused = false;
        this.labelFloat = false;
        this.onChange = (_) => { };
        this.onTouched = () => { };
    }
    get required() {
        return this._required;
    }
    set required(value) {
        this._required = Object(_angular_cdk_coercion__WEBPACK_IMPORTED_MODULE_8__["coerceBooleanProperty"])(value);
    }
    get disabled() {
        return this._disabled;
    }
    set disabled(value) {
        this._disabled = Object(_angular_cdk_coercion__WEBPACK_IMPORTED_MODULE_8__["coerceBooleanProperty"])(value);
    }
    ngOnInit() {
        if (this.value != null) {
            this.writeValue(this.value);
        }
    }
    onClick() {
        this.input.nativeElement.focus();
    }
    writeValue(value) {
        this.value = value;
        this.labelFloat = !!this.value;
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    onTextChange(value) {
        this.labelFloat = !!this.value;
        this.onChange(value);
    }
    onNumberChange(value) {
        const badInput = this.input.nativeElement.validity.badInput;
        this.labelFloat = badInput || this.value !== null;
        this.onChange(value);
    }
    onChangeValue(value) {
        if (this.type === 'number') {
            this.onNumberChange(value);
        }
        else {
            this.onTextChange(value);
        }
    }
    onFocus() {
        this.focused = true;
    }
    onBlur() {
        this.focused = false;
        this.onTouched();
    }
    setDisabledState(isDisabled) {
        this.disabled = isDisabled;
    }
}
/** @nocollapse */ VitamUIInputComponent.ɵfac = function VitamUIInputComponent_Factory(t) { return new (t || VitamUIInputComponent)(); };
/** @nocollapse */ VitamUIInputComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: VitamUIInputComponent, selectors: [["vitamui-library-input"]], viewQuery: function VitamUIInputComponent_Query(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵviewQuery"])(_c0$1, true);
    } if (rf & 2) {
        var _t;
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"])(_t = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"])()) && (ctx.input = _t.first);
    } }, hostVars: 4, hostBindings: function VitamUIInputComponent_HostBindings(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("click", function VitamUIInputComponent_click_HostBindingHandler() { return ctx.onClick(); });
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("vitamui-focused", ctx.focused)("vitamui-float", ctx.labelFloat);
    } }, inputs: { type: "type", maxlength: "maxlength", placeholder: "placeholder", autofocus: "autofocus", required: "required", disabled: "disabled", value: "value" }, features: [Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵProvidersFeature"])([VITAMUI_INPUT_VALUE_ACCESSOR])], ngContentSelectors: _c1, decls: 7, vars: 11, consts: [[1, "vitamui-input"], ["class", "required-marker", 4, "ngIf"], [3, "type", "required", "disabled", "autofocus", "ngModel", "blur", "focus", "ngModelChange"], ["input", ""], ["class", "vitamui-input-errors", 4, "ngIf"], [1, "required-marker"], [1, "vitamui-input-errors"]], template: function VitamUIInputComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵprojectionDef"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "label");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(3, VitamUIInputComponent_span_3_Template, 2, 0, "span", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(4, "input", 2, 3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("blur", function VitamUIInputComponent_Template_input_blur_4_listener() { return ctx.onBlur(); })("focus", function VitamUIInputComponent_Template_input_focus_4_listener() { return ctx.onFocus(); })("ngModelChange", function VitamUIInputComponent_Template_input_ngModelChange_4_listener($event) { return ctx.value = $event; })("ngModelChange", function VitamUIInputComponent_Template_input_ngModelChange_4_listener($event) { return ctx.onChangeValue($event); });
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(6, VitamUIInputComponent_div_6_Template, 2, 0, "div", 4);
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("disabled", ctx.disabled);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"])(" ", ctx.placeholder, " ");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", ctx.required);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("type", ctx.type)("required", ctx.required)("disabled", ctx.disabled)("autofocus", ctx.autofocus)("ngModel", ctx.value);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"])("maxlength", ctx.maxlength);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", !ctx.disabled);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["RequiredValidator"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["MaxLengthValidator"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["NgModel"]], styles: ["[_nghost-%COMP%]{display:inline-block}.ng-valid.ng-touched[_nghost-%COMP%]   .vitamui-input[_ngcontent-%COMP%]{border-color:#27740a}.ng-invalid.ng-touched[_nghost-%COMP%]   .vitamui-input[_ngcontent-%COMP%]{border-color:#c10000}[_nghost-%COMP%]   .vitamui-input[_ngcontent-%COMP%]   mat-spinner[_ngcontent-%COMP%]{display:block}"] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamUIInputComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-library-input',
                templateUrl: './vitamui-input.component.html',
                styleUrls: ['./vitamui-input.component.scss'],
                providers: [VITAMUI_INPUT_VALUE_ACCESSOR],
            }]
    }], null, { type: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], maxlength: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], placeholder: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], autofocus: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], required: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], disabled: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], input: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"],
            args: ['input', { static: false }]
        }], focused: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["HostBinding"],
            args: ['class.vitamui-focused']
        }], labelFloat: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["HostBinding"],
            args: ['class.vitamui-float']
        }], value: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], onClick: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["HostListener"],
            args: ['click']
        }] }); })();

/* tslint:disable:no-use-before-declare component-selector */
function CardSelectComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r3 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "div", 4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(2, "vitamui-library-input", 5, 6);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("keydown.enter", function CardSelectComponent_div_0_Template_vitamui_library_input_keydown_enter_2_listener() { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r3); const _r1 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"])(3); const ctx_r2 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r2.addElement(_r1); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(4, "div", 7);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(5, "button", 8);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("click", function CardSelectComponent_div_0_Template_button_click_5_listener() { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r3); const _r1 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"])(3); const ctx_r4 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r4.addElement(_r1); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(6, "i", 9);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(7, "add_circle_outline");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(8, "span");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(9);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const ctx_r0 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("placeholder", ctx_r0.placeholder)("disabled", ctx_r0.values.size == ctx_r0.size);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(3);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("disabled", ctx_r0.values.size == ctx_r0.size);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"])(ctx_r0.label);
} }
const CARD_SELECT_VALUE_ACCESSOR = {
    provide: _angular_forms__WEBPACK_IMPORTED_MODULE_7__["NG_VALUE_ACCESSOR"],
    useExisting: Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["forwardRef"])(() => CardSelectComponent),
    multi: true,
};
class CardSelectComponent {
    constructor() {
        this.label = 'Add';
        this.disabled = false;
        this.values = new Set();
        this.onChange = (_) => { };
        this.onTouched = () => { };
    }
    addElement(input) {
        if (this.size !== undefined && this.values.size >= this.size) {
            return;
        }
        if (input.value != null && input.value !== '') {
            this.values.add(input.value.trim());
            input.writeValue(null);
            this.onChange(Array.from(this.values));
        }
    }
    changeValue($event) {
        this.values = $event;
        this.onChange(Array.from(this.values));
    }
    writeValue(value) {
        this.values = new Set(value == null ? new Array() : value);
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
}
/** @nocollapse */ CardSelectComponent.ɵfac = function CardSelectComponent_Factory(t) { return new (t || CardSelectComponent)(); };
/** @nocollapse */ CardSelectComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: CardSelectComponent, selectors: [["vitamui-card-select"]], inputs: { placeholder: "placeholder", label: "label", disabled: "disabled", size: "size" }, features: [Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵProvidersFeature"])([CARD_SELECT_VALUE_ACCESSOR])], decls: 4, vars: 3, consts: [["class", "row multi-select-row", 4, "ngIf"], [1, "row", "multi-select-row"], ["clas", "col-12"], [3, "values", "showAction", "valuesChange"], [1, "col-8"], ["type", "text", "required", "", 3, "placeholder", "disabled", "keydown.enter"], ["input", ""], [1, "col-4"], ["type", "button", 1, "btn", "add-button", 3, "disabled", "click"], [1, "material-icons"]], template: function CardSelectComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(0, CardSelectComponent_div_0_Template, 10, 4, "div", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "div", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(2, "div", 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(3, "vitamui-card-group", 3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("valuesChange", function CardSelectComponent_Template_vitamui_card_group_valuesChange_3_listener($event) { return ctx.changeValue($event); });
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", !ctx.disabled);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("values", ctx.values)("showAction", !ctx.disabled);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], CardGroupComponent, VitamUIInputComponent], styles: [".add-button[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]{margin-left:5px}.multi-select-row[_ngcontent-%COMP%]{margin-bottom:30px}vitamui-library-input[_ngcontent-%COMP%]{width:100%}"] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(CardSelectComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-card-select',
                templateUrl: './card-select.component.html',
                styleUrls: ['./card-select.component.scss'],
                providers: [CARD_SELECT_VALUE_ACCESSOR],
            }]
    }], null, { placeholder: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], label: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], disabled: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], size: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }] }); })();

/*
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */
class VitamUIInputModule {
}
/** @nocollapse */ VitamUIInputModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: VitamUIInputModule });
/** @nocollapse */ VitamUIInputModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function VitamUIInputModule_Factory(t) { return new (t || VitamUIInputModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"], _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatProgressSpinnerModule"]]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(VitamUIInputModule, { declarations: [VitamUIInputComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"], _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatProgressSpinnerModule"]], exports: [VitamUIInputComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamUIInputModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"], _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatProgressSpinnerModule"]],
                declarations: [VitamUIInputComponent],
                exports: [VitamUIInputComponent],
            }]
    }], null, null); })();

class CardSelectModule {
}
/** @nocollapse */ CardSelectModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: CardSelectModule });
/** @nocollapse */ CardSelectModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function CardSelectModule_Factory(t) { return new (t || CardSelectModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["VitamUICommonModule"], VitamUIInputModule, CardGroupModule, _angular_material_input__WEBPACK_IMPORTED_MODULE_9__["MatInputModule"]]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(CardSelectModule, { declarations: [CardSelectComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["VitamUICommonModule"], VitamUIInputModule, CardGroupModule, _angular_material_input__WEBPACK_IMPORTED_MODULE_9__["MatInputModule"]], exports: [CardSelectComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(CardSelectModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                declarations: [CardSelectComponent],
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["VitamUICommonModule"], VitamUIInputModule, CardGroupModule, _angular_material_input__WEBPACK_IMPORTED_MODULE_9__["MatInputModule"]],
                exports: [CardSelectComponent],
            }]
    }], null, null); })();

/* tslint:disable:component-selector */
const _c0$2 = function (a0) { return { objectType: a0 }; };
const _c1$1 = function (a0, a1) { return { objectType: a0, objectName: a1 }; };
function ConfirmActionComponent_vitamui_common_confirm_dialog_0_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "vitamui-common-confirm-dialog", 1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"])(1, "translate");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"])(2, "translate");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"])(3, "translate");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"])(5, "translate");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const ctx_r0 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"])("dialogTitle", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"])(1, 4, "CONFIRM_DIALOG.DELETE_TITLE", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"])(14, _c0$2, ctx_r0.objectType)));
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"])("confirmLabel", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"])(2, 7, "COMMON.CONFIRM"));
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"])("cancelLabel", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"])(3, 9, "COMMON.CANCEL"));
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"])(" ", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"])(5, 11, "CONFIRM_DIALOG.DELETE", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction2"])(16, _c1$1, ctx_r0.objectType, ctx_r0.objectName)), "\n");
} }
function ConfirmActionComponent_vitamui_common_confirm_dialog_1_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "vitamui-common-confirm-dialog", 1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"])(1, "translate");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"])(2, "translate");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"])(3, "translate");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"])(5, "translate");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"])("dialogTitle", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"])(1, 4, "CONFIRM_DIALOG.UNSAVED_CHANGES_TITLE"));
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"])("confirmLabel", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"])(2, 6, "COMMON.YES"));
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"])("cancelLabel", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"])(3, 8, "COMMON.NO"));
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(4);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"])(" ", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"])(5, 10, "CONFIRM_DIALOG.SAVE"), "\n");
} }
class ConfirmActionComponent {
    constructor() {
        // delete or changeTab
        this.dialogType = 'delete';
    }
}
/** @nocollapse */ ConfirmActionComponent.ɵfac = function ConfirmActionComponent_Factory(t) { return new (t || ConfirmActionComponent)(); };
/** @nocollapse */ ConfirmActionComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: ConfirmActionComponent, selectors: [["vitamui-confirm-action"]], inputs: { dialogType: "dialogType", objectName: "objectName", objectType: "objectType" }, decls: 2, vars: 2, consts: [[3, "dialogTitle", "confirmLabel", "cancelLabel", 4, "ngIf"], [3, "dialogTitle", "confirmLabel", "cancelLabel"]], template: function ConfirmActionComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(0, ConfirmActionComponent_vitamui_common_confirm_dialog_0_Template, 6, 19, "vitamui-common-confirm-dialog", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(1, ConfirmActionComponent_vitamui_common_confirm_dialog_1_Template, 6, 12, "vitamui-common-confirm-dialog", 0);
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", ctx.dialogType === "delete");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", ctx.dialogType === "changeTab");
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["ConfirmDialogComponent"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_11__["TranslatePipe"]], styles: [""] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(ConfirmActionComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-confirm-action',
                templateUrl: './confirm-action.component.html',
                styleUrls: ['./confirm-action.component.scss'],
            }]
    }], null, { dialogType: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], objectName: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], objectType: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }] }); })();

/*
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */
class ConfirmActionModule {
}
/** @nocollapse */ ConfirmActionModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: ConfirmActionModule });
/** @nocollapse */ ConfirmActionModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function ConfirmActionModule_Factory(t) { return new (t || ConfirmActionModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__["MatDialogModule"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["ConfirmDialogModule"], _ngx_translate_core__WEBPACK_IMPORTED_MODULE_11__["TranslateModule"]]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(ConfirmActionModule, { declarations: [ConfirmActionComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__["MatDialogModule"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["ConfirmDialogModule"], _ngx_translate_core__WEBPACK_IMPORTED_MODULE_11__["TranslateModule"]], exports: [ConfirmActionComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(ConfirmActionModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                declarations: [ConfirmActionComponent],
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__["MatDialogModule"], ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["ConfirmDialogModule"], _ngx_translate_core__WEBPACK_IMPORTED_MODULE_11__["TranslateModule"]],
                exports: [ConfirmActionComponent],
                entryComponents: [ConfirmActionComponent],
            }]
    }], null, null); })();

function getBooleanValue(unit, key) {
    const value = getKeywordValue(unit, key);
    return value === 'true';
}
function getPositionType(unit) {
    return getKeywordValue(unit, 'position_type');
}
function getKeywordValue(unit, keywordReference) {
    if (!unit.Keyword) {
        return null;
    }
    const keyword = unit.Keyword.find((k) => k.KeywordReference === keywordReference);
    return keyword ? keyword.KeywordContent : null;
}
function getMetadataPermission(unit) {
    const serializedMetadata = getKeywordValue(unit, 'metadata');
    if (!serializedMetadata) {
        return [];
    }
    return JSON.parse(serializedMetadata);
}

/*
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2015-2022)
 *
 * contact.vitam@culture.gouv.fr
 *
 * This software is a computer program whose purpose is to implement a digital archiving back-office system managing
 * high volumetry securely and efficiently.
 *
 * This software is governed by the CeCILL 2.1 license under French law and abiding by the rules of distribution of free
 * software. You can use, modify and/ or redistribute the software under the terms of the CeCILL 2.1 license as
 * circulated by CEA, CNRS and INRIA at the following URL "https://cecill.info".
 *
 * As a counterpart to the access to the source code and rights to copy, modify and redistribute granted by the license,
 * users are provided only with a limited warranty and the software's author, the holder of the economic rights, and the
 * successive licensors have only limited liability.
 *
 * In this respect, the user's attention is drawn to the risks associated with loading, using, modifying and/or
 * developing or reproducing the software by the user in light of its specific status of free software, that may mean
 * that it is complicated to manipulate, and that also therefore means that it is reserved for developers and
 * experienced professionals having in-depth computer knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions enabling the security of their systems and/or data
 * to be ensured and, more generally, to use and operate it in the same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had knowledge of the CeCILL 2.1 license and that you
 * accept its terms.
 *
 *
 */
var ExpandLevel;
(function (ExpandLevel) {
    ExpandLevel[ExpandLevel["NONE"] = 0] = "NONE";
    ExpandLevel[ExpandLevel["ROOT_ONLY"] = 1] = "ROOT_ONLY";
    ExpandLevel[ExpandLevel["ALL"] = 2] = "ALL";
})(ExpandLevel || (ExpandLevel = {}));
var FilingPlanMode;
(function (FilingPlanMode) {
    FilingPlanMode[FilingPlanMode["SOLO"] = 0] = "SOLO";
    FilingPlanMode[FilingPlanMode["INCLUDE_ONLY"] = 1] = "INCLUDE_ONLY";
    FilingPlanMode[FilingPlanMode["BOTH"] = 2] = "BOTH";
})(FilingPlanMode || (FilingPlanMode = {}));
class FilingPlanService {
    constructor(searchUnitApi, locale) {
        this.searchUnitApi = searchUnitApi;
        this.locale = locale;
        // tslint:disable-next-line:variable-name
        this._pending = 0;
    }
    get pending() {
        return this._pending > 0;
    }
    loadTree(tenantIdentifier, accessContractId, idPrefix) {
        this._pending++;
        const headers = new _angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpHeaders"]({
            'X-Tenant-Id': tenantIdentifier.toString(),
            'X-Access-Contract-Id': accessContractId,
        });
        const units$ = this.searchUnitApi.getFilingPlan(headers).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_17__["catchError"])(() => {
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_16__["of"])({ $hits: null, $results: [] });
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_17__["map"])((response) => response.$results), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_17__["tap"])(() => this._pending--), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_17__["shareReplay"])(1));
        return units$.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_17__["map"])((results) => {
            return this.getNestedChildren(results, idPrefix);
        }));
    }
    getFileTypeFromUnit(unit) {
        return this.getFileType(unit['#unitType'], unit.DescriptionLevel);
    }
    getFileType(unitType, descriptionLevel) {
        // TODO file type for documents
        if (descriptionLevel === ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["DescriptionLevel"].FILE) {
            if (unitType === ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["UnitType"].HOLDING_UNIT) {
                return ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["FileType"].FOLDER_HOLDING;
            }
            return ui_frontend_common__WEBPACK_IMPORTED_MODULE_2__["FileType"].FOLDER_INGEST;
        }
        return null;
    }
    getNestedChildren(arr, idPrefix, parentNode) {
        const out = [];
        arr.forEach((unit) => {
            if ((parentNode && parentNode.vitamId && unit['#unitups'] && unit['#unitups'][0] === parentNode.vitamId) ||
                (!parentNode && (!unit['#unitups'] || !unit['#unitups'].length || !idExists(arr, unit['#unitups'][0])))) {
                const outNode = {
                    id: idPrefix + '-' + unit['#id'],
                    label: unit.Title,
                    type: this.getFileTypeFromUnit(unit),
                    children: [],
                    ingestContractIdentifier: getKeywordValue(unit, 'ingest_contract'),
                    vitamId: unit['#id'],
                    parents: parentNode ? [parentNode] : [],
                    checked: false,
                };
                outNode.children = this.getNestedChildren(arr, idPrefix, outNode);
                out.push(outNode);
            }
        });
        return out.sort(byTitle(this.locale));
    }
}
/** @nocollapse */ FilingPlanService.ɵfac = function FilingPlanService_Factory(t) { return new (t || FilingPlanService)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"])(SearchUnitApiService), Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_1__["LOCALE_ID"])); };
/** @nocollapse */ FilingPlanService.ɵprov = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"])({ token: FilingPlanService, factory: FilingPlanService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(FilingPlanService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"],
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: SearchUnitApiService }, { type: undefined, decorators: [{
                type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"],
                args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["LOCALE_ID"]]
            }] }]; }, null); })();
function idExists(units, id) {
    return !!units.find((unit) => unit['#id'] === id);
}
function byTitle(locale) {
    return (a, b) => {
        if (!a || !b || !a.label || !b.label) {
            return 0;
        }
        return a.label.localeCompare(b.label, locale);
    };
}
/** Required at least one node in included */
function oneIncludedNodeRequired() {
    return (control) => {
        const nodes = control.value;
        if (!nodes) {
            return { missingNodes: { value: 'nodes required' } };
        }
        if (!nodes.included || nodes.included.length < 1) {
            return { missingIncludedNodes: { value: 'included nodes required' } };
        }
        return null;
    };
}

/* tslint:disable:component-selector */
class NodeComponent {
    constructor() {
        this.nodeToggle = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        this.labelClick = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
    }
    ngOnInit() { }
}
/** @nocollapse */ NodeComponent.ɵfac = function NodeComponent_Factory(t) { return new (t || NodeComponent)(); };
/** @nocollapse */ NodeComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: NodeComponent, selectors: [["vitamui-library-node"]], inputs: { tenantIdentifier: "tenantIdentifier", node: "node", expanded: "expanded", disabled: "disabled" }, outputs: { nodeToggle: "nodeToggle", labelClick: "labelClick" }, decls: 6, vars: 9, consts: [["mat-icon-button", "", "disableRipple", "", "type", "button", 3, "disabled", "click"], [1, "material-icons", "mat-icon-rtl-mirror"], [3, "id", "ngModel", "indeterminate", "disabled", "ngModelChange", "indeterminateChange"], [1, "node-label", 3, "for", "click"]], template: function NodeComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "button", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("click", function NodeComponent_Template_button_click_0_listener() { return ctx.nodeToggle.emit(); });
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "i", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(3, "mat-checkbox", 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("ngModelChange", function NodeComponent_Template_mat_checkbox_ngModelChange_3_listener($event) { return ctx.node.checked = $event; })("indeterminateChange", function NodeComponent_Template_mat_checkbox_indeterminateChange_3_listener($event) { return ctx.node.disabledChild = $event; })("ngModelChange", function NodeComponent_Template_mat_checkbox_ngModelChange_3_listener() { return ctx.labelClick.emit(); });
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(4);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(5, "label", 3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("click", function NodeComponent_Template_label_click_5_listener() { return ctx.labelClick.emit(); });
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("disabled", ctx.disabled);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"])("aria-label", "toggle " + (ctx.node == null ? null : ctx.node.label));
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"])(ctx.expanded ? "expand_more" : "chevron_right");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate1"])("id", "enable", ctx.node == null ? null : ctx.node.id, "");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngModel", ctx.node.checked)("indeterminate", ctx.node.disabledChild)("disabled", ctx.node.disabled);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"])(ctx.node == null ? null : ctx.node.label);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate1"])("for", "enable", ctx.node == null ? null : ctx.node.id, "");
    } }, directives: [_angular_material_button__WEBPACK_IMPORTED_MODULE_6__["MatButton"], _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_18__["MatCheckbox"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["NgModel"]], styles: ["[_nghost-%COMP%]{align-items:center;display:flex;width:100%}[_nghost-%COMP%]   .hover-btn[_ngcontent-%COMP%], [_nghost-%COMP%]:hover   .hover-btn[_ngcontent-%COMP%]{opacity:0;transform:translateX(20%);transition:transform .1s ease-out,opacity .1s ease-out}[_nghost-%COMP%]:hover:hover   .hover-btn[_ngcontent-%COMP%]{opacity:1;transform:translateX(0)}.node-label[_ngcontent-%COMP%]{flex-grow:1;padding:10px 0}"] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(NodeComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-library-node',
                templateUrl: './node.component.html',
                styleUrls: ['./node.component.scss'],
            }]
    }], function () { return []; }, { tenantIdentifier: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], node: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], expanded: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], disabled: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], nodeToggle: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"]
        }], labelClick: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"]
        }] }); })();

/* tslint:disable:no-use-before-declare component-selector */
function FilingPlanComponent_mat_tree_node_3_Template(rf, ctx) { if (rf & 1) {
    const _r5 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "mat-tree-node");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "li", 6);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(2, "vitamui-library-node", 7);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("nodeToggle", function FilingPlanComponent_mat_tree_node_3_Template_vitamui_library_node_nodeToggle_2_listener() { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r5); const node_r3 = ctx.$implicit; const ctx_r4 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r4.nestedTreeControl.toggle(node_r3); })("labelClick", function FilingPlanComponent_mat_tree_node_3_Template_vitamui_library_node_labelClick_2_listener() { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r5); const node_r3 = ctx.$implicit; const ctx_r6 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r6.emitVitamId(node_r3); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const node_r3 = ctx.$implicit;
    const ctx_r0 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("tenantIdentifier", ctx_r0.tenantIdentifier)("node", node_r3);
} }
function FilingPlanComponent_mat_nested_tree_node_4_Template(rf, ctx) { if (rf & 1) {
    const _r9 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "mat-nested-tree-node");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "li");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(2, "div", 6);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(3, "vitamui-library-node", 8);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("nodeToggle", function FilingPlanComponent_mat_nested_tree_node_4_Template_vitamui_library_node_nodeToggle_3_listener() { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r9); const node_r7 = ctx.$implicit; const ctx_r8 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r8.nestedTreeControl.toggle(node_r7); })("labelClick", function FilingPlanComponent_mat_nested_tree_node_4_Template_vitamui_library_node_labelClick_3_listener() { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"])(_r9); const node_r7 = ctx.$implicit; const ctx_r10 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])(); return ctx_r10.emitVitamId(node_r7); });
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(4, "ul");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"])(5, 9);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} if (rf & 2) {
    const node_r7 = ctx.$implicit;
    const ctx_r1 = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"])();
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(3);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("tenantIdentifier", ctx_r1.tenantIdentifier)("node", node_r7)("expanded", ctx_r1.nestedTreeControl.isExpanded(node_r7));
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"])("filing-tree-invisible", !ctx_r1.nestedTreeControl.isExpanded(node_r7));
} }
function FilingPlanComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 10);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"])(1, "mat-spinner", 11);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} }
const NODE_SELECT_VALUE_ACCESSOR = {
    provide: _angular_forms__WEBPACK_IMPORTED_MODULE_7__["NG_VALUE_ACCESSOR"],
    useExisting: Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["forwardRef"])(() => FilingPlanComponent),
    multi: true,
};
class FilingPlanComponent {
    constructor(filingPlanService) {
        this.filingPlanService = filingPlanService;
        this.componentId = Object(uuid__WEBPACK_IMPORTED_MODULE_15__["v4"])();
        this.selectedNodes = {
            included: [],
            excluded: [],
        };
        // tslint:disable-next-line:variable-name
        this.onChange = (_x) => { };
        this.onTouched = () => { };
        this.hasNestedChild = (_, node) => node.children && node.children.length;
        this.nestedTreeControl = new _angular_cdk_tree__WEBPACK_IMPORTED_MODULE_13__["NestedTreeControl"]((node) => node.children);
        this.nestedDataSource = new _angular_material_tree__WEBPACK_IMPORTED_MODULE_14__["MatTreeNestedDataSource"]();
    }
    initFiningTree() {
        this.filingPlanService.loadTree(this.tenantIdentifier, this.accessContract, this.componentId).subscribe((nodes) => {
            this.nestedDataSource.data = nodes;
            this.nestedTreeControl.dataNodes = nodes;
            this.initCheckedNodes(this.selectedNodes, nodes);
        });
    }
    ngOnChanges(changes) {
        if (changes.accessContract) {
            this.initFiningTree();
        }
    }
    updateChildrenStatusAndSelectedNodes(children, check, enableAllChildren = false) {
        if (!children || children.length === 0) {
            return;
        }
        children.forEach((childNode) => {
            var _a;
            if (!childNode) {
                return;
            }
            childNode.checked = check;
            childNode.disabledChild = false;
            if (this.mode === FilingPlanMode.INCLUDE_ONLY) {
                childNode.disabled = check;
            }
            this.selectedNodes.included = this.selectedNodes.included.filter((id) => childNode.vitamId !== id);
            if (this.mode === FilingPlanMode.BOTH) {
                if (enableAllChildren) {
                    childNode.disabled = false;
                }
                else {
                    childNode.disabled = !((_a = childNode.parents[0]) === null || _a === void 0 ? void 0 : _a.checked);
                }
                this.selectedNodes.excluded = this.selectedNodes.excluded.filter((id) => childNode.vitamId !== id);
            }
            this.updateChildrenStatusAndSelectedNodes(childNode.children, check, enableAllChildren);
        });
    }
    updateParentsStatus(parents, nodeChecked, childDisabled) {
        if (!parents || parents.length === 0) {
            return;
        }
        parents.forEach((parentNode) => {
            if (!parentNode || !parentNode.checked) {
                return;
            }
            if (!nodeChecked || childDisabled) {
                parentNode.disabledChild = true;
            }
            else if (nodeChecked &&
                !childDisabled &&
                parentNode.disabledChild &&
                !parentNode.children.find((child) => !child.checked || childDisabled)) {
                parentNode.disabledChild = false;
            }
            if (parentNode.parents) {
                this.updateParentsStatus(parentNode.parents, parentNode.checked, parentNode.disabledChild);
            }
        });
    }
    unselectOther(nodeId, nodes) {
        if (!nodes && nodes.length === 0) {
            return;
        }
        nodes.forEach((node) => {
            if (!node) {
                return;
            }
            if (node.vitamId !== nodeId && node.checked) {
                node.checked = false;
                const index = this.selectedNodes.included.findIndex((id) => node.vitamId === id);
                if (index !== -1) {
                    this.selectedNodes.included.splice(index, 1);
                }
            }
            this.unselectOther(nodeId, node.children);
        });
    }
    emitVitamId(node) {
        const nodeChecked = node.checked;
        if (this.mode === FilingPlanMode.BOTH) {
            this.updateParentsStatus(node.parents, nodeChecked, node.disabledChild);
            let enableAllChildren = false;
            if (!nodeChecked) {
                enableAllChildren = this.areAllParentsUnchecked(node.parents);
            }
            this.updateChildrenStatusAndSelectedNodes(node.children, nodeChecked, enableAllChildren);
        }
        if (this.mode === FilingPlanMode.INCLUDE_ONLY) {
            this.updateChildrenStatusAndSelectedNodes(node.children, node.checked);
        }
        if (this.mode === FilingPlanMode.SOLO && nodeChecked) {
            this.unselectOther(node.vitamId, this.nestedDataSource.data);
        }
        // Update selectedNodes with new update
        // remove old inclusion/exclusion because of a parent change status
        if (nodeChecked) {
            const oldExcludedIndex = this.selectedNodes.excluded.findIndex((id) => node.vitamId === id);
            if (this.mode === FilingPlanMode.BOTH && oldExcludedIndex !== -1) {
                this.selectedNodes.excluded.splice(oldExcludedIndex, 1);
            }
            else {
                this.selectedNodes.included.push(node.vitamId);
            }
        }
        else {
            const oldIncludedIndex = this.selectedNodes.included.findIndex((id) => node.vitamId === id);
            if (this.mode === FilingPlanMode.BOTH && oldIncludedIndex === -1) {
                this.selectedNodes.excluded.push(node.vitamId);
            }
            else {
                this.selectedNodes.included.splice(oldIncludedIndex, 1);
            }
        }
        // FIXME is this really needed ?
        this.onChange(this.selectedNodes);
    }
    areAllParentsUnchecked(parents) {
        var _a;
        if ((_a = parents[0]) === null || _a === void 0 ? void 0 : _a.checked) {
            return false;
        }
        if (parents.length === 0 || !parents[0].parents || parents[0].parents.length === 0) {
            return true;
        }
        return this.areAllParentsUnchecked(parents[0].parents);
    }
    initCheckedNodes(obj, nodes, parentChecked = false) {
        if (!obj || !nodes) {
            return;
        }
        let shouldStop = false;
        nodes.forEach((node) => {
            var _a;
            if (!node || shouldStop) {
                return;
            }
            if (this.mode === FilingPlanMode.SOLO && obj.included && obj.included.includes(node.vitamId)) {
                node.checked = true;
                shouldStop = true;
                return;
            }
            if (this.mode === FilingPlanMode.INCLUDE_ONLY && !parentChecked && obj.included && obj.included.includes(node.vitamId)) {
                node.checked = true;
                this.updateChildrenStatusAndSelectedNodes(node.children, true);
                return;
            }
            if (this.mode === FilingPlanMode.BOTH &&
                ((_a = node.parents) === null || _a === void 0 ? void 0 : _a.length) > 0 &&
                (node.parents[0].disabled || (obj.excluded && obj.excluded.includes(node.parents[0].vitamId)))) {
                node.disabled = true;
            }
            if ((this.mode === FilingPlanMode.BOTH && !parentChecked && obj.included && obj.included.includes(node.vitamId)) || parentChecked) {
                node.checked = true;
            }
            if (this.mode === FilingPlanMode.BOTH && parentChecked && obj.excluded && obj.excluded.includes(node.vitamId)) {
                node.checked = false;
                this.updateParentsStatus(node.parents, false, node.disabledChild);
            }
            shouldStop = this.initCheckedNodes(obj, node.children, node.checked);
        });
        return shouldStop;
    }
    writeValue(obj) {
        this.initCheckedNodes(obj, this.nestedDataSource.data);
        this.selectedNodes = obj;
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setDisabledState(isDisabled) {
        this.disabled = isDisabled;
    }
}
/** @nocollapse */ FilingPlanComponent.ɵfac = function FilingPlanComponent_Factory(t) { return new (t || FilingPlanComponent)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"])(FilingPlanService)); };
/** @nocollapse */ FilingPlanComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: FilingPlanComponent, selectors: [["vitamui-library-filing-plan"]], inputs: { tenantIdentifier: "tenantIdentifier", accessContract: "accessContract", mode: "mode", componentId: "componentId" }, features: [Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵProvidersFeature"])([NODE_SELECT_VALUE_ACCESSOR]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]], decls: 6, vars: 4, consts: [[1, "dlab-sidepanel"], [1, "dlab-sidepanel-body"], [1, "filing-tree", 3, "dataSource", "treeControl"], [4, "matTreeNodeDef"], [4, "matTreeNodeDef", "matTreeNodeDefWhen"], ["class", "loader", 4, "ngIf"], [1, "mat-tree-node", "filing-tree-node"], ["disabled", "", 3, "tenantIdentifier", "node", "nodeToggle", "labelClick"], [3, "tenantIdentifier", "node", "expanded", "nodeToggle", "labelClick"], ["matTreeNodeOutlet", ""], [1, "loader"], ["diameter", "50", "color", "accent"]], template: function FilingPlanComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "div", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(2, "mat-tree", 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(3, FilingPlanComponent_mat_tree_node_3_Template, 3, 2, "mat-tree-node", 3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(4, FilingPlanComponent_mat_nested_tree_node_4_Template, 6, 5, "mat-nested-tree-node", 4);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(5, FilingPlanComponent_div_5_Template, 2, 0, "div", 5);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("dataSource", ctx.nestedDataSource)("treeControl", ctx.nestedTreeControl);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("matTreeNodeDefWhen", ctx.hasNestedChild);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", ctx.filingPlanService.pending);
    } }, directives: [_angular_material_tree__WEBPACK_IMPORTED_MODULE_14__["MatTree"], _angular_material_tree__WEBPACK_IMPORTED_MODULE_14__["MatTreeNodeDef"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], _angular_material_tree__WEBPACK_IMPORTED_MODULE_14__["MatTreeNode"], NodeComponent, _angular_material_tree__WEBPACK_IMPORTED_MODULE_14__["MatNestedTreeNode"], _angular_material_tree__WEBPACK_IMPORTED_MODULE_14__["MatTreeNodeOutlet"], _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatSpinner"]], styles: [".dlab-sidepanel[_ngcontent-%COMP%]{min-width:0}.dlab-sidepanel-header[_ngcontent-%COMP%] > .title[_ngcontent-%COMP%] > h2[_ngcontent-%COMP%]{font-weight:300;max-width:500px;text-transform:none}.dlab-sidepanel-body[_ngcontent-%COMP%]{overflow:auto;padding:0;top:200px}.dlab-sidepanel-body[_ngcontent-%COMP%] > h3[_ngcontent-%COMP%]{font-size:18px;font-weight:300;margin-top:40px}.filing-tree-invisible[_ngcontent-%COMP%]{display:none}.filing-tree[_ngcontent-%COMP%]   li[_ngcontent-%COMP%], .filing-tree[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]{list-style-type:none;margin-bottom:0;margin-top:0}.filing-tree-node[_ngcontent-%COMP%]{border-bottom:1px solid hsla(0,0%,59.2%,.3);color:#666;cursor:pointer}.filing-tree-node[_ngcontent-%COMP%]:hover{background-color:rgba(92,186,169,.15)}.loader[_ngcontent-%COMP%]{align-items:center;background:hsla(0,0%,100%,.8);bottom:0;display:flex;justify-content:center;left:0;position:absolute;right:0;top:0}.icon-greeny-blue[_ngcontent-%COMP%]{color:var(--vitamui-secondary)}.icon-yellow[_ngcontent-%COMP%]{color:#ffcb19}"] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(FilingPlanComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-library-filing-plan',
                templateUrl: './filing-plan.component.html',
                styleUrls: ['./filing-plan.component.scss'],
                providers: [NODE_SELECT_VALUE_ACCESSOR],
            }]
    }], function () { return [{ type: FilingPlanService }]; }, { tenantIdentifier: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], accessContract: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], mode: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], componentId: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }] }); })();

class FilingPlanModule {
}
/** @nocollapse */ FilingPlanModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: FilingPlanModule });
/** @nocollapse */ FilingPlanModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function FilingPlanModule_Factory(t) { return new (t || FilingPlanModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"], _angular_material_tree__WEBPACK_IMPORTED_MODULE_14__["MatTreeModule"], _angular_material_button__WEBPACK_IMPORTED_MODULE_6__["MatButtonModule"], _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_18__["MatCheckboxModule"], _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatProgressSpinnerModule"], _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_19__["MatTooltipModule"]]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(FilingPlanModule, { declarations: [FilingPlanComponent, NodeComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"], _angular_material_tree__WEBPACK_IMPORTED_MODULE_14__["MatTreeModule"], _angular_material_button__WEBPACK_IMPORTED_MODULE_6__["MatButtonModule"], _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_18__["MatCheckboxModule"], _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatProgressSpinnerModule"], _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_19__["MatTooltipModule"]], exports: [FilingPlanComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(FilingPlanModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"], _angular_material_tree__WEBPACK_IMPORTED_MODULE_14__["MatTreeModule"], _angular_material_button__WEBPACK_IMPORTED_MODULE_6__["MatButtonModule"], _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_18__["MatCheckboxModule"], _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatProgressSpinnerModule"], _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_19__["MatTooltipModule"]],
                declarations: [FilingPlanComponent, NodeComponent],
                exports: [FilingPlanComponent],
            }]
    }], null, null); })();

class VitamUIRadioGroupService {
    constructor() {
        this.resetAll = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        this.random = Math.random();
    }
}
/** @nocollapse */ VitamUIRadioGroupService.ɵfac = function VitamUIRadioGroupService_Factory(t) { return new (t || VitamUIRadioGroupService)(); };
/** @nocollapse */ VitamUIRadioGroupService.ɵprov = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"])({ token: VitamUIRadioGroupService, factory: VitamUIRadioGroupService.ɵfac });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamUIRadioGroupService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"]
    }], function () { return []; }, null); })();

/* tslint:disable:component-selector */
const _c0$3 = function (a0) { return { checked: a0 }; };
class VitamUIRadioComponent {
    constructor(radioGroupService) {
        this.radioGroupService = radioGroupService;
    }
    ngOnInit() {
        this.checked = this.checked !== undefined;
    }
    changed() {
        this.radioGroupService.resetAll.emit(this);
    }
}
/** @nocollapse */ VitamUIRadioComponent.ɵfac = function VitamUIRadioComponent_Factory(t) { return new (t || VitamUIRadioComponent)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"])(VitamUIRadioGroupService)); };
/** @nocollapse */ VitamUIRadioComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: VitamUIRadioComponent, selectors: [["vitamui-radio"]], inputs: { value: "value", label: "label", checked: "checked" }, decls: 5, vars: 5, consts: [[1, "radio-label", 3, "ngClass"], ["type", "radio", 3, "value", "click"], ["input", ""]], template: function VitamUIRadioComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "label", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "input", 1, 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("click", function VitamUIRadioComponent_Template_input_click_1_listener() { return ctx.changed(); });
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(3, "span");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(4);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngClass", Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"])(3, _c0$3, ctx.checked));
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("value", ctx.value);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"])(" ", ctx.label, " ");
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgClass"]], styles: ["input[type=radio][_ngcontent-%COMP%]{display:none;position:absolute;visibility:hidden}.radio-label[_ngcontent-%COMP%]{color:var(--vitamui-secondary);cursor:pointer;display:inline-block;font-weight:700;padding:5px 20px}.radio-label[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]{-moz-user-select:none;-webkit-user-select:none;user-select:none}.radio-label.checked[_ngcontent-%COMP%]{background:var(--vitamui-secondary);color:#fff}"] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamUIRadioComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-radio',
                templateUrl: './vitamui-radio.component.html',
                styleUrls: ['./vitamui-radio.component.scss'],
            }]
    }], function () { return [{ type: VitamUIRadioGroupService }]; }, { value: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], label: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], checked: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }] }); })();

/* tslint:disable:no-use-before-declare component-selector */
function VitamUIRadioGroupComponent_span_4_Template(rf, ctx) { if (rf & 1) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "span", 5);
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(1, "*");
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
} }
const _c0$4 = [[["vitamui-radio"]]];
const _c1$2 = ["vitamui-radio"];
const RADIO_GROUP_VALUE_ACCESSOR = {
    provide: _angular_forms__WEBPACK_IMPORTED_MODULE_7__["NG_VALUE_ACCESSOR"],
    useExisting: Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["forwardRef"])(() => VitamUIRadioGroupComponent),
    multi: true,
};
class VitamUIRadioGroupComponent {
    constructor(radioGroupService) {
        this.radioGroupService = radioGroupService;
        this.onChange = (_) => { };
        this.onTouched = () => { };
    }
    ngOnInit() {
        this.required = this.required === undefined ? false : true;
        const subscription = this.radioGroupService.resetAll.subscribe((elem) => {
            this.radios.forEach((radioButton) => {
                radioButton.checked = false;
            });
            elem.checked = true;
            this.value = elem.value;
            this.onChange(this.value);
        });
        this.ngOnDestroy = () => {
            subscription.unsubscribe();
        };
    }
    ngAfterContentInit() {
        this.radios
            .filter((radio) => radio.checked)
            .forEach((radio) => {
            this.value = radio.value;
            this.onChange(this.value);
        });
        this.radios.filter((radio) => radio.value === this.value).forEach((radio) => (radio.checked = true));
    }
    writeValue(value) {
        this.value = value;
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
}
/** @nocollapse */ VitamUIRadioGroupComponent.ɵfac = function VitamUIRadioGroupComponent_Factory(t) { return new (t || VitamUIRadioGroupComponent)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"])(VitamUIRadioGroupService, 2)); };
/** @nocollapse */ VitamUIRadioGroupComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: VitamUIRadioGroupComponent, selectors: [["vitamui-radio-group"]], contentQueries: function VitamUIRadioGroupComponent_ContentQueries(rf, ctx, dirIndex) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"])(dirIndex, VitamUIRadioComponent, false);
    } if (rf & 2) {
        var _t;
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"])(_t = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"])()) && (ctx.radios = _t);
    } }, inputs: { label: "label", required: "required" }, features: [Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵProvidersFeature"])([RADIO_GROUP_VALUE_ACCESSOR, VitamUIRadioGroupService])], ngContentSelectors: _c1$2, decls: 8, vars: 2, consts: [[1, "row"], [1, "col-12", "mb-3"], ["class", "required-marker", 4, "ngIf"], [1, "col-12"], [1, "radio-group"], [1, "required-marker"]], template: function VitamUIRadioGroupComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵprojectionDef"])(_c0$4);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(0, "div", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "div", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(2, "label");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"])(4, VitamUIRadioGroupComponent_span_4_Template, 2, 0, "span", 2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(5, "div", 3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(6, "div", 4);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵprojection"])(7);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(3);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"])("", ctx.label, " ");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("ngIf", ctx.required);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"]], styles: [".radio-group[_ngcontent-%COMP%]{border:1px solid var(--vitamui-secondary);border-radius:5px;display:inline-block;overflow:hidden}label[_ngcontent-%COMP%]{pointer-events:none}label[_ngcontent-%COMP%]   .required-marker[_ngcontent-%COMP%]{color:var(--vitamui-primary)}"] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamUIRadioGroupComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-radio-group',
                templateUrl: './vitamui-radio-group.component.html',
                styleUrls: ['./vitamui-radio-group.component.scss'],
                providers: [RADIO_GROUP_VALUE_ACCESSOR, VitamUIRadioGroupService],
            }]
    }], function () { return [{ type: VitamUIRadioGroupService, decorators: [{
                type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Self"]
            }] }]; }, { radios: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ContentChildren"],
            args: [VitamUIRadioComponent]
        }], label: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], required: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }] }); })();

class VitamUIRadioGroupModule {
}
/** @nocollapse */ VitamUIRadioGroupModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: VitamUIRadioGroupModule });
/** @nocollapse */ VitamUIRadioGroupModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function VitamUIRadioGroupModule_Factory(t) { return new (t || VitamUIRadioGroupModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["ReactiveFormsModule"]]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(VitamUIRadioGroupModule, { declarations: [VitamUIRadioGroupComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["ReactiveFormsModule"]], exports: [VitamUIRadioGroupComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamUIRadioGroupModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                declarations: [VitamUIRadioGroupComponent],
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"], _angular_forms__WEBPACK_IMPORTED_MODULE_7__["ReactiveFormsModule"]],
                exports: [VitamUIRadioGroupComponent],
            }]
    }], null, null); })();

class VitamUIRadioModule {
}
/** @nocollapse */ VitamUIRadioModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: VitamUIRadioModule });
/** @nocollapse */ VitamUIRadioModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function VitamUIRadioModule_Factory(t) { return new (t || VitamUIRadioModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"]]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(VitamUIRadioModule, { declarations: [VitamUIRadioComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"]], exports: [VitamUIRadioComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamUIRadioModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"]],
                declarations: [VitamUIRadioComponent],
                exports: [VitamUIRadioComponent],
            }]
    }], null, null); })();

/* tslint:disable:component-selector */
class VitamUISelectAllOptionComponent extends _angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatOption"] {
    constructor(elementRef, changeDetectorRef, parent, group) {
        super(elementRef, changeDetectorRef, parent, group);
        this.values = [];
        this.toggleSelection = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        this.cssClass = 'mat-option';
    }
    click() {
        this._selectViaInteraction();
        if (this.control) {
            this.control.setValue(this.selected ? this.values : []);
        }
        else {
            this.toggleSelection.emit(!this.selectedAll ? this.values : []);
        }
    }
    ngOnInit() {
        this.refresh();
        if (this.control) {
            this.unsubscribe = new rxjs__WEBPACK_IMPORTED_MODULE_16__["Subject"]();
            this.control.valueChanges.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_17__["takeUntil"])(this.unsubscribe)).subscribe(() => {
                this.refresh();
            });
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
        if (this.control) {
            this.unsubscribe.next();
            this.unsubscribe.complete();
        }
    }
    get selectedItemsCount() {
        if (this.control) {
            return Array.isArray(this.control.value) ? this.control.value.filter((el) => el !== null).length : 0;
        }
        else {
            return this.value ? this.value.filter((el) => el !== null).length : 0;
        }
    }
    get selectedAll() {
        return this.selectedItemsCount === this.values.length;
    }
    get selectedPartially() {
        const selectedItemsCount = this.selectedItemsCount;
        return selectedItemsCount > 0 && selectedItemsCount < this.values.length;
    }
    get checkboxState() {
        let state = 'unchecked';
        if (this.selectedAll) {
            state = 'checked';
        }
        else if (this.selectedPartially) {
            state = 'indeterminate';
        }
        return state;
    }
    refresh() {
        if (this.selectedItemsCount > 0) {
            this.select();
        }
        else {
            this.deselect();
        }
    }
}
/** @nocollapse */ VitamUISelectAllOptionComponent.ɵfac = function VitamUISelectAllOptionComponent_Factory(t) { return new (t || VitamUISelectAllOptionComponent)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"])(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ElementRef"]), Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"])(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ChangeDetectorRef"]), Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"])(_angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MAT_OPTION_PARENT_COMPONENT"], 8), Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"])(_angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatOptgroup"], 8)); };
/** @nocollapse */ VitamUISelectAllOptionComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: VitamUISelectAllOptionComponent, selectors: [["vitamui-select-all-option"]], hostVars: 2, hostBindings: function VitamUISelectAllOptionComponent_HostBindings(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"])("click", function VitamUISelectAllOptionComponent_click_HostBindingHandler() { return ctx.click(); });
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassMap"])(ctx.cssClass);
    } }, inputs: { control: "control", value: "value", values: "values", title: "title" }, outputs: { toggleSelection: "toggleSelection" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 4, vars: 6, consts: [[1, "mat-option-pseudo-checkbox", 3, "state", "disabled", "ngClass"], [1, "mat-option-text"], ["mat-ripple", "", 1, "mat-option-ripple", 3, "matRippleTrigger", "matRippleDisabled"]], template: function VitamUISelectAllOptionComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"])(0, "mat-pseudo-checkbox", 0);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"])(1, "span", 1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"])();
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"])(3, "div", 2);
    } if (rf & 2) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("state", ctx.checkboxState)("disabled", ctx.disabled)("ngClass", ctx.selected ? "bg-accent" : "");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(2);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"])(" ", ctx.title, "\n");
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"])(1);
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"])("matRippleTrigger", ctx._getHostElement())("matRippleDisabled", ctx.disabled || ctx.disableRipple);
    } }, directives: [_angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatPseudoCheckbox"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgClass"], _angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatRipple"]], styles: [""] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamUISelectAllOptionComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: 'vitamui-select-all-option',
                templateUrl: './vitamui-select-all-option.component.html',
                styleUrls: ['./vitamui-select-all-option.component.scss'],
            }]
    }], function () { return [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ElementRef"] }, { type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ChangeDetectorRef"] }, { type: undefined, decorators: [{
                type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Optional"]
            }, {
                type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"],
                args: [_angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MAT_OPTION_PARENT_COMPONENT"]]
            }] }, { type: _angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatOptgroup"], decorators: [{
                type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Optional"]
            }] }]; }, { control: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], value: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], values: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], title: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"]
        }], toggleSelection: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"]
        }], cssClass: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["HostBinding"],
            args: ['class']
        }], click: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["HostListener"],
            args: ['click']
        }] }); })();

class VitamUISelectAllOptionModule {
}
/** @nocollapse */ VitamUISelectAllOptionModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: VitamUISelectAllOptionModule });
/** @nocollapse */ VitamUISelectAllOptionModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function VitamUISelectAllOptionModule_Factory(t) { return new (t || VitamUISelectAllOptionModule)(); }, imports: [[_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatPseudoCheckboxModule"], _angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatRippleModule"]]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(VitamUISelectAllOptionModule, { declarations: [VitamUISelectAllOptionComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatPseudoCheckboxModule"], _angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatRippleModule"]], exports: [VitamUISelectAllOptionComponent] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamUISelectAllOptionModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatPseudoCheckboxModule"], _angular_material_core__WEBPACK_IMPORTED_MODULE_20__["MatRippleModule"]],
                declarations: [VitamUISelectAllOptionComponent],
                exports: [VitamUISelectAllOptionComponent],
            }]
    }], null, null); })();

var Status;
(function (Status) {
    Status["ACTIVE"] = "ACTIVE";
    Status["INACTIVE"] = "INACTIVE";
})(Status || (Status = {}));

var DescriptionLevel;
(function (DescriptionLevel) {
    // SEDA : LevelType
    DescriptionLevel["FONDS"] = "Fonds";
    DescriptionLevel["SUBFONDS"] = "Subfonds";
    DescriptionLevel["CLASS"] = "Class";
    DescriptionLevel["COLLECTION"] = "Collection";
    DescriptionLevel["SERIES"] = "Series";
    DescriptionLevel["SUBSERIES"] = "Subseries";
    DescriptionLevel["RECORD_GRP"] = "RecordGrp";
    DescriptionLevel["SUB_GRP"] = "SubGrp";
    DescriptionLevel["FILE"] = "File";
    DescriptionLevel["ITEM"] = "Item";
    DescriptionLevel["OTHER_LEVEL"] = "OtherLevel";
})(DescriptionLevel || (DescriptionLevel = {}));

/*
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 *
 * contact@programmevitam.fr
 *
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */
var DslQueryType;
(function (DslQueryType) {
    DslQueryType["ARCHIVE_UNIT"] = "ARCHIVE_UNIT";
    DslQueryType["TECHNICAL_OBJECT_GROUP"] = "TECHNICAL_OBJECT_GROUP";
})(DslQueryType || (DslQueryType = {}));

const FILE_FORMAT_EXTERNAL_PREFIX = 'EXTERNAL_';

var FileTypes;
(function (FileTypes) {
    FileTypes["CSV"] = "text/csv";
    FileTypes["JSON"] = "application/json";
    FileTypes["XML"] = "text/xml";
    FileTypes["VND"] = "application/vnd.ms-excel";
})(FileTypes || (FileTypes = {}));

class MetadataService {
    constructor(metadataApi) {
        this.metadataApi = metadataApi;
    }
    get(tenantIdentifier, unitId) {
        const headers = new _angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpHeaders"]({
            'X-Tenant-Id': tenantIdentifier.toString(),
            // FIXME: Use Root/Admin Access Contract ? Use Specific Value ? Let the user choose ?
            'X-Access-Contract-Id': 'hardCodedAccessContract' /*this.activeAccessContract.identifier*/,
        });
        return this.metadataApi.searchMetadata(unitId, headers);
    }
    compareVtag(tag1, tag2) {
        if (isArrayEmpty(tag1.Key) && isArrayEmpty(tag2.Key)) {
            return 0;
        }
        else if (isArrayEmpty(tag2.Key) && !isArrayEmpty(tag1.Key)) {
            return -1;
        }
        else if (isArrayEmpty(tag1.Key) && !isArrayEmpty(tag2.Key)) {
            return 1;
        }
        else if (tag1.Key[0] < tag2.Key[0]) {
            return -1;
        }
        else if (tag2.Key[0] < tag1.Key[0]) {
            return 1;
        }
        return 0;
    }
    sortVtag(vtagArray) {
        if (vtagArray) {
            vtagArray.sort(this.compareVtag);
        }
    }
}
/** @nocollapse */ MetadataService.ɵfac = function MetadataService_Factory(t) { return new (t || MetadataService)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"])(MetadataApiService)); };
/** @nocollapse */ MetadataService.ɵprov = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"])({ token: MetadataService, factory: MetadataService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(MetadataService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"],
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: MetadataApiService }]; }, null); })();
function isArrayEmpty(arr) {
    return !arr || arr.length < 1;
}

class SpinnerComponent {
}
/** @nocollapse */ SpinnerComponent.ɵfac = function SpinnerComponent_Factory(t) { return new (t || SpinnerComponent)(); };
/** @nocollapse */ SpinnerComponent.ɵcmp = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"])({ type: SpinnerComponent, selectors: [["ng-component"]], decls: 1, vars: 0, consts: [[1, "vitamui-spinner", "x-large", "my-3"]], template: function SpinnerComponent_Template(rf, ctx) { if (rf & 1) {
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"])(0, "mat-spinner", 0);
    } }, directives: [_angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatSpinner"]], styles: [".spinner-overlay .mat-dialog-container {\n        background: transparent;\n        box-shadow: none;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n      }"] });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(SpinnerComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                template: `<mat-spinner class="vitamui-spinner x-large my-3"></mat-spinner>`,
                styles: [
                    `
      ::ng-deep .spinner-overlay .mat-dialog-container {
        background: transparent;
        box-shadow: none;
        display: flex;
        align-items: center;
        justify-content: center;
      }
    `,
                ],
            }]
    }], null, null); })();
class SpinnerModule {
}
/** @nocollapse */ SpinnerModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: SpinnerModule });
/** @nocollapse */ SpinnerModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function SpinnerModule_Factory(t) { return new (t || SpinnerModule)(); }, imports: [[_angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatProgressSpinnerModule"]]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(SpinnerModule, { declarations: [SpinnerComponent], imports: [_angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatProgressSpinnerModule"]] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(SpinnerModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                declarations: [SpinnerComponent],
                imports: [_angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatProgressSpinnerModule"]],
                exports: [],
            }]
    }], null, null); })();
class SpinnerOverlayService {
    constructor(dialog) {
        this.dialog = dialog;
    }
    open() {
        this.spinnerOverlayRef = this.dialog.open(SpinnerComponent, {
            disableClose: true,
            height: '100%',
            width: '100%',
            panelClass: 'spinner-overlay',
        });
        // We prevent usage of "TAB" while the overlay is opened in order to prevent being able to edit forms in the background.
        const preventTab = (event) => {
            if (event.key === 'Tab') {
                event.preventDefault();
            }
        };
        document.addEventListener('keydown', preventTab);
        this.spinnerOverlayRef.afterClosed().subscribe(() => {
            document.removeEventListener('keydown', preventTab);
        });
    }
    close() {
        var _a;
        (_a = this.spinnerOverlayRef) === null || _a === void 0 ? void 0 : _a.close();
    }
}
/** @nocollapse */ SpinnerOverlayService.ɵfac = function SpinnerOverlayService_Factory(t) { return new (t || SpinnerOverlayService)(Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"])(_angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__["MatDialog"])); };
/** @nocollapse */ SpinnerOverlayService.ɵprov = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"])({ token: SpinnerOverlayService, factory: SpinnerOverlayService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(SpinnerOverlayService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"],
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: _angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__["MatDialog"] }]; }, null); })();

function download(blob, filename) {
    const anchor = document.createElement('a');
    anchor.download = filename ? filename : 'download.zip';
    anchor.href = window.URL.createObjectURL(blob);
    anchor.click();
}

class VitamUILibraryModule {
}
/** @nocollapse */ VitamUILibraryModule.ɵmod = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"])({ type: VitamUILibraryModule });
/** @nocollapse */ VitamUILibraryModule.ɵinj = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"])({ factory: function VitamUILibraryModule_Factory(t) { return new (t || VitamUILibraryModule)(); }, imports: [[
            CardGroupModule,
            CardModule,
            CardSelectModule,
            ConfirmActionModule,
            FilingPlanModule,
            UpdatedApplicationSelectContentModule,
            UpdatedVitamUIMenuTileModule,
            VitamUIInputModule,
            VitamUIRadioGroupModule,
            VitamUIRadioModule,
            VitamUISelectAllOptionModule,
        ], CardGroupModule,
        CardModule,
        CardSelectModule,
        ConfirmActionModule,
        FilingPlanModule,
        UpdatedApplicationSelectContentModule,
        UpdatedVitamUIMenuTileModule,
        VitamUIInputModule,
        VitamUIRadioGroupModule,
        VitamUIRadioModule,
        VitamUISelectAllOptionModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"])(VitamUILibraryModule, { imports: [CardGroupModule,
        CardModule,
        CardSelectModule,
        ConfirmActionModule,
        FilingPlanModule,
        UpdatedApplicationSelectContentModule,
        UpdatedVitamUIMenuTileModule,
        VitamUIInputModule,
        VitamUIRadioGroupModule,
        VitamUIRadioModule,
        VitamUISelectAllOptionModule], exports: [CardGroupModule,
        CardModule,
        CardSelectModule,
        ConfirmActionModule,
        FilingPlanModule,
        UpdatedApplicationSelectContentModule,
        UpdatedVitamUIMenuTileModule,
        VitamUIInputModule,
        VitamUIRadioGroupModule,
        VitamUIRadioModule,
        VitamUISelectAllOptionModule] }); })();
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamUILibraryModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                declarations: [],
                imports: [
                    CardGroupModule,
                    CardModule,
                    CardSelectModule,
                    ConfirmActionModule,
                    FilingPlanModule,
                    UpdatedApplicationSelectContentModule,
                    UpdatedVitamUIMenuTileModule,
                    VitamUIInputModule,
                    VitamUIRadioGroupModule,
                    VitamUIRadioModule,
                    VitamUISelectAllOptionModule,
                ],
                exports: [
                    CardGroupModule,
                    CardModule,
                    CardSelectModule,
                    ConfirmActionModule,
                    FilingPlanModule,
                    UpdatedApplicationSelectContentModule,
                    UpdatedVitamUIMenuTileModule,
                    VitamUIInputModule,
                    VitamUIRadioGroupModule,
                    VitamUIRadioModule,
                    VitamUISelectAllOptionModule,
                ],
            }]
    }], null, null); })();

class VitamuiLibraryService {
    constructor() { }
}
/** @nocollapse */ VitamuiLibraryService.ɵfac = function VitamuiLibraryService_Factory(t) { return new (t || VitamuiLibraryService)(); };
/** @nocollapse */ VitamuiLibraryService.ɵprov = Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"])({ token: VitamuiLibraryService, factory: VitamuiLibraryService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"])(VitamuiLibraryService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"],
        args: [{
                providedIn: 'root',
            }]
    }], function () { return []; }, null); })();

const RULE_ID_PATTERN_ERROR_KEY = 'ruleIdPattern';
const ManagementRuleValidators = {
    ruleIdPattern: (control) => (/[À-ÖØ-öø-ÿ ]/.test(control.value) ? { [RULE_ID_PATTERN_ERROR_KEY]: true } : null),
};

/*
 * Public API Surface of vitamui-library
 */

/**
 * Generated bundle index. Do not edit.
 */


//# sourceMappingURL=vitamui-library.js.map


/***/ }),

/***/ "8hMF":
/*!******************************!*\
  !*** ./src/assets/seda.json ***!
  \******************************/
/*! exports provided: 0, default */
/***/ (function(module) {

module.exports = JSON.parse("[{\"Name\":\"ArchiveTransfer\",\"NameFr\":\"Bordereau de versement\",\"Element\":\"Complex\",\"Cardinality\":\"1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Transfert d'archives.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"Comment\",\"NameFr\":\"Commentaire\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Commentaire sur la transaction.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"Date\",\"NameFr\":\"Date\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date du message.\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"MessageIdentifier\",\"NameFr\":\"Identifiant du message\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du message.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"schemeID\",\"NameFr\":\"Identifiant du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeName\",\"NameFr\":\"Nom du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient le référentiel\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeVersionID\",\"NameFr\":\"Version du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeDataURI\",\"NameFr\":\"URL de la donnée dans le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans le référentiel\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeURI\",\"NameFr\":\"URL du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder au référentiel\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"Signature\",\"NameFr\":\"Signature\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Signature du message.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"ArchivalAgreement\",\"NameFr\":\"Accord de service\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Accord de service.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"schemeID\",\"NameFr\":\"Identifiant du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeName\",\"NameFr\":\"Nom du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient le référentiel\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeVersionID\",\"NameFr\":\"Version du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeDataURI\",\"NameFr\":\"URL de la donnée dans le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans le référentiel\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"schemeURI\",\"NameFr\":\"URL du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder au référentiel\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"CodeListVersions\",\"NameFr\":\"Référence aux listes de codes\",\"Element\":\"Complex\",\"Cardinality\":\"1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Listes des codes de référence utilisés dans le message.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"ReplyCodeListVersion\",\"NameFr\":\"Liste de codes de réponse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste des codes de réponses à utiliser.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"MessageDigestAlgorithmCodeListVersion\",\"NameFr\":\"Liste de codes d’algorithme\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste des algorithmes de hachage à utiliser.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"MimeTypeCodeListVersion\",\"NameFr\":\"Liste de codes des types mime\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste des types Mime à utiliser.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"EncodingCodeListVersion\",\"NameFr\":\"Liste de codes des encodages\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste de codes des encodages de fichier à utiliser\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"FileFormatCodeListVersion\",\"NameFr\":\"Liste de codes des format\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste de codes des formats de fichier à utiliser\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"CompressionAlgorithmCodeListVersion\",\"NameFr\":\"Liste de codes des algorithmes de compression\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste de codes des algorithmes de compression à utiliser\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"DataObjectVersionCodeListVersion\",\"NameFr\":\"Liste de codes des versions d’Objet de données\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste de codes correspondant aux diverses versions d'un objet-données au sein d'un groupe d'objets-données (ex. original papier, conservation, diffusion, vignette, txt).\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"StorageRuleCodeListVersion\",\"NameFr\":\"Liste des codes de durée d’utilité courante\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste des codes de durée d’utilité courante à utiliser\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"AppraisalRuleCodeListVersion\",\"NameFr\":\"Liste des codes de durée d’utilité administrative et de sort final\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste des codes de durée d’utilité administrative et de sort final à utiliser\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"AccessRuleCodeListVersion\",\"NameFr\":\"Liste des codes de communicabilité\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste des codes de communicabilité à utiliser\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"DisseminationRuleCodeListVersion\",\"NameFr\":\"Liste des codes de diffusion\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste des codes de diffusion à utiliser\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"ReuseRuleCodeListVersion\",\"NameFr\":\"Liste de codes de réutilisation\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste de codes pour les règles de réutilisation.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"ClassificationRuleCodeListVersion\",\"NameFr\":\"Liste des codes de classification\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Listes des codes de classification à utiliser.\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"AcquisitionInformationCodeListVersion\",\"NameFr\":\"Liste des codes de modalités d'entrée\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste des codes de modalités d'entrée à utiliser\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"AuthorizationReasonCodeListVersion\",\"NameFr\":\"Liste des codes de raison d’autorisation\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste des codes de raison d’autorisation à utiliser\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]},{\"Name\":\"RelationshipCodeListVersion\",\"NameFr\":\"Liste des codes des relations de signature\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Liste des codes des relations de signature à utiliser\",\"Collection\":\"Entête\",\"Children\":[{\"Name\":\"listID\",\"NameFr\":\"Identifiant de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listName\",\"NameFr\":\"Nom de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"name\",\"NameFr\":\"Nom\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom correspondant au code utilisé dans le contenu de la métadonnée\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"languageID\",\"NameFr\":\"Identifiant de la langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la langue utilisée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listURI\",\"NameFr\":\"URL de la donnée dans la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]},{\"Name\":\"listSchemeURI\",\"NameFr\":\"URL de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la liste de codes\",\"Collection\":\"Entête\",\"Children\":[]}]}]},{\"Name\":\"DataObjectPackage\",\"NameFr\":\"Paquet d'Objets de données\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Objets-données échangés dans le message.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectGroup\",\"NameFr\":\"Groupe d'Objets de données\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Bloc qui correspond à un groupe d'Objets de données englobant des objets binaires ou physiques.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"BinaryDataObject\",\"NameFr\":\"Fichier numérique\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Bloc de métadonnées techniques des objets-données numériques. Le caractère facultatif est requis afin de permettre le transfert d'un plan de classement sans DataObject joint.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectSystemId\",\"NameFr\":\"Identifiant de l'Objet de données du SAE\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué aux objets de données. Il est attribué par le SAE et correspond à un identifiant interne.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectGroupSystemId\",\"NameFr\":\"Identifiant du groupe d'Objet de données du SAE\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué aux groupes d'objets de données. Il est attribué par le SAE et correspond à un identifiant interne.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Relationship\",\"NameFr\":\"Relation de signature\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Permet de spécifier un lien technique entre un objet-données et une signature.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"target\",\"NameFr\":\"Cible\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"NCName\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Cible de la relation de signature\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"type\",\"NameFr\":\"Type\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type de signature\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"DataObjectGroupReferenceId\",\"NameFr\":\"Identifiant du groupe d'objet-données lié\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à un groupe d'objets-données listé dans les métadonnées de transport.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectGroupId\",\"NameFr\":\"Identifiant du groupe d’Objets de données\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée qui permet d’identifier un groupe d’Objets de données à l’intérieur d’une transaction. Compatibilité SEDA 2.0 qui déclare les groupes d’Objets de données avec le diptyque DataObjectGroupId et DataObjectGroupReferenceId. Cet ensemble ne doit pas être utilisé dans DataObjectGroup.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectVersion\",\"NameFr\":\"Version de l’Objet de données\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version d'un objet-données (par exemple : original papier, conservation, diffusion, vignette, txt, ...).\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Attachment\",\"NameFr\":\"Objet attaché\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"base64Binary\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée qui permet d’associer en Base 64 l’Objet de données dans la transaction directement. Choix à faire entre Attachment et Uri\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"filename\",\"NameFr\":\"Nom du fichier\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du fichier d’origine\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"uri\",\"NameFr\":\"URI\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"L'URI spécifie où se trouve l'objet-données numérique. Peut correspondre à un chemin relatif.\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Uri\",\"NameFr\":\"URI\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"L'URI spécifie où se trouve l'objet-données numérique. Peut correspondre à un chemin relatif.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"MessageDigest\",\"NameFr\":\"Empreinte\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"base64Binary\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Empreinte de l'objet-données.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"algorithm\",\"NameFr\":\"Algorithme\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Algorithme utilisé pour calculer l'empreinte\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Size\",\"NameFr\":\"Taille\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"positiveInteger\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Permet de spécifier la taille de l'objet-données en octet.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Compressed\",\"NameFr\":\"Compression\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"boolean\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Indique si l'objet-données est compressé et doit être décompressé.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"algorithm\",\"NameFr\":\"Algorithme\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Algorithme utilisé pour compresser le fichier\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"unCompressedSize\",\"NameFr\":\"Taille non compressée\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"positiveInteger\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Taille non compressée de l'objet-données\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"FormatIdentification\",\"NameFr\":\"Identification du format\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identification du format du fichier constituant l’Objet de données numérique\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"FormatLitteral\",\"NameFr\":\"Format littéral\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Forme littérale du nom du format. Exemple : Microsoft Word Document.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"MimeType\",\"NameFr\":\"Type MIME\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type Mime associé. Exemple : application/msword\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"FormatId\",\"NameFr\":\"Identifiant du format\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du format tel que défini dans FormatIdCodeList. Exemple : (Pronom)fmt/40\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Encoding\",\"NameFr\":\"Encodage\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Encodage du fichier. Exemple : Utf-8\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"FileInfo\",\"NameFr\":\"Information sur le fichier\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Propriétés techniques génériques du fichier (nom d'origine, logiciel de création, système d'exploitation de création).\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"Filename\",\"NameFr\":\"Nom du fichier\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du fichier d'origine.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"CreatingApplicationName\",\"NameFr\":\"Nom de l'application de création\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'application utilisée pour créer le fichier.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"CreatingApplicationVersion\",\"NameFr\":\"Version de l'application de création\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version de l'application utilisée pour créer le fichier.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DateCreatedByApplication\",\"NameFr\":\"Date de création\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de création du fichier dans l'application. A ne pas confondre avec CreatedDate dans les métadonnées descriptives\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"CreatingOs\",\"NameFr\":\"Système d'exploitation d'origine\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Système d’exploitation utilisé pour faire fonctionner l’application de création du fichier échangé.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"CreatingOsVersion\",\"NameFr\":\"Version du système d'exploitation d'origine\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version du système d'exploitation utilisé pour créer le fichier.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"LastModified\",\"NameFr\":\"Date de dernière modification\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de la dernière modification du fichier.\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Metadata\",\"NameFr\":\"Autres métadonnées\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Propriétés techniques spécifiques du fichier en fonction de sa nature technique (texte, document, image, audio, vidéo, etc.).\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"Text\",\"NameFr\":\"Texte\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"yes\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées pour un objet-données de type textuel.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Document\",\"NameFr\":\"Document\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"yes\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées pour un objet-données de type document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Image\",\"NameFr\":\"Image\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"yes\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées pour un objet-données de type image.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Audio\",\"NameFr\":\"Audio\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"yes\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées pour un objet-données de type audio.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Video\",\"NameFr\":\"Vidéo\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"yes\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées pour un objet-données de type vidéo.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]}]},{\"Name\":\"OtherMetadata\",\"NameFr\":\"Autres métadonnées techniques\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Autres métadonnées techniques si celles définies précédemment ne suffisent pas.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]}]},{\"Name\":\"PhysicalDataObject\",\"NameFr\":\"Objet de données physique\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Bloc de métadonnées techniques des objets de données physiques.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectSystemId\",\"NameFr\":\"Identifiant de l'Objet de données du SAE\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué aux objets de données. Il est attribué par le SAE et correspond à un identifiant interne.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectGroupSystemId\",\"NameFr\":\"Identifiant du groupe d'Objet de données du SAE\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué aux groupes d'objets de données. Il est attribué par le SAE et correspond à un identifiant interne.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Relationship\",\"NameFr\":\"Relation de signature\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Permet de spécifier un lien technique entre un objet-données et une signature.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"target\",\"NameFr\":\"Cible\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"NCName\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Cible de la relation de signature\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"type\",\"NameFr\":\"Type\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type de signature\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"DataObjectGroupReferenceId\",\"NameFr\":\"Identifiant du groupe d'objet-données lié\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à un groupe d'objets-données listé dans les métadonnées de transport.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectGroupId\",\"NameFr\":\"Identifiant du groupe d’Objets de données\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée qui permet d’identifier un groupe d’Objets de données à l’intérieur d’une transaction. Compatibilité SEDA 2.0 qui déclare les groupes d’Objets de données avec le diptyque DataObjectGroupId et DataObjectGroupReferenceId. Cet ensemble ne doit pas être utilisé dans DataObjectGroup.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectVersion\",\"NameFr\":\"Version de l’Objet de données\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version d'un objet-données (par exemple : original papier, conservation, diffusion, vignette, txt, ...).\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"PhysicalId\",\"NameFr\":\"Identifiant d’Objet de données physique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant physique d'un objet-données physique, externe à celui-ci (ex. code-barres).\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"schemeID\",\"NameFr\":\"Identifiant du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeName\",\"NameFr\":\"Nom du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient le référentiel\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeVersionID\",\"NameFr\":\"Version du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeDataURI\",\"NameFr\":\"URL de la donnée dans le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans le référentiel\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeURI\",\"NameFr\":\"URL du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder au référentiel\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"PhysicalDimensions\",\"NameFr\":\"Dimensions physiques\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Dimensions d'un objet-données physique.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"Width\",\"NameFr\":\"Largeur\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : largeur du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Height\",\"NameFr\":\"Hauteur\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : hauteur du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Depth\",\"NameFr\":\"Profondeur\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : profondeur du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Shape\",\"NameFr\":\"Forme\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : forme du document.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Diameter\",\"NameFr\":\"Diamètre\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : diamètre du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Length\",\"NameFr\":\"Longueur\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : longueur du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Thickness\",\"NameFr\":\"Epaisseur\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : épaisseur du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Weight\",\"NameFr\":\"Poids\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"microgram\",\"MC\",\"milligram\",\"MGM\",\"gram\",\"GRM\",\"kilogram\",\"KGM\"],\"Definition\":\"Métadonnée de dimension physique : poids du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"NumberOfPage\",\"NameFr\":\"Nombre de pages\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"int\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : nombre de pages.\",\"Collection\":\"Objets\",\"Children\":[]}]}]},{\"Name\":\"LogBook\",\"NameFr\":\"Journal des traces\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Eléments de traçabilité sur le cycle de vie des Objets de données\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"Event\",\"NameFr\":\"Evénement\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"EventIdentifier\",\"NameFr\":\"Identifiant de l'événement\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'événement. Références : premis.eventIdentifier\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"EventTypeCode\",\"NameFr\":\"Code du type d'événement\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code du type d'événement.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"EventType\",\"NameFr\":\"Type d'événement\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type d'événement.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"EventDateTime\",\"NameFr\":\"Date et heure de l'événement\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"DateType\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date et heure de l'événement.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"EventDetail\",\"NameFr\":\"Détail sur l'événement\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Détail sur l'événement.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Outcome\",\"NameFr\":\"Résultat d'un événement\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Résultat d'un événement : succès, succès partiel ou échec.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"OutcomeDetail\",\"NameFr\":\"Description détaillée de l'événement.\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Description détaillée du résultat de l'événement.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"OutcomeDetailMessage\",\"NameFr\":\"Message du résultat\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Message complet du résultat de l'événement.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"EventDetailData\",\"NameFr\":\"Message technique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Message technique détaillant l'événement.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectReferenceId\",\"NameFr\":\"Identifiant de l'objet-données lié\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à un objet-données listé dans les métadonnées de transport.\",\"Collection\":\"Objets\",\"Children\":[]}]}]}]},{\"Name\":\"BinaryDataObject\",\"NameFr\":\"Fichier numérique\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Bloc de métadonnées techniques des objets-données numériques. Le caractère facultatif est requis afin de permettre le transfert d'un plan de classement sans DataObject joint.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectSystemId\",\"NameFr\":\"Identifiant de l'Objet de données du SAE\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué aux objets de données. Il est attribué par le SAE et correspond à un identifiant interne.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectGroupSystemId\",\"NameFr\":\"Identifiant du groupe d'Objet de données du SAE\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué aux groupes d'objets de données. Il est attribué par le SAE et correspond à un identifiant interne.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Relationship\",\"NameFr\":\"Relation de signature\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Permet de spécifier un lien technique entre un objet-données et une signature.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"target\",\"NameFr\":\"Cible\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"NCName\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Cible de la relation de signature\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"type\",\"NameFr\":\"Type\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type de signature\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"DataObjectGroupReferenceId\",\"NameFr\":\"Identifiant du groupe d'objet-données lié\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à un groupe d'objets-données listé dans les métadonnées de transport.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectGroupId\",\"NameFr\":\"Identifiant du groupe d’Objets de données\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée qui permet d’identifier un groupe d’Objets de données à l’intérieur d’une transaction. Compatibilité SEDA 2.0 qui déclare les groupes d’Objets de données avec le diptyque DataObjectGroupId et DataObjectGroupReferenceId. Cet ensemble ne doit pas être utilisé dans DataObjectGroup.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectVersion\",\"NameFr\":\"Version de l’Objet de données\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version d'un objet-données (par exemple : original papier, conservation, diffusion, vignette, txt, ...).\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Attachment\",\"NameFr\":\"Objet attaché\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"base64Binary\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée qui permet d’associer en Base 64 l’Objet de données dans la transaction directement. Choix à faire entre Attachment et Uri\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"filename\",\"NameFr\":\"Nom du fichier\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du fichier d’origine\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"uri\",\"NameFr\":\"URI\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"L'URI spécifie où se trouve l'objet-données numérique. Peut correspondre à un chemin relatif.\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Uri\",\"NameFr\":\"URI\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"L'URI spécifie où se trouve l'objet-données numérique. Peut correspondre à un chemin relatif.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"MessageDigest\",\"NameFr\":\"Empreinte\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"base64Binary\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Empreinte de l'objet-données.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"algorithm\",\"NameFr\":\"Algorithme\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Algorithme utilisé pour calculer l'empreinte\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Size\",\"NameFr\":\"Taille\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"positiveInteger\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Permet de spécifier la taille de l'objet-données en octet.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Compressed\",\"NameFr\":\"Compression\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"boolean\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Indique si l'objet-données est compressé et doit être décompressé.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"algorithm\",\"NameFr\":\"Algorithme\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Algorithme utilisé pour compresser l'objet-données \",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"unCompressedSize\",\"NameFr\":\"Taille non compressée\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"positiveInteger\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Taille non compressée de l'objet-données\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"FormatIdentification\",\"NameFr\":\"Identification du format\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identification du format du fichier constituant l’Objet de données numérique\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"FormatLitteral\",\"NameFr\":\"Format littéral\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Forme littérale du nom du format. Exemple : Microsoft Word Document.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"MimeType\",\"NameFr\":\"Type MIME\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type Mime associé. Exemple : application/msword\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"FormatId\",\"NameFr\":\"Identifiant du format\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type spécifique du format tel que défini dans FormatIdCodeList. Exemple : (Pronom)fmt/40\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Encoding\",\"NameFr\":\"Encodage\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Encodage du fichier. Exemple : Utf-8\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"FileInfo\",\"NameFr\":\"Information sur le fichier\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Propriétés techniques génériques du fichier (nom d'origine, logiciel de création, système d'exploitation de création).\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"Filename\",\"NameFr\":\"Nom du fichier\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du fichier d'origine.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"CreatingApplicationName\",\"NameFr\":\"Nom de l'application de création\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'application utilisée pour créer le fichier.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"CreatingApplicationVersion\",\"NameFr\":\"Version de l'application de création\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version de l'application utilisée pour créer le fichier.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DateCreatedByApplication\",\"NameFr\":\"Date de création\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de création du fichier dans l'application. A ne pas confondre avec CreatedDate dans les métadonnées descriptives\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"CreatingOs\",\"NameFr\":\"Système d'exploitation d'origine\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Système d’exploitation utilisé pour faire fonctionner l’application de création du fichier échangé.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"CreatingOsVersion\",\"NameFr\":\"Version du système d'exploitation d'origine\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version du système d'exploitation utilisé pour créer le fichier.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"LastModified\",\"NameFr\":\"Date de dernière modification\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de la dernière modification du fichier.\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Metadata\",\"NameFr\":\"Autres métadonnées\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Propriétés techniques spécifiques du fichier en fonction de sa nature technique (texte, document, image, audio, vidéo, etc.).\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"Text\",\"NameFr\":\"Texte\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"yes\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées pour un objet-données de type textuel.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Document\",\"NameFr\":\"Document\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"yes\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées pour un objet-données de type document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Image\",\"NameFr\":\"Image\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"yes\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées pour un objet-données de type image.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Audio\",\"NameFr\":\"Audio\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"yes\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées pour un objet-données de type audio.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Video\",\"NameFr\":\"Vidéo\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"yes\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées pour un objet-données de type vidéo.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]}]},{\"Name\":\"OtherMetadata\",\"NameFr\":\"Autres métadonnées techniques\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Autres métadonnées techniques si celles définies précédemment ne suffisent pas.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Objets\",\"Children\":[]}]}]},{\"Name\":\"PhysicalDataObject\",\"NameFr\":\"Objet de données physique\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Bloc de métadonnées techniques des objets de données physiques.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectSystemId\",\"NameFr\":\"Identifiant de l'Objet de données du SAE\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué aux objets de données. Il est attribué par le SAE et correspond à un identifiant interne.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectGroupSystemId\",\"NameFr\":\"Identifiant du groupe d'Objet de données du SAE\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué aux groupes d'objets de données. Il est attribué par le SAE et correspond à un identifiant interne.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Relationship\",\"NameFr\":\"Relation de signature\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Permet de spécifier un lien technique entre un objet-données et une signature.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"target\",\"NameFr\":\"Cible\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"NCName\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Cible de la relation de signature\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"type\",\"NameFr\":\"Type\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type de signature\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"DataObjectGroupReferenceId\",\"NameFr\":\"Identifiant du groupe d'objet-données lié\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à un groupe d'objets-données listé dans les métadonnées de transport.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectGroupId\",\"NameFr\":\"Identifiant du groupe d’Objets de données\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée qui permet d’identifier un groupe d’Objets de données à l’intérieur d’une transaction. Compatibilité SEDA 2.0 qui déclare les groupes d’Objets de données avec le diptyque DataObjectGroupId et DataObjectGroupReferenceId. Cet ensemble ne doit pas être utilisé dans DataObjectGroup.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"DataObjectVersion\",\"NameFr\":\"Version de l’Objet de données\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version d'un objet-données (par exemple : original papier, conservation, diffusion, vignette, txt, ...).\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"PhysicalId\",\"NameFr\":\"Identifiant d’Objet de données physique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant physique d'un objet-données physique, externe à celui-ci (ex. code-barres).\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"schemeID\",\"NameFr\":\"Identifiant du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeName\",\"NameFr\":\"Nom du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient le référentiel\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeVersionID\",\"NameFr\":\"Version du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeDataURI\",\"NameFr\":\"URL de la donnée dans le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans le référentiel\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"schemeURI\",\"NameFr\":\"URL du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder au référentiel\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"PhysicalDimensions\",\"NameFr\":\"Dimensions physiques\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Dimensions d'un objet-données physique.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"Width\",\"NameFr\":\"Largeur\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : largeur du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Height\",\"NameFr\":\"Hauteur\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : hauteur du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Depth\",\"NameFr\":\"Profondeur\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : profondeur du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Shape\",\"NameFr\":\"Forme\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : forme du document.\",\"Collection\":\"Objets\",\"Children\":[]},{\"Name\":\"Diameter\",\"NameFr\":\"Diamètre\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : diamètre du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Length\",\"NameFr\":\"Longueur\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : longueur du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Thickness\",\"NameFr\":\"Epaisseur\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : épaisseur du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"micrometre\",\"4H\",\"millimetre\",\"MMT\",\"centimetre\",\"CMT\",\"metre\",\"inch\",\"INH\",\"foot\",\"FOT\"],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"Weight\",\"NameFr\":\"Poids\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"decimal\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"microgram\",\"MC\",\"milligram\",\"MGM\",\"gram\",\"GRM\",\"kilogram\",\"KGM\"],\"Definition\":\"Métadonnée de dimension physique : poids du document.\",\"Collection\":\"Objets\",\"Children\":[{\"Name\":\"unit\",\"NameFr\":\"Unité de mesure\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Unité de mesure\",\"Collection\":\"Objets\",\"Children\":[]}]},{\"Name\":\"NumberOfPage\",\"NameFr\":\"Nombre de pages\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"int\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Métadonnée de dimension physique : nombre de pages.\",\"Collection\":\"Objets\",\"Children\":[]}]}]},{\"Name\":\"DescriptiveMetadata\",\"NameFr\":\"Métadonnées descriptives\",\"Element\":\"Complex\",\"Cardinality\":\"1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Bloc de métadonnées descriptives des objets-données.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"ArchiveUnit\",\"NameFr\":\"Unité d'archives\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Correspond à la notion de composant en ISAD(G). ArchiveUnit permet à la fois de gérer la hiérarchie intellectuelle, tout en contenant les métadonnées de description et de gestion propres à chaque niveau de description archivistique.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'unité d'archives utilisé par exemple dans le cas de multiples héritages, pour savoir quel noeud contient une erreur.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"ArchiveUnitRefId\",\"NameFr\":\"Référence à un ArchiveUnit interne\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Permet de faire une référence à d'autres ArchiveUnit dans la même transaction.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"ArchiveUnitProfile\",\"NameFr\":\"Profil d'unité archivistique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à une partie d'un profil d'archivage applicable à un ArchiveUnit en particulier. Permet par exemple de faire référence à une typologie documentaire dans un profil d'archivage.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"schemeID\",\"NameFr\":\"Identifiant du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeName\",\"NameFr\":\"Nom du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeVersionID\",\"NameFr\":\"Version du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeDataURI\",\"NameFr\":\"URL de la donnée dans le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeURI\",\"NameFr\":\"URL du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder au référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Management\",\"NameFr\":\"Métadonnées de gestion\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées de gestion applicables à l'ArchiveUnit concernée et à ses héritiers.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"StorageRule\",\"NameFr\":\"Durée d'utilité courante\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Gestion de la durée d'utilité courante.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Rule\",\"NameFr\":\"Règle de gestion\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à la règle de durée d'utilité courante.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"StartDate\",\"NameFr\":\"Date de départ\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"date\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de départ de calcul de la règle d'utilité courante.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PreventInheritance\",\"NameFr\":\"Héritage  dans  le  nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"boolean\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[\"false\",\"true\"],\"Definition\":\"Indique si les règles de gestion héritées des ArchiveUnit parents doivent être ignorées pour l'ArchiveUnit concerné.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"RefNonRuleId\",\"NameFr\":\"Arrêt de l’héritage dans le nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"L'identifiant de la règle spécifiée pourra être retirée de l'héritage dans ce noeud.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"FinalAction\",\"NameFr\":\"Sort final\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"RestrictAccess\",\"Transfer\",\"Copy\"],\"Definition\":\"Action à mettre en œuvre au terme de la durée de gestion.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"AppraisalRule\",\"NameFr\":\"Durée d'utilité administrative\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Gestion de la durée d’utilité administrative.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Rule\",\"NameFr\":\"Règle de gestion\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à la règle de durée d'utilité administrative.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"StartDate\",\"NameFr\":\"Date de départ\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"date\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de départ de calcul de la règle d'utilité administrative.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PreventInheritance\",\"NameFr\":\"Héritage  dans  le  nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"boolean\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[\"false\",\"true\"],\"Definition\":\"Indique si les règles de gestion héritées des ArchiveUnit parents doivent être ignorées pour l'ArchiveUnit concerné.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"RefNonRuleId\",\"NameFr\":\"Arrêt de l’héritage dans le nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"L'identifiant de la règle spécifiée pourra être retirée de l'héritage dans ce noeud.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"FinalAction\",\"NameFr\":\"Sort final\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"Keep\",\"Destroy\"],\"Definition\":\"Action à mettre en œuvre au terme de la durée de gestion.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"AccessRule\",\"NameFr\":\"Communicabilité\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Gestion de la communicabilité.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Rule\",\"NameFr\":\"Règle de gestion\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à la règle de communicabilité.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"StartDate\",\"NameFr\":\"Date de départ\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"date\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de départ de calcul de la règle de communicabilité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PreventInheritance\",\"NameFr\":\"Héritage  dans  le  nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"boolean\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[\"false\",\"true\"],\"Definition\":\"Indique si les règles de gestion héritées des ArchiveUnit parents doivent être ignorées pour l'ArchiveUnit concerné.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"RefNonRuleId\",\"NameFr\":\"Arrêt de l’héritage dans le nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"L'identifiant de la règle spécifiée pourra être retirée de l'héritage dans ce noeud.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"DisseminationRule\",\"NameFr\":\"Diffusion\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Gestion de la diffusion.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Rule\",\"NameFr\":\"Règle de gestion\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à la règle de diffusion.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"StartDate\",\"NameFr\":\"Date de départ\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"date\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de départ de calcul de la règle de diffusion.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PreventInheritance\",\"NameFr\":\"Héritage  dans  le  nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"boolean\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[\"false\",\"true\"],\"Definition\":\"Indique si les règles de gestion héritées des ArchiveUnit parents doivent être ignorées pour l'ArchiveUnit concerné.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"RefNonRuleId\",\"NameFr\":\"Arrêt de l’héritage dans le nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"L'identifiant de la règle spécifiée pourra être retirée de l'héritage dans ce noeud.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"ReuseRule\",\"NameFr\":\"Réutilisation\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Gestion de la réutilisation.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Rule\",\"NameFr\":\"Règle de gestion\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à la règle de réutilisation.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"StartDate\",\"NameFr\":\"Date de départ\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"date\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de départ de calcul de la règle de réutilisation.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PreventInheritance\",\"NameFr\":\"Héritage  dans  le  nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"boolean\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[\"false\",\"true\"],\"Definition\":\"Indique si les règles de gestion héritées des ArchiveUnit parents doivent être ignorées pour l'ArchiveUnit concerné.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"RefNonRuleId\",\"NameFr\":\"Arrêt de l’héritage dans le nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"L'identifiant de la règle spécifiée pourra être retirée de l'héritage dans ce noeud.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"ClassificationRule\",\"NameFr\":\"Classification\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Gestion de la classification.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Rule\",\"NameFr\":\"Règle de gestion\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à la règle de classification.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"StartDate\",\"NameFr\":\"Date de départ\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"date\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de départ de calcul de la règle de classification.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"ClassificationAudience\",\"NameFr\":\"Audience de la classification\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Information qui permet de gérer les mentions complémentaires de protection comme 'diffusion restreinte', 'spécial France' ou 'Confidentiel Industrie'\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PreventInheritance\",\"NameFr\":\"Héritage  dans  le  nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"boolean\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[\"false\",\"true\"],\"Definition\":\"Indique si les règles de gestion héritées des ArchiveUnit parents doivent être ignorées pour l'ArchiveUnit concerné.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"RefNonRuleId\",\"NameFr\":\"Arrêt de l’héritage dans le nœud courant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"L'identifiant de la règle spécifiée pourra être retirée de l'héritage dans ce noeud.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"ClassificationLevel\",\"NameFr\":\"Niveau de classification\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence au niveau de classification.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"ClassificationOwner\",\"NameFr\":\"Propriétaire de la classification\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Propriétaire de la classification. Service émetteur au sens de l’IGI 1300.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"ClassificationReassessingDate\",\"NameFr\":\"Date de réévaluation\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de réévaluation de la classification.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"NeedReassessingAuthorization\",\"NameFr\":\"Autorisation de réévaluation\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"boolean\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"true\",\"false\"],\"Definition\":\"Indique si une autorisation humaine est nécessaire pour réévaluer la classification.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"LogBook\",\"NameFr\":\"Journal des traces\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Eléments de traçabilité sur le cycle de vie des Objets de données\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Event\",\"NameFr\":\"Evénement\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"EventIdentifier\",\"NameFr\":\"Identifiant de l'événement\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'événement. Références : premis.eventIdentifier\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"EventTypeCode\",\"NameFr\":\"Code du type d'événement\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code du type d'événement.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"EventType\",\"NameFr\":\"Type d'événement\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type d'événement.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"EventDateTime\",\"NameFr\":\"Date et heure de l'événement\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"DateType\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date et heure de l'événement.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"EventDetail\",\"NameFr\":\"Détail sur l'événement\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Détail sur l'événement.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Outcome\",\"NameFr\":\"Résultat d'un événement\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Résultat d'un événement : succès, succès partiel ou échec.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"OutcomeDetail\",\"NameFr\":\"Description détaillée de l'événement.\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Description détaillée du résultat de l'événement.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"OutcomeDetailMessage\",\"NameFr\":\"Message du résultat\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Message complet du résultat de l'événement.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"EventDetailData\",\"NameFr\":\"Message technique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Message technique détaillant l'événement.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"NeedAuthorization\",\"NameFr\":\"Besoin d'autorisation\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"boolean\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"true\",\"false\"],\"Definition\":\"Indique si une autorisation humaine est nécessaire pour vérifier ou valider les opérations de gestion des ArchiveUnit.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Content\",\"NameFr\":\"Contenu\",\"Element\":\"Complex\",\"Cardinality\":\"1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées de description associées à un ArchiveUnit.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"DescriptionLevel\",\"NameFr\":\"Niveau de description\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"Fonds\",\"Subfonds\",\"Class\",\"Collection\",\"Series\",\"Subseries\",\"RecordGrp\",\"SubGrp\",\"File\",\"Item\",\"OtherLevel\"],\"Definition\":\"Niveau de description au sens de la norme ISAD (G). Indique si l'ArchiveUnit correspond à un fonds, à un sous-fonds, à une classe, à une série organique, à une sous-série organique, à un dossier, à un sous-dossier ou à une pièce. Référence : seda.DescriptionLevel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Title\",\"NameFr\":\"Intitulé\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Intitulé de l'ArchiveUnit. Références : DC.Title ead.unittitle\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"FilePlanPosition\",\"NameFr\":\"Position dans le plan de classement\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Position de l'ArchiveUnit dans le plan de classement du service producteur. Références : seda.FilePlanPosition\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"SystemId\",\"NameFr\":\"Identifiant système\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué à l'objet de donnnées référencé dans l'unité d'archives. Il est attribué par le SAE et correspond à un identifiant interne. Références : ARMS\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"OriginatingSystemId\",\"NameFr\":\"Identifiant de l’unité d’archives par l’application du système producteur\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant système attribué à l’unité d’archives par l'application du service producteur.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"ArchivalAgencyArchiveUnitIdentifier\",\"NameFr\":\"Identifiant de l’unité d’archives pour le service d’archive\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant métier attribué à l'ArchiveUnit par le service d'archives. Peut être comparé à une cote.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"OriginatingAgencyArchiveUnitIdentifier\",\"NameFr\":\"Identifiant de l’unité d’archives pour le service producteur\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué à l’unité d’archives par le service producteur.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"TransferringAgencyArchiveUnitIdentifier\",\"NameFr\":\"Identifiant de l’unité d’archives pour le service versant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant attribué à l'ArchiveUnit par le service versant.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Description\",\"NameFr\":\"Description\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Description générale de l'ArchiveUnit. Correspond à la présentation du contenu au sens de la norme ISAD(G). Références : DC:Documentation\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"CustodialHistory\",\"NameFr\":\"Historique de la conservation\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Énumère les changements successifs de propriété, de responsabilité et de conservation des ArchiveUnit avant leur entrée dans le lieu de conservation. On peut notamment y indiquer comment s'est effectué le passage de l'application d'origine au fichier archivable. Correspond à l'historique de la conservation en ISAD(G). Références : seda.CustodialHistory\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"CustodialHistoryItem\",\"NameFr\":\"Elément d'historique\",\"Element\":\"Simple\",\"Cardinality\":\"1-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Description d'une période ou d'un événement précis dans l'historique.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"when\",\"NameFr\":\"Quand\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Permet de déclarer la temporalité de l'élément\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"CustodialHistoryFile\",\"NameFr\":\"Fichier d'historique\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à un fichier de journalisation externe.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"DataObjectReferenceId\",\"NameFr\":\"Identifiant de l'objet-données lié\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à un objet-données listé dans les métadonnées de transport.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"DataObjectGroupReferenceId\",\"NameFr\":\"Identifiant du groupe d'objet-données lié\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"yes\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Référence à un groupe d'objets-données listé dans les métadonnées de transport.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"Type\",\"NameFr\":\"Type OAIS\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type de l’Objet de données qui permet notamment de différencier un objet contenu et l’information de représentation ou de pérennisation de cet objet (OAIS), par exemple les données d’une base de données et le descriptif de sa structure. Références : seda.DocumentType\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"DocumentType\",\"NameFr\":\"Typologie diplomatique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Type de document au sens diplomatique du terme (ex. compte-rendu de réunion, note, correspondance, etc.). Ne pas confondre avec Type.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Language\",\"NameFr\":\"Langue du contenu\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue principale du contenu du document décrit dans l'unité d'archives. Références : seda.Language\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"DescriptionLanguage\",\"NameFr\":\"Langue de description\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue utilisée dans les métadonnées de représentation et de pérennisation. Références : seda.DescriptionLanguage\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Status\",\"NameFr\":\"Statut\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Etat de l'objet-données (par rapport avec son cycle de vie). Permet par exemple d'indiquer si la signature du fichier a été vérifiée avant le transfert aux archives. Références : seda.Status\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Version\",\"NameFr\":\"Version\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version intellectuelle du document décrit dans l'unité d'archives. A ne pas confondre avec DataObjectVersion qui identifie les versions techniques d’un même contenu d’informations (image haute définition contre image basse définition).\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Tag\",\"NameFr\":\"Indexation libre\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Mots-clés ou liste de mots-clés génériques. En ce qui concerne l'indexation, on pourra utiliser Tag ou Keyword en fonction de ce que l'on souhaite décrire.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Keyword\",\"NameFr\":\"Mot-clé structuré\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Mot-clé associé à une unité d'archives. Correspond à la structure de l’indexation en SEDA 1.0. Le mot-clé peut être qualifié par un KeywordType. A utiliser en parallèle de Tag et Coverage. Références : seda.Keyword\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"KeywordContent\",\"NameFr\":\"Valeur du mot-clé\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Valeur du mot-clé. A utiliser avec Keyword.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"KeywordReference\",\"NameFr\":\"Référence du mot-clé\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Indique, s’il en a un, l’identifiant du mot clé dans une liste déposée, par exemple pour un lieu son Code Officiel Géographique selon l’INSEE.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"schemeID\",\"NameFr\":\"Identifiant du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeName\",\"NameFr\":\"Nom du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeVersionID\",\"NameFr\":\"Version du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeDataURI\",\"NameFr\":\"URL de la donnée dans le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeURI\",\"NameFr\":\"URL du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder au référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"KeywordType\",\"NameFr\":\"Type de mot-clé\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[\"corpname\",\"famname\",\"geogname\",\"name\",\"occupation\",\"persname\",\"subject\",\"genreform\",\"function\"],\"Definition\":\"Type de mot clé.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"listVersionID\",\"NameFr\":\"Identifiant de la version de la liste de codes\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la version de la liste de codes utilisée pour le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"Coverage\",\"NameFr\":\"Couverture\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Couverture spatiale, temporelle ou juridictionnelle de l'ArchiveUnit. Références : DC.Coverage\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Spatial\",\"NameFr\":\"Couverture spatiale\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Couverture spatiale ou couverture géographique de l'unité d'archives. Références: AGKRMS.spatialCoverage\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Temporal\",\"NameFr\":\"Couverture temporelle\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Couverture temporelle de l'unité d'archives. Références: AGKRMS.temporalCoverage\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Juridictional\",\"NameFr\":\"Couverture juridictionnelle\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Juridiction administrative ou ressort administratif de l'unité d'archives. Références: AGKRMS.juridictionalCoverage\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"OriginatingAgency\",\"NameFr\":\"Service producteur\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Service producteur. Personne physique ou morale, publique ou privée, qui a produit, reçu et conservé des archives dans l'exercice de son activité. A ne pas confondre avec OriginatingAgencyIdentifier utilisé dans ManagementMedata pour indiquer l’identifiant d’un producteur lors d’un échange. OriginatingAgency peut également être un acteur SEDA (métadonnées de transport) dans certaines transactions. Références : seda.OriginatingAgency\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Identifier\",\"NameFr\":\"Identifiant du producteur\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du service producteur.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"schemeID\",\"NameFr\":\"Identifiant du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeName\",\"NameFr\":\"Nom du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeVersionID\",\"NameFr\":\"Version du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeDataURI\",\"NameFr\":\"URL de la donnée dans le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeURI\",\"NameFr\":\"URL du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder au référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"OrganizationDescriptiveMetadata\",\"NameFr\":\"Description du producteur\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées de description du service producteur\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"SubmissionAgency\",\"NameFr\":\"Service versant\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Service versant responsable du transfert des données. A ne pas confondre avec SubmissionAgencyIdentifier dans ManagementMetadata pour indiquer l’identifiant d’un service versant lors d’un échange. Références : seda.SubmissionAgency\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Identifier\",\"NameFr\":\"Identifiant du service versant\",\"Element\":\"Simple\",\"Cardinality\":\"1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du service versant\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"schemeID\",\"NameFr\":\"Identifiant du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeName\",\"NameFr\":\"Nom du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeAgencyID\",\"NameFr\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de l'organisation qui maintient le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeAgencyName\",\"NameFr\":\"Nom de l'organisation qui maintient le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de l'organisation qui maintient le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeVersionID\",\"NameFr\":\"Version du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Version du référentiel utilisé pour renseigner le contenu de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeDataURI\",\"NameFr\":\"URL de la donnée dans le référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder à la donnée dans le référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"schemeURI\",\"NameFr\":\"URL du référentiel\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse où l'on peut accéder au référentiel\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"OrganizationDescriptiveMetadata\",\"NameFr\":\"Description du service versant\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"yes\",\"Enumeration\":[],\"Definition\":\"Métadonnées de description du service versant\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xlink:href\",\"NameFr\":\"URL liée\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"anyURI\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"URL liée\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"xml:id\",\"NameFr\":\"id\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"ID\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la balise\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"AuthorizedAgent\",\"NameFr\":\"Personne ayant des droits sur l’unité d’archives\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Personne ayant des droits sur l’unité d’archives. Ex. : titulaire de droits de propriété littéraire et artistique\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"FirstName\",\"NameFr\":\"Prénom\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Prénom d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthName\",\"NameFr\":\"Nom de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de naissance d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"FullName\",\"NameFr\":\"Nom complet\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom complet d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"GivenName\",\"NameFr\":\"Nom d'usage\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'usage d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Gender\",\"NameFr\":\"Sexe\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Sexe de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthDate\",\"NameFr\":\"Date de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"date\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthPlace\",\"NameFr\":\"Lieu de naissance\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Addresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"DeathDate\",\"NameFr\":\"Date de décès\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"date\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"DeathPlace\",\"NameFr\":\"Lieu de décès\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Nationality\",\"NameFr\":\"Nationalité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nationalité d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Corpname\",\"NameFr\":\"Nom d'une entité\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Identifier\",\"NameFr\":\"Identifiant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la personne (par exemple, le numéro matricule) ou de l'entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Function\",\"NameFr\":\"Fonction\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Fonction de la personne ou de l'entité\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Activity\",\"NameFr\":\"Activité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Activité de la personne ou de l'entité\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Position\",\"NameFr\":\"Intitulé du poste de travail\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Intitulé du poste de travail occupé par la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Role\",\"NameFr\":\"Droits dans une application\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Droits avec lesquels un utilisateur a réalisé une opération, notamment dans une application. Références : moreq.role\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Mandate\",\"NameFr\":\"Mandat\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Mandat octroyé à la personne. Ex.: statut d’un organisme, contrat de cession de droits en termes de propriété intellectuelle et artistique sur une archive\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"Writer\",\"NameFr\":\"Rédacteur \",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Rédacteur de l'ArchiveUnit. Références : interpares.Writer\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"FirstName\",\"NameFr\":\"Prénom\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Prénom d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthName\",\"NameFr\":\"Nom de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de naissance d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"FullName\",\"NameFr\":\"Nom complet\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom complet d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"GivenName\",\"NameFr\":\"Nom d'usage\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'usage d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Gender\",\"NameFr\":\"Sexe\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Sexe de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthDate\",\"NameFr\":\"Date de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthPlace\",\"NameFr\":\"Lieu de naissance\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"DeathDate\",\"NameFr\":\"Date de décès\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"DeathPlace\",\"NameFr\":\"Lieu de décès\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Nationality\",\"NameFr\":\"Nationalité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nationalité d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Corpname\",\"NameFr\":\"Nom d'une entité\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Identifier\",\"NameFr\":\"Identifiant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la personne (par exemple, le numéro matricule) ou de l'entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Function\",\"NameFr\":\"Fonction\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Fonction de la personne ou de l'entité\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Activity\",\"NameFr\":\"Activité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Activité de la personne ou de l'entité\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Position\",\"NameFr\":\"Intitulé du poste de travail\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Intitulé du poste de travail occupé par la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Role\",\"NameFr\":\"Droits dans une application\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Droits avec lesquels un utilisateur a réalisé une opération, notamment dans une application. Références : moreq.role\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Mandate\",\"NameFr\":\"Mandat\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Mandat octroyé à la personne. Ex.: statut d’un organisme, contrat de cession de droits en termes de propriété intellectuelle et artistique sur une archive\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"Addressee\",\"NameFr\":\"Destinataire pour action\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Destinataire pour action. Utilisé pour indiquer le nom du destinataire par exemple dans un courrier électronique. Références : ARMS.Addressee, Interpares.Addressee\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"FirstName\",\"NameFr\":\"Prénom\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Prénom d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthName\",\"NameFr\":\"Nom de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de naissance d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"FullName\",\"NameFr\":\"Nom complet\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom complet d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"GivenName\",\"NameFr\":\"Nom d'usage\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'usage d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Gender\",\"NameFr\":\"Sexe\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Sexe de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthDate\",\"NameFr\":\"Date de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthPlace\",\"NameFr\":\"Lieu de naissance\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"DeathDate\",\"NameFr\":\"Date de décès\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"DeathPlace\",\"NameFr\":\"Lieu de décès\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Nationality\",\"NameFr\":\"Nationalité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nationalité d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Corpname\",\"NameFr\":\"Nom d'une entité\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Identifier\",\"NameFr\":\"Identifiant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la personne (par exemple, le numéro matricule) ou de l'entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Function\",\"NameFr\":\"Fonction\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Fonction de la personne ou de l'entité\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Activity\",\"NameFr\":\"Activité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Activité de la personne ou de l'entité\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Position\",\"NameFr\":\"Intitulé du poste de travail\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Intitulé du poste de travail occupé par la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Role\",\"NameFr\":\"Droits dans une application\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Droits avec lesquels un utilisateur a réalisé une opération, notamment dans une application. Références : moreq.role\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Mandate\",\"NameFr\":\"Mandat\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Mandat octroyé à la personne. Ex.: statut d’un organisme, contrat de cession de droits en termes de propriété intellectuelle et artistique sur une archive\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"Recipient\",\"NameFr\":\"Destinataire pour information\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Destinataire pour information. Utilisé pour indiquer le nom du destinatire en copie, pour information, par exemple dans un courrier électronique. A ne pas confondre avec Addressee. Références : Interpares.Recipient\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"FirstName\",\"NameFr\":\"Prénom\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Prénom d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthName\",\"NameFr\":\"Nom de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de naissance d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"FullName\",\"NameFr\":\"Nom complet\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom complet d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"GivenName\",\"NameFr\":\"Nom d'usage\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'usage d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Gender\",\"NameFr\":\"Sexe\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Sexe de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthDate\",\"NameFr\":\"Date de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthPlace\",\"NameFr\":\"Lieu de naissance\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"DeathDate\",\"NameFr\":\"Date de décès\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"DeathPlace\",\"NameFr\":\"Lieu de décès\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Nationality\",\"NameFr\":\"Nationalité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nationalité d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Corpname\",\"NameFr\":\"Nom d'une entité\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Identifier\",\"NameFr\":\"Identifiant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la personne (par exemple, le numéro matricule) ou de l'entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Function\",\"NameFr\":\"Fonction\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Fonction de la personne ou de l'entité\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Activity\",\"NameFr\":\"Activité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Activité de la personne ou de l'entité\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Position\",\"NameFr\":\"Intitulé du poste de travail\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Intitulé du poste de travail occupé par la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Role\",\"NameFr\":\"Droits dans une application\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Droits avec lesquels un utilisateur a réalisé une opération, notamment dans une application. Références : moreq.role\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Mandate\",\"NameFr\":\"Mandat\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Mandat octroyé à la personne. Ex.: statut d’un organisme, contrat de cession de droits en termes de propriété intellectuelle et artistique sur une archive\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"Transmitter\",\"NameFr\":\"Emetteur\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Emetteur du message. Identifie la personne qui a rédigé le message (à la différence de celui qui l’envoie)\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"FirstName\",\"NameFr\":\"Prénom\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Prénom d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthName\",\"NameFr\":\"Nom de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de naissance d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"FullName\",\"NameFr\":\"Nom complet\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom complet d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"GivenName\",\"NameFr\":\"Nom d'usage\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'usage d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Gender\",\"NameFr\":\"Sexe\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Sexe de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthDate\",\"NameFr\":\"Date de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthPlace\",\"NameFr\":\"Lieu de naissance\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"DeathDate\",\"NameFr\":\"Date de décès\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"DeathPlace\",\"NameFr\":\"Lieu de décès\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Nationality\",\"NameFr\":\"Nationalité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nationalité d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Corpname\",\"NameFr\":\"Nom d'une entité\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Identifier\",\"NameFr\":\"Identifiant\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Identifiant de la personne (par exemple, le numéro matricule) ou de l'entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Function\",\"NameFr\":\"Fonction\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Fonction de la personne ou de l'entité\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Activity\",\"NameFr\":\"Activité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Activité de la personne ou de l'entité\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Position\",\"NameFr\":\"Intitulé du poste de travail\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Intitulé du poste de travail occupé par la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Role\",\"NameFr\":\"Droits dans une application\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Droits avec lesquels un utilisateur a réalisé une opération, notamment dans une application. Références : moreq.role\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Mandate\",\"NameFr\":\"Mandat\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Mandat octroyé à la personne. Ex.: statut d’un organisme, contrat de cession de droits en termes de propriété intellectuelle et artistique sur une archive\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"xml:lang\",\"NameFr\":\"Langue\",\"Element\":\"Attribute\",\"Cardinality\":\"0-1\",\"Type\":\"language\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Langue du document de la métadonnée\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]}]},{\"Name\":\"Sender\",\"NameFr\":\"Expéditeur\",\"Element\":\"Complex\",\"Cardinality\":\"0-N\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Expéditeur du message. Identifie la personne qui envoie le message (à la différence de celui qui le rédige).\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"FirstName\",\"NameFr\":\"Prénom\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Prénom d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthName\",\"NameFr\":\"Nom de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom de naissance d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"FullName\",\"NameFr\":\"Nom complet\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom complet d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"GivenName\",\"NameFr\":\"Nom d'usage\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom d'usage d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Gender\",\"NameFr\":\"Sexe\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Sexe de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthDate\",\"NameFr\":\"Date de naissance\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"BirthPlace\",\"NameFr\":\"Lieu de naissance\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de naissance de la personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"DeathDate\",\"NameFr\":\"Date de décès\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"token\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Date de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"DeathPlace\",\"NameFr\":\"Lieu de décès\",\"Element\":\"Complex\",\"Cardinality\":\"0-1\",\"Type\":\"null\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Lieu de décès d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[{\"Name\":\"Geogname\",\"NameFr\":\"Nom géographique\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nom géographique associé à la description d'une personne ou d'une entité. Références : ead.geogname\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Address\",\"NameFr\":\"Adresse\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Adresse associée à la description d'une personne ou d'une entité. Références : ead.address\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"PostalCode\",\"NameFr\":\"Code postal\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Code postal associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"City\",\"NameFr\":\"Ville\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Ville associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Region\",\"NameFr\":\"Région\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Région associée à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Country\",\"NameFr\":\"Pays\",\"Element\":\"Simple\",\"Cardinality\":\"0-1\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Pays associé à la description d'une personne ou d'une entité.\",\"Collection\":\"Unités d'archives\",\"Children\":[]}]},{\"Name\":\"Nationality\",\"NameFr\":\"Nationalité\",\"Element\":\"Simple\",\"Cardinality\":\"0-N\",\"Type\":\"string\",\"Choice\":\"no\",\"Extensible\":\"no\",\"Enumeration\":[],\"Definition\":\"Nationalité d'une personne.\",\"Collection\":\"Unités d'archives\",\"Children\":[]},{\"Name\":\"Corpname\",\"NameFr\":\"Nom d'une entité\",\"Element\":\"Simple\",\"Cardinality\":\"0