/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.common.utils;

import java.util.List;
import java.util.Optional;

public final class IamUtils {
    public static final String EMAIL_VALID_REGEXP = "^[_A-Za-z0-9]+(((\\.|-)[_A-Za-z0-9]+))*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";

    private IamUtils() {
    }

    @SafeVarargs
    public static <E extends Enum<E>> Optional<String> buildOptionalEmbedded(Enum<E> ... embeddedField) {
        return Optional.of(IamUtils.buildEmbedded(embeddedField));
    }

    @SafeVarargs
    public static <E extends Enum<E>> String buildEmbedded(Enum<E> ... embeddedField) {
        StringBuilder sb = new StringBuilder();
        if (embeddedField.length > 0) {
            sb.append(embeddedField[0]);
            for (int i = 1; i < embeddedField.length; ++i) {
                sb.append(",").append(embeddedField[i].toString());
            }
        }
        return sb.toString();
    }

    public static <E extends Enum<E>> Optional<String> buildOptionalEmbedded(List<E> embeddedFieldList) {
        return Optional.of(IamUtils.buildEmbedded(embeddedFieldList));
    }

    public static <E extends Enum<E>> String buildEmbedded(List<E> embeddedFieldList) {
        return IamUtils.buildEmbedded((Enum[])embeddedFieldList.toArray());
    }
}

