/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.client;

import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitsDto;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class CollectTransactionInternalRestClient
extends BasePaginatingAndSortingRestClient<CollectTransactionDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CollectTransactionInternalRestClient.class);

    public CollectTransactionInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected Class<CollectTransactionDto> getDtoClass() {
        return CollectTransactionDto.class;
    }

    protected ParameterizedTypeReference<List<CollectTransactionDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<CollectTransactionDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<CollectTransactionDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<CollectTransactionDto>>(){};
    }

    public String getPathUrl() {
        return "/collect-api/v1/transactions";
    }

    public void sendTransaction(InternalHttpContext context, String id) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{id}/send"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.PUT, request, Void.class);
    }

    public void validateTransaction(InternalHttpContext context, String id) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{id}/validate"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.PUT, request, Void.class);
    }

    public void reopenTransaction(InternalHttpContext context, String id) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{id}/reopen"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.PUT, request, Void.class);
    }

    public void abortTransaction(InternalHttpContext context, String id) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{id}/abort"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.PUT, request, Void.class);
    }

    public CollectTransactionDto getTransactionById(InternalHttpContext context, String transactionId) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{transactionId}), HttpMethod.GET, request, CollectTransactionDto.class);
        return (CollectTransactionDto)response.getBody();
    }

    public ResponseEntity<ResultsDto> findUnitById(String id, InternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/archiveunit/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, ResultsDto.class);
    }

    public ArchiveUnitsDto searchCollectProjectArchiveUnits(InternalHttpContext context, String projectId, SearchCriteriaDto searchQuery) {
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)searchQuery, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/" + projectId + "/archive-units", HttpMethod.POST, request, ArchiveUnitsDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (ArchiveUnitsDto)response.getBody();
    }

    public Resource exportCsvArchiveUnitsByCriteria(String projectId, SearchCriteriaDto query, InternalHttpContext context) {
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/" + projectId + "/archive-units/export-csv-search", HttpMethod.POST, request, Resource.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (Resource)response.getBody();
    }

    public CollectTransactionDto updateTransaction(InternalHttpContext context, CollectTransactionDto transactionDto) {
        HttpEntity request = new HttpEntity((Object)transactionDto, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.getUrl(), HttpMethod.PUT, request, CollectTransactionDto.class, new Object[0]);
        return (CollectTransactionDto)response.getBody();
    }

    public ResponseEntity<ResultsDto> findObjectGroupById(String id, InternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/objects/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, ResultsDto.class);
    }

    public List<VitamUiOntologyDto> getExternalOntologiesList(InternalHttpContext context) {
        LOGGER.debug("[INTERNAL] : Calling Get External ontologies list");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/external-ontologies"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return (List)this.restTemplate.exchange(uriBuilder.build().toUri(), HttpMethod.GET, request, ArrayList.class).getBody();
    }

    public ResultsDto selectUnitWithInheritedRules(InternalHttpContext context, String transactionId, SearchCriteriaDto query) {
        LOGGER.debug("Calling select Unit With Inherited Rules with query {} ", (Object)query);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/" + transactionId + "/unit-with-inherited-rules", HttpMethod.POST, request, ResultsDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (ResultsDto)response.getBody();
    }
}

