/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.client;

import fr.gouv.vitamui.collect.common.dto.CollectProjectDto;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import java.util.List;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class CollectInternalRestClient
extends BasePaginatingAndSortingRestClient<CollectProjectDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CollectInternalRestClient.class);
    private static final String TRANSACTIONS = "/transactions";

    public CollectInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected Class<CollectProjectDto> getDtoClass() {
        return CollectProjectDto.class;
    }

    protected ParameterizedTypeReference<List<CollectProjectDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<CollectProjectDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<CollectProjectDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<CollectProjectDto>>(){};
    }

    public String getPathUrl() {
        return "/collect-api/v1/projects";
    }

    private String getTransactionUrl() {
        if (this.baseUrl != null) {
            return this.baseUrl + "/collect-api/v1/transactions";
        }
        return "/collect-api/v1/transactions";
    }

    public CollectProjectDto create(InternalHttpContext context, CollectProjectDto dto) {
        return (CollectProjectDto)this.create(this.getUrl(), (AbstractHttpContext)context, (IdDto)dto);
    }

    public PaginatedValuesDto<CollectProjectDto> getAllPaginated(InternalHttpContext context, Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        URIBuilder builder = this.getUriBuilder(this.getUrl());
        return this.getAllPaginated(builder, (AbstractHttpContext)context, page, size, criteria, orderBy, direction, Optional.empty());
    }

    public ResponseEntity<ResultsDto> findObjectById(String id, InternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/object-groups/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, ResultsDto.class);
    }

    public void deleteProject(InternalHttpContext context, String id) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.DELETE, request, Void.class);
    }

    public PaginatedValuesDto<CollectTransactionDto> getTransactionsByProjectPaginated(InternalHttpContext context, Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, String projectId) {
        URIBuilder builder = this.getUriBuilder(this.getUrl() + "/" + projectId + TRANSACTIONS);
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("search page={}, size={}, criteria={}, orderBy={}, direction={}", new Object[]{page, size, criteria, orderBy, direction});
        builder.addParameter("page", page.toString());
        builder.addParameter("size", size.toString());
        criteria.ifPresent(o -> builder.addParameter("criteria", o));
        orderBy.ifPresent(o -> builder.addParameter("orderBy", o));
        direction.ifPresent(o -> builder.addParameter("direction", o.toString()));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(builder), HttpMethod.GET, request, this.getTransactionDtoPaginatedClass());
        this.checkResponse(response, new Integer[0]);
        return (PaginatedValuesDto)response.getBody();
    }

    public CollectTransactionDto getTransactionById(InternalHttpContext context, String transactionId) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getTransactionUrl() + "/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{transactionId}), HttpMethod.GET, request, CollectTransactionDto.class);
        return (CollectTransactionDto)response.getBody();
    }

    public CollectTransactionDto createTransaction(InternalHttpContext context, CollectTransactionDto dto, String id) {
        ApiUtils.checkValidity((Object)dto);
        HttpEntity request = new HttpEntity((Object)dto, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/" + id + TRANSACTIONS, HttpMethod.POST, request, CollectTransactionDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (CollectTransactionDto)response.getBody();
    }

    public CollectTransactionDto getLastTransactionForProjectId(InternalHttpContext context, String id) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{id}/last-transaction"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, CollectTransactionDto.class);
        return (CollectTransactionDto)response.getBody();
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<CollectTransactionDto>> getTransactionDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<CollectTransactionDto>>(){};
    }
}

