/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.client;

import fr.gouv.vitamui.collect.common.dto.OperationIdDto;
import fr.gouv.vitamui.collect.common.dto.UpdateArchiveUnitDto;
import fr.gouv.vitamui.collect.common.rest.ArchiveUnitClient;
import fr.gouv.vitamui.commons.api.dtos.JsonPatch;
import fr.gouv.vitamui.commons.api.dtos.JsonPatchDto;
import fr.gouv.vitamui.commons.api.dtos.MultiJsonPatchDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Set;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class ArchiveUnitClientImpl
extends BaseRestClient<InternalHttpContext>
implements ArchiveUnitClient {
    private static final String ARCHIVE_UNITS = "archive-units";
    private static final VitamUILogger log = VitamUILoggerFactory.getInstance(ArchiveUnitClientImpl.class);

    public ArchiveUnitClientImpl(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return String.format("/%s", ARCHIVE_UNITS);
    }

    public OperationIdDto update(AbstractHttpContext abstractHttpContext, String transactionId, Set<UpdateArchiveUnitDto> updateOperationDtoSet) {
        URI uri;
        try {
            uri = new URIBuilder(this.getBaseUrl()).setPathSegments(new String[]{ARCHIVE_UNITS, transactionId}).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpEntity httpEntity = new HttpEntity(updateOperationDtoSet, this.buildHeaders(abstractHttpContext));
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.PATCH, httpEntity, OperationIdDto.class);
        return Objects.requireNonNull((OperationIdDto)responseEntity.getBody());
    }

    public OperationIdDto update(AbstractHttpContext abstractHttpContext, String transactionId, String id, JsonPatch jsonPatch) {
        URI uri;
        try {
            uri = new URIBuilder(this.getBaseUrl()).setPathSegments(new String[]{ARCHIVE_UNITS, transactionId, id}).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpEntity httpEntity = new HttpEntity((Object)jsonPatch, this.buildHeaders(abstractHttpContext));
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.PATCH, httpEntity, OperationIdDto.class);
        return Objects.requireNonNull((OperationIdDto)responseEntity.getBody());
    }

    public OperationIdDto update(AbstractHttpContext abstractHttpContext, String transactionId, JsonPatchDto jsonPatchDto) {
        URI uri;
        try {
            uri = new URIBuilder(this.getBaseUrl()).setPathSegments(new String[]{ARCHIVE_UNITS, transactionId, "update", "single"}).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpEntity httpEntity = new HttpEntity((Object)jsonPatchDto, this.buildHeaders(abstractHttpContext));
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.PATCH, httpEntity, OperationIdDto.class);
        return Objects.requireNonNull((OperationIdDto)responseEntity.getBody());
    }

    public OperationIdDto update(AbstractHttpContext abstractHttpContext, String transactionId, MultiJsonPatchDto multiJsonPatchDto) {
        URI uri;
        try {
            uri = new URIBuilder(this.getBaseUrl()).setPathSegments(new String[]{ARCHIVE_UNITS, transactionId, "update", "multiple"}).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpEntity httpEntity = new HttpEntity((Object)multiJsonPatchDto, this.buildHeaders(abstractHttpContext));
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.PATCH, httpEntity, OperationIdDto.class);
        return Objects.requireNonNull((OperationIdDto)responseEntity.getBody());
    }
}

