/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.client;

import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseWebClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileResponse;
import fr.gouv.vitamui.pastis.common.util.CustomMultipartFile;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

public class PastisTransformationWebClient
extends BaseWebClient<ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(PastisTransformationWebClient.class);

    public PastisTransformationWebClient(WebClient webClient, String baseUrl) {
        super(webClient, baseUrl);
    }

    public ResponseEntity<ProfileResponse> loadProfileFromFile(MultipartFile file, ExternalHttpContext context) {
        LOGGER.debug("Upload profile");
        return ResponseEntity.ok((Object)((ProfileResponse)this.multipartData(this.getUrl() + "/profile", HttpMethod.POST, (AbstractHttpContext)context, Collections.singletonMap("fileName", file.getOriginalFilename()), Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("file", file)), ProfileResponse.class)));
    }

    public ResponseEntity<ElementProperties> loadProfilePA(Resource resource, ExternalHttpContext context) throws IOException {
        LOGGER.debug("Upload profile");
        CustomMultipartFile multipartFile = new CustomMultipartFile(resource.getInputStream().readAllBytes());
        return ResponseEntity.ok((Object)((ElementProperties)this.multipartData(this.getUrl() + "/editpa", HttpMethod.POST, (AbstractHttpContext)context, Collections.singletonMap("fileName", multipartFile.getOriginalFilename()), Optional.of(new AbstractMap.SimpleEntry<String, CustomMultipartFile>("file", multipartFile)), ElementProperties.class)));
    }

    public String getPathUrl() {
        return "/pastis";
    }
}

