/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.gateway.filters;

import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Order(value=1)
@Component
public class X509CertificateFilter
implements GlobalFilter {
    private static final VitamUILogger logger = VitamUILoggerFactory.getInstance(X509CertificateFilter.class);
    @Value(value="${authn.client-certificate-header-name}")
    private String clientCertificateHeaderName;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        X509Certificate[] certs;
        ServerHttpRequest req = exchange.getRequest();
        SslInfo sslInfo = req.getSslInfo();
        if (sslInfo != null && (certs = sslInfo.getPeerCertificates()) != null && certs.length > 0) {
            ServerHttpRequest request = exchange.getRequest().mutate().headers(httpHeaders -> {
                X509Certificate certificate = certs[0];
                try {
                    certificate.checkValidity();
                    String encodedCert = new String(Base64.encodeBase64((byte[])certificate.getEncoded()));
                    httpHeaders.set(this.clientCertificateHeaderName, encodedCert);
                }
                catch (CertificateEncodingException | CertificateExpiredException | CertificateNotYetValidException e) {
                    logger.error("Certificate is invalid : {}", (Object)certificate, (Object)e);
                }
            }).build();
            return chain.filter(exchange.mutate().request(request).build());
        }
        return chain.filter(exchange);
    }
}

