/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseWebClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Optional;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

public class ProfileInternalWebClient
extends BaseWebClient<InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProfileInternalWebClient.class);

    public ProfileInternalWebClient(WebClient webClient, String baseUrl) {
        super(webClient, baseUrl);
    }

    public ResponseEntity<JsonNode> importProfiles(InternalHttpContext context, String fileName, MultipartFile file) {
        LOGGER.debug("Import Profile {}", (Object)(file != null ? file.getOriginalFilename() : null));
        if (file == null) {
            throw new BadRequestException("No file to check .");
        }
        return ResponseEntity.ok((Object)((JsonNode)this.multipartData("http://localhost:7087/referential/v1/profile/import", HttpMethod.POST, (AbstractHttpContext)context, Collections.singletonMap("fileName", fileName), Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("file", file)), JsonNode.class)));
    }

    public JsonNode updateProfileFile(InternalHttpContext context, String id, MultipartFile profileFile) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/updateProfileFile/{id}"));
        return (JsonNode)this.multipartData(this.getUrl() + "/updateProfileFile/{id}", HttpMethod.PUT, (AbstractHttpContext)context, Collections.singletonMap("fileName", profileFile.getOriginalFilename()), Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("file", profileFile)), JsonNode.class);
    }

    public String getPathUrl() {
        return null;
    }

    public void close() {
    }
}

