/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.external.server.service;

import fr.gouv.vitamui.collect.common.dto.CollectProjectDto;
import fr.gouv.vitamui.collect.internal.client.CollectInternalRestClient;
import fr.gouv.vitamui.collect.internal.client.CollectInternalWebClient;
import fr.gouv.vitamui.commons.vitam.api.dto.QualifiersDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VersionsDto;
import fr.gouv.vitamui.commons.vitam.api.model.ObjectQualifierType;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ProjectObjectGroupExternalService
extends AbstractResourceClientService<CollectProjectDto, CollectProjectDto> {
    private final CollectInternalRestClient collectInternalRestClient;
    private final CollectInternalWebClient collectInternalWebClient;

    public ProjectObjectGroupExternalService(CollectInternalRestClient collectInternalRestClient, CollectInternalWebClient collectInternalWebClient, ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
        this.collectInternalRestClient = collectInternalRestClient;
        this.collectInternalWebClient = collectInternalWebClient;
    }

    public Mono<ResponseEntity<Resource>> downloadObjectFromUnit(String id, String objectId, String usage, Integer version) {
        String fileName = null;
        ResultsDto got = (ResultsDto)this.findObjectById(objectId).getBody();
        if (Objects.nonNull(got)) {
            QualifiersDto qualifier;
            if (ObjectUtils.isEmpty((Object)usage)) {
                qualifier = this.getLastObjectQualifier(got);
            } else {
                String finalUsage = usage;
                qualifier = got.getQualifiers().stream().filter(q -> finalUsage.equals(q.getQualifier())).findFirst().orElse(null);
            }
            if (Objects.nonNull(qualifier)) {
                VersionsDto versionsDto;
                usage = qualifier.getQualifier();
                if (Objects.isNull(version)) {
                    versionsDto = this.getLastVersion(qualifier);
                } else {
                    Integer finalVersion = version;
                    versionsDto = qualifier.getVersions().stream().filter(v -> finalVersion.equals(ProjectObjectGroupExternalService.extractVersion(v))).findFirst().orElse(null);
                }
                if (Objects.nonNull(versionsDto)) {
                    version = ProjectObjectGroupExternalService.extractVersion(versionsDto);
                    fileName = this.getFilename(versionsDto);
                }
            }
        }
        return this.collectInternalWebClient.downloadObjectFromUnit(id, usage, version, this.getInternalHttpContext(), fileName);
    }

    private QualifiersDto getLastObjectQualifier(ResultsDto got) {
        for (String qualifierName : ObjectQualifierType.allValuesOrdered) {
            QualifiersDto qualifierFound = got.getQualifiers().stream().filter(qualifier -> qualifierName.equals(qualifier.getQualifier())).reduce((first, second) -> second).orElse(null);
            if (!Objects.nonNull(qualifierFound)) continue;
            return qualifierFound;
        }
        return null;
    }

    private VersionsDto getLastVersion(QualifiersDto qualifier) {
        return qualifier.getVersions().stream().max(Comparator.comparing(ProjectObjectGroupExternalService::extractVersion)).orElse(null);
    }

    @NotNull
    private static Integer extractVersion(VersionsDto versionsDto) {
        return Integer.parseInt(versionsDto.getDataObjectVersion().split("_")[1]);
    }

    private String getFilename(VersionsDto version) {
        if (Objects.isNull(version) || StringUtils.isEmpty((CharSequence)version.getId())) {
            return null;
        }
        return version.getId() + this.getExtension(version);
    }

    private String getExtension(VersionsDto version) {
        String uriExtension = "";
        if (StringUtils.isNotBlank((CharSequence)version.getUri()) && version.getUri().contains(".")) {
            uriExtension = version.getUri().substring(version.getUri().lastIndexOf(46) + 1);
        }
        String filenameExtension = "";
        if (Objects.nonNull(version.getFileInfoModel()) && StringUtils.isNotBlank((CharSequence)version.getFileInfoModel().getFilename()) && version.getFileInfoModel().getFilename().contains(".")) {
            filenameExtension = version.getFileInfoModel().getFilename().substring(version.getFileInfoModel().getFilename().lastIndexOf(46) + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)filenameExtension)) {
            return "." + filenameExtension;
        }
        if (StringUtils.isNotBlank((CharSequence)uriExtension)) {
            return "." + uriExtension;
        }
        return "";
    }

    public ResponseEntity<ResultsDto> findObjectById(String id) {
        return this.collectInternalRestClient.findObjectById(id, this.getInternalHttpContext());
    }

    protected CollectInternalRestClient getClient() {
        return this.collectInternalRestClient;
    }

    @Generated
    public CollectInternalRestClient getCollectInternalRestClient() {
        return this.collectInternalRestClient;
    }

    @Generated
    public CollectInternalWebClient getCollectInternalWebClient() {
        return this.collectInternalWebClient;
    }
}

