/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.external.server.service;

import fr.gouv.vitamui.collect.common.dto.CollectProjectDto;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.internal.client.CollectInternalRestClient;
import fr.gouv.vitamui.collect.internal.client.CollectStreamingInternalRestClient;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.io.InputStream;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ProjectExternalService
extends AbstractResourceClientService<CollectProjectDto, CollectProjectDto> {
    private final CollectInternalRestClient collectInternalRestClient;
    private final CollectStreamingInternalRestClient collectStreamingInternalRestClient;

    @Autowired
    public ProjectExternalService(CollectInternalRestClient collectInternalRestClient, CollectStreamingInternalRestClient collectStreamingInternalRestClient, ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
        this.collectInternalRestClient = collectInternalRestClient;
        this.collectStreamingInternalRestClient = collectStreamingInternalRestClient;
    }

    protected CollectInternalRestClient getClient() {
        return this.collectInternalRestClient;
    }

    public PaginatedValuesDto<CollectProjectDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        return this.getClient().getAllPaginated(this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
    }

    public CollectProjectDto createProject(CollectProjectDto collectProjectDto) {
        return this.collectInternalRestClient.create(this.getInternalHttpContext(), collectProjectDto);
    }

    public CollectTransactionDto createTransactionForProject(CollectTransactionDto collectTransactionDto, String projectId) {
        return this.collectInternalRestClient.createTransaction(this.getInternalHttpContext(), collectTransactionDto, projectId);
    }

    public ResponseEntity<Void> streamingUpload(InputStream inputStream, String transactionId, String originalFileName) {
        return this.collectStreamingInternalRestClient.streamingUpload(this.getInternalHttpContext(), inputStream, transactionId, originalFileName);
    }

    public CollectProjectDto updateProject(CollectProjectDto collectProjectDto) {
        return (CollectProjectDto)this.collectInternalRestClient.update((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)collectProjectDto);
    }

    public CollectProjectDto findProjectById(String projectId) {
        return (CollectProjectDto)this.collectInternalRestClient.getOne((AbstractHttpContext)this.getInternalHttpContext(), projectId);
    }

    public void deleteProjectById(String projectId) {
        this.collectInternalRestClient.deleteProject(this.getInternalHttpContext(), projectId);
    }

    public PaginatedValuesDto<CollectTransactionDto> getTransactionsByProjectPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, String projectId) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getTransactionsByProjectPaginated(this.getInternalHttpContext(), page, size, this.checkAuthorization(criteria), orderBy, direction, projectId);
        return new PaginatedValuesDto(result.getValues(), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    public CollectTransactionDto getLastTransactionForProjectId(String projectId) {
        return this.collectInternalRestClient.getLastTransactionForProjectId(this.getInternalHttpContext(), projectId);
    }

    @Generated
    public CollectInternalRestClient getCollectInternalRestClient() {
        return this.collectInternalRestClient;
    }

    @Generated
    public CollectStreamingInternalRestClient getCollectStreamingInternalRestClient() {
        return this.collectStreamingInternalRestClient;
    }
}

