/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.external.server.service.TransactionExternalService;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Collect"})
@RequestMapping(value={"/collect-api/v1/transactions"})
@RestController
@ResponseBody
public class TransactionExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(TransactionExternalController.class);
    private final TransactionExternalService transactionExternalService;
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    private static final String TRANSACTION_ID = "The transaction id {} ";

    @Autowired
    public TransactionExternalController(TransactionExternalService transactionExternalService) {
        this.transactionExternalService = transactionExternalService;
    }

    @Secured(value={"ROLE_SEND_TRANSACTIONS"})
    @PutMapping(value={"/{id}/send"})
    public void sendTransaction(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug(TRANSACTION_ID, (Object)id);
        this.transactionExternalService.sendTransaction(id);
    }

    @Secured(value={"ROLE_REOPEN_TRANSACTIONS"})
    @PutMapping(value={"/{id}/reopen"})
    public void reopenTransaction(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug(TRANSACTION_ID, (Object)id);
        this.transactionExternalService.reopenTransaction(id);
    }

    @Secured(value={"ROLE_ABORT_TRANSACTIONS"})
    @PutMapping(value={"/{id}/abort"})
    public void abortTransaction(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug(TRANSACTION_ID, (Object)id);
        this.transactionExternalService.abortTransaction(id);
    }

    @Secured(value={"ROLE_CLOSE_TRANSACTIONS"})
    @PutMapping(value={"/{id}/validate"})
    public void validateTransaction(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug(TRANSACTION_ID, (Object)id);
        this.transactionExternalService.validateTransaction(id);
    }

    @ApiOperation(value="Get transaction by id")
    @GetMapping(value={"/{id}"})
    public CollectTransactionDto getTransactionById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Find the Transactions with project Id {}", (Object)id);
        return this.transactionExternalService.getTransactionById(id);
    }

    @Secured(value={"ROLE_UPDATE_TRANSACTIONS"})
    @PutMapping
    public CollectTransactionDto updateTransaction(@RequestBody CollectTransactionDto transactionDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{transactionDto.getId()});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionDto.getId()});
        SanityChecker.sanitizeCriteria((Object)transactionDto);
        LOGGER.debug("[External] Transaction to update : {}", (Object)transactionDto);
        return this.transactionExternalService.updateTransaction(transactionDto);
    }

    @Secured(value={"ROLE_UPDATE_UNITS_METADATA"})
    @ApiOperation(value="Upload on streaming metadata file and update archive units", consumes="application/octet-stream")
    @PutMapping(value={"/{transactionId}/update-units-metadata"}, consumes={"application/octet-stream"})
    public String updateArchiveUnitsMetadataFromFile(@PathVariable(value="transactionId") String transactionId, InputStream inputStream, @RequestHeader(value="X-Original-Filename") String originalFileName) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)" [External] The transactionId is a mandatory parameter: ", (String[])new String[]{transactionId});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        SanityChecker.isValidFileName((String)originalFileName);
        SafeFileChecker.checkSafeFilePath((String)originalFileName);
        LOGGER.debug("[External] Calling update archive units metadata for transaction Id  {} ", (Object)transactionId);
        return this.transactionExternalService.updateArchiveUnitsFromFile(transactionId, inputStream, originalFileName);
    }
}

