/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.archives.search.common.dto.VitamUIArchiveUnitResponseDto;
import fr.gouv.vitamui.collect.external.server.service.TransactionArchiveUnitExternalService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.ws.rs.Consumes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Collect"})
@RequestMapping(value={"/collect-api/v1/transactions"})
@RestController
@ResponseBody
public class TransactionArchiveUnitExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(TransactionArchiveUnitExternalController.class);
    private static final String MANDATORY_QUERY = "The query is a mandatory parameter: ";
    private static final String MANDATORY_IDENTIFIER = "The identifier is a mandatory parameter: ";
    private final TransactionArchiveUnitExternalService transactionArchiveUnitExternalService;

    @Autowired
    public TransactionArchiveUnitExternalController(TransactionArchiveUnitExternalService transactionArchiveUnitExternalService) {
        this.transactionArchiveUnitExternalService = transactionArchiveUnitExternalService;
    }

    @ApiOperation(value="find archive units by criteria")
    @Secured(value={"ROLE_GET_PROJECTS"})
    @PostMapping(value={"/{transactionId}/archive-units"})
    @Consumes(value={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public VitamUIArchiveUnitResponseDto searchArchiveUnits(@PathVariable(value="transactionId") String transactionId, @RequestBody SearchCriteriaDto searchQuery) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Query and the transactionId are mandatories parameters: ", (Object[])new Object[]{transactionId, searchQuery});
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        LOGGER.debug("search archives Units by criteria = {}", (Object)searchQuery);
        return this.transactionArchiveUnitExternalService.searchCollectTransactionArchiveUnits(transactionId, searchQuery);
    }

    @PostMapping(value={"/{transactionId}/archive-units/export-csv-search"})
    public Resource exportCsvArchiveUnitsByCriteria(@PathVariable(value="transactionId") String transactionId, @RequestBody SearchCriteriaDto query) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling export to csv search archive Units By Criteria {} ", (Object)query);
        return this.transactionArchiveUnitExternalService.exportCsvArchiveUnitsByCriteria(transactionId, query);
    }

    @GetMapping(value={"/archiveunit/{id}"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public ResponseEntity<ResultsDto> findUnitById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("the UA by id {} ", (Object)id);
        return this.transactionArchiveUnitExternalService.findUnitById(id);
    }

    @GetMapping(value={"/objects/{id}"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public ResponseEntity<ResultsDto> getObjectGroupById(@PathVariable(value="id") String objectId) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{objectId});
        SanityChecker.checkSecureParameter((String[])new String[]{objectId});
        LOGGER.debug("[EXTERNAL] : Get ObjectGroup By id : {}", (Object)objectId);
        return this.transactionArchiveUnitExternalService.findObjectGroupById(objectId);
    }

    @GetMapping(value={"/external-ontologies"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public List<VitamUiOntologyDto> getExternalOntologiesList() {
        LOGGER.debug("[EXTERNAL] : Get external ontologies list");
        return this.transactionArchiveUnitExternalService.getExternalOntologiesList();
    }

    @PostMapping(value={"/{transactionId}/unit-with-inherited-rules"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public ResultsDto selectUnitWithInheritedRules(@PathVariable(value="transactionId") String transactionId, @RequestBody SearchCriteriaDto query) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling select Unit With Inherited Rules By Criteria {} ", (Object)query);
        return this.transactionArchiveUnitExternalService.selectUnitWithInheritedRules(transactionId, query);
    }
}

