/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.collect.external.server.service.ProjectObjectGroupExternalService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Api(tags={"Collect"})
@RequestMapping(value={"/collect-api/v1/projects/object-groups"})
@RestController
@ResponseBody
public class ProjectObjectGroupExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProjectObjectGroupExternalController.class);
    private final ProjectObjectGroupExternalService projectObjectGroupExternalService;
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";

    @Autowired
    public ProjectObjectGroupExternalController(ProjectObjectGroupExternalService projectObjectGroupExternalService) {
        this.projectObjectGroupExternalService = projectObjectGroupExternalService;
    }

    @GetMapping(value={"/downloadobjectfromunit/{id}"}, produces={"application/octet-stream"})
    public Mono<ResponseEntity<Resource>> downloadObjectFromUnit(@PathVariable(value="id") String id, @RequestParam(value="objectId") String objectId, @RequestParam(value="usage", required=false) String usage, @RequestParam(value="version", required=false) Integer version) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{objectId});
        SanityChecker.checkSecureParameter((String[])new String[]{objectId});
        LOGGER.debug("Download the Archive Unit Object with id {} ", (Object)objectId);
        return this.projectObjectGroupExternalService.downloadObjectFromUnit(id, objectId, usage, version);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ResultsDto> findObjectById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Find an ObjectGroup by id {} ", (Object)id);
        return this.projectObjectGroupExternalService.findObjectById(id);
    }
}

