/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.rest.client.BaseRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.iam.security.client.AbstractInternalClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.dto.profiles.Notice;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileNotice;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileResponse;
import fr.gouv.vitamui.pastis.common.exception.TechnicalException;
import fr.gouv.vitamui.pastis.common.util.NoticeUtils;
import fr.gouv.vitamui.pastis.server.service.PastisService;
import fr.gouv.vitamui.referential.internal.client.ProfileInternalRestClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.security.NoSuchAlgorithmException;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"pastis"})
@RequestMapping(value={"/pastis"})
@RestController
@ResponseBody
class PastisController
extends AbstractInternalClientService {
    private static final String APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    private final PastisService profileService;
    private final ProfileInternalRestClient profileInternalRestClient;

    public PastisController(ExternalSecurityService externalSecurityService, PastisService profileService, ProfileInternalRestClient profileInternalRestClient) {
        super(externalSecurityService);
        this.profileService = profileService;
        this.profileInternalRestClient = profileInternalRestClient;
    }

    protected BaseRestClient<InternalHttpContext> getClient() {
        return this.profileInternalRestClient;
    }

    @ApiOperation(value="Download Pa Profile rng file")
    @Secured(value={"ROLE_GET_PROFILES"})
    @PostMapping(value={"/archiveprofile"}, consumes={"application/json; charset=utf-8"}, produces={"application/xml"})
    ResponseEntity<String> getArchiveProfile(@RequestBody ElementProperties json) throws TechnicalException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)json);
        String archiveProfile = this.profileService.getArchiveProfile(json);
        if (archiveProfile != null) {
            return ResponseEntity.ok((Object)archiveProfile);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Download Pua Profile json file")
    @Secured(value={"ROLE_GET_ARCHIVE_PROFILES"})
    @PostMapping(value={"/getarchiveunitprofile"}, consumes={"application/json; charset=utf-8"}, produces={"application/json"})
    ResponseEntity<String> getArchiveUnitProfile(@RequestBody ProfileNotice json) throws TechnicalException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)json);
        String archiveUnitProfile = this.profileService.getArchiveUnitProfile(json, false);
        if (archiveUnitProfile != null) {
            return ResponseEntity.ok((Object)archiveUnitProfile);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Retrieve json representation from PUA notice")
    @Secured(value={"ROLE_CREATE_ARCHIVE_PROFILES", "ROLE_UPDATE_PROFILES"})
    @PostMapping(value={"/edit"})
    ResponseEntity<ProfileResponse> loadProfile(@RequestBody Notice notice) throws TechnicalException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)notice);
        if (notice.getControlSchema() == null) {
            Resource resource = (Resource)this.profileInternalRestClient.download(this.getInternalHttpContext(), notice.getIdentifier()).getBody();
            ElementProperties elementProperties = this.profileService.loadProfilePA(resource);
            ProfileResponse profileResponse = NoticeUtils.convertToProfileResponse((Notice)notice);
            profileResponse.setProfile(elementProperties);
            return ResponseEntity.ok((Object)profileResponse);
        }
        ProfileResponse profileResponse = this.profileService.loadProfile(notice);
        if (profileResponse != null) {
            return ResponseEntity.ok((Object)profileResponse);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Retrieve json representation from input file")
    @Secured(value={"ROLE_UPDATE_ARCHIVE_PROFILES", "ROLE_CREATE_PROFILES"})
    @PostMapping(value={"/profile"}, consumes={"multipart/form-data"}, produces={"application/json"})
    ResponseEntity<ProfileResponse> loadProfileFromFile(@RequestParam MultipartFile file) throws NoSuchAlgorithmException, TechnicalException, PreconditionFailedException {
        String fileName = file.getOriginalFilename();
        SanityChecker.isValidFileName((String)fileName);
        ProfileResponse profileResponse = this.profileService.loadProfileFromFile(file, fileName, false);
        if (profileResponse != null) {
            return ResponseEntity.ok((Object)profileResponse);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Retrieve json representation from PA file")
    @Secured(value={"ROLE_CREATE_ARCHIVE_PROFILES", "ROLE_UPDATE_PROFILES"})
    @PostMapping(value={"/editpa"}, consumes={"multipart/form-data"}, produces={"application/json"})
    ResponseEntity<ElementProperties> loadPA(@RequestParam(value="file") MultipartFile file) {
        ElementProperties elementProperties = this.profileService.loadProfilePA(file);
        if (elementProperties != null) {
            return ResponseEntity.ok((Object)elementProperties);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Get template profile by type")
    @Secured(value={"ROLE_UPDATE_ARCHIVE_PROFILES", "ROLE_CREATE_PROFILES"})
    @GetMapping(value={"/profile"})
    ResponseEntity<ProfileResponse> createProfile(@RequestParam(name="type") String profileType) throws NoSuchAlgorithmException, TechnicalException, InvalidParseOperationException {
        SanityChecker.checkSecureParameter((String[])new String[]{profileType});
        ProfileResponse profileResponse = this.profileService.createProfile(profileType, false);
        if (profileResponse != null) {
            return ResponseEntity.ok((Object)profileResponse);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

