/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.server.config;

import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.rest.configuration.SwaggerConfiguration;
import fr.gouv.vitamui.iam.internal.client.IamInternalRestClientFactory;
import fr.gouv.vitamui.iam.internal.client.UserInternalRestClient;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.service.ExternalAuthentificationService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.pastis.common.service.JsonFromPUA;
import fr.gouv.vitamui.pastis.common.service.PuaFromJSON;
import fr.gouv.vitamui.pastis.common.service.PuaPastisValidator;
import fr.gouv.vitamui.pastis.server.config.ApiPastisApplicationProperties;
import fr.gouv.vitamui.referential.internal.client.ProfileInternalRestClient;
import fr.gouv.vitamui.referential.internal.client.ReferentialInternalRestClientFactory;
import fr.gouv.vitamui.security.client.ContextRestClient;
import fr.gouv.vitamui.security.client.SecurityRestClientFactory;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
@Import(value={RestExceptionHandler.class, SwaggerConfiguration.class, HttpMessageConvertersAutoConfiguration.class})
public class ApiPastisServerConfig
extends AbstractContextConfiguration {
    @Bean
    public SecurityRestClientFactory securityRestClientFactory(ApiPastisApplicationProperties apiArchiveExternalApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new SecurityRestClientFactory(apiArchiveExternalApplicationProperties.getSecurityClient(), restTemplateBuilder);
    }

    @Bean
    public ContextRestClient contextCrudRestClient(SecurityRestClientFactory securityRestClientFactory) {
        return securityRestClientFactory.getContextRestClient();
    }

    @Bean
    public ExternalApiAuthenticationProvider apiAuthenticationProvider(ExternalAuthentificationService externalAuthentificationService) {
        return new ExternalApiAuthenticationProvider(externalAuthentificationService);
    }

    @Bean
    public ExternalSecurityService externalSecurityService() {
        return new ExternalSecurityService();
    }

    @Bean
    public ExternalAuthentificationService externalAuthentificationService(ContextRestClient contextRestClient, UserInternalRestClient userInternalRestClient) {
        return new ExternalAuthentificationService(contextRestClient, userInternalRestClient);
    }

    @Bean
    public ReferentialInternalRestClientFactory referentialInternalRestClientFactory(ApiPastisApplicationProperties apiArchiveExternalApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new ReferentialInternalRestClientFactory(apiArchiveExternalApplicationProperties.getReferentialInternalClient(), restTemplateBuilder);
    }

    @Bean
    public ProfileInternalRestClient profileInternalRestClient(ReferentialInternalRestClientFactory referentialInternalRestClientFactory) {
        return referentialInternalRestClientFactory.getProfileInternalRestClient();
    }

    @Bean
    public IamInternalRestClientFactory iamInternalRestClientFactory(ApiPastisApplicationProperties apiArchiveExternalApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IamInternalRestClientFactory(apiArchiveExternalApplicationProperties.getIamInternalClient(), restTemplateBuilder);
    }

    @Bean
    public UserInternalRestClient userInternalRestClient(IamInternalRestClientFactory iamInternalRestClientFactory) {
        return iamInternalRestClientFactory.getUserInternalRestClient();
    }

    @Bean
    public MappingJackson2HttpMessageConverter customizedJacksonMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, new MediaType("application", "*+json"), MediaType.APPLICATION_OCTET_STREAM));
        return converter;
    }

    @Bean
    public JsonFromPUA jsonFromPUA() {
        return new JsonFromPUA();
    }

    @Bean
    public PuaFromJSON puaFromJSON() {
        return new PuaFromJSON(this.puaPastisValidator());
    }

    @Bean
    public PuaPastisValidator puaPastisValidator() {
        return new PuaPastisValidator();
    }
}

