/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.common.utils;

import com.nimbusds.jose.JWSAlgorithm;
import fr.gouv.vitamui.commons.test.utils.ServerIdentityConfigurationBuilder;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.utils.Pac4jClientBuilder;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;

public class Pac4jClientBuilderTest {
    private static final String LOGIN_URL = "casLoginUrl";
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    private static final String DISCOVERY_URL = "https://accounts.google.com/.well-known/openid-configuration";
    private static final String SCOPE = "openid email";
    private static final JWSAlgorithm ALGORITHM = JWSAlgorithm.HS256;
    private static final Map CUSTOM_PARAMS = Map.of("prompt", "login");

    @Before
    public void setUp() {
        ServerIdentityConfigurationBuilder.setup((String)"identityName", (String)"identityRole", (int)1, (int)0);
    }

    @Ignore
    @Test
    public void testOidcProviderCreationSuccessful() {
        IdentityProviderDto provider = new IdentityProviderDto();
        provider.setClientId(CLIENT_ID);
        provider.setClientSecret(CLIENT_SECRET);
        provider.setDiscoveryUrl(DISCOVERY_URL);
        provider.setScope(SCOPE);
        provider.setPreferredJwsAlgorithm(ALGORITHM.toString());
        provider.setCustomParams(CUSTOM_PARAMS);
        provider.setUseState(Boolean.valueOf(false));
        provider.setUseNonce(Boolean.valueOf(false));
        provider.setUsePkce(Boolean.valueOf(true));
        Pac4jClientBuilder builder = new Pac4jClientBuilder();
        builder.setCasLoginUrl(LOGIN_URL);
        Optional optClient = builder.buildClient(provider);
        Assert.assertTrue((boolean)optClient.isPresent());
        IndirectClient client = (IndirectClient)optClient.get();
        Assert.assertTrue((boolean)(client instanceof OidcClient));
        OidcConfiguration config = ((OidcClient)client).getConfiguration();
        Assert.assertEquals((Object)CLIENT_ID, (Object)config.getClientId());
        Assert.assertEquals((Object)CLIENT_SECRET, (Object)config.getSecret());
        Assert.assertEquals((Object)DISCOVERY_URL, (Object)config.getDiscoveryURI());
        Assert.assertEquals((Object)SCOPE, (Object)config.getScope());
        Assert.assertEquals((Object)ALGORITHM, (Object)config.getPreferredJwsAlgorithm());
        Assert.assertEquals((Object)CUSTOM_PARAMS, (Object)config.getCustomParams());
        Assert.assertFalse((boolean)config.isWithState());
        Assert.assertFalse((boolean)config.isUseNonce());
        Assert.assertFalse((boolean)config.isDisablePkce());
    }

    @Test
    public void testOidcProviderCreationFailure() {
        IdentityProviderDto provider = new IdentityProviderDto();
        provider.setClientId(CLIENT_ID);
        provider.setClientSecret(CLIENT_SECRET);
        provider.setDiscoveryUrl("http://url");
        Pac4jClientBuilder builder = new Pac4jClientBuilder();
        builder.setCasLoginUrl(LOGIN_URL);
        Optional optClient = builder.buildClient(provider);
        Assert.assertTrue((boolean)optClient.isEmpty());
    }
}

