/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.service;

import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.ManagementContractDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.referential.external.client.ManagementContractExternalRestClient;
import fr.gouv.vitamui.ui.commons.service.AbstractPaginateService;
import fr.gouv.vitamui.ui.commons.service.CommonService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagementContractService
extends AbstractPaginateService<ManagementContractDto> {
    static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ManagementContractService.class);
    private ManagementContractExternalRestClient client;
    private CommonService commonService;

    @Autowired
    public ManagementContractService(CommonService commonService, ManagementContractExternalRestClient client) {
        this.commonService = commonService;
        this.client = client;
    }

    public Collection<ManagementContractDto> getAll(ExternalHttpContext context, Optional<String> criteria) {
        return this.client.getAll((AbstractHttpContext)context, criteria);
    }

    public boolean check(ExternalHttpContext context, ManagementContractDto managementContractDto) {
        return this.client.check(context, managementContractDto);
    }

    public PaginatedValuesDto<ManagementContractDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, ExternalHttpContext context) {
        return super.getAllPaginated(page, size, criteria, orderBy, direction, context);
    }

    public ManagementContractDto create(ExternalHttpContext context, ManagementContractDto managementContractDto) {
        super.beforeCreate((IdDto)managementContractDto);
        return (ManagementContractDto)this.client.create((AbstractHttpContext)context, (IdDto)managementContractDto);
    }

    protected Integer beforePaginate(Integer page, Integer size) {
        return this.commonService.checkPagination(page.intValue(), size.intValue());
    }

    public ManagementContractExternalRestClient getClient() {
        return this.client;
    }
}

