/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.service;

import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.ProcessDetailDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUIProcessDetailResponseDto;
import fr.gouv.vitamui.referential.external.client.LogbookManagementOperationExternalRestClient;
import fr.gouv.vitamui.ui.commons.service.AbstractPaginateService;
import fr.gouv.vitamui.ui.commons.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class LogbookManagementOperationService
extends AbstractPaginateService<ProcessDetailDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(LogbookManagementOperationService.class);
    private LogbookManagementOperationExternalRestClient logbookManagementOperationExternalRestClient;
    private CommonService commonService;

    @Autowired
    public LogbookManagementOperationService(LogbookManagementOperationExternalRestClient logbookManagementOperationExternalRestClient, CommonService commonService) {
        this.logbookManagementOperationExternalRestClient = logbookManagementOperationExternalRestClient;
        this.commonService = commonService;
    }

    protected Integer beforePaginate(Integer page, Integer size) {
        return this.commonService.checkPagination(page.intValue(), size.intValue());
    }

    public BasePaginatingAndSortingRestClient<ProcessDetailDto, ExternalHttpContext> getClient() {
        return this.logbookManagementOperationExternalRestClient;
    }

    public ResponseEntity<VitamUIProcessDetailResponseDto> searchOperationsDetails(ExternalHttpContext context, ProcessQuery processQuery) {
        LOGGER.debug("Get All Operations Details with processQuery = {}", (Object)processQuery);
        return this.logbookManagementOperationExternalRestClient.searchOperationsDetails(context, processQuery);
    }

    public ResponseEntity<VitamUIProcessDetailResponseDto> cancelOperationProcessExecution(ExternalHttpContext context, String operationId) {
        LOGGER.debug("Cancel the operation Id = {}", (Object)operationId);
        return this.logbookManagementOperationExternalRestClient.cancelOperationProcessExecution(context, operationId);
    }

    public ResponseEntity<VitamUIProcessDetailResponseDto> updateOperationActionProcess(ExternalHttpContext context, String actionId, String operationId) {
        LOGGER.debug("Update the operation id={} with the Action ={}", (Object)operationId, (Object)actionId);
        return this.logbookManagementOperationExternalRestClient.updateOperationActionProcess(context, actionId, operationId);
    }
}

