/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.service;

import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.IngestContractDto;
import fr.gouv.vitamui.referential.external.client.IngestContractExternalRestClient;
import fr.gouv.vitamui.ui.commons.service.AbstractPaginateService;
import fr.gouv.vitamui.ui.commons.service.CommonService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IngestContractService
extends AbstractPaginateService<IngestContractDto> {
    static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IngestContractService.class);
    private IngestContractExternalRestClient client;
    private CommonService commonService;

    @Autowired
    public IngestContractService(CommonService commonService, IngestContractExternalRestClient client) {
        this.commonService = commonService;
        this.client = client;
    }

    public PaginatedValuesDto<IngestContractDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, ExternalHttpContext context) {
        return super.getAllPaginated(page, size, criteria, orderBy, direction, context);
    }

    public IngestContractDto create(ExternalHttpContext context, IngestContractDto ingestContractDto) {
        super.beforeCreate((IdDto)ingestContractDto);
        return (IngestContractDto)this.client.create((AbstractHttpContext)context, (IdDto)ingestContractDto);
    }

    protected Integer beforePaginate(Integer page, Integer size) {
        return this.commonService.checkPagination(page.intValue(), size.intValue());
    }

    public BasePaginatingAndSortingRestClient<IngestContractDto, ExternalHttpContext> getClient() {
        return this.client;
    }

    public Collection<IngestContractDto> getAll(ExternalHttpContext context, Optional<String> criteria) {
        return this.client.getAll((AbstractHttpContext)context, criteria);
    }

    public boolean check(ExternalHttpContext context, IngestContractDto ingestContractDto) {
        return this.client.check(context, ingestContractDto);
    }
}

