/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.AgencyDto;
import fr.gouv.vitamui.referential.external.client.AgencyExternalRestClient;
import fr.gouv.vitamui.referential.external.client.AgencyExternalWebClient;
import fr.gouv.vitamui.ui.commons.service.AbstractPaginateService;
import fr.gouv.vitamui.ui.commons.service.CommonService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AgencyService
extends AbstractPaginateService<AgencyDto> {
    static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AgencyService.class);
    private AgencyExternalRestClient client;
    private AgencyExternalWebClient webClient;
    private CommonService commonService;

    @Autowired
    public AgencyService(CommonService commonService, AgencyExternalRestClient client, AgencyExternalWebClient webClient) {
        this.commonService = commonService;
        this.client = client;
        this.webClient = webClient;
    }

    public PaginatedValuesDto<AgencyDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, ExternalHttpContext context) {
        return super.getAllPaginated(page, size, criteria, orderBy, direction, context);
    }

    protected Integer beforePaginate(Integer page, Integer size) {
        return this.commonService.checkPagination(page.intValue(), size.intValue());
    }

    public BasePaginatingAndSortingRestClient<AgencyDto, ExternalHttpContext> getClient() {
        return this.client;
    }

    public Collection<AgencyDto> getAll(ExternalHttpContext context, Optional<String> criteria) {
        return this.client.getAll((AbstractHttpContext)context, criteria);
    }

    public boolean check(ExternalHttpContext context, AgencyDto accessContractDto) {
        return this.client.check(context, accessContractDto);
    }

    public ResponseEntity<Boolean> deleteWithResponse(ExternalHttpContext context, String id) {
        return this.client.deleteWithResponse(context, id);
    }

    public ResponseEntity<Resource> export(ExternalHttpContext context) {
        return this.client.export(context);
    }

    public JsonNode importAgencies(ExternalHttpContext context, MultipartFile file) {
        return this.webClient.importAgencies(context, file);
    }
}

