/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.service;

import fr.gouv.vitamui.commons.api.domain.AccessionRegisterSearchDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterDetailDto;
import fr.gouv.vitamui.referential.external.client.AccessionRegisterDetailExternalRestClient;
import fr.gouv.vitamui.ui.commons.service.AbstractPaginateService;
import fr.gouv.vitamui.ui.commons.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AccessionRegisterDetailService
extends AbstractPaginateService<AccessionRegisterDetailDto> {
    static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessionRegisterDetailService.class);
    private final AccessionRegisterDetailExternalRestClient client;
    private final CommonService commonService;

    @Autowired
    public AccessionRegisterDetailService(CommonService commonService, AccessionRegisterDetailExternalRestClient client) {
        this.commonService = commonService;
        this.client = client;
    }

    public ResponseEntity<Resource> exportAccessionRegisterCsv(AccessionRegisterSearchDto searchQuery, ExternalHttpContext context) {
        LOGGER.info("Accession register details csv export: {}", (Object)searchQuery);
        return this.client.exportAccessionRegisterCsv(searchQuery, context);
    }

    protected Integer beforePaginate(Integer page, Integer size) {
        return this.commonService.checkPagination(page.intValue(), size.intValue());
    }

    public BasePaginatingAndSortingRestClient<AccessionRegisterDetailDto, ExternalHttpContext> getClient() {
        return this.client;
    }
}

