/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.AbstractUiRestController;
import fr.gouv.vitamui.commons.rest.dto.RuleDto;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.service.RuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Deprecated(since="5.0.2", forRemoval=true)
@Api(tags={"rule"})
@RestController
@RequestMapping(value={"${ui-referential.prefix}/rule"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RuleController
extends AbstractUiRestController {
    protected final RuleService service;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(RuleController.class);

    @Autowired
    public RuleController(RuleService service) {
        this.service = service;
    }

    @ApiOperation(value="Get entity")
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<RuleDto> getAll(Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get all with criteria={}", criteria);
        return this.service.getAll(this.buildUiHttpContext(), criteria);
    }

    @ApiOperation(value="Get entities paginated")
    @GetMapping(params={"page", "size"})
    @ResponseStatus(value=HttpStatus.OK)
    public PaginatedValuesDto<RuleDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam Optional<String> criteria, @RequestParam Optional<String> orderBy, @RequestParam Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.service.getAllPaginated(page, size, criteria, orderBy, direction, this.buildUiHttpContext());
    }

    @ApiOperation(value="Get rule by ID")
    @GetMapping(path={"/{identifier:.+}"})
    @ResponseStatus(value=HttpStatus.OK)
    public RuleDto getById(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("getById {} / {}", (Object)identifier, (Object)URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{identifier});
        return (RuleDto)this.service.getOne(this.buildUiHttpContext(), URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @ApiOperation(value="Check ability to create rule")
    @PostMapping(path={"/check"})
    public ResponseEntity<Void> check(@RequestBody RuleDto ruleDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)ruleDto);
        LOGGER.debug("check ability to create rule={}", (Object)ruleDto);
        boolean exist = this.service.check(this.buildUiHttpContext(), ruleDto);
        LOGGER.debug("response value={}" + exist);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @ApiOperation(value="Create rule")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> create(@Valid @RequestBody RuleDto ruleDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)ruleDto);
        LOGGER.debug("create rule={}", (Object)ruleDto);
        return RestUtils.buildBooleanResponse((boolean)this.service.createRule(this.buildUiHttpContext(), ruleDto));
    }

    @ApiOperation(value="Patch entity")
    @PatchMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Void> patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier, the partialEntity are mandatory parameters: ", (Object[])new Object[]{id, partialDto});
        SanityChecker.sanitizeCriteria(partialDto);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Patch User {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch rule : the DTO id must match the path id.");
        return RestUtils.buildBooleanResponse((boolean)this.service.patchRule(this.buildUiHttpContext(), partialDto, id));
    }

    @ApiOperation(value="get history by rule's id")
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for rule with id :{}", (Object)id);
        return this.service.findHistoryById(this.buildUiHttpContext(), id);
    }

    @ApiOperation(value="delete rule")
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("delete rule with id :{}", (Object)id);
        return RestUtils.buildBooleanResponse((boolean)this.service.deleteRule(this.buildUiHttpContext(), id));
    }

    @ApiOperation(value="get exported csv for rules")
    @GetMapping(value={"/export"})
    @Produces(value={"application/octet-stream"})
    public ResponseEntity<Resource> export() throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("export rules");
        return this.service.export(this.buildUiHttpContext());
    }

    @ApiOperation(value="import a rule file")
    @PostMapping(value={"/import"})
    public JsonNode importRules(@Context HttpServletRequest request, MultipartFile file) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Import rule file {}", (Object)(file != null ? file.getOriginalFilename() : null));
        return this.service.importRules(this.buildUiHttpContext(), file);
    }
}

