/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.rest;

import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.AbstractUiRestController;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.LogbookOperationDto;
import fr.gouv.vitamui.referential.common.dto.ReportType;
import fr.gouv.vitamui.referential.service.OperationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"operation"})
@RestController
@RequestMapping(value={"${ui-referential.prefix}/operation"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class OperationController
extends AbstractUiRestController {
    protected final OperationService service;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OperationController.class);

    @Autowired
    public OperationController(OperationService service) {
        this.service = service;
    }

    @ApiOperation(value="Get entity")
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<LogbookOperationDto> getAll(Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get all with criteria={}", criteria);
        return this.service.getAll(this.buildUiHttpContext(), criteria);
    }

    @ApiOperation(value="Get entities paginated")
    @GetMapping(params={"page", "size"})
    @ResponseStatus(value=HttpStatus.OK)
    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam Optional<String> criteria, @RequestParam Optional<String> orderBy, @RequestParam Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("Get all with criteria={}", criteria);
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.service.getAllPaginated(page, size, criteria, orderBy, direction, this.buildUiHttpContext());
    }

    @ApiOperation(value="get history by operation's id")
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for operation with id :{}", (Object)id);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        return this.service.findHistoryById(this.buildUiHttpContext(), id);
    }

    @ApiOperation(value="export operation by id")
    @GetMapping(value={"/{id}/download/{type}"})
    public ResponseEntity<Resource> export(@PathVariable(value="id") String id, @PathVariable(value="type") ReportType type) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        LOGGER.debug("export {} operation with id :{}", (Object)type, (Object)id);
        Resource body = (Resource)this.service.export(this.buildUiHttpContext(), id, type).getBody();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment"})).body((Object)body);
    }

    @ApiOperation(value="Create audit")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public boolean create(@Valid @RequestBody AuditOptions auditOptions) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)auditOptions);
        LOGGER.debug("create audit={}", (Object)auditOptions);
        return this.service.runAudit(this.buildUiHttpContext(), auditOptions);
    }

    @ApiOperation(value="extract information from timestamp")
    @PostMapping(value={"/timestamp"})
    public ObjectNode extractInfoFromTimestamp(@RequestBody String timestamp) {
        ObjectNode result = JsonHandler.createObjectNode();
        try {
            ASN1InputStream bIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(Base64.decode((byte[])timestamp.getBytes())));
            ASN1Primitive obj = bIn.readObject();
            TimeStampResponse tsResp = new TimeStampResponse(obj.toASN1Primitive().getEncoded());
            SignerId signerId = tsResp.getTimeStampToken().getSID();
            X500Name signerCertIssuer = signerId.getIssuer();
            result.put("genTime", LocalDateUtil.getString((LocalDateTime)LocalDateUtil.fromDate((Date)tsResp.getTimeStampToken().getTimeStampInfo().getGenTime())));
            result.put("signerCertIssuer", signerCertIssuer.toString());
        }
        catch (IOException | TSPException e) {
            LOGGER.error("Error while transforming timestamp", e);
            throw new BadRequestException("Error while transforming timestamp", e);
        }
        return result;
    }

    @ApiOperation(value="check traceability operation")
    @GetMapping(value={"/check/{id}"})
    public LogbookOperationsResponseDto checkTraceabilityOperation(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Launch check traceability operation with id = {}", (Object)id);
        return this.service.checkTraceabilityOperation(this.buildUiHttpContext(), id);
    }

    @ApiOperation(value="run probative value operation")
    @PostMapping(value={"/probativeValue"})
    public boolean runProbativeValue(@Valid @RequestBody ProbativeValueRequest probativeValueOptions) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)probativeValueOptions);
        LOGGER.debug("launch probative value = {}", (Object)probativeValueOptions);
        return this.service.runProbativeValue(this.buildUiHttpContext(), probativeValueOptions);
    }

    @ApiOperation(value="Export probative value as zip")
    @GetMapping(value={"/probativeValue/{id}"})
    public ResponseEntity<Resource> exportProbativeValue(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("export probative value with id :{}", (Object)id);
        Resource body = (Resource)this.service.exportProbativeValue(this.buildUiHttpContext(), id).getBody();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment"})).body((Object)body);
    }
}

