/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.ManagementContractDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.AbstractUiRestController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.service.ManagementContractService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"management-contract"})
@RestController
@RequestMapping(value={"${ui-referential.prefix}/management-contract"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ManagementContractController
extends AbstractUiRestController {
    protected final ManagementContractService service;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ManagementContractController.class);

    @Autowired
    public ManagementContractController(ManagementContractService service) {
        this.service = service;
    }

    @ApiOperation(value="Get entity")
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<ManagementContractDto> getAll(Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get all with criteria={}", criteria);
        return this.service.getAll(this.buildUiHttpContext(), criteria);
    }

    @ApiOperation(value="Get entities paginated")
    @GetMapping(params={"page", "size"})
    @ResponseStatus(value=HttpStatus.OK)
    public PaginatedValuesDto<ManagementContractDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam Optional<String> criteria, @RequestParam Optional<String> orderBy, @RequestParam Optional<DirectionDto> direction) throws InvalidParseOperationException {
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.service.getAllPaginated(page, size, criteria, orderBy, direction, this.buildUiHttpContext());
    }

    @ApiOperation(value="Get management contract by ID")
    @GetMapping(path={"/{identifier:.+}"})
    public ManagementContractDto getById(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException, InvalidParseOperationException {
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("getById {} / {}", (Object)identifier, (Object)URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
        return (ManagementContractDto)this.service.getOne(this.buildUiHttpContext(), URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @ApiOperation(value="Check ability to create entity")
    @PostMapping(path={"/check"})
    public ResponseEntity<Void> check(@RequestBody ManagementContractDto managementContractDto) throws InvalidParseOperationException {
        SanityChecker.sanitizeCriteria((Object)managementContractDto);
        LOGGER.debug("check ability to create managementContract={}", (Object)managementContractDto);
        boolean exist = this.service.check(this.buildUiHttpContext(), managementContractDto);
        LOGGER.debug("response value={}" + exist);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @ApiOperation(value="Create entity")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public ManagementContractDto create(@Valid @RequestBody ManagementContractDto managementContractDto) throws InvalidParseOperationException {
        LOGGER.debug("create managementContract={}", (Object)managementContractDto);
        return this.service.create(this.buildUiHttpContext(), managementContractDto);
    }

    @ApiOperation(value="Patch entity")
    @PatchMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public ManagementContractDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch managementContract {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch managementContract : the DTO id must match the path id.");
        return (ManagementContractDto)this.service.patch(this.buildUiHttpContext(), partialDto, id);
    }

    @ApiOperation(value="get history by managementContract's id")
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable String id) throws InvalidParseOperationException {
        LOGGER.debug("get logbook for managementContract with id :{}", (Object)id);
        return this.service.findHistoryById(this.buildUiHttpContext(), id);
    }
}

