/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.AbstractUiRestController;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUIProcessDetailResponseDto;
import fr.gouv.vitamui.referential.service.LogbookManagementOperationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"logbook-management-operation"})
@RestController
@RequestMapping(value={"${ui-referential.prefix}/logbook-management-operation"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LogbookManagementOperationController
extends AbstractUiRestController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(LogbookManagementOperationController.class);
    protected final LogbookManagementOperationService logbookManagementOperationService;

    @Autowired
    public LogbookManagementOperationController(LogbookManagementOperationService logbookManagementOperationService) {
        this.logbookManagementOperationService = logbookManagementOperationService;
    }

    @ApiOperation(value="Get All Operations Details")
    @PostMapping(value={"/operations"})
    @ResponseStatus(value=HttpStatus.OK)
    public VitamUIProcessDetailResponseDto listOperationsDetails(@RequestBody ProcessQuery processQuery) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)processQuery);
        LOGGER.debug("Get the operations details with criteria = {}", (Object)processQuery);
        VitamUIProcessDetailResponseDto operationResponseDto = new VitamUIProcessDetailResponseDto();
        ResponseEntity<VitamUIProcessDetailResponseDto> processDetailResponse = this.logbookManagementOperationService.searchOperationsDetails(this.buildUiHttpContext(), processQuery);
        if (processDetailResponse != null) {
            operationResponseDto = (VitamUIProcessDetailResponseDto)processDetailResponse.getBody();
        }
        return operationResponseDto;
    }

    @ApiOperation(value="Cancel the operation")
    @PostMapping(value={"/operations/cancel/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public VitamUIProcessDetailResponseDto cancelOperationProcessExecution(@PathVariable(value="id") String operationId) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"operationId is mandatory : ", (String[])new String[]{operationId});
        SanityChecker.checkSecureParameter((String[])new String[]{operationId});
        LOGGER.debug("Cancel the operation id= {}", (Object)operationId);
        return this.logbookManagementOperationService.cancelOperationProcessExecution(this.buildUiHttpContext(), operationId) != null ? (VitamUIProcessDetailResponseDto)this.logbookManagementOperationService.cancelOperationProcessExecution(this.buildUiHttpContext(), operationId).getBody() : null;
    }

    @ApiOperation(value="Update the operation status")
    @PostMapping(value={"/operations/update/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public VitamUIProcessDetailResponseDto updateOperationActionProcess(@PathVariable(value="id") String operationId, @RequestBody String actionId) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"operationId and actionId are mandatories : ", (String[])new String[]{operationId, actionId});
        SanityChecker.checkSecureParameter((String[])new String[]{operationId, actionId});
        LOGGER.debug("Update Operation Id={} with ActionId = {}", (Object)operationId, (Object)actionId);
        return this.logbookManagementOperationService.updateOperationActionProcess(this.buildUiHttpContext(), actionId, operationId) != null ? (VitamUIProcessDetailResponseDto)this.logbookManagementOperationService.updateOperationActionProcess(this.buildUiHttpContext(), actionId, operationId).getBody() : null;
    }
}

