/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.AbstractUiRestController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.FileFormatDto;
import fr.gouv.vitamui.referential.service.FileFormatService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"fileformat"})
@RestController
@RequestMapping(value={"${ui-referential.prefix}/fileformat"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FileFormatController
extends AbstractUiRestController {
    protected final FileFormatService service;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(FileFormatController.class);

    @Autowired
    public FileFormatController(FileFormatService service) {
        this.service = service;
    }

    @ApiOperation(value="Get entity")
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<FileFormatDto> getAll(Optional<String> criteria) throws PreconditionFailedException, InvalidParseOperationException {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get all with criteria={}", criteria);
        return this.service.getAll(this.buildUiHttpContext(), criteria);
    }

    @ApiOperation(value="Get entities paginated")
    @GetMapping(params={"page", "size"})
    @ResponseStatus(value=HttpStatus.OK)
    public PaginatedValuesDto<FileFormatDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam Optional<String> criteria, @RequestParam Optional<String> orderBy, @RequestParam Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.service.getAllPaginated(page, size, criteria, orderBy, direction, this.buildUiHttpContext());
    }

    @ApiOperation(value="Get file format by ID or history by file format's id if path ends by /history")
    @RequestMapping(value={"/**"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public Object getByIdOrHistory(HttpServletRequest request) throws UnsupportedEncodingException, InvalidParseOperationException {
        LOGGER.debug("Entering in 'getByIdOrHistory' method");
        String requestUrl = request.getRequestURL().toString();
        String fileFormatId = this.extractFileFormatId(requestUrl);
        boolean isHistoryRequest = this.isHistoryRequest(requestUrl);
        LOGGER.debug("Search history for {} file format", (Object)fileFormatId);
        return isHistoryRequest ? this.findHistoryById(fileFormatId) : this.getById(fileFormatId);
    }

    private String extractFileFormatId(String url) {
        String pathSeparator = "/fileformat/";
        String historySuffix = "/history";
        String path = StringUtils.substringAfter((String)url, (String)"/fileformat/");
        boolean isHistoryRequest = this.isHistoryRequest(url);
        LOGGER.debug("Is history request: {}", (Object)isHistoryRequest);
        if (isHistoryRequest) {
            return StringUtils.substringBefore((String)path, (String)"/history");
        }
        return StringUtils.removeEndIgnoreCase((String)path, (String)"/");
    }

    private boolean isHistoryRequest(String url) {
        String historySuffix = "/history";
        return StringUtils.endsWith((CharSequence)url, (CharSequence)"/history");
    }

    private FileFormatDto getById(String identifier) throws UnsupportedEncodingException, InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("getById {} / {}", (Object)identifier, (Object)URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
        return (FileFormatDto)this.service.getOne(this.buildUiHttpContext(), identifier);
    }

    @ApiOperation(value="Check ability to create file format")
    @PostMapping(path={"/check"})
    public ResponseEntity<Void> check(@RequestBody FileFormatDto fileformatDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)fileformatDto);
        LOGGER.debug("check ability to create file format={}", (Object)fileformatDto);
        boolean exist = this.service.check(this.buildUiHttpContext(), fileformatDto);
        LOGGER.debug("response value={}" + exist);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @ApiOperation(value="Create file format")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public FileFormatDto create(@Valid @RequestBody FileFormatDto fileformatDto) throws PreconditionFailedException, InvalidParseOperationException {
        SanityChecker.sanitizeCriteria((Object)fileformatDto);
        LOGGER.debug("create file format={}", (Object)fileformatDto);
        SanityChecker.sanitizeCriteria((Object)fileformatDto);
        return (FileFormatDto)this.service.create(this.buildUiHttpContext(), (IdDto)fileformatDto);
    }

    @ApiOperation(value="Patch entity")
    @PatchMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public FileFormatDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(partialDto);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Patch User {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch fileformat : the DTO id must match the path id.");
        return (FileFormatDto)this.service.patch(this.buildUiHttpContext(), partialDto, id);
    }

    private LogbookOperationsResponseDto findHistoryById(String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for file format with id :{}", (Object)id);
        return this.service.findHistoryById(this.buildUiHttpContext(), id);
    }

    @ApiOperation(value="delete file format")
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("delete file format with id :{}", (Object)id);
        this.service.delete(this.buildUiHttpContext(), id);
    }

    @ApiOperation(value="get exported csv for file formats")
    @GetMapping(value={"/export"})
    @Produces(value={"application/octet-stream"})
    public ResponseEntity<Resource> export() throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("export file formats");
        return this.service.export(this.buildUiHttpContext());
    }

    @ApiOperation(value="import a file format xml file")
    @PostMapping(value={"/import"})
    public JsonNode importFileFormats(@Context HttpServletRequest request, MultipartFile file) throws InvalidParseOperationException, PreconditionFailedException {
        if (file != null) {
            SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        }
        LOGGER.debug("Import file format file {}", (Object)(file != null ? file.getOriginalFilename() : null));
        return this.service.importFileFormats(this.buildUiHttpContext(), file);
    }
}

