/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.AccessionRegisterSearchDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.AbstractUiRestController;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterDetailDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterSummaryDto;
import fr.gouv.vitamui.referential.service.AccessionRegisterDetailService;
import fr.gouv.vitamui.referential.service.AccessionRegisterSummaryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"accession-register"})
@RestController
@RequestMapping(value={"${ui-referential.prefix}/accession-register"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AccessionRegisterController
extends AbstractUiRestController {
    protected final AccessionRegisterSummaryService summaryService;
    protected final AccessionRegisterDetailService detailsService;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessionRegisterController.class);

    public AccessionRegisterController(AccessionRegisterSummaryService summaryService, AccessionRegisterDetailService detailsService) {
        this.summaryService = summaryService;
        this.detailsService = detailsService;
    }

    @ApiOperation(value="Get accession register summary entities")
    @GetMapping(value={"/summary"})
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<AccessionRegisterSummaryDto> getAll(Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get all with criteria={}", criteria);
        return this.summaryService.getAll(this.buildUiHttpContext(), criteria);
    }

    @ApiOperation(value="Get accession register details entities paginated")
    @GetMapping(value={"/details"}, params={"page", "size"})
    @ResponseStatus(value=HttpStatus.OK)
    public PaginatedValuesDto<AccessionRegisterDetailDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam Optional<String> criteria, @RequestParam Optional<String> orderBy, @RequestParam Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.detailsService.getAllPaginated(page, size, criteria, orderBy, direction, this.buildUiHttpContext());
    }

    @ApiOperation(value="Export accession register by criteria into csv format")
    @PostMapping(value={"/details/export-csv"})
    @Consumes(value={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Resource> exportCsvArchiveUnitsByCriteria(@RequestBody AccessionRegisterSearchDto searchQuery) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Export accession register by criteria into csv format = {}", (Object)searchQuery);
        Resource exportedCsvResult = (Resource)this.detailsService.exportAccessionRegisterCsv(searchQuery, this.buildUiHttpContext()).getBody();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment"})).body((Object)exportedCsvResult);
    }
}

