/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.internal.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import java.io.InputStream;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class IngestStreamingInternalRestClient
extends BasePaginatingAndSortingRestClient<LogbookOperationDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IngestStreamingInternalRestClient.class);

    public IngestStreamingInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return "/v1/ingest";
    }

    protected Class<LogbookOperationDto> getDtoClass() {
        return LogbookOperationDto.class;
    }

    protected ParameterizedTypeReference<List<LogbookOperationDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<LogbookOperationDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<LogbookOperationDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<LogbookOperationDto>>(){};
    }

    public ResponseEntity<Void> streamingUpload(InternalHttpContext context, InputStream inputStream, String contextId, String action) {
        LOGGER.debug("Calling upload using streaming process");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/upload"));
        HttpHeaders headersList = new HttpHeaders();
        headersList.addAll(this.buildHeaders((AbstractHttpContext)context));
        headersList.add((Object)"X-Context-Id", (Object)contextId);
        headersList.add((Object)"X-Action", (Object)action);
        HttpHeaders headersParams = new HttpHeaders();
        headersParams.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headersParams.addAll((MultiValueMap)headersList);
        HttpEntity request = new HttpEntity((Object)new InputStreamResource(inputStream), (MultiValueMap)headersParams);
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, request, Void.class, new Object[0]);
        LOGGER.debug("The response on ingest is {} ", (Object)response.toString());
        return response;
    }
}

